$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'formcard1') {
                    $('.driver-close-btn').on('click', location.reload());
                };
            }
        });

        driver.defineSteps([{
            element: '#campostuto',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtUnidade',
            popover: {
                title: 'Unidade',
                description: 'Neste campo adicionamos o nome da Unidade.',
                position: 'top'
            }
        },
        {
            element: '#checkAtivo',
            popover: {
                title: 'Ativo',
                description: 'Selecionando este elemento, marcamos a unidade como ativa.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição sobre a Unidade.',
                position: 'top'
            }
        },
        {
            element: '#txtQuantidade',
            popover: {
                title: 'Quantidade',
                description: 'Adicionamos neste campo a quantidade da unidade.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a Unidade.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtQuantidade').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let unidade = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('UNIDADE', getCookie('usuario'), unidade);
        window.location.href = `${BASE_URI}/unidade`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtUnidade: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                },
                txtQuantidade: {
                    required: true,
                },
            },
            messages: {
                txtUnidade: {
                    required: "Informe uma unidade válida.",
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
                txtQuantidade: {
                    required: "Informe uma quantidade válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (unidade != '' && unidade != 'create') {

        if (await liberarRegistro('UNIDADE', unidade) == false) {
            window.location.href = '../unidade';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade", 
                    "camposSelect":["unidade", "descricao", "ativo", "qtde", "unid_inteira"], 
                    "where": ["unidade = '${unidade}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtUnidade').attr('readonly', true);

                    $('#txtUnidade').val(jsonStr.RESULT[0][0].UNIDADE);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtQuantidade').val(jsonStr.RESULT[0][0].QTDE);

                    if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    } else {
                        $('#checkAtivo').prop('checked', false);
                    }

                    $('#checkUnidInteira').prop('checked', jsonStr.RESULT[0][0].UNID_INTEIRA == 'S');

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('#txtUnidade').on('keypress', function (event) {
        let regex = new RegExp("^[a-zA-Z0-9]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $('#txtUnidade').change(async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"unidade", 
    "camposSelect":["unidade"], 
    "where": ["unidade = '${$('#txtUnidade').val()}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (jsonStr.RESULT[0].length > 0) {
                    msgAlerta('Unidade já cadastrada, redirecionando à edição da mesma.');
                    setTimeout(function () { window.location.href = `${BASE_URI}/unidade/${$('#txtUnidade').val()}`; }, 3000);
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    unidade = {};

                    unidade.UNIDADE = $('#txtUnidade').val().toUpperCase();;
                    unidade.DESCRICAO = $('#txtDescricao').val().toUpperCase();;
                    unidade.QTDE = $('#txtQuantidade').val();

                    if ($('#checkAtivo').prop('checked')) {
                        unidade.ATIVO = 'S';
                    } else {
                        unidade.ATIVO = 'N';
                    }
                    unidade.UNIDINTEIRA = $('#checkUnidInteira').is(':checked') ? 'S' : 'N';

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/unidade?', `JSON=${encodeURIComponent(JSON.stringify(unidade))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/unidade`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});