$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });

        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtrar',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'botton'
            }
        },
        {
            element: '#check_todosTour',
            popover: {
                title: 'Selecionar Todos',
                description: 'Aqui você seleciona todos os registros.',
                position: 'top'
            }
        },
        {
            element: '#aplicarTodosTour',
            popover: {
                title: 'Aplicar a Todos',
                description: 'Aqui você aplica as opções a todos os registros selecionados.',
                position: 'top'
            }
        },
        {
            element: '#tabelaAcessos_wrapper',
            popover: {
                title: 'Lista de Acessos',
                description: 'Aqui você encontra a lista de usuários e seus respectivos acessos.',
                position: 'top'
            }
        }, {
            element: '#btn-liberar',
            popover: {
                title: 'Botão Confirmar',
                description: 'Clicando aqui você libera ou remove os acessos dos usuários conforme manutenção feita no passo anterior.',
                position: 'top'
            }
        }
        ]);
        //inicio tour 

        driver.start();

        const activeElement = driver.getHighlightedElement();
        // inicior tuor
        //final
    });
});
//fim tour

$(document).ready(async function () {


    var tabelaAcessos = $('#tabelaAcessos').DataTable({
        paging: false,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        scrollX: true,
        scrollY: '200px',
    });

    const naoFiltraSisplan = getCookie('cod_usuario') != '0000' ? `AND CODIGO <> '0000'`: '';
    componenteFiltro('usuario2', true, false, '', [`CODIGO <> '9999' ${naoFiltraSisplan}`]);

    /// funcoes tela
    const tabelaTratada = 'Tela';
    const input = $(`#txt${tabelaTratada}`);
    const botao = $(`#btn${tabelaTratada}`);
    const botaoLimpar = $(`#btnLimpa${tabelaTratada}`);

    if (!input[0] || !botao[0] || !botaoLimpar[0]) {
        throw new Error('algum dos componentes está errado');
    }

    // $('#txtTamanho').pesquisa_variosServerside(1, '{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}', 'TAM', 'FAIXA');
    // $('#btnTamanho').pesquisa_serversideSel('#txtTamanho', `{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"], "where": null}`, 'Pesquisa de Tamanho');
    $(input).pesquisa_variosServerside(1, '{}', 'TELA', 'TELA');
    $(botao).pesquisa_serversideSel(input, `{}`, `Pesquisa de Tela`);

    $(input).addClass('camposFiltros');

    $(botaoLimpar).on('click', function () {
        $(input).empty().trigger('change');
        $(input).val('');
        $(input).attr('data-chave', '');
        $(input).attr('data-desc', '');
    });


    // funcoes tela

    // $('#txtUsuario').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999' ${naoFiltraSisplan}"]}`);

    // $('#btnUsuario').pesquisa('#txtUsuario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999' ${naoFiltraSisplan}"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    // $('#btnAUsuario').on('click', function () {
    //     $('#txtUsuario').val('');
    // });
    // $('#btnATela').on('click', function () {
    //     $('#txtTela').val('');
    // });

    $('#txtCopia').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    $('#btnCopia').pesquisa('#txtCopia', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btnACopia').on('click', function () {
        $('#txtCopia').val('');
    });

    $('#txtCopiaPara').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["CODIGO <> '9999'"]}`);
    $('#btnCopiaPara').pesquisa('#txtCopiaPara', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btnACopiaPara').on('click', function () {
        $('#txtCopiaPara').val('');
    });

    // async function buscarTelas() {
    //     const url = `/Sisplan/AcessoMenu/v1/telas?`;
    //     try {
    //         $.LoadingOverlay("show");
    //         const response = await requisicao('GET', url, ``, null, 60000);

    //         if (!response) {
    //             $.LoadingOverlay("hide");
    //             return;
    //         }

    //         const jsonStr = await response.json();
    //         if (response.status != 200) {
    //             $.LoadingOverlay("hide");
    //             msgErro(jsonStr['RESULT'][0].mensagem);
    //             return;
    //         }
    //         $.LoadingOverlay("hide");
    //         return jsonStr;
    //     } catch (error) {
    //         console.error(error);
    //         $.LoadingOverlay("hide");
    //         msgErro('Não foi possível buscar os dados de acesso.');
    //     }
    // };
    // buscarTelas();

    async function buscarDados(usrCopia = '') {
        const url = `/Sisplan/AcessoMenu/v1/Acesso?`;
        try {
            $.LoadingOverlay("show");
            const cnpj = getCookie('g_cnpj_empresa_logada');
            const telas = await formataListas($('#txtTela').val().toString());
            const usuarios = usrCopia == '' ? await formataListas($('#txtUsuario2').val().toString()) : `'${usrCopia}'`;
            const response = await requisicao('GET', url, `codusuarios=${usuarios}&telas=${telas}&CNPJ=${cnpj}`, null, 60000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Não foi possível buscar os dados de acesso.');
        }
    };

    async function salvarDados() {
        const url = `/Sisplan/AcessoMenu/v1/Acesso?`;
        const cnpj = getCookie('g_cnpj_empresa_logada');
        const codigoUsuario = sessionStorage.getItem('cod_usuario');
        const arrayAcesso = [];
        try {
            $.LoadingOverlay("show");
            for (let i = 0; i < $('#tabelaAcessos').DataTable().rows().count(); i++) {
                if ($(`#check_col_${  i  }_row_0`).prop('checked')) {
                    const dados = $('#tabelaAcessos').DataTable().row(i).data();
                    const acesso = {};
                    acesso.NOME_TELA = dados.NOME_TELA;
                    acesso.CODIGO = dados.CODIGO;
                    acesso.CONSULTA = $(`#check_col_${  i  }_row_4`).prop('checked') ? 'S' : 'N';
                    acesso.ALTERA = $(`#check_col_${  i  }_row_5`).prop('checked') ? 'S' : 'N';
                    acesso.EXCLUI = $(`#check_col_${  i  }_row_6`).prop('checked') ? 'S' : 'N';
                    acesso.INCLUI = $(`#check_col_${  i  }_row_7`).prop('checked') ? 'S' : 'N';
                    arrayAcesso.push(acesso);
                }
            }

            const response = await requisicao('POST', url, `COD_USUARIO=${codigoUsuario}&CNPJ=${cnpj}`, `JSON=${encodeURIComponent(JSON.stringify(arrayAcesso))}`, 60000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            toastr.success(
                'Liberação efetuada com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function () {
                    window.location.href = `${BASE_URI}/acesso_menu`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });;
            $.LoadingOverlay("hide");
            return jsonStr;
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro('Não foi possível buscar os dados de acesso.');
        }
    };


    $('#check_todos').on('change', function () {

        $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    });

    $('#check_consultar').on('change', function () {
        for (let i = 0; i < $('.campoSel').length; i++) {
            if ($($('.campoSel')[i]).prop('checked')) {
                $($('.campoConsulta')[i]).prop('checked', $('#check_consultar').prop('checked'));
            }
        }
    });
    $('#check_alterar').on('change', function () {
        for (let i = 0; i < $('.campoSel').length; i++) {
            if ($($('.campoSel')[i]).prop('checked')) {
                $($('.campoAltera')[i]).prop('checked', $('#check_alterar').prop('checked'));
            }
        }
    });

    $('#check_excluir').on('change', function () {
        for (let i = 0; i < $('.campoSel').length; i++) {
            if ($($('.campoSel')[i]).prop('checked')) {
                $($('.campoExclui')[i]).prop('checked', $('#check_excluir').prop('checked'));
            }
        }
    });

    $('#check_incluir').on('change', function () {
        for (let i = 0; i < $('.campoSel').length; i++) {
            if ($($('.campoSel')[i]).prop('checked')) {
                $($('.campoInclui')[i]).prop('checked', $('#check_incluir').prop('checked'));
            }
        }
    });

    $('#btn-liberar').on('click', async function () {
        salvarDados();
    });

    // $('#txtTela', this).on('keyup change', function() {
    //     if (tabelaAcessos.column(3).search() !== this.value) {
    //         tabelaAcessos.column(3).search(this.value).draw();
    //     }
    // });

    // $('#txtUsuario', this).on('keyup change', function() {
    //     if (tabelaAcessos.columns(2).search() !== this.value) {
    //         tabelaAcessos.columns(2).search(this.value).draw();
    //     }
    // });

    $('#btn-consultar').on('click', async function () {
        
        const dados = getCookie('cod_usuario') != '0000' ? (await buscarDados()).filter(usr=> usr.CODIGO != '0000')
                                                         :  await buscarDados();
        const dataSetCols = [];

        if (dados.length > 0) {
            var keys = Object.keys(dados[0]);
            dataSetCols.push({
                'title': 'SEL',
                'data': 'SEL',
                'width': '15px'
            });
        }

        dataSetCols[0].render = function (data, type, row, meta) {
            return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`;
            // return '<div class="group-default form-group">' +
            //     '<div class="relative">' +
            //     '<input style="height:15px" type="checkbox" id="check_col_' + [meta.row] + '_row_' + [meta.col] + '" class="input-default focus form-control validate campoSel"> ' +
            //     '</div>' +
            //     '</div>';
        }

        for (var k in keys) {
            dataSetCols.push({
                'data': keys[k]
            });
        }

        dataSetCols[4].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.CONSULTA == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[5].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.ALTERA == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoAltera">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[6].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.EXCLUI == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoExclui">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[7].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.INCLUI == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoInclui">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        tabelaAcessos = $('#tabelaAcessos').DataTable({
            paging: false,
            filter: true,
            info: true,
            order: true,
            destroy: true,
            scrollX: true,
            scrollY: '500px',
            "data": dados,
            "columns": dataSetCols
        });

        $('#modal-filtros').modal('hide');

        $('.campoSel').on('change', function () {
            if (this.checked) {
                $(this).addClass('selecionado');
            } else {
                $(this).removeClass('selecionado');
            }
        });

        $('#txtCopia').val('');
    });

    $('#txtCopia').on('blur', function(){
        if (pegaChave('#txtCopia') == '0000' && getCookie('cod_usuario') != '0000') {
            msgAlerta('Não é possível copiar acessos do usuário Sisplan.');
            $(this).val('');
        }
    });

    $('#btn-confirmar-copia').on('click', async function () {
        const usrCopia = $('#txtCopia').val();
        const usr = $('#txtCopiaPara').val();

        if ((usr == '') || (usrCopia == '')) {
            msgAlerta('Necessário preencher os dois campos para copiar os acessos.');
            return;
        };

        await preencheDadosCopia(usr, usrCopia);
    });

    async function preencheDadosCopia(usr, usrCopia) {
        var dados = await buscarDados(pegaChave(usrCopia));
        var dataSetCols = [];

        $('#txtUsuario').val('');

        for (let i = 0; i < dados.length; i++) {
            dados[i].CODIGO = pegaChave(usr);
            dados[i].NOME_USUARIO = pegaDescricao(usr);
        }

        if (dados.length > 0) {
            var keys = Object.keys(dados[0]);
            dataSetCols.push({
                'title': 'SEL',
                'data': 'SEL',
                'width': '15px'
            });
        }

        dataSetCols[0].render = function (data, type, row, meta) {
            return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel" checked>
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        for (var k in keys) {
            dataSetCols.push({
                'data': keys[k]
            });
        }

        dataSetCols[4].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.CONSULTA == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[5].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.ALTERA == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoAltera">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[6].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.EXCLUI == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoExclui">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }
        dataSetCols[7].render = function (data, type, row, meta) {
            return `<div class="icheck-danger d-inline">
                        <input type="checkbox" ${row.INCLUI == 'S' ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoInclui">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        tabelaAcessos = $('#tabelaAcessos').DataTable({
            paging: false,
            filter: true,
            info: true,
            order: true,
            destroy: true,
            scrollX: true,
            scrollY: '500px',
            "data": dados,
            "columns": dataSetCols
        });

        $('#modal-filtros').modal('hide');

        $('.campoSel').on('change', function () {
            if (this.checked) {
                $(this).addClass('selecionado');
            } else {
                $(this).removeClass('selecionado');
            }
        });
    }

});