$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova sequência operacional.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela Sequências Operacionais",
          description: "Aqui estão os dados das sequências operacionais cadastradas.",
          position: "top",
        },
      },
      {
        element: "#tabelaOperacoes",
        popover: {
          title: "Tabela Processos",
          description: "Aqui estão os processos da sequência operacional selecionada.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  preencherFiltrosSalvos()

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    window.location.href = 'sequencia_operacional/create'
  })

  componenteFiltro('produto', true, true)
  componenteFiltro('parte', true, true)
  componenteFiltro('colecao', true, true)
  componenteFiltro('operacaoTempos', true, true, 'Operacao')
  componenteFiltro('modelo', true, true)
  componenteFiltro('marca', true, true)
  componenteFiltro('grupo', true, true)
  componenteFiltro('linha', true, true)

  $('#btnConsultar').on('click', async function () {
    await retornarDados()
  })

  async function retornarFiltros() {
    const produtos = await formataListas($('#txtProduto').val().toString())
    const partes = await formataListas($('#txtParte').val().toString())
    const colecoes = await formataListas($('#txtColecao').val().toString())
    const operacoes = await formataListas($('#txtOperacao').val().toString())
    const modelos = await formataListas($('#txtModelo').val().toString())
    const marcas = await formataListas($('#txtMarca').val().toString())
    const grupos = await formataListas($('#txtGrupo').val().toString())
    const linhas = await formataListas($('#txtLinha').val().toString())

    return {
      produtos,
      partes,
      colecoes,
      operacoes,
      modelos,
      marcas,
      grupos,
      linhas,
    }
  }

  async function retornarDados() {
    try {
      $.LoadingOverlay('show')

      const filtros = await retornarFiltros()

      atualizarFiltrosAbasAcessoSessionStorage('sequencia_operacional', filtros)
      const response = await requisicao("POST", `/Sisplan/sequenciaoperacional/v1/retornardadosacesso?`, '', JSON.stringify(filtros), 3600000)

      const data = await response.json()

      if (data) {
        const { resultado, mensagem } = data
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (resultado) {
          const { itens } = resultado
          criarTabelaItens(itens || [])
          return
        }
      }
    } catch (error) {
      msgErro(error || 'Ocorreu um erro ao buscar os dados.')
    } finally {
      $('#modal-filtros').modal('hide')
      $.LoadingOverlay('hide')
    }
  }

  function criarTabelaItens(data) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    const columns = [
      {
        data: 'id',
        title: 'Id',
        render: function (data) {
          return retornarBotaoOpcoes(data)
        },
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'parte',
        title: 'Parte',
      },
      {
        data: 'descricaoParte',
        title: 'Descrição Parte',
      },
      {
        data: 'cor',
        title: 'Cor',
      },
      {
        data: 'descricaoCor',
        title: 'Descrição Cor',
      },
      {
        data: 'dificuldade',
        title: 'Dificuldade',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempo',
        title: 'Tempo',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoTotal',
        title: 'Tempo Total',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoOperacao',
        title: 'Tempo Operação',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoOperacaoCapa',
        title: 'Tempo Operação Capa',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'custoTotal',
        title: 'Custo Total',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'modelo',
        title: 'Modelo',
      },
      {
        data: 'descricaoModelo',
        title: 'Descrição Modelo',
      },
      {
        data: 'marca',
        title: 'Marca',
      },
      {
        data: 'descricaoMarca',
        title: 'Descrição Marca',
      },
      {
        data: 'colecao',
        title: 'Coleção',
      },
      {
        data: 'descricaoColecao',
        title: 'Descrição Coleção',
      },
      {
        data: 'grupo',
        title: 'Grupo',
      },
      {
        data: 'descricaoGrupo',
        title: 'Descrição Grupo',
      },
      {
        data: 'linha',
        title: 'Linha',
      },
      {
        data: 'descricaoLinha',
        title: 'Descrição Linha',
      },
    ]

    const table = $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollY: true,
      scrollX: true,
      scrollCollapse: true,
      select: {
        style: 'single',
        toggleable: false,
      },
    })

    let selectedRowIndex = 0

    function selectRow(index) {
      const row = table.row(index)
      if (row.node()) {
        table.rows().deselect()
        table.row(index).select()
        selectedRowIndex = index
      }
    }

    function navigateToRow(newIndex) {
      const pageSize = table.page.info().length
      const currentPage = table.page.info().page
  
      const targetPage = Math.floor(newIndex / pageSize)
  
      if (targetPage !== currentPage) {
        table.page(targetPage).draw('page')
      }
  
      selectRow(newIndex)
      const rowNode = table.row(newIndex).node()
      $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
    }

    if (data.length > 0) navigateToRow(selectedRowIndex)
    else criarTabelaOperacoes([])

    $('#tabelaItens_wrapper .dataTables_scrollBody').off('wheel')
    $('#tabelaItens_wrapper .dataTables_scrollBody').on('wheel', function (event) {
      event.preventDefault()
      const direction = event.originalEvent.deltaY > 0 ? 1 : -1
      const newIndex = selectedRowIndex + direction


      if (newIndex >= 0 && newIndex < table.rows().count()) {
        navigateToRow(newIndex)


        // const rowNode = table.row(newIndex).node()
        // $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
      }
    })

    table.off('select')
    table.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        const data = table.rows(indexes[0]).data().toArray()
        selectedRowIndex = indexes[0]
        carregarOperacoes(data[0]?.id)
      }
    })

    $(document).off('keydown')
    $(document).on('keydown', function (event) {
      if (event.key === 'ArrowDown' || event.key === 'ArrowUp') {
        event.preventDefault()

        const direction = event.key === 'ArrowDown' ? 1 : -1
        const newIndex = selectedRowIndex + direction

        if (newIndex >= 0 && newIndex < table.rows().count()) {
          navigateToRow(newIndex)
          // const rowNode = table.row(newIndex).node()
          // $(rowNode).get(0).scrollIntoView({ behavior: 'smooth', block: 'center' })
        }
      }
    })
    $('#tabelaItens').DataTable().row(':first', { page: 'current' }).select()
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '</div>'
    return retorno
  }

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    let data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
    if (data && data?.id > 0) {
      let registroLiberado = await verificarRegistro('SEQUENCIA_OPERACIONAL', data?.id)
      if (registroLiberado) {
        window.location.href = `sequencia_operacional/${data?.id}`
      }
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    let data = $('#tabelaItens').DataTable().row($(this)).data()
    if (data && data?.id > 0) {
      let registroLiberado = await verificarRegistro('SEQUENCIA_OPERACIONAL', data?.id)
      if (registroLiberado) {
        window.location.href = `sequencia_operacional/${data?.id}`
      }
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!")
    // }
  })

  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (filtrosSessionStorage) {
      const { sequencia_operacional: filtros } = JSON.parse(filtrosSessionStorage)
      if (filtros) {
        carregarFiltrosSalvos(filtros).then(({ produtos, partes, colecoes, operacoes, modelos, marcas, grupos, linhas, }) => {
          if (produtos) produtos.forEach((item) => adicionaValorPadraoVarios('produto', item?.codigo, item?.descricao))
          if (partes) partes.forEach((item) => adicionaValorPadraoVarios('parte', item?.codigo, item?.descricao))
          if (colecoes) colecoes.forEach((item) => adicionaValorPadraoVarios('colecao', item?.codigo, item?.descricao))
          if (operacoes) operacoes.forEach((item) => adicionaValorPadraoVarios('operacao', item?.codigo, item?.descricao))
          if (modelos) modelos.forEach((item) => adicionaValorPadraoVarios('modelo', item?.codigo, item?.descricao))
          if (marcas) marcas.forEach((item) => adicionaValorPadraoVarios('marca', item?.codigo, item?.descricao))
          if (grupos) grupos.forEach((item) => adicionaValorPadraoVarios('grupo', item?.codigo, item?.descricao))
          if (linhas) linhas.forEach((item) => adicionaValorPadraoVarios('linha', item?.codigo, item?.descricao))
          $('#btnConsultar').trigger('click')
        }).catch(
          () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
        ).finally(() => { })
      }
    }
  }

  async function carregarFiltrosSalvos(filtros) {
    const response = await requisicao("POST", `/Sisplan/sequenciaoperacional/v1/retornardadosinputsfiltrosacesso?`, '', JSON.stringify(filtros), 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function carregarOperacoes(id) {
    if (!id) return
    buscarOperacoes(id).then(({ operacoes }) => {
      criarTabelaOperacoes(operacoes)
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao carregar as operações.')
    })
  }

  async function buscarOperacoes(id) {
    const response = await requisicao("GET", `/Sisplan/sequenciaoperacional/v1/retornardadoslinhaselecionadaacesso?`, `&FILTROS=${encodeURIComponent(JSON.stringify({ id }))}`, 3600000)

    const data = await response.json()

    if (data) {
      const { resultado, mensagem } = data
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function criarTabelaOperacoes(data) {

    if ($.fn.DataTable.isDataTable('#tabelaOperacoes')) {
      $('#tabelaOperacoes').DataTable().destroy()
      $('#tabelaOperacoes').empty()
    }

    const columns = [
      {
        data: 'ordem',
        title: 'Ordem',
      },
      {
        data: 'grupo',
        title: 'Grupo',
      },
      {
        data: 'descricaoGrupo',
        title: 'Descrição Grupo',
      },
      {
        data: 'operacao',
        title: 'Operação',
      },
      {
        data: 'descricaoOperacao',
        title: 'Descrição Operação',
      },
      {
        data: 'maquina',
        title: 'Máquina',
      },
      {
        data: 'descricaoMaquina',
        title: 'Descrição Máquina',
      },
      {
        data: 'dificuldade',
        title: 'Dificuldade',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoOriginal',
        title: 'Tempo Original',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempo',
        title: 'Tempo',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoHora',
        title: 'Tempo Hora',
      },
      {
        data: 'tempoOperacao',
        title: 'Tempo Operação',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
      {
        data: 'tempoOperacaoCapa',
        title: 'Tempo Operação Capa',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 4,
              minimumFractionDigits: 4,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
        },
        className: 'text-right',
      },
    ]

    $('#tabelaOperacoes').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      autoWidth: true,
      data,
      columns,
    }).draw(false)
  }

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    // if (permissaoUsuarioLogado.EXCLUI == 'S') {
    const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
    let data = row.data()
    if (data && data?.id) {
      let registroLiberado = await verificarRegistro('SEQUENCIA_OPERACIONAL', data?.id)
      if (registroLiberado) {
        msgAlerta(
          'Deseja excluir a sequência operacional selecionada?',
          () => { },
          () => { },
          () => excluir(data?.id, row),
        )
      }
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  async function excluir(id, row) {
    if (!id || !row) return
    $.LoadingOverlay('show')
    requisicao("DELETE", `/sisplan/sequenciaoperacional/v1/excluir?`, `&FILTROS=${encodeURIComponent(JSON.stringify({ chave: id }))}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          console.error(json?.mensagem?.mensagem)
          throw json?.mensagem?.mensagem
        }

        toastr.success("Sequência operacional excluída com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            row.remove().draw(false)
            $('#tabelaItens').DataTable().row(0).select()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      ).finally(() => $.LoadingOverlay('hide'))
  }

  limparFiltros(true)
})