$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
                position: 'top'
            }
        },
        {
            element: '#txtDocumento',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTipoEntrada',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtQualidade',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDeposito',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtBarra',
            popover: {
                title: 'Campo Barra',
                description: 'Aqui você irá bipar o produto que será dado entrada.',
                position: 'top'
            }
        },
        {
            element: '#tabela-movimentados',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui ficam os produtos bipados.',
                position: 'top'
            }
        },
        {
            element: '#confirmar_mov',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a movimentação.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let listaBarrasBipadas = [];
    const parametrosSistema = await BuscaParametrosSistema();
    const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
    const bApenasBarraLog = parametrosSistema[0].VALOR == 2;
    await buscaValoresPadroesTela();

    await setarDataAtual('txtDataMovimentoEntrada');
    let codigoEntradasManual = '';

    async function carregaTipoEntrada() {
        const pesquisaParam = {
            tabela: 'TABBAI',
            camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
            where: [`ATIVO = 'S'`],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        let entradaManual = '';

        jsonStr.forEach(tipoBaixa => {
            if (tipoBaixa.TIPO && tipoBaixa.TIPO.charAt(0) === 'S') {
                entradaManual += entradaManual ? `,'${tipoBaixa.CODIGO}'` : `'${tipoBaixa.CODIGO}'`;
            }
        });

        codigoEntradasManual = entradaManual;
    }

    await carregaTipoEntrada()

    $('#txtQuantidadeBipada').val(0);

    $("#txtPrecoSped").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
    });

    await setarDataAtual('txtDataDe');
    await setarDataAtual('txtDataAte');

    async function filtraGrade() {
        if (($('#txtProduto').val() != '') && ($('#txtCor').val() != '') && ($('#txtCor').val().substr(0, 1) == '[')) {
            let dataSet = await RetornaGradeProd();
            $('#tabela-grade').DataTable().rows().remove().draw(false);
            for (let i = 0; i < dataSet.length; i++) {
                const grade = dataSet[i];
                tabela.row.add([
                    grade.TAM,
                    grade.ESTOQUE,
                    grade.EXPEDICAO,
                    grade.RESERVA,
                    grade.QUANTIDADE,
                    `<input class="input-default" style="width:150px;" type="number" min="0" max="${grade.QUANTIDADE > 0 ? grade.QUANTIDADE : 0}"/>`
                ]).draw(false);
            }

            $('#modal-grade').modal('show');
        }
        ajustaCusto();
        await carregaDadosProduto()
    };

    function ajustaCusto() {
        const custo = $('#txtPrecoSped').val();
        if (custo.split('').includes(',')) {
            $('#txtPrecoSped').val((parseFloat((custo).replace(',', '.'))).toFixed(2));
        }
    }

    async function RetornaGradeProd() {
        let sCodigo = pegaChave('#txtProduto');
        let sDeposito = pegaChave('#txtDeposito');
        let sCor = pegaChave('#txtCor');
        let sQualidade = pegaChave('#txtQualidade');
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = `JSON={
        "tabela":"pa_iten", 
        "camposSelectSubSelect": ["DISTINCT TAM", "ESTOQUE", "SUM(COALESCE(EXPEDICAO,0)) EXPEDICAO", "SUM(COALESCE(RESERVA,0)) RESERVA", "ESTOQUE - SUM(COALESCE(EXPEDICAO,0)) - SUM(COALESCE(RESERVA,0)) QUANTIDADE", "POSICAO"], 
        "groupBySubSelect": ["TAM", "ESTOQUE", "POSICAO"],
        "camposSelect":[ "pa_iten.tam", ` +
            `"FAIXA_ITEN.POSICAO", ` +
            `" COALESCE ((SELECT COALESCE(SUM(QUANTIDADE), 0) QTDE ` +
            ` FROM [PA_ITEN] PA_ITEN_QTDE ` +
            ` WHERE PA_ITEN_QTDE.CODIGO = PA_ITEN.CODIGO ` +
            ` AND PA_ITEN_QTDE.COR = PA_ITEN.COR ` +
            ` AND PA_ITEN_QTDE.TAM = PA_ITEN.TAM ` +
            ` AND PA_ITEN_QTDE.TIPO='${sQualidade}'), 0) as ESTOQUE, ` +
            ` COALESCE ((SELECT SUM(PEDIDO3.QTDE) ` +
            ` FROM [PEDIDO3] PEDIDO3` +
            ` WHERE PEDIDO3.CODIGO    = '${sCodigo}'` +
            ` AND PEDIDO3.COR       = '${sCor}'` +
            ` AND PEDIDO3.QUALIDADE = '${sQualidade}'` +
            ` AND PEDIDO3.DEPOSITO  = PA_ITEN.DEPOSITO` +
            ` AND PEDIDO3.TAM       = PA_ITEN.TAM ` +
            ` AND PEDIDO3.LOTE      = PA_ITEN.LOTE ` +
            ` AND PEDIDO3.QTDE      > 0), 0) EXPEDICAO, ` +
            ` COALESCE ((SELECT SUM(QTDE) QTDE ` +
            ` FROM [PED_RESERVA] PED_RESERVA` +
            ` WHERE CODIGO = PA_ITEN.CODIGO ` +
            ` AND COR = PA_ITEN.COR ` +
            ` AND LOTE = PA_ITEN.LOTE ` +
            ` AND TAM = PA_ITEN.TAM ` +
            ` AND QUAL = PA_ITEN.TIPO` +
            ` AND DEPOSITO = PA_ITEN.DEPOSITO ` +
            ` HAVING SUM(QTDE) > 0), 0) RESERVA` +
            `"], 
        "leftjoin": [{ "tabela" : "produto", "condicao" : "pa_iten.codigo = produto.codigo" }, 
                     { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam" }], 
        "groupby": ["pa_iten.codigo", "pa_iten.cor", "pa_iten.tam", "faixa_iten.posicao", "pa_iten.lote", "pa_iten.deposito", "pa_iten.tipo"],
        "orderby": ["posicao"],
        "where": ["pa_iten.codigo = '${sCodigo}' and pa_iten.cor='${sCor}'"]}`;

        try {
            let response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados da venda.');
            return '';
        }
    }

    async function carregaDadosProduto() {
        try {
            let sWhere = '';
            const codigo = pegaChave('#txtProduto');
            // const cor = pegaChave('#txtCor');
            const deposito = pegaChave('#txtDeposito');
            const qualidade = pegaChave('#txtQualidade');

            if (codigo == '') {
                return;
            }

            sWhere = `PRODUTO.CODIGO = '${codigo}' ${deposito != '' ? `AND PA_ITEN.DEPOSITO = '${deposito}'` : ''} `;
            // ${cor != '' ? `AND PA_ITEN.COR = '${cor}'` : '' }
            // ${qualidade != '' ? `AND PA_ITEN.TIPO = '${qualidade}'` : ''}
            const url = `/sisplan/funcoes/v1/pesquisa?`;

            const params = `JSON={"tabela":"PA_ITEN", "camposSelect":[ "PRODUTO.CODIGO", "PA_ITEN.QUANTIDADE QUANTIDADE", "PRODUTO.CUSTO"], "leftjoin": [{ "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO " },{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR " },{ "tabela" : "TABQUL", "condicao" : "PA_ITEN.TIPO = TABQUL.CODIGO " }],"where": ["${sWhere}"]}`;

            const response = await requisicao('GET', url, params, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            let quantidade = jsonStr.RESULT[0].reduce((acc, item) => {
                return item.QUANTIDADE > 0 ? acc + item.QUANTIDADE : acc;
            }, 0);

            $('#txtEstoque').val(quantidade);
            // $('#txtPrecoSped').val(jsonStr.RESULT[0][0].CUSTO);

        } catch (error) {
            console.error(error);
        }
    }


    $('#txtTipoEntrada').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${codigoEntradasManual})"] }`, [], [], []);
    $('#btnTipoEntrada').on('click', function () {
        if (!codigoEntradasManual) {
            msgErro('Não existe Tipo Entrada cadastrada como Entrada Manual na tela "Tipo Baixa" para essa consulta.');
            return;
        }

        $('#btnTipoEntrada').pesquisa_array(['#txtTipoEntrada'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoEntradasManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
    });
    $('#btnLimpaTipoEntrada').on('click', function () {
        $('#txtTipoEntrada').val('');
    });

    $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"tabqul", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabqul", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Qualidade', 'tabqul');
    $('#btnLimpaQualidade').on('click', function () {
        $('#txtQualidade').val('');
    });

    $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnFuncionario').pesquisa_array(['#txtFuncionario'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
    $('#btnLimpaFuncionario').on('click', function () {
        $('#txtFuncionario').val('');
    });

    const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
    const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

    if (depositoUsuario != 'null') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ${depositoUsuario}}`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else if (depositosEmpresaLogada != '') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else if (json.length == 0) {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
    }

    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO, CUSTO"], "where": [] }`, ['#txtPrecoSped'], ['CUSTO'], ['CUSTO'], filtraGrade, [true]);
    // $('#btnProduto').pesquisa_array(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO'], ['DESCRICAO', 'CUSTO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"produto", "camposSelect":[ "codigo", "descricao", "custo" ], "where": null}', 'Pesquisa Produto', 'produto', filtraGrade, [false, true]);
    $('#btnProduto').pesquisa_serverside(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO', 'CODIGO2'], ['DESCRICAO', 'CUSTO', 'CODIGO2'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CUSTO", "CODIGO2" ], "where": null, "camposWhereServerSide": ["CODIGO", "DESCRICAO", "CODIGO2"]}', 'Pesquisa Produto', filtraGrade, [false, true]);
    $('#btnLimpaProduto').on('click', function () {
        $('#txtProduto').val('');
    });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#txtCor').focusout(async () => {
        await filtraGrade()
    });
    $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao" ], "where": null}', 'Pesquisa Cor', 'cadcor', filtraGrade);
    $('#btnLimpaCor').on('click', function () {
        $('#txtCor').val('');
    });

    $('#txtProduto').on('blur', function () {
        // $('#txtCor').off();
        $('#txtCor').unbind('autocompleta');
        $('#txtCor').autocompleta(1, `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], [], filtraGrade);
        $('#btnCor').off();
        $('#btnCor').unbind('pesquisa_array');
        $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "pa_iten.cor", "cadcor.descricao" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'cadcor', filtraGrade);
    });


    let tabela = $('#tabela-grade').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        // "columnDefs": [{
        //     "visible": false,
        //     "targets": 3
        // }] 
    });

    $('#tabela-movimentados').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        "columnDefs": [
            {
                "visible": false,
                "targets": 8
            },
            {
                "targets": [5, 6],
                "className": 'pr-4 text-right'
            }
        ]
    });


    $('#tabela-movimentados').on('click', '.btn-excluir', async function () {
        const itemPosicionado = $('#tabela-movimentados').DataTable().row($(this).parents('tr')).data();
        $('#tabela-movimentados').DataTable().row($(this).parents('tr')).remove().draw(false);
        VerificaQuantidadeBipada();
        removeItemListaBarra(itemPosicionado[0], itemPosicionado[2], itemPosicionado[4]);

        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonEntradaManualProduto', jsonarquivo);
    });

    async function documentoEhValido() {
        try {
            const pesquisa = {
                camposSelect: ['CODIGO'],
                tabela: 'PA_MOV',
                where: [`NUM_DOCTO = '${$('#txtDocumento').val()}'`]
            };

            const url = `/sisplan/funcoes/v1/pesquisa?`;
            const params = `JSON=${JSON.stringify(pesquisa)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                return false;
            }
            return jsonStr.RESULT[0].length > 0;
        } catch (error) {
            return false;
        }
    }

    $('#txtDocumento').on('blur', async function () {
        try {
            $.LoadingOverlay("show");
            let lancto;
            if ($(this).val() == '') {
                let docto = await RetornaDoctoELancto('DOCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtDocumento', docto);
                insereValor('#txtLancamento', lancto);
                $(this).attr('disabled', $(this).val() != '');
            } else {
                if (!await documentoEhValido()) {
                    msgAlerta('Documento inválido, verifique', null, null, () => {
                        $('#txtDocumento').focus();
                    });
                    $('#txtDocumento').val('');
                    return;
                }
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtLancamento', lancto);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#tabela-movimentados tbody').on('click', 'tr', function () {
        const tabelamovimentados = $('#tabela-movimentados').DataTable();
        tabelamovimentados.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });

    $('#btnMenosOuMais').on('click', function () {
        const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
        $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').focus();
        $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
        if (estaComoEstorno) {
            $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
    });

    $('#txtBarra').on('blur', async function () {
        let qtde = Number($('#txtQuantidade').val());
        const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
        const ehPrimeiroRegistro = $('#tabela-movimentados').DataTable().rows().data().toArray().length === 0;
        const ehbarralog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";

        if ($('#txtBarra').val() == '') {
            return;
        }

        if (!ehbarralog && bApenasBarraLog) {
            msgAlerta('Barra log não encontrada, impossível continuar!');
            return;
        }

        if (ehPrimeiroRegistro && estornaQuantidade == 'true') {
            SomAlerta(BASE_URI, true);
            return msgAlerta("Nenhuma barra encontrada para estornar!");
        }

        try {
            $.LoadingOverlay("show");
            bloqueiaCampos('card-body', true);

            if (!($('#txtQuantidade').val() > 0)) {
                msgAlerta('Quantidade inválida, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }
            if ($('#txtLote').val() == '') {
                msgAlerta('Lote inválido, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }
            let dadosProd = typeof (await retornaDadosBarra($(this).val(), ehbarralog))[0] === 'undefined' ? null : (await retornaDadosBarra($(this).val(), ehbarralog))[0];

            if (dadosProd == null) {
                msgAlerta('Nenhum dado para esta barra!');
                SomAlerta(BASE_URI, true);
                $('#txtBarra').val('');
                $('#txtBarra').focus();
                return;
            }

            if (utilizaBarraLog && ehbarralog && $("#txtQuantidade").val() > 1) {
                msgAlerta("Quantidade inválida. Permitido bipar somente uma quantidade na barra log.");
                SomAlerta(BASE_URI, true);
                return;
            }

            if (utilizaBarraLog && ehbarralog && (pegaChave('#txtDeposito') == '')) {
                msgAlerta("Necessário informar o depósito ao bipar barra log.");
                SomAlerta(BASE_URI, true);
                return;
            }

            const barraEstornada = utilizaBarraLog ? await barraJaEstornada($('#txtBarra').val()) : false;

            if (barraEstornada && estornaQuantidade == 'true' && ehbarralog) {
                msgErro(`Barra ${$('#txtBarra').val()} já estornada, verifique.`);
                SomAlerta(BASE_URI, true);
                return;
            }

            if (utilizaBarraLog) {
                if (estornaQuantidade == 'true') {
                    await estornaBarraBipada($('#txtBarra').val());
                }
            }
            const barraBipada = utilizaBarraLog ? await barraJaEstaBipada($('#txtBarra').val()) : false;
            if (utilizaBarraLog) {
                if (estornaQuantidade == 'false') {
                    await adicionaBarraBipada(
                        {
                            codigo: dadosProd.CODIGO,
                            cor: dadosProd.COR,
                            tam: dadosProd.TAM,
                            barra: $('#txtBarra').val(),
                            deposito: pegaChave('#txtDeposito')
                        }
                    );
                }
            }


            if (!barraBipada) {
                $('#tabela-movimentados').DataTable().rows().data().map((item, index) => {

                    if ((dadosProd.CODIGO == item[0]) && (dadosProd.COR == item[2]) && (dadosProd.TAM == item[4]) && ($('#txtLote').val() == item[7])) {
                        if (estornaQuantidade == 'false') {
                            qtde = parseFloat(item[5]) + parseFloat($('#txtQuantidade').val());
                        } else {
                            qtde = parseFloat(item[5]) - parseFloat($('#txtQuantidade').val());
                        }

                        $('#txtQuantidade').val(qtde);
                        $('#tabela-movimentados').DataTable().rows(index).remove().draw();
                    }
                    return 'ok';
                });


                if (ehPrimeiroRegistro || qtde > 0) {
                    $('#tabela-movimentados').DataTable().row.add([
                        dadosProd.CODIGO,
                        dadosProd.DESCRICAO,
                        dadosProd.COR,
                        dadosProd.DESCCOR,
                        dadosProd.TAM,
                        qtde,
                        $('#txtPrecoSped').val(),
                        $('#txtLote').val(),
                        dadosProd.ID,
                        retornaBotaoOpcoes()
                    ]).draw(false);
                    SomAlerta();
                    VerificaQuantidadeBipada();
                }
            }

            $('#tabela-movimentados tbody tr:last-child').trigger('click');
            let $scrollBody = $($('#tabela-movimentados').DataTable().table().node()).parent();
            $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
            await VerificaQuantidadeBipada();

            const jsonarquivo = montaJsonArquivo();
            await salvaArquivo('JsonEntradaManualProduto', jsonarquivo);
        } finally {
            $.LoadingOverlay("hide");
            bloqueiaCampos('card-body', false);
            $('#txtBarra').val('');
            $('#txtQuantidade').val('1');
            $('#txtBarra').focus();
        }
    });

    async function VerificaQuantidadeBipada() {
        const quantidade = $("#tabela-movimentados")
            .DataTable()
            .column(5, {})
            .data()
            .sum();
        $('#txtQuantidadeBipada').val(+quantidade);
    }

    $("#btnCancelarEntradaManual").on("click", async function () {
        msgAlerta("Deseja realmente cancelar a movimentação?", () => { deletaArquivo("JsonEntradaManualProduto"), window.location.reload() });

    });

    $('#btnConfirmar').on('click', async function () {
        if ($('#txtProduto').val() == '') {
            msgErro('Informe um produto para continuar.');
            return;
        }

        if ($('#txtDocumento').val() == '') {
            msgErro('Necessário um número de documento para continuar.');
            return;
        }

        if ($('#txtTipoEntrada').val() == '') {
            msgErro('Informe um tipo de entrada para continuar.');
            return;
        }

        if ($('#txtQualidade').val() == '') {
            msgErro('Informe uma qualidade para continuar.');
            return;
        }

        if ($('#txtDeposito').val() == '') {
            msgErro('Informe um deposito para continuar.');
            return;
        }

        if ($('#txtCor').val() == '') {
            msgErro('Informe uma cor para continuar.');
            return;
        }

        if ($('#txtPrecoSped').val() <= 0) {
            msgErro('Informe um preço válido para continuar.');
            return;
        }

        // valida grade
        if ($('td>input').length <= 0) {
            msgErro('Não há grade para o produto/cor informado, verifique.');
            return;
        }
        let bTemQtde = false;
        for (let index = 0; index < $('td>input').length; index++) {
            let qtde = $($('td>input')[index]).val();
            if (qtde > 0) {
                bTemQtde = true;
            }
        }
        if (!bTemQtde) {
            msgErro('Grade sem quantidade, impossível continuar.');
            return;
        }

        let sProduto = pegaChave('#txtProduto');
        let sDescricao = pegaDescricao('#txtProduto');
        let sCor = pegaChave('#txtCor');
        let sDescCor = pegaDescricao('#txtCor');
        let arrEstoque = [];
        await $('#tabela-grade').DataTable()
            .rows()
            .data()
            .each(async function (value, index) {

                let sTam = value[0];
                let vQtde = $($('td>input')[index]).val();
                if ((vQtde > 0)) {
                    arrEstoque.push(await montaJsonEstoque(sProduto, sCor, sTam, vQtde, $('#txtPrecoSped').val(), $('#txtLote').val()));
                }
            });

        try {
            await $.LoadingOverlay("show");
            for (let index = 0; index < arrEstoque.length; index++) {
                const element = arrEstoque[index];
                await $('#tabela-movimentados').DataTable().row.add([
                    sProduto,
                    sDescricao,
                    sCor,
                    sDescCor,
                    element.tamanho,
                    element.quantidade,
                    $('#txtPrecoSped').val(),
                    $('#txtLote').val(),
                    0,
                    retornaBotaoOpcoes()
                ]).draw(false);
            }
        } finally {
            await $.LoadingOverlay("hide");
        }

        limpaValor('#txtProduto');
        limpaValor('#txtCor');
        limpaValor('#txtPrecoSped');
        limpaValor('#txtEstoque');
        limpaValor('#txtObs');
        $('#tabela-grade').DataTable().rows().remove().draw(false);
        $('#txtProduto').focus();


        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonEntradaManualProduto', jsonarquivo);
        VerificaQuantidadeBipada();

        $('#modal-grade').modal('hide');

    });

    $('#confirmar_mov').on('click', async function () {

        try {
            $('#confirmar_mov').prop('disabled', true);
            $.LoadingOverlay("show");
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros != 0) {
                $('#confirmar_mov').prop('disabled', false);
                return;
            }

            if ($('#tabela-movimentados').DataTable().rows().count() == 0) {
                $('#confirmar_mov').prop('disabled', false);
                msgAlerta('Nenhum produto bipado, favor verificar.');
                return;
            }
            await gravarMovimentacao();
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#msform').validate({
        ignore: "",
        rules: {
            txtDocumento: {
                required: true,
            },
            txtTipoEntrada: {
                required: true,
            },
            txtQualidade: {
                required: true,
            },
            txtDeposito: {
                required: true,
            },
            txtDataMovimentoEntrada: {
                required: true,
            },
            txtFuncionario: {
                required: true,
            }
        },
        messages: {
            txtDocumento: {
                required: "Gere um documento para continuar."
            },
            txtTipoEntrada: {
                required: "Informe um tipo de entrada."
            },
            txtQualidade: {
                required: "Informe uma qualidade."
            },
            txtDeposito: {
                required: "Informe um depósito."
            },
            txtDataMovimentoEntrada: {
                required: "Informe uma data de movimento."
            },
            txtFuncionario: {
                required: "Informe um funcionário."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    $('.somAtivo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodEntrada.somAtivo", false);
        $('.somInativo').removeClass('d-none');
    });

    $('.somInativo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodEntrada.somAtivo", true);
        $('.somAtivo').removeClass('d-none');
    });

    const somAtivo = localStorage.getItem('@prodEntrada.somAtivo') ?? 'false';
    if (somAtivo == 'true') {
        $($('.somInativo')[0]).trigger('click');
    }

    function montaJsonEstoque(codigo, cor, tam, qtde, custo, lote) {
        let EstProd = {
            codigo,
            cor,
            tamanho: tam,
            deposito: pegaChave('#txtDeposito'),
            quantidade: qtde,
            documento: $('#txtDocumento').val(),
            custo,
            qualidade: pegaChave('#txtQualidade'),
            lote,
            unidade: '',
            cliente: '',
            descricao: '',
            tipobaixa: pegaChave('#txtTipoEntrada'),
            tipo: 'MN',
            observacao: $('#txtObs').val(),
            barralog: 'campo de barra',
            funcionario: pegaChave('#txtFuncionario'),
            data: $('#txtDataMovimentoEntrada').val()
        };
        return EstProd;
    }

    async function gravarMovimentacao() {
        try {
            const listaEstProd = {
                produtos: []
            }
            $('#tabela-movimentados').DataTable()
                .rows()
                .data()
                .each(async function (value) {
                    listaEstProd.produtos.push(montaJsonEstoque(value[0], value[2], value[4], value[5], value[6], value[7]));
                });
            let sLancto = $('#txtLancamento').val();

            const barraslog = {
                barras: utilizaBarraLog ? listaBarrasBipadas : []
            };

            const response = await requisicao(pagar = 'POST', '/Sisplan/Estoque/V1/MovimentaEstoque?', '', `JSON=${encodeURIComponent(JSON.stringify(listaEstProd))}&LANCTO=${sLancto}&TIPO=ENTRADA&JSONBARRAS=${encodeURIComponent(JSON.stringify(barraslog))}`, 300000);

            if (!response) {
                $('#confirmar_mov').prop('disabled', false);
                return;
            }

            if (response.status != 200) {
                $('#confirmar_mov').prop('disabled', false);
                msgErro(`Erro API:${jsonStr.RESULT[0].mensagem}`);
                return;
            }

            $('#txtQuantidadeBipada').val(0);

            msgAlerta('Deseja imprimir a movimentação?',
                () => { },
                () => { callBack(); },
                async () => {
                    await ImprimirRelatorio();
                    callBack();
                },
                () => { callBack(); });

            function callBack() {

                toastr.success("Movimentação realizada com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    }
                }).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px",
                });

            }

            await deletaArquivo('JsonEntradaManualProduto');
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
            msgErro(`Não foi possível gravar os dados do Estoque: ${error}`);
        }
    }

    async function adicionaBarraBipada(objItem) {
        try {
            const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
            if (['barra_log'].includes(retornoBarraLog)) {
                listaBarrasBipadas.push(objItem);
                return true;
            } else {
                return false;
            }
        } catch (error) {
            console.error(error);
        }
    }

    async function retornaDadosBarra(sBarra, bBarraLog) {
        let barra28 = sBarra;
        if (bBarraLog) {
            barra28 = await extraiBarra28(sBarra);
        }

        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESCCOR", "PA_ITEN.TAM", "PRODUTO.CUSTO", "0 ID"],
        "innerjoin": [{ "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" }],
        "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "CADCOR.COR = PA_ITEN.COR"}],
        "where": ["PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barra28}' OR PA_ITEN.BARRACLI = '${sBarra}'"]}`);

        try {
            let response = await requisicao('GET', url, params, null);
            if (!response) {
                return '';
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            return jsonStr.RESULT[0];

        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados da venda.');
            return '';
        }
    }

    async function retornaBarraLogLida(sBarra) {
        try {
            const url = `/sisplan/barralog/v1/validarbarra?`;
            const params = `barra=${encodeURIComponent(sBarra)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
                return jsonStr.mensagem;
            }

            return jsonStr.mensagem;
        } catch (error) {
            console.error(error);
        }
    }

    async function barraJaEstaBipada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                msgErro(`Barra ${sBarra} já lida, verifique.`);
                return true;
            }
            return false;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function barraJaEstornada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                return false;
            }
            return true;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function removeItemListaBarra(sCodigo, sCor, sTam) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.codigo !== sCodigo && item.cor !== sCor && item.tam !== sTam)];
        } catch (error) {
            console.error(error);
        }
    }

    async function estornaBarraBipada(sBarra) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
        } catch (error) {
            console.error(error);
        }
    }

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    retornaHintRelatorio('btnImprimir', 'relentradabarraproduto')

    $("#btnImprimir").on("click", async function () {
        ImprimirRelatorio();
    });

    async function ImprimirRelatorio() {
        let dadosBackEnd = {};
        let arrayTransferencia = [];
        const Dados = $('#tabela-movimentados').DataTable().rows().data();
        Dados.each((campo => {
            dadosBackEnd = {
                CODIGO: campo[0],
                DESCRICAO: campo[1],
                COR: campo[2],
                TAM: campo[4],
                QTDE: +campo[5],
                PRECOSPED: +campo[6],
                LOTE: campo[7],
                NUM_DOCTO: pegaValor('#txtDocumento')
            };
            arrayTransferencia.push(dadosBackEnd);
        }));
        console.log(arrayTransferencia);
        const url = `/sisplan/impressao/v1/imprimirentradaporbarra?`;
        const params = `JSON=${JSON.stringify(arrayTransferencia)}`;
        const response = await requisicao('GET', url, params, null);
        const arquivo = await response.text();

        if (arquivo != undefined) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            await limparRelatorios();
        }
    };

    try {
        const response = await carregaArquivo('JsonEntradaManualProduto');
        if (response.status === 200) {
            const jsonStr = await response.json();
            insereValor("#txtDocumento", jsonStr.documento);
            insereValor("#txtLancamento", jsonStr.lancamento);
            insereValor("#txtDataMovimentoEntrada", jsonStr.data);
            insereValor("#txtFuncionario", jsonStr.funcionario.split("] - ")[0].substr(1), jsonStr.funcionario.split("] - ")[1]);
            insereValor("#txtTipoEntrada", jsonStr.tipoentrada.split("] - ")[0].substr(1), jsonStr.tipoentrada.split("] - ")[1]);
            insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
            insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
            jsonStr.itens.forEach((item) => {
                $("#tabela-movimentados")
                    .DataTable()
                    .row.add([
                        item.codigo,
                        item.descricao,
                        item.cor,
                        item.desc_cor,
                        item.tam,
                        item.qtde,
                        item.precosped,
                        item.lote,
                        item.id,
                        retornaBotaoOpcoes(),
                    ])
                    .draw(false);
            });
            listaBarrasBipadas = jsonStr.barrasbipadas;
            VerificaQuantidadeBipada();
            msgAlerta("Carregado dados não salvos, verifique.");
        }
    } catch (error) {
        console.log(error);
    }

    function montaJsonItens() {
        const itensDataTable = $("#tabela-movimentados").DataTable().data().toArray();
        const itens = itensDataTable.map((itemDT) => {
            const item = {
                codigo: itemDT[0],
                descricao: itemDT[1],
                cor: itemDT[2],
                desc_cor: itemDT[3],
                tam: itemDT[4],
                qtde: itemDT[5],
                precosped: itemDT[6],
                lote: itemDT[7],
                id: itemDT[8],
            };
            return item;
        });
        return itens;
    }

    function montaJsonArquivo() {
        const importacao = {
            documento: $("#txtDocumento").val(),
            lancamento: $("#txtLancamento").val(),
            tipoentrada: $("#txtTipoEntrada").val(),
            qualidade: $("#txtQualidade").val(),
            deposito: $("#txtDeposito").val(),
            funcionario: $("#txtFuncionario").val(),
            data: $("#txtDataMovimentoEntrada").val(),
            itens: montaJsonItens(),
            barrasbipadas: listaBarrasBipadas,
        };
        return importacao;
    }

    async function buscaValoresPadroesTela() {
        $.LoadingOverlay('show');

        try {
            const buscarValoresPadrao = async () => {
                const response = await requisicao(
                    'POST',
                    '/sisplan/valorespadroes/v1/buscar?',
                    '',
                    JSON.stringify({ POSICAO: '1' })
                );

                if (response) {
                    const jsonStr = await response.json();
                    insereValor('#txtTipoEntrada', jsonStr.tipoSaida);
                    insereValor('#txtQualidade', jsonStr.qualidade);
                    insereValor('#txtDeposito', jsonStr.deposito);
                }
            };

            const buscarCores = async () => {
                const dados = await buscaValoresPadroes('CADOF')
                dados.forEach(item => {
                    if (item.CAMPO === 'COR_ENT_MANUAL' && item.VALOR) {
                        insereValor('#txtCor', item.VALOR, { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'COR', valorWhere: item.VALOR });
                    }
                });
            };

            const buscarTipos = async () => {

                const dados = await buscaValoresPadroes('ESTOQUE')

                const mapeamentoCampos = {
                    'ENTRADA_PROD': (item) => {
                        if (item.VALOR) {
                            insereValor('#txtTipoEntrada', item.VALOR, {
                                tabela: 'TABBAI',
                                campoBusca: 'DESCRICAO',
                                campoWhere: 'CODIGO',
                                valorWhere: item.VALOR
                            });
                        }
                    }
                };

                dados.forEach(item => {
                    if (mapeamentoCampos[item.CAMPO]) {
                        mapeamentoCampos[item.CAMPO](item);
                    }
                });
            };

            await Promise.all([
                buscarValoresPadrao(),
                buscarCores(),
                buscarTipos()
            ]);

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }
});
