$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Código',
                    description: "Aqui, adicionamos o codigo do país.",
                    position: 'top'
                }
            },
            {
                element: '#txtNome',
                popover: {
                    title: 'Nome',
                    description: 'Aqui, adicionamos o Nome do país.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#gravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o cadastro de país.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    componenteFiltro('moeda', false, false)
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let pais = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PAIS', getCookie('usuario'), pais);
        window.location.href = `${BASE_URI}/pais`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtNome: {
                    required: true,
                },
                txtCodigo: {
                    required: true,
                },
            },
            messages: {
                txtNome: {
                    required: "Informe um nome válido."
                },
                txtCodigo: {
                    required: "Informe um codigo válido."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (pais != '' && pais != 'create') {

        if (await liberarRegistro('PAIS', pais) == false) {
            window.location.href = '../pais';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CADPAIS", 
                    "camposSelect":["CODIGO", "NOME", "COD_SISCOMEX", "DDI", "IDIOMA_COMERCIAL", "MOEDA"], 
                    "where": ["CODIGO = '${pais}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtNome').val(jsonStr.RESULT[0][0].NOME);
                    $('#txtSiscomex').val(jsonStr.RESULT[0][0].COD_SISCOMEX);
                    $('#txtDDI').val(jsonStr.RESULT[0][0].DDI);
                    $('#rgLinguagem').val(jsonStr.RESULT[0][0].IDIOMA_COMERCIAL);
                    insereValor('#txtMoeda', jsonStr.RESULT[0][0].MOEDA, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: jsonStr.RESULT[0][0].MOEDA });
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do país: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    let paisClasse = {};

                    paisClasse.CODIGO = $('#txtCodigo').val();
                    paisClasse.NOME = $('#txtNome').val().toUpperCase();
                    paisClasse.CODSISCOMEX = $('#txtSiscomex').val();
                    paisClasse.DDI = $('#txtDDI').val();
                    paisClasse.IDIOMACOMERCIAL = $('#rgLinguagem').val();
                    paisClasse.MOEDA = pegaChave('#txtMoeda');

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/pais?', `JSON=${encodeURIComponent(JSON.stringify(paisClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/pais`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});