/* eslint-disable prefer-destructuring */
// $("#tutorial").on("click", function () {
//   $(document).ready(async function () {
//     const driver = new Driver({
//       doneBtnText: "Sair",
//       closeBtnText: "Fechar",
//       nextBtnText: "Próximo",
//       prevBtnText: "Anterior",
//       allowClose: false,
//       animate: true,
//     });

//     driver.defineSteps([
//       {
//         element: "#tourGeral",
//         popover: {
//           title: "Dados Gerais",
//           description: "Aqui estão os dados gerais da nota.",
//           position: "top",
//         },
//       },
//       {
//         element: "#txtCliente",
//         popover: {
//           title: "Campos Obrigatórios",
//           description:
//             "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
//           position: "top",
//         },
//       },
//       {
//         element: "#txtDeposito",
//         popover: {
//           title: "Campos Obrigatórios",
//           description:
//             "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
//           position: "top",
//         },
//       },
//       {
//         element: "#avancar1",
//         popover: {
//           title: "Botão Avançar",
//           description:
//             "Clique aqui para avançar para a aba itens, onde será possível adicionar itens e após isso, adicionar duplicatas e/ou gravar a nota.",
//           position: "left",
//         },
//       },
//     ]);
//     driver.start();
//   });
// });

$(document).ready(async function () {

  await verificaPermissoes('ORDEM_SERVICO');
  await setarDataAtual("txtDataEmissao");
  await setarDataAtual("txtDataSaida");
  await setarDataAtual("txtDtBaixa");
  await carregaValoresPadroes();
  await adicionaEmpresas();
  await validaEdicao();

  addPesquisaAutocompleta();
  criaMascaraCampos();

  let tipoPesquisa = 'S';

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCliente: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtTransportadora: {
        required: true,
      },
      "txtProduto-0": {
        required: true,
      },
      "txtQuantidade-0": {
        required: true,
      },
      "txtPreco-0": {
        required: true,
      },
      txtMoeda: {
        required: true,
      },
      txtHistorico: {
        required: true,
      },
      txtBanco: {
        required: true,
      },
      txtSituacao: {
        required: true,
      },
      txtClasseGer: {
        required: true,
      },
    },
    messages: {
      txtCliente: {
        required: "Informe um cliente válido.",
      },
      txtDeposito: {
        required: "Informe um depósito válido.",
      },
      txtTransportadora: {
        required: "Informe uma transportadora válida.",
      },
      "txtProduto-0": {
        required: "Informe um produto válido.",
      },
      "txtQuantidade-0": {
        required: "Informe uma quantidade válida.",
      },
      "txtPreco-0": {
        required: "Informe um preço válido.",
      },
      txtMoeda: {
        required: "Informe uma moeda válida.",
      },
      txtHistorico: {
        required: "Informe um histórico válido.",
      },
      txtBanco: {
        required: "Informe um banco válido.",
      },
      txtSituacao: {
        required: "Informe uma situação válida.",
      },
      txtClasseGer: {
        required: "Informe uma classe válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".next").click(async function () {
    let currentFs = $(this).parent();
    if (currentFs.prevObject[0].id == 'avancar1') {
      if (!$('#txtCliente').val()) {
        throw msgAlerta('Necessário inserir um cliente, verifique!')
      }
    }

    let nextFs = $(this).parent().next();
    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
    nextFs.show();
    currentFs.animate(
      {
        opacity: 0
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none", position: "relative",
          });
          nextFs.css({ opacity, });
        },
        duration: 600
      }
    );
  });

  $(".previous").click(async function () {
    let currentFs = $(this).parent();
    let previousFs = $(this).parent().prev();
    $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({ display: "none", position: "relative" });
          previousFs.css({ opacity });
        },
        duration: 600,
      }
    );
  });

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $("#txtCliente").change(async function () {
    const codcli = pegaChave("#txtCliente");
    try {
      const responseOperadora = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"entidade", "camposSelect":["bloqueio"], "where": ["codcli = '${codcli}'"]}`, null);
      const jsonStr = await responseOperadora.json();

      if (jsonStr.RESULT[0][0].BLOQUEIO == "S" && !confirm("Cliente bloqueado, deseja continuar mesmo assim?")) {
        $("#txtCliente").val("");
        $("#txtCliente").trigger("blur");
      }
      criarToolTipCliente(codcli);
    } catch (error) {
      console.error(error);
    }
  });

  function AddItens() {
    const itens = $(".itens");
    $("#items-wrap").append(
      `<div class="row itens" ${parseInt(itens.length) != 0 ? 'style="margin-top:3px"' : ""}>
                <div class="item-${itens.length} contador col-1">
                  <span id="item-${itens.length}">${itens.length + 1}</span>
            </div>
            <div class="item-${itens.length} col-lg-6 col-12">
            ${itens.length == 0 ? `<label data-error="wrong" data-success="right" for="txtProduto-${itens.length}">Item</label>` : ""}
                      <div class="input-group">
                          <input type="text" class="inputs input-default focus form-control classeProduto txtItem-${itens.length}" style="margin-left:5px;"id="txtProduto-${itens.length}" name="txtProduto-${itens.length}" placeholder="Serviço (F4 para pesquisar)" readonly>
                          <div class="input-group-append">
                            <a id="btn-produto-${itens.length}"><i class="fas fa-search text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i></a>
                            <a id="btn-limpa-produto-${itens.length}"><i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i></a>
                          </div>
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-2 col-12">
                      ${itens.length == 0 ? `<label data-error="wrong" data-success="right" for="txtQuantidade-${itens.length}">Qtde.</label>` : ""}
                      <div class="input-group">
                          <input type="text" maxlength="8" class="inputs input-default focus form-control maskItens classeQuantidade"
                              min="0" id="txtQuantidade-${itens.length}" name="txtQuantidade-${itens.length}" class="form-control" placeholder="Qtde.">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-2 col-12">
                  ${itens.length == 0 ? '<label data-error="wrong" data-success="right" for="txtPreco">Preço</label>' : ""}
                      <div class="input-group">
                          <input type="text" maxlength="10" class="inputs input-default focus form-control maskItens classePreco"
                              min="0" id="txtPreco-${itens.length}" name="txtPreco-${itens.length}" class="form-control" placeholder="Preco">
                      </div>
                  </div>
                  <div class="col-lg-1 col-12">
                      <div class="btn-group grupo_botao item-${itens.length}" role="group" aria-label="Basic example">
                          <button type="button" class="btn btn-opcao bg-light nofocus btn-limpa-${itens.length}">
                              <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                          </button>
                          <button type="button" class="btn btn-opcao bg-light nofocus btn-add-${itens.length}">
                              <i class="fas fa-plus text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                          </button>
                      </div>
                  </div>
                </div>`
    );

    $(`.item-${itens.length}:not(:first-child)`).css("padding", "0 1.3px 0 0");
    $(".maskItens").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".classePreco").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2
    });

    let id = `.btn-limpa-${itens.length}`;

    $('#radioProduto').on('click', function () {
      $('#tabelaProdutos').DataTable().rows().clear().draw()
      tipoPesquisa = 'P';
    });

    $('#radioServico').on('click', function () {
      $('#tabelaProdutos').DataTable().rows().clear().draw()
      tipoPesquisa = 'S';
    });

    $(`#txtProduto-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 115) {
        $(`#btn-produto-${itens.length}`).trigger("click");
      }
      if (e.keyCode == 13) {
        $(`#txtQuantidade-${itens.length}`).focus();
      }
    });

    $(`#txtQuantidade-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 13) {
        $(`#txtPreco-${itens.length}`).focus();
      }
    });
    $(`#txtPreco-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 13) {
        $(`#btn-add-${itens.length}`).trigger('click');
      }
    });

    $(`#txtProduto-${itens.length}`).on("change, blur", function () {
      adicionaHint(`#txtProduto-${itens.length}`);
    });

    $(`#btn-limpa-produto-${itens.length}`).on("click", function () {
      $(`#txtProduto-${itens.length}`).val("");
      $(`#txtProduto-${itens.length}`).attr("data-codigo", "");
      $(`#txtProduto-${itens.length}`).attr("data-cor", "");
      $(`#txtProduto-${itens.length}`).attr("data-tam", "");
    });

    $(`.btn-add-${itens.length}`).on("click", function () {
      let qtdeProd = $(".itens");
      let elemento = $(this).attr("class").split("-");
      elemento = elemento[elemento.length - 1];
      if (parseInt(elemento) === qtdeProd.length - 1 && $(`#txtProduto-${elemento}`).val() != "") {
        AddItens();
        $(`#txtProduto-${parseInt(elemento) + 1}`).focus();
      }
    });

    $(`#btn-produto-${itens.length}`).on("click", function () {
      $("#idLinha").val(this.id.split("-")[2]);
      $("#modalProduto").modal("show");
      if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
        $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
      }
      $("#txtProdutoCodigo").val("");
      $("#txtProdutoDescricao").val("");
    });

    $(`#txtPreco-${itens.length}`).on("blur", function () {
      if ($(`#txtQuantidade-${itens.length}`).val() != "") {
        calculaTotaisItens();
      }
    });

    $(`#txtQuantidade-${itens.length}`).on("blur", function () {
      if ($(`#txtPreco-${itens.length}`).val() != "") {
        calculaTotaisItens();
      }
    });

    addEvent(id);
    return itens.length;
  }

  $("#modalProduto").on("shown.bs.modal", function () {
    if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
      $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
    }
    $("#txtProdutoCodigo").focus();
  });

  $("#txtProdutoDescricao").on("focusout", function () {
    $("#btnConsultarProduto").focus();
  });

  $("#btnConsultarProduto").on("keypress", function () {
    $("#btnConsultarProduto").trigger("click");
  });

  $("#modalProduto").on("hidden.bs.modal", function () {
    const id = $("#idLinha").val();
    $(`#txtProduto-${id}`).trigger("blur");
    $(`#txtProduto-${id}`).focus();
  });

  $("#txtProdutoCodigo").change(async function () {
    if (tipoPesquisa == 'P') {
      await buscaProdutos();
    } else {
      await buscaServicos();
    };
  });

  $("#txtProdutoDescricao").change(async function () {
    if (tipoPesquisa == 'P') {
      await buscaProdutos();
    } else {
      await buscaServicos();
    };
  });

  $("#btnConsultarProduto").on("click", async function () {
    if (tipoPesquisa == 'P') {
      await buscaProdutos();
    } else {
      await buscaServicos();
    };
  });

  $("#btn_confirmar_produto").click(async function () {
    let data = $("#tabelaProdutos").dataTable().api().row(".selected").data();
    const regiao = pegaChave('#txtTabPreco');
    const id = $("#idLinha").val();
    $(`#txtProduto-${id}`).val(`${data.CODIGO} - ${data.DESCRICAO} ${(tipoPesquisa == 'P' ? ` - ${data.COR} - ${data.TAM}` : '')}`);
    $(`#txtProduto-${id}`).attr("data-codigo", data.CODIGO);
    $(`#txtProduto-${id}`).attr("data-descricao", data.DESCRICAO);
    $(`#txtProduto-${id}`).attr("data-cor", (data.COR != '' && data.COR != undefined ? data.COR : ''));
    $(`#txtProduto-${id}`).attr("data-tam", (data.TAM != '' && data.TAM != undefined ? data.TAM : ''));
    if (tipoPesquisa == 'P') {
      const preco = await retornaPrecoProduto(data.CODIGO, regiao);
      if (preco != undefined) {
        $(`#txtPreco-${id}`).val(`${(preco.toFixed(2))}`);
      }
      $(`#txtQuantidade-${id}`).val(1);
    }

    $("#modalProduto").modal("hide");
  });

  async function retornaPrecoProduto(codigoProduto = '', tabPreco = '') {
    try {
      if (tabPreco == '') {
        return
      }

      if (codigoProduto == '') {
        return
      }

      const PesquisaPreco = {
        tabela: 'TABPRECO',
        camposSelect: ['PRECO_00'],
        where: [`CODIGO = '${codigoProduto}' AND REGIAO = '${tabPreco}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaPreco));

      return jsonStr[0].PRECO_00;

    } catch (error) {
      msgAlerta('Não foi possível buscar preço do produto! Verifique se existe preço desse mesmo produto na tabela de preço.');
      console.error(error);
    }
  };

  function addEvent(element) {
    $(element).blur(function () {
      let itens = $(".itens");
      let id = $(this).attr("class").split("-");
      id = id[id.length - 1];
      if (
        parseInt(id) === itens.length - 1 &&
        $(`#txtProduto-${id}`).val() != ""
      ) {
        AddItens();
        $(`#txtProduto-${parseInt(id) + 1}`).focus();
      }
    });

    $(element).on("click", async function () {
      let itens = $(".itens");
      let id = $(this).attr("class").split("-");
      id = id[id.length - 1];
      const idInput = $(`.txtItem-${id}`)[0].id;
      if (itens.length === 1) {
        itens = [];
        $(`.item-${id}`).closest(".row").remove();
        AddItens();
      } else {
        await DeleteItem(id);
        $(`.removido`).closest(".row").remove();
        if (id == 0) {
          $($(`.itens > .item-0 > .input-group`)[0]).css("margin-top", "8%");
          $($(`.itens > .item-0 > .input-group`)[1]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[2]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[3]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[4]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[5]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[6]).css("margin-top", "33%");
        }
      }
    });
  }

  $("#btnConfirmarTrib").on("click", function () {
    const indice = $("#txtIndiceAlteracao").val();
    $(`#txtEnquadra${indice}`).val($("#txtEnquadra").val());
    $(`#txtCsosn${indice}`).val($("#txtCsosn").val());
    $(`#txtCstIcms${indice}`).val($("#txtCstIcms").val());
    $(`#txtCstIpi${indice}`).val($("#txtCstIpi").val());
    $(`#txtCstPis${indice}`).val($("#txtCstPis").val());
    $(`#txtCstCofins${indice}`).val($("#txtCstCofins").val());

    $(`#modalTribProd`).modal("hide");
  });

  $('#btnVoltarAcesso').on('click', function () {
    window.location.href = `${BASE_URI}/ordemservico`;
  });

  $('#txtPercDesc').on('blur', function () {
    calculaTotaisItens();
  })

  function calculaTotaisItens() {
    let totHoras = 0;
    let totItens = 0;
    let totTotal = 0;

    for (let i = 0; i < $('.itens').length; i++) {
      const pQtde = parseFloat($(`#txtQuantidade-${i}`).val());
      const pPreco = parseFloat($(`#txtPreco-${i}`).val());
      if ((pQtde > 0) && (pPreco > 0)) {
        totHoras += parseFloat(pQtde);
        totItens += (ArredondarValor(pQtde * pPreco, 2));
        totTotal += (ArredondarValor(pQtde * pPreco, 2));
      }
    }

    const porcentagemDesconto = $('#txtPercDesc').val();
    const totDesconto = totTotal * (porcentagemDesconto / 100);

    $('#txtTotalDesconto').html(parseFloat(totDesconto).toLocaleString("pt-BR", { style: "currency", currency: "BRL" }))
    $("#txtTotalHoras").html(ArredondarValor(totHoras, 2));
    $("#txtTotalItens").html(parseFloat(totItens).toLocaleString("pt-BR", { style: "currency", currency: "BRL" }));
    $("#txtValorTotal").html(parseFloat(totTotal).toLocaleString("pt-BR", { style: "currency", currency: "BRL" }));
    $('#txtTotalLiquido').html(parseFloat(totTotal - totDesconto).toLocaleString("pt-BR", { style: "currency", currency: "BRL" }))
  };

  function decodeHTMLEntities(text) {
    var textArea = document.createElement('textarea');
    textArea.innerHTML = text;
    return textArea.value;
  }

  async function validaEdicao() {
    AddItens();

    const sNumero = $(window.location.href.split('/')).get(-1);

    if (sNumero == 'create') {
      insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 6));
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'OS',
        camposSelect: [
          'OS.NUMERO', 'OS.USUARIO', 'OS.CODREP', 'OS.CLIENTE', 'OS.DT_CADASTRO', 'OS.DT_SAIDA', 'OS.TERCEIRO', 'OS.DUPLICATA',
          'OS.DESCONTO', 'OS.STATUS', 'OS.REQUISITANTE', 'OS.SETOR', 'OS.OBSERVACAO', 'OS.DESCONTO_VALOR', 'OS.DT_BAIXA',
          'OS.PEDIDO', 'OS.EMP_FAT', 'OS.VEICULO', 'OS.ANO_MODELO', 'OS.KILOMETRAGEM', 'OS.CHASSI', 'OS.PLACA', 'OS.TAB_PRE',
          'REPRESEN.NOME NOME_REP', 'ENTIDADE.NOME NOME_CLI', 'PESSOAL.NOME NOME_EXEC', 'SITPROD.DESCRICAO DESC_STATUS',
          'CADFLUXO.DESCRICAO DESC_SETOR', 'REGIAO.DESCRICAO DESC_TABPRE', 'OS.MOEDA', 'MOEDA.DESCRICAO AS DESC_MOEDA',
          'OS.CLASSE_GER', 'CLASSE_GER.DESCRICAO AS DESC_CLASSE_GER', 'OS.OBS', 'OS.OBS3'
        ],
        leftJoin: [
          { tabela: 'REPRESEN', condicao: 'OS.CODREP = REPRESEN.CODREP' },
          { tabela: 'ENTIDADE', condicao: 'OS.CLIENTE = ENTIDADE.CODCLI' },
          { tabela: 'PESSOAL', condicao: 'OS.TERCEIRO = PESSOAL.CODIGO' },
          { tabela: 'SITPROD', condicao: 'OS.STATUS = SITPROD.CODIGO' },
          { tabela: 'CADFLUXO', condicao: 'OS.SETOR = CADFLUXO.CODIGO' },
          { tabela: 'REGIAO', condicao: 'OS.TAB_PRE = REGIAO.REGIAO' },
          { tabela: 'MOEDA', condicao: 'OS.MOEDA = CAST(MOEDA.CODMOE AS VARCHAR(10))' },
          { tabela: 'CLASSE_GER', condicao: 'OS.CLASSE_GER = CLASSE_GER.CODIGO' },
        ],
        where: [`OS.NUMERO = '${sNumero}'`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Ordem de serviço não encontrada.', () => { window.location.href = `${BASE_URI}/ordemservico`; });
      }

      insereValor('#txtNumero', jsonStr[0].NUMERO);
      insereValor('#txtUsuario', jsonStr[0].USUARIO);
      insereValor('#txtVendedor', jsonStr[0].CODREP, jsonStr[0].NOME_REP);
      insereValor('#txtCliente', jsonStr[0].CLIENTE, jsonStr[0].NOME_CLI);
      insereValor('#txtDataEmissao', jsonStr[0].DT_CADASTRO);
      insereValor('#txtDataSaida', jsonStr[0].DT_SAIDA);
      insereValor('#txtExecutor', jsonStr[0].TERCEIRO, jsonStr[0].NOME_EXEC);
      insereValor('#txtDuplicata', jsonStr[0].DUPLICATA);
      insereValor('#txtPercDesc', jsonStr[0].DESCONTO);
      insereValor('#txtStatus', jsonStr[0].STATUS, jsonStr[0].DESC_STATUS);
      insereValor('#txtRequisitante', jsonStr[0].REQUISITANTE);
      insereValor('#txtSetor', jsonStr[0].SETOR, jsonStr[0].DESC_SETOR);
      insereValor('#txtObservacao', decodeHTMLEntities(jsonStr[0].OBS3));
      insereValor('#txtTabPreco', jsonStr[0].TAB_PRE, jsonStr[0].DESC_TABPRE);
      insereValor('#txtDesconto', jsonStr[0].DESCONTO_VALOR);
      insereValor('#txtDtBaixa', jsonStr[0].DT_BAIXA);
      insereValor('#txtPedido', jsonStr[0].PEDIDO);
      insereValor('#txtVeiculo', jsonStr[0].VEICULO);
      insereValor('#txtAnoModelo', jsonStr[0].ANO_MODELO);
      insereValor('#txtQuilometragem', jsonStr[0].KILOMETRAGEM);
      insereValor('#txtChassi', jsonStr[0].CHASSI);
      insereValor('#txtPlaca', jsonStr[0].PLACA);
      if (jsonStr[0].MOEDA != '') { insereValor('#txtMoeda', jsonStr[0].MOEDA, jsonStr[0].DESC_MOEDA) };
      if (jsonStr[0].CLASSE_GER != '') { insereValor('#txtClasseGer', jsonStr[0].CLASSE_GER, jsonStr[0].DESC_CLASSE_GER) };
      if (jsonStr[0].OBSERVACAO != '') { $('#txtRequisicao').val(`${jsonStr[0].OBSERVACAO.replaceAll("&#013;", "\n")}`) };
      if (jsonStr[0].OBS != '') { $('#txtDescricao').val(`${jsonStr[0].OBS.replaceAll("&#013;", "\n")}`) };
      insereValor('#selectEmpresa', jsonStr[0].EMP_FAT);
      $('#selectEmpresa').change();

      const pesquisaParamI = {
        tabela: 'OS_ITEN',
        camposSelect: ['OS_ITEN.CODIGO', 'OS_ITEN.DESCRICAO', 'OS_ITEN.QTDE', 'OS_ITEN.PRECO', 'OS_ITEN.COR', 'OS_ITEN.TAM', 'OS_ITEN.TIPO'],
        where: [`OS_ITEN.NUMERO = '${sNumero}'`]
      };

      const jsonStrI = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParamI));

      jsonStrI.map((item, index) => {
        $(`#txtProduto-${index}`).attr('data-codigo', item.CODIGO);
        $(`#txtProduto-${index}`).attr('data-descricao', item.DESCRICAO);
        if (item.TIPO == 'P') {
          $(`#txtProduto-${index}`).attr('data-cor', item.COR);
          $(`#txtProduto-${index}`).attr('data-tam', item.TAM);
        }
        $(`#txtProduto-${index}`).val(`${item.CODIGO} - ${item.DESCRICAO} ${(item.TIPO == 'P' ? ` - ${item.COR}` : '')} ${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`);
        $(`#txtQuantidade-${index}`).val(item.QTDE);
        $(`#txtPreco-${index}`).val(item.PRECO);

        AddItens();
      });

      calculaTotaisItens();

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaServicos(background = false) {
    const sCodigo = $("#txtProdutoCodigo").val();
    const sDescricao = $("#txtProdutoDescricao").val().toUpperCase();

    let dataSetCols = [];
    let sWhere = "";

    sWhere += (sCodigo == '' ? '' : ` AND SERVICO.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `);
    sWhere += (sDescricao == '' ? '' : ` AND UPPER(SERVICO.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]') `);

    try {
      if (!background) {
        $.LoadingOverlay("show");
      }
      const response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"SERVICO","camposSelect":["SERVICO.CODIGO", "SERVICO.DESCRICAO" ],"where": ["1=1 ${sWhere}"],"limit": 1000}`, null, 20000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        return;
      }

      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });

      if ($.fn.DataTable.isDataTable('#tabelaProdutos')) {
        $('#tabelaProdutos').DataTable().destroy();
        $('#tabelaProdutos').empty();
      };

      criaDataTablePadrao('#tabelaProdutos', false, false, true, false, true, false, '300px', dataSet, dataSetCols);

      $("#tabelaProdutos tbody").on("click", "tr", function () {
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
      });

      $("#tabelaProdutos tbody").on("dblclick", "tr", function () {
        document.firstElementChild.style.zoom = "reset";
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
        $("#btn_confirmar_produto").click();
      });
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados do serviço.");
    } finally {
      if (!background) {
        $.LoadingOverlay("hide");
      }
    }
  }

  async function buscaProdutos(background = false) {
    const sCodigo = $("#txtProdutoCodigo").val();
    const sDescricao = $("#txtProdutoDescricao").val().toUpperCase();

    let dataSetCols = [];
    let sWhere = "";

    sWhere += (sCodigo == '' ? '' : ` AND PA_ITEN.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `);
    sWhere += (sDescricao == '' ? '' : ` AND UPPER(PRODUTO.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]') `);

    try {
      if (!background) {
        $.LoadingOverlay("show");
      }
      const response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"PA_ITEN","camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "PA_ITEN.TAM"],"leftJoin":[{ "tabela": "PRODUTO", "condicao": "PRODUTO.CODIGO = PA_ITEN.CODIGO" }], "where": ["1=1 ${sWhere} AND PA_ITEN.QUANTIDADE > 0"],"limit": 1000}`, null, 20000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if ($.isEmptyObject(jsonStr.RESULT[0])) {
        return;
      }

      const dataSet = jsonStr.RESULT[0];
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });

      if ($.fn.DataTable.isDataTable('#tabelaProdutos')) {
        $('#tabelaProdutos').DataTable().destroy();
        $('#tabelaProdutos').empty();
      };

      criaDataTablePadrao('#tabelaProdutos', false, false, true, false, true, false, '300px', dataSet, dataSetCols);

      $("#tabelaProdutos tbody").on("click", "tr", function () {
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
      });

      $("#tabelaProdutos tbody").on("dblclick", "tr", function () {
        document.firstElementChild.style.zoom = "reset";
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
        $("#btn_confirmar_produto").click();
      });
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados do produto.");
    } finally {
      if (!background) {
        $.LoadingOverlay("hide");
      }
    }
  }

  if (tipoPesquisa == 'P') {
    await buscaProdutos(TruncaDecimaisNova);
  } else {
    await buscaServicos(TruncaDecimaisNova);
  }

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#ultimoVoltar").click(async function () {
    if ($("#financeiroFs").hasClass("d-none")) {
      setTimeout(function () {
        $("#voltarFinanceiro").trigger("click");
      }, 100);
    }
  });

  $("#dropdown").trigger("change");

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    let valorTot = 0;

    $.LoadingOverlay("show");
    try {
      let arrayItens = [];
      let itemSemQtde = false;
      for (let index = 0; index < $(".itens").length; index++) {
        if ($(seletorPorNome("txtProduto", index)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", index)).attr("data-codigo") != "") {
          const preco = isNaN(parseFloat($(seletorPorNome("txtPreco", index)).val())) ? 0 : parseFloat($(seletorPorNome("txtPreco", index)).val())
          arrayItens.push({
            CODIGO: $(seletorPorNome("txtProduto", index)).attr("data-codigo"),
            DESCRICAO: $(seletorPorNome("txtProduto", index)).attr("data-descricao"),
            QUALIDADE: '1',
            COR: $(seletorPorNome("txtProduto", index)).attr("data-cor"),
            TAM: $(seletorPorNome("txtProduto", index)).attr("data-tam"),
            QTDE: parseFloat($(seletorPorNome("txtQuantidade", index)).val()),
            PRECO: preco,
            VALOR_TOTAL: parseFloat(parseFloat(parseFloat($(seletorPorNome("txtQuantidade", index)).val()) * preco).toFixed(2)),
          });

          valorTot = valorTot + parseFloat(parseFloat(parseFloat($(seletorPorNome("txtQuantidade", index)).val()) * preco).toFixed(2));
        }
      }

      if (arrayItens.length <= 0) {
        msgAlerta('Ordem de serviço sem itens, favor verificar!');
        return
      }

      for (let i = 0; i < arrayItens.length; i++) {
        if ((isNaN(parseFloat(arrayItens[i].QTDE))) || (parseFloat(arrayItens[i].QTDE) <= 0)) {
          itemSemQtde = true
          break
        }
      }

      if (itemSemQtde) {
        msgAlerta('Existem itens sem quantidade informada, favor verificar!');
        return
      }

      const classOs = {
        NUMERO: pegaValor('#txtNumero'),
        USUARIO: pegaValor('#txtUsuario'),
        CODREP: pegaChave('#txtVendedor'),
        CLIENTE: pegaChave('#txtCliente'),
        DT_CADASTRO: pegaValor('#txtDataEmissao'),
        DT_SAIDA: pegaValor('#txtDataSaida'),
        TERCEIRO: pegaChave('#txtExecutor'),
        DUPLICATA: pegaValor('#txtDuplicata'),
        DESCONTO: pegaValor('#txtPercDesc'),
        STATUS: pegaChave('#txtStatus'),
        REQUISITANTE: pegaValor('#txtRequisitante'),
        SETOR: pegaChave('#txtSetor'),
        OBS3: pegaValor('#txtObservacao'),
        TAB_PRE: pegaChave('#txtTabPreco'),
        DESCONTO_VALOR: pegaValor('#txtDesconto'),
        DT_BAIXA: pegaValor('#txtDtBaixa'),
        PEDIDO: pegaChave('#txtPedido'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        VEICULO: pegaValor('#txtVeiculo'),
        ANO_MODELO: pegaValor('#txtAnoModelo'),
        KILOMETRAGEM: pegaValor('#txtQuilometragem'),
        CHASSI: pegaValor('#txtChassi'),
        PLACA: pegaValor('#txtPlaca'),
        OBSERVACAO: $('#txtRequisicao').val(),
        OBS: $('#txtDescricao').val(),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        MOEDA: pegaChave('#txtMoeda'),
        VALOR: valorTot,
        ITENS: arrayItens,
        EMP_ID: getCookie('emp_id'),
        SITUACAO: 'P'
      };

      const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      criaMensagemSucesso('Ordem de serviço gravada com sucesso.', () => { window.location.href = `${BASE_URI}/ordemservico`; });

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error}`);
    } finally {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
    }
  });

  function trocaIdClass(seletor, indice) {
    const classe = seletor.substring(1);
    $(`${seletor}-${indice}`).addClass(`${classe}-atual`).removeClass(`${classe}-${indice}`);
    $(`${seletor}-atual`).addClass(`${classe}-${indice - 1}`).removeClass(`${classe}-atual`);
  };

  async function DeleteItem(id) {
    let itens = $(".itens");
    for (let i = 0; i < itens.length; i++) {
      if (i == id) {
        $(`.item-${i}`).addClass(`removido`).removeClass(`item-${i}`);
      } else if (i > id) {
        $(`.item-${i}`).addClass(`atual`).removeClass(`item-${i}`);
        $(`.atual`).addClass(`item-${i - 1}`).removeClass(`atual`);
        trocaIdClass(`.btn-limpa`, i);
        trocaIdClass(`.btn-edit`, i);
        trocaIdClass(`.btn-add`, i);
        trocaIdClass(`.txtItem`, i);
        $(`.contador.item-${i - 1}>span`).html(i);
      }
    }
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente", "#txtCNPJ"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () { $("#txtCliente").val(""); $("#txtCNPJ").val(""); $("#txtCliente").trigger("blur"); });

    $("#txtVendedor").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Vendedor").pesquisa_serverside(["#txtVendedor"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Vendedor");
    $("#btn-limpa-Vendedor").on("click", function () { $("#txtVendedor").val(""); });

    $("#txtExecutor").autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Executor").pesquisa_serverside(["#txtExecutor"], ["CODIGO"], ["NOME"], `{"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, "Pesquisa Executor");
    $("#btn-limpa-Executor").on("click", function () { $("#txtExecutor").val(""); });

    $("#txtStatus").autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-Status").pesquisa_serverside(["#txtStatus"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Status");
    $("#btn-limpa-Status").on("click", function () { $("#txtStatus").val(""); });

    $("#txtSetor").autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-Setor").pesquisa_serverside(["#txtSetor"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Setor");
    $("#btn-limpa-Setor").on("click", function () { $("#txtSetor").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-TabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btn-limpa-TabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $('#btn-Pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], `{"tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": null}`, 'Pesquisa Pedido');
    $("#btn-limpa-Pedido").on("click", function () { $("#txtPedido").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-Moeda").pesquisa_serverside(["#txtMoeda"], ["CODMOE"], ["DESCRICAO"], `{"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, "Pesquisa Moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-ClasseGer").pesquisa_serverside(["#txtClasseGer"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Classe Gerencial");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT, null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function seletorPorNome(name, i) {
    return `.item-${i}>div>input[name*="${name}"]`;
  };

  function criaMascaraCampos() {
    $("#txtDescontoTotal").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
    $("#txtFreteTotal").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
    $("#txtDespesaTotal").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtDesconto").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
    $("#txtPercDesc").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
  };

  async function carregaValoresPadroes() {
    const os = $(window.location.href.split('/')).get(-1);
    if (os != 'create') {
      return;
    }

    insereValor('#txtUsuario', getCookie('usuario'));

    const jsonStr = await buscaValoresPadroes('OS')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'MOEDA': {
          if (item.VALOR != '') {
            insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
          }
          break;
        }
        case 'STATUS': {
          if (item.VALOR != '') {
            insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TAB_PRECO': {
          if (item.VALOR != '') {
            insereValor('#txtTabPreco', item.VALOR, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: item.VALOR });
          }
          break;
        }

      }
    });
  };

});

