$(document).ready(async function () {

  await setarDataAtual('txtDataMovimentoSaida');
  await buscaValoresPadroesTela();
  let codigoSaidasManual = '';
  const parametroPermiteEstoqueNegativo = ["1", "2"].includes(await CopiaParametro('VENDA', 4));

  async function carregaTipoSaida() {
    const pesquisaParam = {
      tabela: 'TABBAI',
      camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
      where: [`ATIVO = 'S'`],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    let saidasManual = '';

    jsonStr.forEach(tipoBaixa => {
      if (tipoBaixa.TIPO && tipoBaixa.TIPO.charAt(9) === 'S') {
        saidasManual += saidasManual ? `,'${tipoBaixa.CODIGO}'` : `'${tipoBaixa.CODIGO}'`;
      }
    });

    codigoSaidasManual = saidasManual;
  }

  await carregaTipoSaida();

  $('#tabela-movimentados').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: true,
    destroy: true,
    columnDefs: [
      {
        "targets": [4],
        "className": 'pr-4 text-right'
      }
    ]
  });

  const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
  const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
  const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

  if (depositoUsuario != 'null') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`, [], [], [],
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      }
    );
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO',
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      });
  } else if (depositosEmpresaLogada != '') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], [],
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      }
    );
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO',
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      }
    );
  } else if (json.length == 0) {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`, [], [], [],
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      }
    );
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO',
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      });
  } else {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], [],
    () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      }
    );
    $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO',
      () => {
        if ($('#txtDeposito').val()) {
          $('.campoMaterial').attr('disabled', false)
          // $('.campoDeposito').attr('disabled', true)
        }
        rotinaSaidaDeposito()
      });
  }

  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  // let data = new Date();

  // $('#txtDataMovimentoSaida').val(`${data.getUTCFullYear()}-${String(data.getUTCMonth() + 1).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`);

  $('#txtFuncionarioSaidaMat').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnFuncionarioSaidaMat').pesquisa_array(['#txtFuncionarioSaidaMat'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
  $('#btnLimpaFuncionarioSaidaMat').on('click', function () {
    $('#txtFuncionarioSaidaMat').val('');
  });

  $('#txtTipoBaixa').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${codigoSaidasManual})"] }`, [], [], []);
  $('#btnTipoBaixa').on('click', function () {
    if (!codigoSaidasManual) {
      msgErro('Não existe Tipo Saída cadastrada como Saída Manual na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTipoBaixa').pesquisa_array(['#txtTipoBaixa'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoSaidasManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });
  $('#btnLimpaTipoBaixa').on('click', function () {
    $('#txtTipoBaixa').val('');
  });

  function rotinaSaidaDeposito() {
    setTimeout(() => {
      const sDeposito = pegaChave("#txtDeposito");

      $("#txtMaterialSaida").autocompleta(
        1,
        `JSON={"tabela": "MATERIAL",` +
        `"camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO DESCRICAO"],` +
        `"leftJoin": [{"tabela":"MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],` +
        `"where": ["MAT_ITEN.DEPOSITO = '${sDeposito}' ${parametroPermiteEstoqueNegativo ? "" : " AND MAT_ITEN.QTDE > 0 "}"],` +
        `"groupBy": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"]}`,
        [],
        [],
        [],
      );

      $('#btnMaterialSaida').pesquisa_serverside(['#txtMaterialSaida'], ['MATERIAL.CODIGO'], ['MATERIAL.DESCRICAO'],
         `{"tabela": "MATERIAL",`+
         `"camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MATERIAL.CODIGO2"],`+
         `"leftJoin": [{"tabela":"MAT_ITEN", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"}],`+
         `"where": ["MAT_ITEN.DEPOSITO = '${sDeposito}' ${parametroPermiteEstoqueNegativo ? "" : " AND MAT_ITEN.QTDE > 0 "}"],`+
         `"groupBy": ["MATERIAL.CODIGO", "MATERIAL.CODIGO2", "MATERIAL.DESCRICAO"]}`, 'Pesquisa de Material');

      $('#btnLimpaMaterial').on('click', function () {
        $('#txtMaterialSaida').val('')
      })

      if ($('#txtMaterialSaida').val()) {
        $('.campoMaterial').attr('disabled', false)
      }

      rotinaSaidaMaterial()
    }, 500)
  }

  function rotinaSaidaMaterial() {
    $("#txtMaterialSaida").on("blur", async function () {
      $("#txtCor").autocompleta(
        1,
        `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
          "#txtMaterialSaida"
        )}')"]}`,
        [],
        [],
        [],
      );

      $("#btnCor").pesquisa_array(
        ["#txtCor"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
          "#txtMaterialSaida"
        )}')"]}`,
        "Pesquisa Cor",
        "cadcor",
      )

      $('#btnLimpaCor').on('click', function () {
        $('#txtCor').val('')
        // $('.campoCor').attr('disabled', true)
        // $('.campoMaterial').attr('disabled', false)
      })

      await carregaDadosMaterial();
      rotinaSaidaCor();

      if ($('#txtMaterialSaida').val()) {
        $('.campoCor').attr('disabled', false)
        // $('.campoMaterial').attr('disabled', true)
        const pesquisaCores = {
          camposSelect: ['MAT_ITEN.COR', 'CADCOR.DESCRICAO'],
          tabela: 'MAT_ITEN',
          innerJoin: [
            {
              tabela: 'CADCOR',
              condicao: 'MAT_ITEN.COR = CADCOR.COR',
            }
          ],
          where: [`MAT_ITEN.CODIGO = '${pegaChave(this.value)}'`],
          groupBy: ['MAT_ITEN.COR', 'CADCOR.DESCRICAO'],
        }

        const dadosCores = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCores))
        if (!dadosCores || dadosCores.length !== 1) return
        const [objetoCor] = dadosCores
        insereValor('#txtCor', objetoCor?.COR, objetoCor?.DESCRICAO)
        
        $('.campoCor').trigger('blur')
      }
    });
  }

  function rotinaSaidaCor() {
    $("#txtCor").on("blur", async function () {
      const sCodigo = pegaChave("#txtMaterialSaida");
      const sCor = pegaChave("#txtCor");
      const sDeposito = pegaChave("#txtDeposito");

      $("#txtQualidade").autocompleta(
        1,
        `JSON={"tabela": "MAT_ITEN",`+
        `"camposSelect": ["QUALIDADE CHAVE", "QUALIDADE DESCRICAO"],`+
        `"where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' ${parametroPermiteEstoqueNegativo ? "" : " AND QTDE > 0 "}"],`+
        `"groupBy": ["QUALIDADE"]}`,
        [],
        [],
        [],
      );

      $("#btnQualidade").pesquisa_array(
        ["#txtQualidade"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MAT_ITEN",`+
        `"camposSelect": ["QUALIDADE CHAVE", "QUALIDADE DESCRICAO"],`+
        `"where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' ${parametroPermiteEstoqueNegativo ? "" : " AND QTDE > 0 "}"],`+
        `"groupBy": ["QUALIDADE"]}`,
        "Pesquisa Qualidade",
        "MAT_ITEN",
      )

      $('#btnLimpaQualidade').on('click', function () {
        $('#txtQualidade').val('')
        // $('.campoQualidade').attr('disabled', true)
        // $('.campoCor').attr('disabled', false)
      })

      if ($('#txtCor').val()) {
        $('.campoQualidade').attr('disabled', false)
        // $('.campoCor').attr('disabled', true)
      }

      await carregaDadosMaterial();
      rotinaSaidaQualidade()
    });
  }

  function rotinaSaidaQualidade() {
    $("#txtQualidade").on("blur", async function () {
      const sCodigo = pegaChave("#txtMaterialSaida");
      const sCor = pegaChave("#txtCor");
      const sDeposito = pegaChave("#txtDeposito");
      const sQualidade = pegaChave("#txtQualidade");

      $("#txtLote").autocompleta(
        1,
        `JSON={"tabela": "MAT_ITEN",`+
        `"camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"],`+
        `"where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUALIDADE = '${sQualidade}' ${parametroPermiteEstoqueNegativo ? "" : " AND QTDE > 0 "}"]}`,
        [],
        [],
        [],
      );

      $("#btnLote").pesquisa_array(
        ["#txtLote"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MAT_ITEN",`+
        `"camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"],`+
        `"where": ["CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}' AND QUALIDADE = '${sQualidade}' ${parametroPermiteEstoqueNegativo ? "" : " AND QTDE > 0 "}"]}`,
        "Pesquisa Lote",
        "MAT_ITEN",
      );

      $('#btnLimpaLote').on('click', function () {
        $('#txtLote').val('')
        // $('.campoLote').attr('disabled', true)
        // $('.campoQualidade').attr('disabled', false)
      })

      if ($('#txtQualidade').val()) {
        $('.campoLote').attr('disabled', false)
        // $('.campoQualidade').attr('disabled', true)
      }

      await carregaDadosMaterial();
      rotinaSaidaLote()
    });
  }

  function rotinaSaidaLote() {
    $("#txtLote").on("blur", async function () {
      await carregaDadosMaterial();
    });
  }

  async function gravarMovimentacao(EstProd) {
    try {
      const url = '/sisplan/estoque/v1/movimentaestoquematerial?';
      const sLancto = $('#txtLancamento').val();
      const params = `JSON=${encodeURIComponent(JSON.stringify(EstProd))}&LANCTO=${sLancto}&TIPO=SAIDA`;
      const response = await requisicao('POST', url, '', params);
      const codigo = pegaChave('#txtMaterialSaida');
      const codigoDesc = pegaDescricao('#txtMaterialSaida');
      const cor = pegaChave('#txtCor');
      const corDesc = pegaDescricao('#txtCor');
      const lote = pegaChave('#txtLote');
      const qtde = $('#txtQuantidade').val();
      const unidade = $('#UnidadeMedidaMat').val();

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#tabela-movimentados').DataTable().row.add([codigo, codigoDesc, cor, corDesc, qtde, unidade, lote]).draw(false);

      toastr.success(
        'Movimentação efetuada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          LimpaCampos();
          buscaValoresPadroesTela();
          setTimeout(() => { $('#txtMaterialSaida').focus(); }, 200);
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
    }
  }

  retornaHintRelatorio('Imprimir', 'movimentacao_material')

  $('#Imprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabela-movimentados').DataTable().rows().count() != 0) {
          let url = `/sisplan/impressao/v1/movmaterial?`;
          const tipoItem = 'M';
          const docto = $('#txtDocumento').val();
          const tipoMov = 'S';
          const bImprimeAutomatico = await verificaImprimirAutomatico('MovimentacaoMaterial');
          let arquivo = await GeraRelatorio(`${url}NUM_DOCTO=${docto}&TIPOITEM=${tipoItem}&TIPOMOV=${tipoMov}&`, 'GET', 100000, false, 'MovimentacaoMaterial');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para serem imprimidos!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function carregaDadosMaterial() {
    try {
      let sWhere = '';
      const codigo = pegaChave('#txtMaterialSaida');
      const cor = pegaChave('#txtCor');
      const deposito = pegaChave('#txtDeposito');
      const qualidade = pegaChave('#txtQualidade');
      const lote = pegaChave('#txtLote');

      if (codigo == '') {
        return;
      }

      sWhere = `MATERIAL.CODIGO = '${codigo}' ${cor != '' ? `AND MAT_ITEN.COR = '${cor}'` : ''} ${deposito != '' ? `AND MAT_ITEN.DEPOSITO = '${deposito}'` : ''} ${qualidade != '' ? `AND MAT_ITEN.QUALIDADE = '${qualidade}'` : ''} ${lote != '' ? ` AND MAT_ITEN.LOTE = '${lote}'` : ''}`;

      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela":"MAT_ITEN",`+
                           `"camposSelect":[ "MATERIAL.CODIGO", "MATERIAL.DESCRICAO","MATERIAL.UNIDADE", "CADCOR.COR", "CADCOR.DESCRICAO AS DESCCOR",`+
                                            `"COALESCE(MAT_ITEN.PRECO_MED, 0) AS PRECO", "MAT_ITEN.QTDE", "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO DESCQUALIDADE"],`+
                           `"leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_ITEN.CODIGO = MATERIAL.CODIGO " },`+
                                        `{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR " },`+
                                        `{ "tabela" : "TABQUL", "condicao" : "MAT_ITEN.QUALIDADE = TABQUL.CODIGO " }],`+
                           `"where": ["${sWhere}"]}`;

      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#UnidadeMedidaMat').val(jsonStr.RESULT[0][0].UNIDADE);
      $('#txtPreco').val(jsonStr.RESULT[0][0].PRECO);
      $('#txtEstoque').val(jsonStr.RESULT[0][0].QTDE);
      // insereValor('#txtQualidade', jsonStr.RESULT[0][0].QUALIDADE, jsonStr.RESULT[0][0].DESCQUALIDADE);

    } catch (error) {
      console.error(error);
    }
  }

  $('#txtDocumento').on('blur', async function () {
    try {
      $.LoadingOverlay("show");
      let lancamento;
      if ($(this).val() == '') {
        let docto = await RetornaDoctoELancto('DOCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');

        insereValor('#txtDocumento', docto);
        insereValor('#txtLancamento', lancamento);

        $(this).attr('disabled', $(this).val() != '');
      } else {
        lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancamento);
        $(this).attr('disabled', $(this).val() != '');

        const dataSet = await RetornaMovimentados($(this).val());
        $('#tabela-movimentados').DataTable().rows().remove().draw(false);
        for (let i = 0; i < dataSet.length; i++) {
          const item = dataSet[i];
          $('#tabela-movimentados').DataTable().row.add([item.CODIGO, item.DESCRICAO, item.COR, item.DESC_COR, item.QUANTIDADE, item.UNIDADE, item.LOTE]).draw(false);
        }
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  });


  function montaObjetoMovimentacao() {
    const objetoMovimentacao = {
      NUM_DOCTO: $('#txtDocumento').val(),
      DT_MOVTO: $('#txtDataMovimentoSaida').val(),
      CODCRE: pegaChave('#txtFuncionarioSaidaMat'),
      TP_MOV: pegaChave('#txtTipoBaixa'),
      CODIGO: pegaChave('#txtMaterialSaida'),
      QUALIDADE: pegaChave('#txtQualidade'),
      COR: pegaChave('#txtCor'),
      LOTE: pegaChave('#txtLote'),
      DEPOSITO: pegaChave('#txtDeposito'),
      QTDE: parseFloat($('#txtQuantidade').val()),
      PRECO: parseFloat($('#txtPreco').val()),
      TIPO: 'MN',
      CODBAIXA: pegaChave('#txtTipoBaixa')
    };

    return objetoMovimentacao;
  }

  $('#limpar_mov').on('click', function () {
    LimpaCampos();
    limpaValor('#txtDocumento');
    limpaValor('#txtLancamento');
    $('#txtDocumento').attr('disabled', false);
    $('#tabela-movimentados').DataTable().rows().remove().draw(false);
    $('#txtDocumento').focus();
  });

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtFuncionarioSaidaMat: {
        required: true,
      },
      txtTipoBaixa: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtMaterialSaida: {
        required: true,
      },
      txtCor: {
        required: true,
      },
      txtLote: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtQuantidade: {
        required: true,
      },
      txtPreco: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtFuncionarioSaidaMat: {
        required: "Informe um funcionário para continuar."
      },
      txtTipoBaixa: {
        required: "Informe um tipo de baixa para continuar."
      },
      txtQualidade: {
        required: "Informe uma qualidade para continuar."
      },
      txtMaterialSaida: {
        required: "Informe um material para continuar."
      },
      txtCor: {
        required: "Informe uma cor para continuar."
      },
      txtLote: {
        required: "Informe um lote para continuar."
      },
      txtDeposito: {
        required: "Informe um deposito para continuar."
      },
      txtQuantidade: {
        required: "Informe uma quantidade válida para continuar."
      },
      txtPreco: {
        required: "Informe um preço válido para continuar."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  $('#confirmar_mov').on('click', async function () {
    try {
      $('#confirmar_mov').prop('disabled', true);
      $.LoadingOverlay('show');
      try {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
          if (parseFloat($('#txtQuantidade').val()) <= 0) {
            msgErro('Não há quantidade para o material informado, verifique.');
            return;
          }
          if (!parametroPermiteEstoqueNegativo && parseFloat($('#txtQuantidade').val()) > (parseFloat($('#txtEstoque').val()))) {
            msgErro('Quantidade maior que o estoque, verifique.');
            return;
          }

          const objetoMovimentacao = montaObjetoMovimentacao();
          await gravarMovimentacao(objetoMovimentacao);
        }
      } catch (error) {
        console.error(error);
      }

    } finally {
      $('#confirmar_mov').prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  });

  async function RetornaMovimentados(sDocto) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela": "MAT_MOV", "camposSelect": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "SUM(MAT_MOV.QTDE) QUANTIDADE", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_MOV.CODIGO = MATERIAL.CODIGO" }, { "tabela" : "CADCOR", "condicao" : "CADCOR.COR = MAT_MOV.COR" }],"groupby": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"where": ["MAT_MOV.NUM_DOCTO = '${sDocto}' AND MAT_MOV.OPERACAO = 'S' "], "orderby": ["MAT_MOV.CODIGO", "MAT_MOV.COR"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return '';
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
    }
  }

  async function buscaValoresPadroesTela() {
    $.LoadingOverlay('show');

    try {
      const buscarValoresPadrao = async () => {
        const response = await requisicao(
          'POST',
          '/sisplan/valorespadroes/v1/buscar?',
          '',
          JSON.stringify({ POSICAO: '9' })
        );

        if (response) {
          const jsonStr = await response.json();
          insereValor('#txtTipoBaixa', jsonStr.tipoSaida);
          insereValor('#txtDeposito', jsonStr.deposito);
        }
      };

      const buscarTipos = async () => {
        const dados = await buscaValoresPadroes('ESTOQUE')

        const mapeamentoCampos = {
          'LOTE_MATERIAL': (item) => {
            insereValor('#txtLote', item.VALOR, item.VALOR);
          },
          'SAIDA_MAT': (item) => {
            if (item.VALOR) {
              insereValor('#txtTipoBaixa', item.VALOR, {
                tabela: 'TABBAI',
                campoBusca: 'DESCRICAO',
                campoWhere: 'CODIGO',
                valorWhere: item.VALOR
              });
            }
          },
          'QUALIDADE_MATERIAL': (item) => {
            if (item.VALOR) {
              insereValor('#txtQualidade', item.VALOR, {
                tabela: 'TABQUL',
                campoBusca: 'DESCRICAO',
                campoWhere: 'CODIGO',
                valorWhere: item.VALOR
              });
            }
          }
        };

        dados.forEach(item => {
          if (mapeamentoCampos[item.CAMPO]) {
            mapeamentoCampos[item.CAMPO](item);
          }
        });
      };

      await Promise.all([
        buscarValoresPadrao(),
        buscarTipos()
      ]);

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function LimpaCampos() {
    $('#txtQuantidade').val(0)
    limpaValor('#txtTipoBaixa');
    limpaValor('#txtQualidade');
    limpaValor('#txtLote');
    limpaValor('#txtEstoque');
    limpaValor('#UnidadeMedidaMat');
    limpaValor('#txtDeposito');
    limpaValor('#txtMaterialSaida');
    limpaValor('#txtCor');
    limpaValor('#txtPreco');

    $('.campoMaterial').attr('disabled', true)
    $('.campoCor').attr('disabled', true)
    $('.campoQualidade').attr('disabled', true)
    $('.campoLote').attr('disabled', true)
    $('.campoDeposito').attr('disabled', false)
  }

  const driver = new Driver({
    doneBtnText: 'Sair',
    closeBtnText: 'Fechar',
    nextBtnText: 'Próximo',
    prevBtnText: 'Anterior',
    allowClose: false,
    animate: true,
  });

  driver.defineSteps([{
    element: '#campostour',
    popover: {
      title: 'Dados Gerais',
      description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
      position: 'top'
    }
  },
  {
    element: '#txtDocumento',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDataMovimentoSaida',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtFuncionarioSaidaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtTipoBaixa',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQualidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtMaterialSaida',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtCor',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtLote',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDeposito',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQuantidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtPreco',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#limpar_mov',
    popover: {
      title: 'Botão Limpar',
      description: 'Clique aqui para limpar os campos.',
      position: 'left'
    }
  },
  {
    element: '#confirmar_mov',
    popover: {
      title: 'Botão Gravar',
      description: 'Clique aqui para gravar a movimentação.',
      position: 'top'
    }
  }
  ]);

  $('#tutorial').on('click', function () {
    driver.start();
  });
});
