/* eslint-disable prefer-destructuring */
// $("#tutorial").on("click", function () {
//   $(document).ready(async function () {
//     const driver = new Driver({
//       doneBtnText: "Sair",
//       closeBtnText: "Fechar",
//       nextBtnText: "Próximo",
//       prevBtnText: "Anterior",
//       allowClose: false,
//       animate: true,
//     });

//     driver.defineSteps([
//       {
//         element: "#tourGeral",
//         popover: {
//           title: "Dados Gerais",
//           description: "Aqui estão os dados gerais da nota.",
//           position: "top",
//         },
//       },
//       {
//         element: "#txtCliente",
//         popover: {
//           title: "Campos Obrigatórios",
//           description:
//             "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
//           position: "top",
//         },
//       },
//       {
//         element: "#txtDeposito",
//         popover: {
//           title: "Campos Obrigatórios",
//           description:
//             "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
//           position: "top",
//         },
//       },
//       {
//         element: "#avancar1",
//         popover: {
//           title: "Botão Avançar",
//           description:
//             "Clique aqui para avançar para a aba itens, onde será possível adicionar itens e após isso, adicionar duplicatas e/ou gravar a nota.",
//           position: "left",
//         },
//       },
//     ]);
//     driver.start();
//   });
// });

$(document).ready(async function () {

  let itensOs;
  await verificaPermissoes('FATSERVICO');
  await setarDataAtual('txtDataEmissao');
  await carregaValoresPadroes();
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let servico = parametros[parametros.length - 1];
  let dadosFin = {};
  if ((servico != '') && (servico != 'create')) {
    await buscaServicos(TruncaDecimaisNova);
    await buscaDadosOs(servico);
  } else {
    AddItens();
    await buscaServicos(TruncaDecimaisNova);
    const pesquisaParam = {
      tabela: "EMPRESA",
      camposSelect: [
        "EMP_SERIENFS",
      ],
      where: [`EMP_ID = ${getCookie('emp_id')}`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return;
    }

    $('#txtSerie').val(`${jsonStr[0].EMP_SERIENFS}`)

  }
  addPesquisaAutocompleta();
  criaMascaraCampos();
  criaDataTablePadrao('#tabelaDuplicatas', false, false, false, false, true, false, '193px');

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCliente: {
        required: true,
      },
      txtTransportadora: {
        required: true,
      },
      "txtProduto-0": {
        required: true,
      },
      "txtQuantidade-0": {
        required: true,
      },
      "txtPreco-0": {
        required: true,
      }
    },
    messages: {
      txtCliente: {
        required: "Informe um cliente válido.",
      },
      txtTransportadora: {
        required: "Informe uma transportadora válida.",
      },
      "txtProduto-0": {
        required: "Informe um produto válido.",
      },
      "txtQuantidade-0": {
        required: "Informe uma quantidade válida.",
      },
      "txtPreco-0": {
        required: "Informe um preço válido.",
      }
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".next").click(async function () {
    let validator = $("#msform").validate();
    let erros = 0;

    if ($('#txtNatureza').val() == '') {
      msgAlerta('Por favor, informe uma natureza para continuar!');
      return
    };

    if ($('#txtCliente').val() == '') {
      msgAlerta('Por favor, informe um cliente para continuar!');
      return
    };

    if ($('#txtSerie').val() == '') {
      msgAlerta('Por favor, informe uma série para continuar!');
      return
    };

    if ($(this).attr("id") == "avancar1") {
      validator.element("#txtCliente");
      validator.element("#txtNatureza");
      if ((
        validator.element("#txtCliente")

      ) || (validator.element("#txtNatureza"))) {
        erros = 0;
      } else {
        erros = 1;
      }
    }

    if (erros > 0) {
      return;
    }

    let currentFs = $(this).parent();
    let nextFs = $(this).parent().next();
    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
    nextFs.show();
    currentFs.animate(
      {
        opacity: 0
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none", position: "relative",
          });
          nextFs.css({ opacity, });
        },
        duration: 600
      }
    );
    $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
  });

  $(".previous").click(async function () {
    let currentFs = $(this).parent();
    let previousFs = $(this).parent().prev();
    $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({ display: "none", position: "relative" });
          previousFs.css({ opacity });
        },
        duration: 600,
      }
    );
    $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
  });


  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $('#btnVoltarAcesso').on('click', function () {
    parent.fechaAbaAberta();
  });

  $(".submit").click(function () {
    return false;
  });

  $("#txtCliente").change(async function () {
    const codcli = pegaChave("#txtCliente");
    await buscaBloqueio(codcli);
  });

  async function buscaBloqueio(codcli) {
    try {
      const responseOperadora = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"entidade", "camposSelect":["bloqueio"], "where": ["codcli = '${codcli}'"]}`, null);
      const jsonStr = await responseOperadora.json();

      if (jsonStr.RESULT[0][0].BLOQUEIO == 'S') {
        msgAguardaConfirmacao('Cliente bloqueado, deseja continuar mesmo assim?', () => { }, () => {
          $('#txtCliente').val('');
        })
      };
    } catch (error) {
      console.error(error);
    }
  }

  function AddItens() {
    const itens = $(".itens");
    $("#items-wrap").append(`
      <div class="row itens" ${parseInt(itens.length) != 0 ? 'style="margin-top:3px"' : ""}>
        <div class="item-${itens.length} contador col-1">
          <span id="item-${itens.length}">${itens.length + 1}</span>
        </div>
        <div class="item-${itens.length} col-lg-6 col-12">
        ${itens.length == 0 ? `<label data-error="wrong" data-success="right" for="txtProduto-${itens.length}">Item</label>` : ""}
          <div class="input-group">
            <input type="text" class="inputs input-default focus form-control classeProduto txtItem-${itens.length}" style="margin-left:5px;"id="txtProduto-${itens.length}" name="txtProduto-${itens.length}" placeholder="Serviço (F4 para pesquisar)" readonly>
            <div class="input-group-append">
              <a id="btn-produto-${itens.length}"><i class="fas fa-search text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i></a>
              <a id="btn-limpa-produto-${itens.length}"><i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i></a>
            </div>
          </div>
        </div>
        <div class="item-${itens.length} col-lg-2 col-12">
          ${itens.length == 0 ? `<label data-error="wrong" data-success="right" for="txtQuantidade-${itens.length}">Qtde.</label>` : ""}
          <div class="input-group">
            <input type="text" maxlength="8" class="inputs input-default focus form-control maskItens classeQuantidade" min="0" id="txtQuantidade-${itens.length}" name="txtQuantidade-${itens.length}" class="form-control" placeholder="Qtde.">
          </div>
        </div>
        <div class="item-${itens.length} col-lg-2 col-12">
          ${itens.length == 0 ? '<label data-error="wrong" data-success="right" for="txtPreco">Preço</label>' : ""}
          <div class="input-group">
            <input type="text" maxlength="8" class="inputs input-default focus form-control maskItens classePreco" min="0" id="txtPreco-${itens.length}" name="txtPreco-${itens.length}" class="form-control" placeholder="Preco">
          </div>
        </div>
        <div class="col-lg-1 col-12">
          <div class="btn-group grupo_botao item-${itens.length}" role="group" aria-label="Basic example">
            <button type="button" class="btn btn-opcao bg-light nofocus btn-limpa-${itens.length}">
              <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
            </button>
            <button type="button" class="btn btn-opcao bg-light nofocus btn-add-${itens.length}">
              <i class="fas fa-plus text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
            </button>
          </div>
        </div>
      </div>
    `);

    $(`.item-${itens.length}:not(:first-child)`).css("padding", "0 1.3px 0 0");
    $(".maskItens").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".classePreco").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2
    });

    let id = `.btn-limpa-${itens.length}`;

    $(`#txtProduto-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 115) {
        $(`#btn-produto-${itens.length}`).trigger("click");
      }
      if (e.keyCode == 13) {
        $(`#txtQuantidade-${itens.length}`).focus();
      }
    });

    $(`#txtQuantidade-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 13) {
        $(`#txtPreco-${itens.length}`).focus();
      }
    });
    $(`#txtPreco-${itens.length}`).keyup(function (e) {
      if (e.keyCode == 13) {
        $(`#btn-add-${itens.length}`).trigger('click');
      }
    });

    $(`#txtProduto-${itens.length}`).on("change, blur", function () {
      adicionaHint(`#txtProduto-${itens.length}`);
    });

    $(`#btn-limpa-produto-${itens.length}`).on("click", function () {
      $(`#txtProduto-${itens.length}`).val("");
      $(`#txtProduto-${itens.length}`).attr("data-codigo", "");
      $(`#txtProduto-${itens.length}`).attr("data-cor", "");
      $(`#txtProduto-${itens.length}`).attr("data-tam", "");
    });

    $(`.btn-add-${itens.length}`).on("click", function () {
      let qtdeProd = $(".itens");
      let elemento = $(this).attr("class").split("-");
      elemento = elemento[elemento.length - 1];
      if (parseInt(elemento) === qtdeProd.length - 1 && $(`#txtProduto-${elemento}`).val() != "") {
        AddItens();
        $(`#txtProduto-${parseInt(elemento) + 1}`).focus();
      }
    });

    $(`#btn-produto-${itens.length}`).on("click", function () {
      $("#idLinha").val(this.id.split("-")[2]);
      $("#modalProduto").modal("show");
      if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
        $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
      }
      $("#txtProdutoCodigo").val("");
      $("#txtProdutoDescricao").val("");
    });

    $(`#txtPreco-${itens.length}`).on("blur", function () {
      if ($(`#txtQuantidade-${itens.length}`).val() != "") {
        calculaTotaisItens();
      }
    });

    $(`#txtQuantidade-${itens.length}`).on("blur", function () {
      if ($(`#txtPreco-${itens.length}`).val() != "") {
        calculaTotaisItens();
      }
    });

    addEvent(id);
    return itens.length;
  }

  $("#modalProduto").on("shown.bs.modal", function () {
    if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
      $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
    }
    $("#txtProdutoCodigo").focus();
  });

  $("#txtProdutoDescricao").on("focusout", function () {
    $("#btnConsultarProduto").focus();
  });

  $("#btnConsultarProduto").on("keypress", function () {
    $("#btnConsultarProduto").trigger("click");
  });

  $("#modalProduto").on("hidden.bs.modal", function () {
    const id = $("#idLinha").val();
    $(`#txtProduto-${id}`).trigger("blur");
    $(`#txtProduto-${id}`).focus();
  });

  $("#txtProdutoCodigo").change(async function () {
    await buscaServicos();
  });

  $("#txtProdutoDescricao").change(async function () {
    await buscaServicos();
  });

  $("#btnConsultarProduto").on("click", async function () {
    await buscaServicos();
  });

  $("#btn_confirmar_produto").click(function () {
    let data = $("#tabelaProdutos").dataTable().api().row(".selected").data();
    const id = $("#idLinha").val();
    $(`#txtProduto-${id}`).val(`${data.CODIGO} - ${data.DESCRICAO}`);
    $(`#txtProduto-${id}`).attr("data-codigo", data.CODIGO);
    $(`#txtProduto-${id}`).attr("data-descricao", data.DESCRICAO);
    $("#modalProduto").modal("hide");
  });

  $("#btnConfirmarTrib").on("click", function () {
    const indice = $("#txtIndiceAlteracao").val();
    $(`#txtEnquadra${indice}`).val($("#txtEnquadra").val());
    $(`#txtCsosn${indice}`).val($("#txtCsosn").val());
    $(`#txtCstIcms${indice}`).val($("#txtCstIcms").val());
    $(`#txtCstIpi${indice}`).val($("#txtCstIpi").val());
    $(`#txtCstPis${indice}`).val($("#txtCstPis").val());
    $(`#txtCstCofins${indice}`).val($("#txtCstCofins").val());

    $(`#modalTribProd`).modal("hide");
  });

  $("#edtVencimento1, #edtVencimento2, #edtVencimento3, #edtVencimento4, #edtVencimento5, #edtVencimento6, #edtVencimento7, #edtVencimento8, #edtVencimento9, #edtVencimento10, #edtVencimento11, #edtVencimento12").change(async function () {
    if ($(this).val() == 0) {
      $(this).val('');
    }
    await simulaFinanceiro();
  });

  function addEvent(element) {
    $(element).blur(function () {
      let itens = $(".itens");
      let id = $(this).attr("class").split("-");
      id = id[id.length - 1];
      if (
        parseInt(id) === itens.length - 1 &&
        $(`#txtProduto-${id}`).val() != ""
      ) {
        AddItens();
        $(`#txtProduto-${parseInt(id) + 1}`).focus();
      }
    });

    $(element).on("click", async function () {
      let itens = $(".itens");
      let id = $(this).attr("class").split("-");
      id = id[id.length - 1];
      const idInput = $(`.txtItem-${id}`)[0].id;
      if (itens.length === 1) {
        itens = [];
        $(`.item-${id}`).closest(".row").remove();
        AddItens();
      } else {
        await DeleteItem(id);
        $(`.removido`).closest(".row").remove();
        if (id == 0) {
          $($(`.itens > .item-0 > .input-group`)[0]).css("margin-top", "8%");
          $($(`.itens > .item-0 > .input-group`)[1]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[2]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[3]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[4]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[5]).css("margin-top", "33%");
          $($(`.itens > .item-0 > .input-group`)[6]).css("margin-top", "33%");
        }
      }
    });
  }

  async function simulaFinanceiro() {
    let parcelas = [];
    for (let i = 0; i < 12; i++) {
      if ($(`#edtVencimento${i + 1}`).val() != "") {
        parcelas.push($(`#edtVencimento${i + 1}`).val());
      }
    }
    let i = 1;
    let diferenca;
    let valorNota = $("#txtValorTotal").html().substring(8).replace(".", "").replace(",", ".");
    let vValor = parseFloat((valorNota / parcelas.length).toFixed(2));
    if (
      valorNota > vValor * parcelas.length ||
      valorNota < vValor * parcelas.length
    ) {
      diferenca = (valorNota - vValor * parcelas.length).toFixed(2);
    }
    let guardaValor = vValor;
    let arrVenctos = await RetornaVencimentos(parcelas);
    $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);
    parcelas.forEach((element) => {
      if (element != "") {
        if (diferenca > 0 || i == 0) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
          diferenca = 0;
        } else {
          vValor = guardaValor;
        }
        if (diferenca < 0 && i == parcelas.length) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
        }
        vValor = `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i}" name="txtValorRec-${i}" value="${vValor}">`;
        $("#tabelaDuplicatas").DataTable().row.add([i, arrVenctos[i - 1], vValor]).draw(false);
      }
      i++;
    });
    focuValor();
  };

  async function RetornaVencimentos(arrDias) {
    let arrVencimentos = [];
    try {
      let dataAtual = new Date();
      for (let index = 0; index < arrDias.length; index++) {
        if (arrDias[index] != "") {
          let novoPrazo = new Date();
          novoPrazo.setDate(dataAtual.getDate() + parseInt(arrDias[index]));

          const response = await requisicao("GET", "/sisplan/nfe/v1/datavencimento?", `CODCLI=${pegaChave('#txtCliente')}&DATA=${formataData(novoPrazo)}`);
          const jsonStr = await response.text();

          let novaData = jsonStr.split('/')[2] + '-' + jsonStr.split('/')[1] + '-' + jsonStr.split('/')[0];
          novaData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${index}" name="txtDataRec" value="${novaData}"></input>`
          arrVencimentos.push(novaData);
        }
      }
      return arrVencimentos;
    } catch (error) {
      console.error(error);
    }
  };

  function focuValor() {
    $('.classeValorFin').on('focusout', function () {
      let parcelas = [];
      let vValor = 0;
      for (let i = 0; i < 12; i++) {
        if ($(`#edtVencimento${i + 1}`).val() != "") {
          parcelas.push($(`#edtVencimento${i + 1}`).val());
          vValor += parseFloat($(`#txtValorRec-${i + 1}`).val());
        }
      }
      const valorNota = $("#txtValorTotal").html().substring(8).replace(".", "").replace(",", ".");
      vValor = parseFloat((valorNota - vValor).toFixed(2));
      const valAtual = parseFloat($(`#txtValorRec-${parcelas.length}`).val());
      if (parseFloat((vValor + valAtual).toFixed(2)) > 0) {
        $(`#txtValorRec-${parcelas.length}`).val(parseFloat((vValor + valAtual).toFixed(2)));
      } else {
        msgAlerta('Valor das parcelas é superior ao total da nota, recalculo será efetuado!');
        simulaFinanceiro();
      }
    });
  };

  async function calculaTotaisItens() {
    $.LoadingOverlay("show");
    try {
      let itens = $(".itens");

      let nota = {};
      nota.CODCLI = pegaChave("#txtCliente");
      nota.DTEMISSAO = $("#txtDataEmissao").val();
      nota.NATUREZA = pegaChave("#txtNatureza");
      nota.ITENS = [];

      for (let i = 0; i < itens.length; i++) {
        if ($(seletorPorNome("txtProduto", i)).val() != "" && $(seletorPorNome("txtPreco", i)).val() != "" && $(seletorPorNome("txtQuantidade", i)).val() != "") {
          if ($(seletorPorNome("txtProduto", i)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", i)).attr("data-codigo") != "") {
            let item = {};
            item.CODIGO = $(seletorPorNome("txtProduto", i)).attr("data-codigo");
            item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", i)).val());
            item.PRECO = parseFloat($(seletorPorNome("txtPreco", i)).val());
            item.NATUREZA = nota.NATUREZA;
            item.VALOR = item.PRECO * item.QTDE;
            nota.ITENS.push(item);
          }
        }
      }

      if (nota.ITENS.length == 0) {
        zeraTotais();
        return;
      }

      try {
        const response = await requisicao("POST", "/sisplan/fatservico/v1/retornatotais?", '', JSON.stringify(nota), 300000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        let qtdeTotal = 0;
        jsonStr.itens.map(item => { qtdeTotal += item.qtde; });

        
        const percDesc = $('#txtDesconto').val();
        const totDesconto = (jsonStr.valor_liq * (percDesc / 100));

        $("#txtTotDesconto").html(parseFloat(totDesconto).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtTotalLiquido").html(parseFloat(jsonStr.valor_liq - totDesconto).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorTotal").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtTotalQtde").html(parseFloat(qtdeTotal));

        $("#txtValorPis").html(parseFloat(jsonStr.val_pis).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorCofins").html(parseFloat(jsonStr.val_cofins).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorIss").html(parseFloat(jsonStr.valor_iss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $("#txtValorCsll").html(parseFloat(jsonStr.val_csll).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorInss").html(parseFloat(jsonStr.val_inss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorIrrf").html(parseFloat(jsonStr.val_irrf).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $("#txtValorFinanceiro").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function buscaServicos(background = false) {
    const sCodigo = $("#txtProdutoCodigo").val();
    const sDescricao = $("#txtProdutoDescricao").val().toUpperCase();

    let dataSetCols = [];
    let sWhere = "";

    sWhere += (sCodigo == '' ? '' : ` AND SERVICO.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `);
    sWhere += (sDescricao == '' ? '' : ` AND UPPER(SERVICO.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]') `);

    try {
      if (!background) {
        $.LoadingOverlay("show");
      }

      const pesquisaParam = {
        tabela: "SERVICO",
        camposSelect: [
          "SERVICO.CODIGO",
          "SERVICO.DESCRICAO"
        ],
        where: ['1 = 1' + sWhere]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        return;
      }

      const dataSet = jsonStr;
      const keys = Object.keys(dataSet[0]);
      keys.forEach((value) => { dataSetCols.push({ title: value, data: value, }); });

      criaDataTablePadrao('#tabelaProdutos', false, false, true, false, true, false, '300px', dataSet, dataSetCols);

      $("#tabelaProdutos tbody").on("click", "tr", function () {
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
      });

      $("#tabelaProdutos tbody").on("dblclick", "tr", function () {
        document.firstElementChild.style.zoom = "reset";
        $("#tabelaProdutos").dataTable().$("tr.selected").removeClass("selected");
        $(this).addClass("selected");
        $("#btn_confirmar_produto").click();
      });
    } finally {
      if (!background) {
        $.LoadingOverlay("hide");
      }
    }
  }

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#ultimoVoltar").click(async function () {
    if ($("#financeiroFs").hasClass("d-none")) {
      setTimeout(function () {
        $("#voltarFinanceiro").trigger("click");
      }, 100);
    }
  });

  $("#dropdown").trigger("change");

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    $.LoadingOverlay("show");

    if (!validaDadosItens()) {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      return;
    }

    if ($('#txtVendedor').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Representante inválido, por favor verifique e tente novamente!');
      return;
    }

    if ($('#txtNatureza').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Natureza inválida, por favor verifique e tente novamente!');
      return;
    }

    if ($('#txtMoeda').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Campo moeda inválido, por favor verifique e tente novamente.');
      return;
    }

    if ($('#txtHistorico').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Campo histórico inválido, por favor verifique e tente novamente.');
      return;
    }

    if ($('#txtBanco').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Campo banco inválido, por favor verifique e tente novamente.');
      return;
    }

    if ($('#txtSituacao').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Campo situação inválido, por favor verifique e tente novamente.');
      return;
    }

    if ($('#txtClasseGer').val() == '') {
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgAlerta('Campo classe gerencial inválido, por favor verifique e tente novamente.');
      return;
    }

    const dataEmi = $('#txtDataEmissao').val();
    const codObra = $('#txtCodObra').val();
    const codArt = $('#txtCodArt').val();
    const codcli = pegaChave('#txtCliente');
    const serie = $('#txtSerie').val();
    const codRep = pegaChave('#txtRepresentante');
    const comissao1 = $('#txtCom1').val();
    const comissao2 = $('#txtCom2').val();
    const natureza = pegaChave('#txtNatureza');
    const cidadeServ = pegaChave('#txtCidade');
    const outrasInfos = $('#txtOutrasInfo').val();
    const rpsZerado = $('#cbRpsZerado').is(':checked');
    const descRetenValLiq = $('#cbDescRetencoes').is(':checked');
    const descIssValLiq = $('#cbDescIss').is(':checked');

    try {

      let arrayItens = [];
      for (let index = 0; index < $(".itens").length; index++) {
        if ($(seletorPorNome("txtProduto", index)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", index)).attr("data-codigo") != "") {
          arrayItens.push({
            CODIGO: $(seletorPorNome("txtProduto", index)).attr("data-codigo"),
            DESCRICAO: $(seletorPorNome("txtProduto", index)).attr("data-descricao"),
            QUALIDADE: '1',
            QTDE: parseFloat($(seletorPorNome("txtQuantidade", index)).val()),
            PRECO: parseFloat($(seletorPorNome("txtPreco", index)).val()),
            VALOR: (parseFloat($(seletorPorNome("txtQuantidade", index)).val()) * parseFloat($(seletorPorNome("txtPreco", index)).val())).toFixed(2),
          });
        }
      }

      let arrayDuplicatas = [];
      for (let index = 0; index < $("#tabelaDuplicatas").DataTable().rows().count(); index++) {
        let duplicata = {};
        duplicata.DT_VENCTO = $(`#txtDataRec-${index}`).val();
        duplicata.VALOR2 = $(`#txtValorRec-${index + 1}`).val();
        duplicata.MOEDA = pegaChave("#txtMoeda");
        duplicata.HISTORICO = pegaChave("#txtHistorico");
        duplicata.BANCO = pegaChave("#txtBanco");
        duplicata.SITUACAO = pegaChave("#txtSituacao");
        duplicata.CLASSE = pegaChave("#txtClasseGer");
        duplicata.DT_EMISSAO = dataEmi;
        duplicata.VALOR = $('#txtValorTotal').html().replace('R$&nbsp;', '').replace(',', '.');
        arrayDuplicatas.push(duplicata);
      }

      const nfse = {};

      nfse.SERIE = serie;
      nfse.CODCLI = codcli;
      nfse.CODREP = codRep;
      nfse.NATUREZA = natureza;
      nfse.OUTRASINF = outrasInfos;
      nfse.CIDADE = cidadeServ;
      nfse.CODOBRA = codObra;
      nfse.CODART = codArt;
      nfse.VALOR_RPS_ZERO = rpsZerado;
      nfse.COM1 = comissao1;
      nfse.COM2 = comissao2;
      nfse.DESCRETVALLIQ = descRetenValLiq;
      nfse.DESCISSVALLIQ = descIssValLiq;
      nfse.DT_EMISSAO = dataEmi;
      nfse.ITENS = arrayItens;
      nfse.DUPLICATAS = arrayDuplicatas;
      nfse.NUM_OS = servico;

      const response = await requisicao('POST', '/sisplan/fatservico/v1/geranfse?', '', `JSON=${encodeURIComponent(JSON.stringify(nfse))}`, 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        $(this).attr('disabled', false);
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        $(this).attr('disabled', false);
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');

      await criaMensagemSucesso('Nota fiscal de serviço eletrônica gravada com sucesso.', () => {
        let abaAtiva = parent.document.querySelector('#listaAbas li.active')
        if (abaAtiva.length !== 0) {
          parent.document.querySelector('#menu_impressaonfse .nav-link').click();
          abaAtiva.children[0].click();
        } else {
          console.error("Aba ativa não encontrada.");
        };
      });

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      $(this).attr('disabled', false);
      msgErro(`Não foi possível gravar os dados da nota fiscal de serviço eletrônica: ${error}`);
    } finally {
      $(this).attr('disabled', false);
    }
  });

  function trocaIdClass(seletor, indice) {
    const classe = seletor.substring(1);
    $(`${seletor}-${indice}`).addClass(`${classe}-atual`).removeClass(`${classe}-${indice}`);
    $(`${seletor}-atual`).addClass(`${classe}-${indice - 1}`).removeClass(`${classe}-atual`);
  };

  async function DeleteItem(id) {
    let itens = $(".itens");
    for (let i = 0; i < itens.length; i++) {
      if (i == id) {
        $(`.item-${i}`).addClass(`removido`).removeClass(`item-${i}`);
      } else if (i > id) {
        $(`.item-${i}`).addClass(`atual`).removeClass(`item-${i}`);
        $(`.atual`).addClass(`item-${i - 1}`).removeClass(`atual`);
        trocaIdClass(`.btn-limpa`, i);
        trocaIdClass(`.btn-edit`, i);
        trocaIdClass(`.btn-add`, i);
        trocaIdClass(`.txtItem`, i);
        $(`.contador.item-${i - 1}>span`).html(i);
      }
    }
    await calculaTotaisItens();
  };

  function validaDadosItens() {
    const servico = $($(".classeProduto")[0]).val();
    const qtde = $($(".classeQuantidade")[0]).val();
    const preco = $($(".classePreco")[0]).val();

    if ([servico, qtde, preco].includes('')) {
      msgAlerta('Serviço, quantidade ou preço não informados.\nFavor voltar a aba de itens e verificar.');
      return false;
    }
    return true;
  };

  function zeraTotais() {
    $("#txtTotalLiquido").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorTotal").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtTotalQtde").html(parseFloat(0));

    $("#txtValorPis").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorCofins").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorCsll").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorInss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIrrf").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorFinanceiro").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  };

  async function carregaValoresPadroes() {
    if ($(window.location.href.split('/')).get(-1) != 'create') {
      return;
    }

    const jsonStr = await buscaValoresPadroes('NOTA')

    // jsonStr.map(item => {
    //   switch (item.CAMPO) {
    //     case 'OPERACAO': {
    //       if (item.VALOR != '') {
    //         insereValor('#txtReducao', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoVenda', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoNota', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoMovimentacao', item.VALOR, 'VALOR PADRÃO');
    //       }
    //       break;
    //     }
    //     case 'DEPOSITO': {
    //       if (item.VALOR != '') {
    //         insereValor('#txtDeposito', item.VALOR, 'VALOR PADRÃO');
    //       }
    //       break;
    //     }
    //   }
    // });
  };

  function seletorPorNome(name, i) {
    return `.item-${i}>div>input[name*="${name}"]`;
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente", "#txtCNPJ"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () { $("#txtCliente").val(""); $("#txtCNPJ").val(""); $("#txtCliente").trigger("blur"); });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Representante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btn-limpa-Representante").on("click", function () { $("#txtRepresentante").val(""); });

    $("#txtObra").autocompleta(1, `JSON={ "tabela":"OBRA", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-Obra").pesquisa_serverside(["#txtObra"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"OBRA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Obra");
    $("#btn-limpa-Obra").on("click", function () { $("#txtObra").val(""); });

    $("#txtNatureza").autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`);
    $("#btn-Natureza").pesquisa("#txtNatureza", "NATUREZA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`, "Pesquisa Natureza", "natureza");
    $("#btn-limpa-Natureza").on("click", function () { $("#txtNatureza").val(""); });

    $("#txtStatus").autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-Status").pesquisa_serverside(["#txtStatus"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, "Pesquisa Status");
    $("#btn-limpa-Status").on("click", function () { $("#txtStatus").val(""); });

    $("#txtCidade").autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Cidade").pesquisa_serverside(["#txtCidade"], ["CODIGO"], ["NOME"], `{"tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, "Pesquisa Cidade");
    $("#btn-limpa-Cidade").on("click", function () { $("#txtCidade").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-banco").on("click", function () { $("#txtBanco").val(""); });
  };

  function criaMascaraCampos() {
    $("#txtCom1, #txtCom2").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
    $("#txtDesconto").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });
  };

  async function buscaDadosOs(servico) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'OS',
        camposSelect: ['OS.*', 'ENTIDADE.NOME', 'REPRESEN.NOME AS NOME_REP', 'REPRESEN.COMISSAO', 'REPRESEN.COMISSAO2', 'REPRESEN.COMISSAO_SERV', 'REPRESEN.COMISSAO_SERV2', 'NATUREZA.DESCRICAO AS DESC_NATUREZA', 'EMPRESA.EMP_CIDADE', 'EMPRESA.EMP_SERIENF', 'EMPRESA.EMP_SERIENFS', 'MOEDA.DESCRICAO AS DESC_MOEDA', 'CLASSE_GER.DESCRICAO AS DESC_CLASSE_GER'],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'OS.CLIENTE = ENTIDADE.CODCLI' },
          { tabela: 'REPRESEN', condicao: 'OS.CODREP = REPRESEN.CODREP' },
          { tabela: 'NATUREZA', condicao: 'OS.NATUREZA = NATUREZA.NATUREZA' },
          { tabela: 'EMPRESA', condicao: `EMPRESA.EMP_ID = ${getCookie('emp_id')}` },
          { tabela: 'MOEDA', condicao: 'OS.MOEDA = CAST(MOEDA.CODMOE AS VARCHAR(10))' },
          { tabela: 'CLASSE_GER', condicao: 'OS.CLASSE_GER = CLASSE_GER.CODIGO' },
        ],
        where: [`OS.NUMERO = '${servico}'`],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Não foi possível buscar os dados da Ordem de Serviço! Por favor, tente novamente');
        return;
      }

      if (jsonStr[0].CLIENTE != undefined && jsonStr[0].CLIENTE != null && jsonStr[0].CLIENTE != '') {
        $('#txtCliente').val(`[${jsonStr[0].CLIENTE}] -  ${jsonStr[0].NOME}`);
        await buscaBloqueio(jsonStr[0].CLIENTE);
      };

      if (jsonStr[0].CODREP != undefined && jsonStr[0].CODREP != null && jsonStr[0].CODREP != '') {
        $('#txtRepresentante').val(`[${jsonStr[0].CODREP}] - ${jsonStr[0].NOME_REP}`);
      };

      if (jsonStr[0].CODREP != undefined && jsonStr[0].CODREP != null && jsonStr[0].CODREP != '') {
        $('#txtRepresentante').val(`[${jsonStr[0].CODREP}] - ${jsonStr[0].NOME_REP}`);

        if (jsonStr[0].COMISSAO_SERV != '') {
          $('#txtCom1').val(jsonStr[0].COMISSAO_SERV);
        } else if (jsonStr[0].COMISSAO != '') {
          $('#txtCom1').val(jsonStr[0].COMISSAO);
        };

        if (jsonStr[0].COMISSAO_SERV2 != '') {
          $('#txtCom2').val(jsonStr[0].COMISSAO_SERV2);
        } else if (jsonStr[0].COMISSAO2 != '') {
          $('#txtCom2').val(jsonStr[0].COMISSAO2)
        }

      };

      if (jsonStr[0].EMP_CIDADE != undefined && jsonStr[0].EMP_CIDADE != null && jsonStr[0].EMP_CIDADE != '') {
        const pesquisaCep = {
          tabela: "CIDADE",
          camposSelect: ["CIDADE.CODIGO"],
          where: [`NOME = '${jsonStr[0].EMP_CIDADE}'`]
        };

        const jsonStrCep = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCep));

        $('#txtCidade').val(`[${jsonStrCep[0].CODIGO}] -  ${jsonStr[0].EMP_CIDADE}`);
      };

      if (jsonStr[0].NATUREZA != undefined && jsonStr[0].NATUREZA != null && jsonStr[0].NATUREZA != '') {
        $('#txtNatureza').val(`[${jsonStr[0].NATUREZA}] - ${jsonStr[0].DESC_NATUREZA}`);
      };

      if (jsonStr[0].EMP_SERIENFS != undefined && jsonStr[0].EMP_SERIENFS != null && jsonStr[0].EMP_SERIENFS != '') {
        $('#txtSerie').val(`${jsonStr[0].EMP_SERIENFS}`);
      } else {
        if (jsonStr[0].EMP_SERIENF != undefined && jsonStr[0].EMP_SERIENF != null && jsonStr[0].EMP_SERIENF) {
          $('#txtSerie').val(`${jsonStr[0].EMP_SERIENF}`);
        }
      };

      if (jsonStr[0].DESCONTO != undefined && jsonStr[0].DESCONTO != null) {
        $('#txtDesconto').val(`${jsonStr[0].DESCONTO}`);
      } 

      const pesquisaOsIten = {
        tabela: 'OS_ITEN',
        camposSelect: ['CODIGO', 'DESCRICAO', 'QTDE', 'PRECO'],
        where: [`NUMERO = '${servico}' AND TIPO = 'S'`]
      }

      const jsonStrOsIten = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaOsIten));

      if (jsonStrOsIten.length == 0) {
        await msgAguardaConfirmacao('Não foi possível buscar os dados dos serviços da Ordem de Serviço! Por favor, tente novamente.', () => { }, () => { }, true, 'Ok');
        parent.fechaAbaAberta();
        return;
      };

      itensOs = jsonStrOsIten;

      dadosFin = {
        classeger: jsonStr[0].CLASSE_GER,
        desc_classe_ger: jsonStr[0].DESC_CLASSE_GER,
        moeda: jsonStr[0].MOEDA,
        desc_moeda: jsonStr[0].DESC_MOEDA
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#avancar1').on('click', async function () {
    const itens = $(".itens");
    if (itens.length < itensOs.length) {
      for (item in itensOs) {
        AddItens();
        $(`#txtProduto-${item}`).val(`${itensOs[item].CODIGO} - ${itensOs[item].DESCRICAO}`);
        $(`#txtProduto-${item}`).attr("data-codigo", itensOs[item].CODIGO);
        $(`#txtProduto-${item}`).attr("data-descricao", itensOs[item].DESCRICAO);
        $(`#txtQuantidade-${item}`).val(`${itensOs[item].QTDE}`);
        $(`#txtPreco-${item}`).val(`${itensOs[item].PRECO.toFixed(2)}`);
        if ($(`#txtQuantidade-${item}`).val() != "") {
          calculaTotaisItens();
        }
      }
    }
  });

  $('#txtDesconto').on('blur', function () {
    calculaTotaisItens()
  })

  $('#avancarItens').on('click', function () {
    if ((servico != '') && (servico != 'create')) {
      if (dadosFin.classeger  != '') {
        $('#txtClasseGer').val(`[${dadosFin.classeger}] - ${dadosFin.desc_classe_ger}`);
      };
  
      if (dadosFin.moeda != '') {
        $('#txtMoeda').val(`[${dadosFin.moeda}] - ${dadosFin.desc_moeda}`)
      };
    }
  });

});

