<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Encontro de Contas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.254.22.1">
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.254.22.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.254.22.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.254.22.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.254.22.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.254.22.1">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.254.22.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.254.22.1">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.254.22.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.254.22.1">
    <style>
        .radioStyle {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding: 6px;
        }

        .campoSel {
            display: inline-block;
            position: absolute;
            width: 22px;
            height: 22px;
            border: 1px solid #D3CFC8;
            border-radius: 0;
        }

        .table.dataTable tbody td {
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden;
        }

        .table.dataTable thead th {
            white-space: nowrap;
            text-overflow: ellipsis;
            overflow: hidden;
        }

        .border-Field .textoBordaBaixaCheque {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 5px;
            border-bottom: none;
            font-weight: bold;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 5px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2 col-12">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Encontro de Contas</h1>
                            <!-- <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button> -->
                        </div>
                        <div class="col-sm-6 text-right mt-3">
                            <span style="color: red; font-weight: bold" id="spanF7">Clique F7 para mostrar/esconder os filtros</span>
                        </div>
                    </div>
                </div>
                <div class="container-fluid card">
                    <div class="row card-body" id="abaGeral">
                        <div class="row col-12 col-sm-12 col-md-12 border-bottom escondeInputs" id="divDadosCheque">
                            <label class="m-0 text-dark col-12 col-sm-12 col-md-12 pl-0 mb-3 mt-0 pt-0">Dados do Cheque</label>
                            <div class="col-sm-2 col-md-2 col-lg-2 form-group pl-0">
                                <label data-error="wrong" data-success="right" for="txtDtVenctoDeCh">Vencimento (de/até): </label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtVenctoDeCh" name="txtDtVenctoDeCh">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtVenctoAteCh" name="txtDtVenctoAteCh">
                                </div>
                            </div>

                            <div class="col-sm-2 col-2 col-md-2 form-group">
                                <label data-error="wrong" data-success="right" for="txtEmissorCh">Emissor: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtEmissorCh" name="txtEmissorCh" placeholder="Emissor">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnLimpaEmissorCh" name="btnLimpaEmissorCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2 col-2 col-md-2 form-group">
                                <label data-error="wrong" data-success="right" for="txtPedidoCh">Pedido: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtPedidoCh" name="txtPedidoCh" placeholder="Pedido">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnLimpaPedidoCh" name="btnLimpaPedidoCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtClienteCh">Cliente/Fornecedor: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtClienteCh" name="txtClienteCh" placeholder="Cliente/Fornecedor">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClienteCh" name="btnClienteCh" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClienteCh" name="btnLimpaClienteCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtRepresentanteCh">Representante: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtRepresentanteCh" name="txtRepresentanteCh" placeholder="Representante CH."> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtRepresentanteCh" name="txtRepresentanteCh" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnRepresentanteCh" name="btnRepresentanteCh" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaRepresentanteCh" name="btnLimpaRepresentanteCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group pl-0">
                                <label data-error="wrong" data-success="right" for="txtHistoricoCh">Histórico Cheque: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtHistoricoCh" name="txtHistoricoCh" placeholder="Histórico CH.">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnHistoricoCh" name="btnHistoricoCh" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaHistoricoCh" name="btnLimpaHistoricoCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtSituacaoCh">Situação Cheque: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtSituacaoCh" name="txtSituacaoCh" placeholder="Situação CH."> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtSituacaoCh" name="txtSituacaoCh" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnSituacaoCh" name="btnSituacaoCh" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaSituacaoCh" name="btnLimpaSituacaoCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group pl-0">
                                <label data-error="wrong" data-success="right" for="txtClasseGerCh">Classe Gererencial Cheque: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtClasseGerCh" name="txtClasseGerCh" placeholder="Classe Ger. CH.">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClasseGerCh" name="btnClasseGerCh" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClasseGerCh" name="btnLimpaClasseGerCh" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtBuscaChequeCMC">Buscar Cheque CMC7: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtBuscaChequeCMC" name="txtBuscaChequeCMC" placeholder="Buscar Cheque">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnLimpaBuscaChequeCmc" name="btnLimpaBuscaChequeCmc" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row col-12 col-sm-12 col-md-12 escondeInputs" id="divDadosReceber">
                            <label class="text-dark col-12 col-sm-12 col-md-12 mb-3 pl-0 mt-2">Dados do Receber</label>
                            <div class="col-sm-2 col-md-2 col-lg-2 form-group pl-0">
                                <label data-error="wrong" data-success="right" for="txtDtVenctoDeRec">Vencimento (de/até): </label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtVenctoDeRec" name="txtDtVenctoDeRec">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtVenctoAteRec" name="txtDtVenctoAteRec">
                                </div>
                            </div>
                            <div class="col-sm-2 col-md-2 col-lg-2 form-group">
                                <label data-error="wrong" data-success="right" for="txtDtEmissaoDeRec">Emissão (de/até): </label>
                                <div class="input-group">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoDeRec" name="txtDtEmissaoDeRec">
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAteRec" name="txtDtEmissaoAteRec">
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtNumeroRec">Número: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtNumeroRec" name="txtNumeroRec" placeholder="Número"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtNumeroRec" name="txtNumeroRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnNumeroRec" name="btnNumeroRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaNumeroRec" name="btnLimpaNumeroRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtClienteRec">Cliente: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtClienteRec" name="txtClienteRec" placeholder="Cliente"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtClienteRec" name="txtClienteRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClienteRec" name="btnClienteRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClienteRec" name="btnLimpaClienteRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-2 col-2 col-md-2 form-group">
                                <label data-error="wrong" data-success="right" for="txtPedidoRec">Pedido: </label>
                                <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtPedidoRec" name="txtPedidoRec" placeholder="Pedido">
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnLimpaPedidoRec" name="btnLimpaPedidoRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group pl-0">
                                <label data-error="wrong" data-success="right" for="txtFaturaRec">Fatura: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtFaturaRec" name="txtFaturaRec" placeholder="Fatura"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtFaturaRec" name="txtFaturaRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnFaturaRec" name="btnFaturaRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaFaturaRec" name="btnLimpaFaturaRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtSituacaoRec">Situação: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtSituacaoRec" name="txtSituacaoRec" placeholder="Situação"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtSituacaoRec" name="txtSituacaoRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnSituacaoRec" name="btnSituacaoRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaSituacaoRec" name="btnLimpaSituacaoRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtRepresenRec">Representante: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtRepresenRec" name="txtRepresenRec" placeholder="Representante"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtRepresenRec" name="txtRepresenRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnRepresenRec" name="btnRepresenRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaRepresenRec" name="btnLimpaRepresenRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3 col-3 col-md-3 form-group">
                                <label data-error="wrong" data-success="right" for="txtClasseGerRec">Classe Gerencial: </label>
                                <div class="input-group">
                                    <!-- <input type="text" class="input-default focus form-control" id="txtClasseGerRec" name="txtClasseGerRec" placeholder="Classe Gerencial"> -->
                                    <select class="js-example-programmatic js-states form-control" id="txtClasseGerRec" name="txtClasseGerRec" multiple="multiple"> </select>
                                    <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnClasseGerRec" name="btnClasseGerRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btnLimpaClasseGerRec" name="btnLimpaClasseGerRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-10 col-10 col-md-10 form-group pb-0 mb-0 pl-0 escondeInputs" id="opcoesConsulta">
                                <div class="form" id="tipoNatureza">
                                    <fieldset class="form border-Field">
                                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                        <div class="d-flex wrap" style="flex-wrap: wrap; gap: 20px">
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input " id="cbBuscaAntecipacao">
                                                <label class="form-check-label" for="cbBuscaAntecipacao">Busca Antecipação</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input" id="cbBuscaDevolucao">
                                                <label class="form-check-label" for="cbBuscaDevolucao">Busca Devolução</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input" id="cbBuscaChequeDev">
                                                <label class="form-check-label" for="cbBuscaChequeDev">Busca Cheque Dev.</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input" id="cbBaixarCheques">
                                                <label class="form-check-label" for="cbBaixarCheques">Baixar Cheques</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input" id="cbBuscaAntecipacaoGridInferior">
                                                <label class="form-check-label" for="cbBuscaAntecipacaoGridInferior">Busca Antecipação no Grid Inferior</label>
                                            </div>
                                            <div class="form-group form-check icheck-primary" style="margin-bottom:  0.65rem;">
                                                <input type="checkbox" class="form-check-input" id="cbNaoLancaContaCor">
                                                <label class="form-check-label" for="cbNaoLancaContaCor">Não lançar valor no Conta Corrente</label>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-2 pl-0 escondeInputs mt-2" id="selEmpresas" style="margin-bottom: 0.65rem">
                                <button id="btnCarregaEmpresas" class="btn btn-danger w-100">Selecionar Empresas</button>
                            </div>
                        </div>
                        <div class="col-lg-12 form-group flex justify-content-start">
                            <button class="btn btn-primary btn-sisp mr-1 escondeInputs" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                            <button class="btn btn-danger btn-sisp escondeInputs" id="btnFechar"><span class="fas fa-arrow-left"></span> Voltar</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body p-0">
                            <h5 id="tituloTableCheque">Dados dos Cheques</h5>
                            <table id="tabelaCheques" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th class="th-sm">Sel
                                        </th>
                                        <th class="th-sm">Número
                                        </th>
                                        <th class="th-sm">Banco
                                        </th>
                                        <th class="th-sm">Conta
                                        </th>
                                        <th class="th-sm">Agência
                                        </th>
                                        <th class="th-sm">Emissão
                                        </th>
                                        <th class="th-sm">Vencimento
                                        </th>
                                        <th class="th-sm">Valor
                                        </th>
                                        <th class="th-sm">Emissor
                                        </th>
                                        <th class="th-sm">Val. Pago
                                        </th>
                                        <th class="th-sm">CodFor
                                        </th>
                                        <th class="th-sm">Codcli
                                        </th>
                                        <th class="th-sm">Duplicata
                                        </th>
                                        <th class="th-sm">Empresa
                                        </th>
                                        <th class="th-sm">Obs
                                        </th>
                                        <th class="th-sm">Barra CH.
                                        </th>
                                        <th class="th-sm">Saldo
                                        </th>
                                        <th class="th-sm">Selecionado
                                        </th>
                                        <th class="th-sm">Status
                                        </th>
                                        <th class="th-sm">Nome Cliente
                                        </th>
                                        <th class="th-sm">Fantasia
                                        </th>
                                        <th class="th-sm">Fatura
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-sm-12 col-12 col-md-12 row p-0">
                            <div class="form-group col-1">
                                <label class="mt-2"> Valor Selecionado: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtValorSelecionadoCh" name="txtValorSelecionadoCh" placeholder="0,00">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2" style="white-space: nowrap;"> Cheques Selecionado: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtChequeSelecionadosCh" name="txtChequeSelecionadosCh" placeholder="0">
                            </div>
                        </div>
                        <div class="col-sm-12 table-responsive card-body p-0 mt-4">
                            <h5>Dados do Receber</h5>
                            <table id="tabelaReceber" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th class="th-sm">Sel
                                        </th>
                                        <th class="th-sm">Número
                                        </th>
                                        <th class="th-sm">Codcli
                                        </th>
                                        <th class="th-sm">Nome Cliente
                                        </th>
                                        <th class="th-sm">Dt. Emissão
                                        </th>
                                        <th class="th-sm">Dt. Vencto
                                        </th>
                                        <th class="th-sm">Valor
                                        </th>
                                        <th class="th-sm">Valor Dev.
                                        </th>
                                        <th class="th-sm">Desconto
                                        </th>
                                        <th class="th-sm">Juros
                                        </th>
                                        <th class="th-sm">Val. Pago
                                        </th>
                                        <th class="th-sm">Saldo
                                        </th>
                                        <th class="th-sm">Empresa
                                        </th>
                                        <th class="th-sm">Selecionado
                                        </th>
                                        <th class="th-sm">Fatura
                                        </th>
                                        <th class="th-sm">Status
                                        </th>
                                        <th class="th-sm">Obs
                                        </th>
                                        <th class="th-sm">Com 2
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-sm-12 col-12 col-md-12 row p-0">
                            <div class="form-group col-1 p-0">
                                <label class="mt-2"> Valor Selecionado: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtValorSelecionadoRec" name="txtValorSelecionadoRec" placeholder="0,00">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2"> Dups. Selecionadas: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtDupSelecionadaRec" name="txtDupSelecionadaRec" placeholder="0">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2"> Valor Duplicatas: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtValorDuplicatasRec" name="txtValorDuplicatasRec" placeholder="0,00">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2"> Valor Acumulado: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtValorAcumuladoRec" name="txtValorAcumuladoRec" placeholder="0,00">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2"> Qtde Cheques: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtQtdeChequesRec" name="txtQtdeChequesRec" placeholder="0">
                            </div>
                            <div class="form-group col-1">
                                <label class="mt-2"> Saldo Receber: </label>
                                <input type="text" class="input-default focus form-control text-right" disabled id="txtSaldoReceberRec" name="txtSaldoReceberRec" placeholder="0,00">
                            </div>
                            <div class="form-group col-1 p-0">
                                <label class="mt-3"></label>
                                <button class="btn btn-secondary col-12 btn-sisp mt-1" id="btnCalcular"><span class="fas fa-calculator"></span> Calcular</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- modal  -->
        </div>
        <div class="row">
            <div id="modal-baixasRecCheque" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Lançar Baixas Receber</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="col-sm-12 table-responsive card-body pr-0 pt-0 pb-0">
                                <h5>A Lançar</h5>
                                <table id="tabelaBaixasRecCheque" class="table table-sm table-select table-hover" width="100%">
                                    <thead>
                                        <tr>
                                            <th class="th-sm">Tipo
                                            </th>
                                            <th class="th-sm">Número
                                            </th>
                                            <th class="th-sm">Codcli
                                            </th>
                                            <th class="th-sm">Valor
                                            </th>
                                            <th class="th-sm">Seq
                                            </th>
                                            <th class="th-sm">Número Rec.
                                            </th>
                                            <th class="th-sm">Obs.
                                            </th>
                                            <th class="th-sm">Usou Dev
                                            </th>
                                            <th class="th-sm">Data Vencto.
                                            </th>
                                            <th class="th-sm">Empresa
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-sm-12 col-md-12 col-12 p-0 row">
                                <div class="col-sm-4 col-md-4 col-4 pb-0 pr-0">
                                    <div class="col-sm-12 col-12 col-md-12 pb-0 pr-0">
                                        <fieldset class="form border-Field pb-0 pr-0">
                                            <legend class="textoBordaBaixaCheque mb-0 pb-0 pr-1">Dados Baixa Cheque</legend>
                                            <div class="form-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                <label data-error="wrong" class="mt-2" data-success="right" for="txtClasseGerRecBCH">Classe Gerencial: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                    <input type="text" class="input-default focus form-control" id="txtClasseGerRecBCH" name="txtClasseGerRecBCH" placeholder="Classe Gerencial">
                                                    <!-- <select class="js-example-programmatic js-states form-control" id="txtClasseGerBaixaCheque" name="txtClasseGerBaixaCheque" multiple="multiple"> </select> -->
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnClasseGerRecBCH" name="btnClasseGerRecBCH" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaClasseGerRecBCH" name="btnLimpaClasseGerRecBCH" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                <label data-error="wrong" data-success="right" for="txtHistoricoRBCH">Histórico: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                    <input type="text" class="input-default focus form-control" id="txtHistoricoRBCH" name="txtHistoricoRBCH" placeholder="Histórico">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnHistoricoRBCH" name="btnHistoricoRBCH" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaHistoricoRBCH" name="btnLimpaHistoricoRBCH" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                    <div class="col-sm-12 col-12 col-md-12 pb-0 pr-0">
                                        <fieldset class="form border-Field pb-0 pr-0 mt-2">
                                            <legend class="textoBordaBaixaCheque mb-0 pb-0 pr-1">Dados Baixa Receber</legend>
                                            <div class="form-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                <label data-error="wrong" class="mt-2" data-success="right" for="txtClasseGerBCHRec">Classe Gerencial: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                    <input type="text" class="input-default focus form-control" id="txtClasseGerBCHRec" name="txtClasseGerBCHRec" placeholder="Classe Gerencial">
                                                    <!-- <select class="js-example-programmatic js-states form-control" id="txtClasseGerBaixaCheque" name="txtClasseGerBaixaCheque" multiple="multiple"> </select> -->
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnClasseGerBCHRec" name="btnClasseGerBCHRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaClasseGerBCHRec" name="btnLimpaClasseGerBCHRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                <label data-error="wrong" data-success="right" for="txtHistoricoBCHRec">Histórico: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12 pr-0 pl-0">
                                                    <input type="text" class="input-default focus form-control" id="txtHistoricoBCHRec" name="txtHistoricoBCHRec" placeholder="Histórico">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnHistoricoBCHRec" name="btnHistoricoBCHRec" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaHistoricoBCHRec" name="btnLimpaHistoricoBCHRec" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="col-sm-8 col-8 col-md-8 pb-0 pr-0">
                                    <fieldset class="form border-Field pb-0 pr-0 mt-2">
                                        <legend class="textoBordaBaixaCheque mb-0 pb-0 pr-1">Dados Pagamento</legend>
                                        <div class="col-12 row">
                                            <div class="col-6">
                                                <label data-error="wrong" data-success="right" for="txtDtPagto">Data Pagamento: </label>
                                                <div class="input-group">
                                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtPagto" name="txtDtPagto">
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label data-error="wrong" data-success="right" for="txtDtContabilizacao">Data Contabalização: </label>
                                                <div class="input-group">
                                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtContabilizacao" name="txtDtContabilizacao">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 row pl-0 pr-0">
                                            <div class="form-group col-md-6 col-sm-6 col-6 pl-0 pr-0">
                                                <label data-error="wrong" class="ml-3 mt-2" data-success="right" for="txtContaR">Conta: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12">
                                                    <input type="text" class="input-default focus form-control" id="txtContaR" name="txtContaR" placeholder="Conta">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnContaR" name="btnContaR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaContaR" name="btnLimpaContaR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-6 col-6 pl-0 pr-0">
                                                <label data-error="wrong" class="ml-3 mt-2" data-success="right" for="txtMoedaR">Moeda: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12">
                                                    <input type="text" class="input-default focus form-control" id="txtMoedaR" name="txtMoedaR" placeholder="Moeda">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnMoedaR" name="btnMoedaR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaMoedaR" name="btnLimpaMoedaR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 row pl-0 pr-0">
                                            <div class="form-group col-md-6 col-sm-6 col-6 pl-0 pr-0 mr-0">
                                                <label data-error="wrong" class="ml-3" data-success="right" for="txtBancoR">Banco: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12">
                                                    <input type="text" class="input-default focus form-control" id="txtBancoR" name="txtBancoR" placeholder="Banco">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnBancoR" name="btnBancoR" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaBancoR" name="btnLimpaBancoR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6 col-sm-6 col-6 pr-0 pl-0">
                                                <label data-error="wrong" class="ml-3" data-success="right" for="txtDoctoR">Documento: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12">
                                                    <input type="text" class="input-default focus form-control" id="txtDoctoR" name="txtDoctoR" placeholder="Documento">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnLimpaDoctoR" name="btnLimpaDoctoR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 row pl-0 pr-0">
                                            <div class="form-group col-md-12 col-sm-12 col-12 pl-0 pr-0">
                                                <label data-error="wrong" class="ml-3" data-success="right" for="txtObsR">Obsservação: </label>
                                                <div class="input-group col-md-12 col-sm-12 col-12">
                                                    <input type="text" class="input-default focus form-control" id="txtObsR" name="txtObsR" placeholder="Observação">
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnLimpaObsR" name="btnLimpaObsR" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer flex justify-content-start align-items-start">
                            <div class="row col-lg-2 col-2">
                                <button class="btn btn-primary col-12 btn-sisp mt-1" id="btnBaixaDados"><span class="fas fa-arrow-down"></span> Baixar Dados</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.254.22.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.254.22.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.254.22.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.254.22.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.254.22.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.254.22.1"></script>
    <script src="dist/js/sisplan.js?versao=3.254.22.1"></script>
    <script src="utils/funcoes.js?versao=3.254.22.1"></script>
    <script src="utils/cookies.js?versao=3.254.22.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.254.22.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.254.22.1"></script>
    <script src="dist/js/driver.min.js?versao=3.254.22.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.254.22.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.254.22.1"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=3.254.22.1"></script>
    <script type="text/javascript" src="config.js?versao=3.254.22.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.254.22.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('ENCONTRO_CONTAS');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/encontro_contas/encontro_contas.js?versao=3.254.22.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>