$(document).ready(async function () {
    let cheqList = [];
    let recList = [];
    let seq = 0;

    $(document).on('keydown', (event) => {
        const keyCode = event.code;

        if (keyCode === "F7") {
            event.preventDefault();
            const components = $('.escondeInputs');

            for (let i = 0; i < components.length; i++) {
                if ($(`#${components[i].id}`).hasClass('d-none')) {
                    $(`#${components[i].id}`).removeClass('d-none');
                } else {
                    $(`#${components[i].id}`).addClass('d-none');
                }
            };
        };
    });

    $('#btnConsultar').on('click', async function () {
        await consultaChequeComReceber();
        await consultaReceber();

        $('html, body').animate({
            scrollTop: $('#tituloTableCheque').offset().top
        }, 300);

        criaFunctionCampoSelChequeReceber();
        criaFunctionCampoSelReceber();

        $('#tabelaCheques').on('draw.dt', async function () {
            criaFunctionCampoSelChequeReceber();
        });

        $('#tabelaReceber').on('draw.dt', async function () {
            criaFunctionCampoSelReceber();
        });
    });

    $('#btnCalcular').on('click', async function () {
        if (cheqList.length <= 0) {
            msgErro('Selecione um cheque para continuar! Tente novamente.');
            return;
        }

        if (recList.length <= 0) {
            msgErro('Seleicona um receber para continuar! Tente novamente.');
            return;
        }
        try {
            await lancarBaixasReceberCheque();
            $('#modal-baixasRecCheque').modal('show');
        } catch (error) {
            console.error(error)
        }
    });

    $('#btnBaixaDados').on('click', async function () {
        await gravaDadosEmissao();
    });

    $('#btnCarregaEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#modal-baixasRecCheque').on('shown.bs.modal', async function () {
        $('#txtHistoricoRBCH').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoRBCH").pesquisa_serverside(['#txtHistoricoRBCH'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoRBCH').on('click', function () { $('#txtHistoricoRBCH').val('') });

        $('#txtClasseGerRecBCH').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerRecBCH").pesquisa_serverside(['#txtClasseGerRecBCH'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerRecBCH').on('click', function () { $('#txtClasseGerRecBCH').val('') });

        $('#txtHistoricoBCHRec').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoBCHRec").pesquisa_serverside(['#txtHistoricoBCHRec'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoBCHRec').on('click', function () { $('#txtHistoricoBCHRec').val('') });

        $('#txtClasseGerBCHRec').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerBCHRec").pesquisa_serverside(['#txtClasseGerBCHRec'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerBCHRec').on('click', function () { $('#txtClasseGerBCHRec').val('') });

        setarDataAtual('txtDtPagto');
        setarDataAtual('txtDtContabilizacao');

        $('#txtContaR').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
        $('#btnContaR').pesquisa_serverside(['#txtContaR'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
        $('#btnLimpaContaR').on('click', function () { $('#txtContaR').val('') })

        $('#txtBancoR').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}`);
        $('#btnBancoR').pesquisa_serverside(['#txtBancoR'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
        $('#btnLimpaBancoR').on('click', function () { $('#txtBancoR').val('') });

        $('#txtMoedaR').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#btnMoedaR').pesquisa_serverside(['#txtMoedaR'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
        $('#btnLimpaMoedaR').on('click', function () { $('#txtMoedaR').val('') })

        $('#btnLimpaObsR').val('');
        $('#btnLimpaDoctoR').val('');
    });

    function criaFunctionCampoSelChequeReceber() {
        $('.campoSelCheque').unbind('change');
        $('.campoSelCheque').on('change', async function () {
            let qtdeCheques = parseInt($('#txtChequeSelecionadosCh').val() == '' ? '0' : $('#txtChequeSelecionadosCh').val());
            let valorSelecionadoCheques = parseFloat($('#txtValorSelecionadoCh').val() == '' ? '0' : $('#txtValorSelecionadoCh').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                const objeto = {
                    "TIPO": $(this).parent().parent().parent()[0].children[18].textContent,
                    "NUMERO": $(this).parent().parent().parent()[0].children[12].textContent,
                    "CODCLI": $(this).parent().parent().parent()[0].children[11].textContent,
                    "VALOR": parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "SALDO": parseFloat($($($(this).parent().parent().parent())[0].children)[16].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "OBS": '',
                    "VENCTO_CHEQUE": $(this).parent().parent().parent()[0].children[6].textContent,
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent
                };
                cheqList.push(objeto);
                qtdeCheques++
                valorSelecionadoCheques += parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.'));
                $('#txtChequeSelecionadosCh').val(String(qtdeCheques));
                $('#txtValorSelecionadoCh').val(valorSelecionadoCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            } else {
                qtdeCheques = qtdeCheques - 1;
                valorSelecionadoCheques -= parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.'));
                const index = cheqList.findIndex(index => index.TIPO == $(this).parent().parent().parent()[0].children[18].textContent
                    && index.NUMERO == $(this).parent().parent().parent()[0].children[12].textContent
                    && index.CODCLI == $(this).parent().parent().parent()[0].children[11].textContent
                );
                if (index != -1) {
                    cheqList.splice(index, 1);
                };
                $('#txtChequeSelecionadosCh').val(String(qtdeCheques));
                $('#txtValorSelecionadoCh').val(valorSelecionadoCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            }
        });
    };

    function criaFunctionCampoSelReceber() {
        $('.campoSelReceber').unbind('change');
        $('.campoSelReceber').on('change', async function () {
            let qtdeDuplicatas = parseInt($('#txtDupSelecionadaRec').val() == '' ? '0' : $('#txtDupSelecionadaRec').val().replace('.', ''));
            let valorSelecionadoReceber = parseFloat($('#txtValorSelecionadoRec').val() == '' ? '0' : $('#txtValorSelecionadoRec').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                const objeto = {
                    "TIPO": $(this).parent().parent().parent()[0].children[15].textContent,
                    "NUMERO": $(this).parent().parent().parent()[0].children[1].textContent,
                    "CODCLI": $(this).parent().parent().parent()[0].children[2].textContent,
                    "VALOR": parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "SALDO": parseFloat($($($(this).parent().parent().parent())[0].children)[11].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "VALOR_UTILIZADO": 0,
                    "NR_CHEQUE_UTILIZADO": '',
                    "OBS": '',
                    "JUROS": parseFloat($($($(this).parent().parent().parent())[0].children)[9].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent,
                    "VENCTO_CHEQUE": $(this).parent().parent().parent()[0].children[5].textContent,
                    "COM2": parseFloat($(this).parent().parent().parent()[0].children[17].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent
                }
                recList.push(objeto);
                qtdeDuplicatas++
                valorSelecionadoReceber += parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.'));
                $('#txtDupSelecionadaRec').val(String(qtdeDuplicatas.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
                $('#txtValorSelecionadoRec').val(valorSelecionadoReceber.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }))
            } else {
                qtdeDuplicatas = qtdeDuplicatas - 1;
                valorSelecionadoReceber -= parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.'));
                const index = recList.findIndex(index => index.TIPO == $(this).parent().parent().parent()[0].children[15].textContent
                    && index.NUMERO == $(this).parent().parent().parent()[0].children[1].textContent
                    && index.CODCLI == $(this).parent().parent().parent()[0].children[2].textContent);
                if (index != -1) {
                    recList.splice(index, 1);
                };
                $('#txtDupSelecionadaRec').val(String(qtdeDuplicatas.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
                $('#txtValorSelecionadoRec').val(valorSelecionadoReceber.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }))
            }
        });
    };

    function criaPesquisasCheque() {
        $('#txtDtVenctoDeCh').val('1200-01-01');
        $('#txtDtVenctoAteCh').val('2500-12-31');

        $('#btnLimpaEmissorCh').on('click', function () { $('#txtEmissorCh').val('') });
        $('#btnLimpaPedidoCh').on('click', function () { $('#txtPedidoCh').val('') });
        $('#btnLimpaBuscaChequeCmc').on('click', function () { $('#txtBuscaChequeCMC').val('') });

        $('#txtClienteCh').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
        $('#btnClienteCh').pesquisa_serverside(['#txtClienteCh'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
        $('#btnLimpaClienteCh').on('click', function () { $('#txtClienteCh').val('') });

        componenteFiltro('vendedor', true, true, 'RepresentanteCh');
        componenteFiltro('situacao', true, true, 'SituacaoCh');

        $('#txtHistoricoCh').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoCh").pesquisa_serverside(['#txtHistoricoCh'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoCh').on('click', function () { $('#txtHistoricoCh').val('') });

        $('#txtClasseGerCh').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerCh").pesquisa_serverside(['#txtClasseGerCh'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerCh').on('click', function () { $('#txtClasseGerCh').val('') });

        $('#txtHistoricoBaixaCheque').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoBaixaCheque").pesquisa_serverside(['#txtHistoricoBaixaCheque'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoBaixaCheque').on('click', function () { $('#txtHistoricoBaixaCheque').val('') });

        $('#txtClasseGerBaixaCheque').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerBaixaCheque").pesquisa_serverside(['#txtClasseGerBaixaCheque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerBaixaCheque').on('click', function () { $('#txtClasseGerBaixaCheque').val('') });
    };

    function criaPesquisasReceber() {
        $('#txtDtVenctoDeRec').val('1200-01-01');
        $('#txtDtVenctoAteRec').val('2500-12-31');

        $('#txtDtEmissaoDeRec').val('1200-01-01');
        $('#txtDtEmissaoAteRec').val('2500-12-31');

        $('#btnLimpaPedidoRec').on('click', function () { $('#txtPedidoRec').val('') });

        componenteFiltro('duplicata', true, true, 'NumeroRec');
        componenteFiltro('cliente', true, true, 'ClienteRec');
        componenteFiltro('situacao', true, true, 'SituacaoRec');
        componenteFiltro('fatura', true, true, 'FaturaRec');
        componenteFiltro('vendedor', true, true, 'RepresenRec');
        componenteFiltro('classe', true, true, 'ClasseGerRec');
    };

    function criaDataTables() {
        $('#tabelaCheques').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,

            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkChequeReceber${meta.row}" class="campoSelCheque" nome="checkChequeReceber${meta.row}">
                        <label for="checkChequeReceber${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [5, 6],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [7, 9, 16],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
        });

        $('#tabelaReceber').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,

            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkReceber${meta.row}" class="campoSelReceber" nome="checkReceber${meta.row}">
                        <label for="checkReceber${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [4, 5],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [6, 7, 8, 9, 10, 11],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ]
        });

        $('#tabelaBaixasRecCheque').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            order: false,

            "autoWidth": true,
            columnDefs: [
                {
                    targets: [8, 9],
                    visible: false
                }
            ]
        });
    };

    criaPesquisasCheque();
    criaPesquisasReceber();
    criaDataTables();

    async function consultaChequeComReceber() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/encontrocontas/v1/buscachequereceber?';
            const filtros = await retornaFiltrosCheque() + '&' + await retornaFiltrosReceber();
            const response = await requisicao('GET', url, '', filtros, 360000);
            const jsonStr = await response.json();
            let rowsTableCheque = [];
            for (row in jsonStr) {
                let r = [];
                r.push(jsonStr[row].SEL);
                r.push(jsonStr[row].NUMERO_CH);
                r.push(jsonStr[row].BANCO_CH);
                r.push(jsonStr[row].CONTA_CH);
                r.push(jsonStr[row].AGENCIA_CH);
                r.push(jsonStr[row].DT_EMISSAO);
                r.push(jsonStr[row].DT_VENCTO);
                r.push(jsonStr[row].VALOR2);
                r.push(jsonStr[row].EMISSOR_CH);
                r.push(0);
                r.push('');
                r.push(jsonStr[row].CODCLI);
                r.push(jsonStr[row].NUMERO);
                r.push(jsonStr[row].EMP);
                r.push(jsonStr[row].OBS);
                r.push(jsonStr[row].BARRA_CH);
                r.push(jsonStr[row].SALDO);
                r.push('');
                r.push(jsonStr[row].STATUS);
                r.push(jsonStr[row].NOME);
                r.push(jsonStr[row].FANTASIA);
                r.push(jsonStr[row].FATURA);
                rowsTableCheque.push(r);
            };
            $('#tabelaCheques').DataTable().rows.add(rowsTableCheque).draw(false);
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function consultaReceber() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/encontrocontas/v1/buscareceber?';
            const filtros = await retornaFiltrosCheque() + '&' + await retornaFiltrosReceber();
            const response = await requisicao('GET', url, '', filtros, 360000);
            const jsonStr = await response.json();
            let qtdeDupsSelecionadas = 0;
            let valorDupsSelecionadas = 0;
            let rowsTableReceber = [];
            for (row in jsonStr) {
                let r = [];
                if (jsonStr[row].SEL == 'S') {
                    qtdeDupsSelecionadas++
                    valorDupsSelecionadas = valorDupsSelecionadas + parseFloat(jsonStr[row].VALOR2);
                };
                r.push(jsonStr[row].SEL);
                r.push(jsonStr[row].NUMERO);
                r.push(jsonStr[row].CODCLI);
                r.push(jsonStr[row].NOME_CLI);
                r.push(jsonStr[row].DT_EMISSAO);
                r.push(jsonStr[row].DT_VENCTO);
                r.push(jsonStr[row].VALOR2);
                r.push(jsonStr[row].VAL_DEV);
                r.push(jsonStr[row].DESCONTO);
                r.push(jsonStr[row].JUROS);
                r.push(jsonStr[row].VALOR_PAGO);
                r.push(jsonStr[row].SALDO);
                r.push(jsonStr[row].EMP);
                r.push('');
                r.push(jsonStr[row].FATURA);
                r.push(jsonStr[row].STATUS);
                r.push(jsonStr[row].OBS);
                r.push(jsonStr[row].COM2);
                rowsTableReceber.push(r);
            };
            $('#tabelaReceber').DataTable().rows.add(rowsTableReceber).draw(false);
            // $('#txtDupSelecionadaRec').val(parseInt(qtdeDupsSelecionadas).toLocaleString('pt-BR', { maximumFractionDigits: 2 }));
            // $('#txtValorSelecionadoRec').val(parseFloat(valorDupsSelecionadas).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function lancarBaixasReceberCheque() {
        $.LoadingOverlay('show');
        try {
            $('#tabelaBaixasRecCheque').DataTable().clear().draw();
            const totValCheque = parseFloat($('#txtValorSelecionadoCh').val().trim().replace(/\./g, '').replace(',', '.'));
            const totValReceber = parseFloat($('#txtValorSelecionadoRec').val().trim().replace(/\./g, '').replace(',', '.'));
            const totQtdeCheque = $('#txtChequeSelecionadosCh').val();
            const totSaldoReceber = parseFloat((totValCheque - totValReceber) < 0 ? 0 : (totValCheque - totValReceber)).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            $('#txtValorDuplicatasRec').val(parseFloat(totValReceber).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtValorAcumuladoRec').val(parseFloat(totValCheque).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtQtdeChequesRec').val(totQtdeCheque);
            $('#txtSaldoReceberRec').val(totSaldoReceber);
            if ((totValCheque - totValReceber) > 0) {
                await msgAguardaConfirmacao(`Cheque ainda contém ${totSaldoReceber} de saldo!`, async () => { await calculaLancamentoReceber() }, () => { }, false, true, 'Ok');
            } else {
                await calculaLancamentoReceber();
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function calculaLancamentoReceber() {
        $.LoadingOverlay('show');
        $('#tabelaBaixasRecCheque').DataTable().clear().draw(false);
        try {
            let listaNova = [];
            let excesso = 0;

            $.each(cheqList, function (i, cheq) {
                let somaRec = 0;
                let recIndex = 0;
                let podeContinuar = false;

                for (rec in recList) {
                    if (recList[rec].SALDO > 0) {
                        podeContinuar = true;
                        break;
                    }
                };

                if (!podeContinuar) {
                    return;
                };

                cheq.OBS = recList[recIndex].NUMERO;

                listaNova.push(cheq);

                while (somaRec < cheq.SALDO) {
                    if (!recList[recIndex]) {
                        break;
                    };

                    if (excesso > 0) {
                        let rec = {};

                        if (listaNova[listaNova.length - 1].TIPO == 'CHEQ') {
                            rec = $.extend(true, {}, listaNova[listaNova.length - 2]);
                        } else {
                            rec = $.extend(true, {}, listaNova[listaNova.length - 1]);
                        };

                        listaNova.push(rec);

                        if (listaNova[listaNova.length - 1].SALDO > 0) {
                            let recNovo = listaNova[listaNova.length - 1];
                            somaRec += recNovo.SALDO;
                            recNovo.VALOR_UTILIZADO = recNovo.SALDO;
                            recNovo.SALDO = 0;
                            recNovo.OBS = cheq.NUMERO;
                            recList[recIndex].SALDO = 0;
                            recNovo.NR_CHEQUE_UTILIZADO = cheq.NUMERO;
                        };

                        excesso = 0;
                    } else if (recList[recIndex].SALDO > 0) {
                        let rec = $.extend(true, {}, recList[recIndex]);
                        somaRec += rec.SALDO;
                        rec.VALOR_UTILIZADO = rec.SALDO;
                        rec.SALDO = 0;
                        rec.NR_CHEQUE_UTILIZADO = cheq.NUMERO;
                        rec.OBS = cheq.NUMERO;
                        recList[recIndex].SALDO = 0;
                        listaNova.push(rec);
                    };

                    if (somaRec > cheq.SALDO) {
                        excesso = somaRec - cheq.SALDO;
                        listaNova[listaNova.length - 1].SALDO = excesso;
                        recList[recIndex].SALDO = excesso;
                        listaNova[listaNova.length - 1].VALOR_UTILIZADO -= excesso;
                        somaRec -= excesso;
                    };

                    recIndex++;
                };
            });

            for (element in listaNova) {
                const tipo = listaNova[element].TIPO;
                const numero = listaNova[element].NUMERO;
                const codcli = listaNova[element].CODCLI;
                const valor = listaNova[element].TIPO == 'CHEQ' ? listaNova[element].SALDO : listaNova[element].VALOR_UTILIZADO;
                seq++;
                const numeroRec = listaNova[element].TIPO == 'CHEQ' ? listaNova[element].NUMERO : listaNova[element].NR_CHEQUE_UTILIZADO;
                const usouDev = 'N';
                const obs = listaNova[element].OBS;
                const dataVencto = listaNova[element].VENCTO_CHEQUE;
                const emp = listaNova[element].EMPRESA
                $('#tabelaBaixasRecCheque').DataTable().row.add([tipo, numero, codcli, parseFloat(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }), seq, numeroRec, obs, usouDev, dataVencto, emp]).draw(false);
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaDadosEmissao() {
        $.LoadingOverlay('show');
        try {
            const tbChequeP = [];
            let continuaGravaDados;

            if ((!$('#cbBuscaAntecipacao').is(':checked')) && (!$('#cbBuscaDevolucao').is(':checked'))) {
                $('#txtDoctoR').val(await RetornaProximo('DOCTO', 'CONTACOR', 'DOCTO', 6));
            };

            if (!$('#cbBaixarCheques').is(':checked')) {
                continuaGravaDados = await msgAguardaConfirmacao('Flag Baixar Cheques não está marcado. Sistema não irá fazer as baixas dos cheques selecionados. Somente as duplicatas. Continuar mesmo assim?',
                    () => { return true },
                    () => { return false }
                )
            };

            if (!continuaGravaDados) {
                return;
            }

            for (cheque in cheqList) {
                cheq = {
                    "NUMERO": cheqList[cheque].NUMERO,
                    "VALOR": cheqList[cheque].VALOR,
                };
                tbChequeP.push(cheq);
            };

            const tbRecCH = [];

            for (receber in recList) {
                rec = {
                    "NUMERO": recList[receber].NUMERO,
                    "CODCLI": recList[receber].CODCLI,
                    "EMPRESA": recList[receber].EMPRESA,
                    "COM2": recList[receber].COM2,
                    "VALOR": recList[receber].VALOR,
                    "JUROS": recList[receber].JUROS,
                };
                tbRecCH.push(rec);
            }

            const tbLancar = [];
            const tableLancar = $('#tabelaBaixasRecCheque').DataTable().data().toArray();

            for (lanc in tableLancar) {
                titulo = {
                    "TIPO": tableLancar[lanc][0],
                    "NUMERO": tableLancar[lanc][1],
                    "CODCLI": tableLancar[lanc][2],
                    "VALOR": parseFloat(tableLancar[lanc][3].trim().replace(/\./g, '').replace(',', '.')),
                    "SEQ": tableLancar[lanc][4],
                    "NUM_REC": tableLancar[lanc][5],
                    "OBS": tableLancar[lanc][6],
                    "USOU_DEV": tableLancar[lanc][7],
                    "LANCAMENTO": '',
                    "VENCTO_CHEQUE": tableLancar[lanc][8] + ' 00:00:00.000',
                    "EMPRESA": tableLancar[lanc][9],
                    "COM": 'N'
                };
                tbLancar.push(titulo);
            };

            const url = '/sisplan/encontrocontas/v1/gravadados?';
            const params = await retornaFiltrosModal();
            const response = await requisicao('POST', url, params, `JSON_TBLANCAR=${encodeURIComponent(JSON.stringify(tbLancar))}&JSON_TBRECCH=${encodeURIComponent(JSON.stringify(tbRecCH))}&JSON_TBCHEQUEP=${encodeURIComponent(JSON.stringify(tbChequeP))}`, 3200000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            };

            await criaMensagemSucesso(await response.text(), () => { window.location.reload() })

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaFiltrosCheque() {
        const dtVenctoDe = $('#txtDtVenctoDeCh').val();
        const dtVenctoAte = $('#txtDtVenctoAteCh').val();
        const emissor = pegaChave('#txtEmissorCh');
        const pedido = $('#txtPedidoCh').val();
        const cliente = pegaChave('#txtClienteCh');
        const represen = await formataListas($('#txtRepresentanteCh').val().toString());
        const historico = pegaChave('#txtHistoricoCh');
        const situacao = await formataListas($('#txtSituacaoCh').val().toString());
        const classeGer = pegaChave('#txtClasseGerCh');
        const buscaCheque = $('#txtBuscaChequeCMC').val();

        return `DT_VENCTO_DE_CH=${dtVenctoDe}` +
            `&DT_VENCTO_ATE_CH=${dtVenctoAte}` +
            `&EMISSOR_CH=${emissor}` +
            `&PEDIDO_CH=${pedido}` +
            `&CLIENTE_CH=${cliente}` +
            `&REPRESEN_CH=${represen}` +
            `&HISTORICO_CH=${historico}` +
            `&SITUACAO_CH=${situacao}` +
            `&CLASSEGER_CH=${classeGer}` +
            `&BUSCACHEQUE_CH=${buscaCheque}`;
    };

    async function retornaFiltrosReceber() {
        const dtVenctoDe = $('#txtDtVenctoDeRec').val();
        const dtVenctoAte = $('#txtDtVenctoAteRec').val();
        const dtEmissaoDe = $('#txtDtEmissaoDeRec').val();
        const dtEmissaoAte = $('#txtDtEmissaoAteRec').val();
        const numero = await formataListas($('#txtNumeroRec').val().toString());
        const cliente = await formataListas($('#txtClienteRec').val().toString());
        const pedido = $('#txtPedidoRec').val();
        const fatura = await formataListas($('#txtFaturaRec').val().toString());
        const situacao = await formataListas($('#txtSituacaoRec').val().toString());
        const representante = await formataListas($('#txtRepresenRec').val().toString());
        const classeGer = await formataListas($('#txtClasseGerRec').val().toString());
        const buscaAntecipacao = $('#cbBuscaAntecipacao').is(':checked');
        const buscaDevolucao = $('#cbBuscaDevolucao').is(':checked');
        const buscaChequeDev = $('#cbBuscaChequeDev').is(':checked');
        const baixarCheques = $('#cbBaixarCheques').is(':checked');
        const naoLancaValorContaCor = $('#cbNaoLancaContaCor').is(':checked');
        const buscaAntecipacaoGridInferior = $('#cbBuscaAntecipacaoGridInferior').is(':checked');

        return `DT_VENCTO_DE_RECEBER=${dtVenctoDe}` +
            `&DT_VENCTO_ATE_RECEBER=${dtVenctoAte}` +
            `&DT_EMISSAO_DE_RECEBER=${dtEmissaoDe}` +
            `&DT_EMISSAO_ATE_RECEBER=${dtEmissaoAte}` +
            `&NUMERO_RECEBER=${numero}` +
            `&CLIENTE_RECEBER=${cliente}` +
            `&PEDIDO_RECEBER=${pedido}` +
            `&FATURA_RECEBER=${fatura}` +
            `&SITUACAO_RECEBER=${situacao}` +
            `&REPRESENTANTE_RECEBER=${representante}` +
            `&CLASSEGER_RECEBER=${classeGer}` +
            `&BUSCA_ANTECIPACAO_RECEBER=${buscaAntecipacao}` +
            `&BUSCA_DEVOLUCAO_RECEBER=${buscaDevolucao}` +
            `&BUSCA_CHEQUE_DEVOLUCAO_RECEBER=${buscaChequeDev}` +
            `&BAIXA_CHEQUES_RECEBER=${baixarCheques}` +
            `&NAO_LANCA_VALOR_CONTA_CC=${naoLancaValorContaCor}` +
            `&BUSCA_ATENCIPACAO_GRID_INFERIOR_RECEBER=${buscaAntecipacaoGridInferior}`
    };

    async function retornaFiltrosModal() {
        const dtPagto = formataDataBonita($('#txtDtPagto').val()) + ' 00:00:00.000'
        const dtCont = formataDataBonita($('#txtDtContabilizacao').val()) + ' 00:00:00.000'
        const contaR = pegaChave('#txtContaR');
        const moedaR = pegaChave('#txtMoedaR');
        const bancoR = pegaChave('#txtBancoR');
        const doctoR = $('#txtDoctoR').val();
        const obsR = $('#txtObsR').val();
        const classeGerRecBCH = pegaChave('#txtClasseGerRecBCH');
        const historicoRBCH = pegaChave('#txtHistoricoRBCH');
        const classeGerBCHRec = pegaChave('#txtClasseGerBCHRec');
        const historicoBCHRec = pegaChave('#txtHistoricoBCHRec');
        const buscaAntecipacao = $('#cbBuscaAntecipacao').is(':checked') ? 'S' : 'N';
        const buscaDev = $('#cbBuscaDevolucao').is(':checked') ? 'S' : 'N';
        const baixaChequeRec = $('#cbBaixarCheques').is(':checked') ? 'S' : 'N';
        const naoLancaCC = $('#cbNaoLancaContaCor').is(':checked') ? 'S' : 'N';

        return `CONTA=${contaR}` +
            `&DT_CONT=${dtCont}` +
            `&CLASSE_GER_BCH_REC=${classeGerBCHRec}` +
            `&CLASSE_GER_REC_BCH=${classeGerRecBCH}` +
            `&HISTORICO_R_BCH=${historicoRBCH}` +
            `&HISTORICO_BCH_REC=${historicoBCHRec}` +
            `&CB_BUSCA_ANTECIPACAO=${buscaAntecipacao}` +
            `&CB_BUSCA_DEV=${buscaDev}` +
            `&MOEDA=${moedaR}` +
            `&DOCTO_R=${doctoR}` +
            `&OBS=${obsR}` +
            `&CB_BAIXAR_CHEQUE_REC=${baixaChequeRec}` +
            `&DT_PAGTO=${dtPagto}` +
            `&BANCO=${bancoR}` +
            `&CB_NAO_LANCA_CONTA_CORRENTE=${naoLancaCC}`;
    };

});