$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostudo",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#tutorialCodigo",
        popover: {
          title: "Código",
          description:
            "Aqui adicionamos o código para o CST IPI.",
          position: "top",
        },
      },
      {
        element: "#produtotuto",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para o CST IPI.",
          position: "top",
        },
      },
      {
        element: "#tutorialTipo",
        popover: {
          title: "Entrada ou Saida",
          description:
            "Aqui escolhemos se o CST IPI será de entrada ou saída.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o CST IPI.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cstipi = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CSTIPI", getCookie("usuario"), cstipi);
    window.location.href = `${BASE_URI}/cstipi`;
  });

  $(document).ready(async function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    if (cstipi != "" && cstipi != "create") {
      if ((await liberarRegistro("CSTIPI", cstipi)) == false) {
        window.location.href = "../cstipi";
      } else {
        carregaDados(cstipi);
      }
    }

    async function carregaDados(cstipiBusca) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                            "tabela":"tabipi", 
                            "camposSelect":["codigo", "descricao", "tipo"], 
                            "where": ["codigo = '${cstipiBusca}'"]}`,
            null
          );
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);

          if (jsonStr.RESULT[0][0].TIPO == "E") {
            $("#radioEntrada").prop("checked", true);
          }
          if (jsonStr.RESULT[0][0].TIPO == "S") {
            $("#radioSaida").prop("checked", true);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do preço: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#txtCodigo").change(async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"tabipi", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$("#txtCodigo").val()}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("CST IPI já cadastrado.");
          $("#txtCodigo").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnGravar").click(async function () {
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        $.LoadingOverlay("show");

        let cstipiClasse = {};

        cstipiClasse.CODIGO = $("#txtCodigo").val();
        cstipiClasse.DESCRICAO = $("#txtDescricao").val();

        if ($("#radioEntrada").prop("checked")) {
          cstipiClasse.TIPO = "E";
        } else {
          cstipiClasse.TIPO = "S";
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/cstipi?",
          `JSON=${encodeURIComponent(JSON.stringify(cstipiClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/cstipi`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados da situação: ${error}`);
    }
  });
});
