$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([{
      element: '#dataInvIni',
      popover: {
        title: 'Campo Período inventário início',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#dataInvFim',
      popover: {
        title: 'Campo Período inventário fim',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtQualidade',
      popover: {
        title: 'Campo Qualidade',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDepositoUsuario',
      popover: {
        title: 'Campo Depósito',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnConsultar',
      popover: {
        title: 'Botão Cosultar',
        description: 'Clique aqui para consultar os dados informados.',
        position: 'left'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir os dados.',
        position: 'left'
      }
    },
    {
      element: '#tabelaInventario_wrapper',
      popover: {
        title: 'Itens',
        description: `Aqui estão os itens da consulta. Obs:               
                          QTDE_MOV = quantidade da PA_MOV;         
                          QTDE_EST = quantidade da PA_ITEN;          
                          DIFERENCA = diferença entre os campos QTDE_INV e QTDE_EST.`,
        position: 'top'
      }
    },
    {
      element: '#txtTpBaixa',
      popover: {
        title: 'Campo Tipo de baixa',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnAcertarEstoque',
      popover: {
        title: 'Botão Acertar Estoque',
        description: 'Clique aqui para acertar o estoque.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CONFERENCIAINV");

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtTipoEntrada: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtDepositoUsuario: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtTipoEntrada: {
        required: "Informe um tipo de entrada."
      },
      txtQualidade: {
        required: "Informe uma qualidade."
      },
      txtDepositoUsuario: {
        required: "Informe um depósito."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    },
    async submitHandler(form, event) {
      event.preventDefault();
    }
  });

  let codigosEntradaSaidaManual = '';
  await carregaValoresPadroes();

  async function carregaTipoEntrada() {
    const pesquisaParam = {
      tabela: 'TABBAI',
      camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
      where: [`ATIVO = 'S'`],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    let codigos = '';

    jsonStr.forEach(tipoBaixa => {
      if (tipoBaixa.TIPO && (tipoBaixa.TIPO.charAt(0) === 'S' || tipoBaixa.TIPO.charAt(9) === 'S')) {
        codigos += codigos ? `,'${tipoBaixa.CODIGO}'` : `'${tipoBaixa.CODIGO}'`;
      }
    });

    codigosEntradaSaidaManual = codigos;
  }

  await carregaTipoEntrada();

  await setarDataAtual('dataInvIni');
  await setarDataAtual('dataInvFim');

  let filtroSetor;
  filtroSetor = await buscaSetorUsuario();
  filtroSetor = filtroSetor == '' ? null : `"CODIGO IN (${filtroSetor})"`;

  const usaProdMaterial = await CopiaParametro("VENDA", 17);
  $('#radioProduto').prop('checked', usaProdMaterial == '0');
  $('#radioMaterial').prop('checked', usaProdMaterial == '1');

  $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [${filtroSetor}]}`, [], [], []);
  $('#btnSetor').pesquisa_array(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "codigo", "descricao" ], "where": [${filtroSetor}]}`, 'Pesquisa Setor', 'CADFLUXO');
  $('#btnASetor').on('click', function () { $('#txtSetor').val(''); });

  $('#txtProduto').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
  $('#btnAProduto').on('click', function () { $('#txtProduto').val(''); });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', 'Pesquisa Cor', 'CADCOR');
  $('#btnACor').on('click', function () { $('#txtCor').val(''); });

  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, TAM DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnTamanho').pesquisa_array(['#txtTamanho'], ['TAM'], ['TAM'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM" ], "where": null}', 'Pesquisa Tamanho', 'TABTAM');
  $('#btnATamanho').on('click', function () { $('#txtTamanho').val(''); });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btnAQualidade').on('click', function () { $('#txtQualidade').val(''); });

  $('#txtTpBaixa').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${codigosEntradaSaidaManual})"] }`, [], [], []);

  $('#btnTpBaixa').on('click', function () {
    if (!codigosEntradaSaidaManual) {
      msgErro('Não existe Tipo de Baixa cadastrada como Entrada Manual ou Saída Manual na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTpBaixa').pesquisa_array(['#txtTpBaixa'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigosEntradaSaidaManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });

  $('#btnATpBaixa').on('click', function () { $('#txtTpBaixa').val(''); });

  componenteFiltro('depositoUsuario', false, false);
  componenteFiltro('grupoMA', false, false);
  componenteFiltro('subGrupo', false, false);
  componenteFiltro('linha', false, false);
  componenteFiltro('status', false, false);
  componenteFiltro('modelo', false, false);
  componenteFiltro('colecao', false, false);
  componenteFiltro('marca', false, false);
  componenteFiltro('etiqueta', false, false);
  componenteFiltro('cliente', false, false);
  componenteFiltro('fornecedor', false, false);
  componenteFiltro('categoria', false, false);
  componenteFiltro('tipoProduto', false, false);

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const url = `/sisplan/impressao/v1/relconferenciainv?`;
      const dtIni = $('#dataInvIni').val();
      const dtFim = $('#dataInvFim').val();
      const setor = pegaChave('#txtSetor');
      const cor = pegaChave('#txtCor');
      const tam = pegaChave('#txtTamanho');
      const qualidade = pegaChave('#txtQualidade');
      const deposito = pegaChave('#txtDepositoUsuario');
      const tpInv = $('#radioMaterial').is(':checked') ? 'M' : 'P';
      let codigo = '';
      if (tpInv === 'P') {
        codigo = pegaChave('#txtProduto');
      } else {
        codigo = pegaChave('#txtMaterial');
      }

      if (dtIni, dtFim, qualidade, deposito == '') {
        msgAlerta('Favor preencher os campos de período, qualidade e depósito.');
        return;
      }
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelConferenciaInv');
      const arquivo = await GeraRelatorio(`${url}DTINI=${dtIni}&DTFIM=${dtFim}&SETOR=${setor}&CODIGO=${codigo}&COR=${cor}&TAM=${tam}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&ENVIO=${0}&TP_INV=${tpInv}`, 'GET', 100000, false, 'RelConferenciaInv');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#radioProduto, #radioMaterial').on('change', function () {
    adicionaPesquisaCampos()
  })

  function adicionaPesquisaProduto() {
    $('#txtProduto').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
    $('#btnAProduto').on('click', function () { $('#txtProduto').val(''); });

    componenteFiltro('grupo', false, false)
  }

  function adicionaPesquisaMaterial() {
    $('#txtMaterial').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnMaterial').pesquisa_serverside(['#txtMaterial'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Material');
    $('#btnAMaterial').on('click', function () { $('#txtMaterial').val(''); });

    componenteFiltro('grupoMA', false, false)
  }

  function mostraCamposMaterial() {
    $('#txtQualidade').attr('required', false)
    $('label[for="txtQualidade"]').text('Qualidade:');
    $('#divTamanho').addClass('d-none')
    $('#divProduto').addClass('d-none')

    $('#divStatus').addClass('d-none')
    $('#divModelo').addClass('d-none')
    $('#divColecao').addClass('d-none')
    $('#divMarca').addClass('d-none')
    $('#divGrupo').addClass('d-none')
    $('#divLinha').addClass('d-none')
    $('#divEtiqueta').addClass('d-none')
    $('#divCliente').addClass('d-none')
    $('#divFornecedor').addClass('d-none')
    $('#divCategoria').addClass('d-none')
    $('#divTipoProduto').addClass('d-none')

    $('#divMaterial').removeClass('d-none')
    $('#divGrupoMA').removeClass('d-none')
    $('#divSubGrupo').removeClass('d-none')
    $('#divLinha').removeClass('d-none')
  }

  function mostraCamposProduto() {
    $('label[for="txtQualidade"]').text('Qualidade: *');
    $('#divTamanho').removeClass('d-none')
    $('#divProduto').removeClass('d-none')

    $('#divStatus').removeClass('d-none')
    $('#divModelo').removeClass('d-none')
    $('#divColecao').removeClass('d-none')
    $('#divMarca').removeClass('d-none')
    $('#divGrupo').removeClass('d-none')
    $('#divLinha').removeClass('d-none')
    $('#divEtiqueta').removeClass('d-none')
    $('#divCliente').removeClass('d-none')
    $('#divFornecedor').removeClass('d-none')
    $('#divCategoria').removeClass('d-none')
    $('#divTipoProduto').removeClass('d-none')

    $('#divMaterial').addClass('d-none')
    $('#divGrupoMA').addClass('d-none')
    $('#divSubGrupo').addClass('d-none')
    $('#divLinha').addClass('d-none')
  }

  function adicionaPesquisaCampos() {
    if ($('#radioMaterial').is(':checked')) {
      mostraCamposMaterial()
      adicionaPesquisaMaterial()
    } else {
      mostraCamposProduto()
      adicionaPesquisaProduto()
    }
  }

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await buscaInventario();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaInventario() {
    if ($.fn.DataTable.isDataTable('#tabelaInventario')) {
      $('#tabelaInventario').DataTable().destroy();
      $('#tabelaInventario').empty();
    };

    try {
      let jsonFinal = [];
      const params = retornaFiltros();

      for (let i = 0; i >= 0; i++) {

        const response = await requisicao('GET', '/sisplan/conferenciainv/v1/consultadiferenca?', params + `&ENVIO=${i}`, null);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        jsonFinal = [...jsonFinal, ...jsonStr];

        if (jsonStr.length < 50000) {
          break;
        }
      }

      if (jsonFinal.length == 0) {
        return
      }

      jsonFinal = jsonFinal.filter(
        item => (item.QTDEATU != item.QTDEINV) ||
          (item.QTDEEST != item.QTDEINV));

      let dataSetCols = [];
      const keys = Object.keys(jsonFinal[0]);

      for (const k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      $('#tabelaInventario').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '300px',
        data: jsonFinal,
        columns: dataSetCols,
        "columnDefs": [
          {
            "targets": [0, 1, 2, 3],
            "className": 'pr-4 text-right'
          }
        ]
      });


    } catch (error) {
      console.error(error);
    }
  };

  $('#btnAcertarEstoque').on('click', async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const tpBaixa = pegaChave('#txtTpBaixa');

      if (tpBaixa == '') {
        msgAlerta('Necessário informar o tipo de baixa.');
        return;
      }
      if ($('#tabelaInventario').DataTable().rows().count() == 0) {
        msgAlerta('Nenhum produto filtrado, favor verificar.');
        return;
      }
      $('#btnAcertarEstoque').prop('disabled', true)
      msgAlerta(
        'Este processo irá ajustar as movimentações com o estoque e posteriormente alinhar o estoque com o inventário, deseja continuar?',
        () => corrigeEstoque().then(() => $('#btnAcertarEstoque').prop('disabled', true)),
        () => $('#btnAcertarEstoque').prop('disabled', false),
        () => $('#btnAcertarEstoque').prop('disabled', false),
        () => $('#btnAcertarEstoque').prop('disabled', false),
        true,
        false,
        true,
      );
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  async function corrigeEstoque() {
    $.LoadingOverlay('show');
    try {
      let arrItens = [];
      let conferencia = {};
      const params = retornaFiltros();
      if ($('#radioMaterial').is(':checked')) {
        $('#tabelaInventario').DataTable().rows().data().map((item) => {
          const diferencaest = parseFloat(item.QTDEATU) - parseFloat(item.QTDEEST);
          const material = {
            CODIGO: item.CODIGO,
            COR: item.COR,
            LOTE: item.LOTE,
            DEPOSITO: item.DEPOSITO,
            QUALIDADE: item.QUALIDADE,
            CODBAIXA: pegaChave('#txtTpBaixa'),
            OPERACAO: diferencaest > 0 ? 'S' : 'E',
            QTDE: diferencaest > 0 ? diferencaest : (diferencaest * -1),
            DESCRICAO: item.DESCRICAO,
            PRECO: item.CUSTO,
            CUSTO: item.CUSTO,
            QTDEMATMOV: item.QTDEATU,
            QTDEMATITEN: item.QTDEEST,
            QTDEINV: item.QTDEINV,
            UNIDADE: item.UNIDADE,
            ID_MAT_ITEN: item.ID_MAT_ITEN,
            LOTEINTERNO: item.LOTE_INTERNO,
            TONALIDADE: item.TONALIDADE,
            BARRA: item.BARRA,
            LOCAL: item.LOCAL,
            DT_FAB: item.DT_FAB,
            INV_DE: $('#dataInvIni').val(),
            INV_ATE: $('#dataInvFim').val(),
            SETOR: item.CODSETOR
          };
          arrItens.push(material);
        });

        conferencia = {
          MATERIAIS: arrItens
        };
      } else {
        $('#tabelaInventario').DataTable().rows().data().map((item) => {
          const diferencaest = parseFloat(item.QTDEATU) - parseFloat(item.QTDEEST);
          const produto = {
            CODIGO: item.CODIGO,
            COR: item.COR,
            TAMANHO: item.TAM,
            LOTE: item.LOTE,
            DEPOSITO: item.DEPOSITO,
            TIPO: pegaChave('#txtQualidade'),
            TIP_BAI: pegaChave('#txtTpBaixa'),
            OPERACAO: diferencaest > 0 ? 'S' : 'E',
            QTDE: diferencaest > 0 ? diferencaest : (diferencaest * -1),
            DESCRICAO: item.DESCRICAO,
            PRECO: item.CUSTO,
            CUSTO: item.CUSTO,
            QTDEPAMOV: item.QTDEATU,
            QTDEPAITEN: item.QTDEEST,
            QTDEINV: item.QTDEINV,
            UNIDADE: item.UNIDADE,
            ID: item.ID
          };
          arrItens.push(produto);
        });
        conferencia = {
          PRODUTOS: arrItens
        };
      }


      const response = await requisicao('POST', '/sisplan/conferenciainv/v1/corrigeestoque?', params, `JSON=${JSON.stringify(conferencia)}`, 30000000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');
      toastr
        .success('Correção efetuada com sucesso!', 'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.reload();
          },
        })
        .css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
    } catch (error) {
      $.LoadingOverlay('hide');
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function retornaFiltros() {
    let codigo = '';
    let grupo = ''
    const dtIni = $('#dataInvIni').val();
    const dtFim = $('#dataInvFim').val();
    const setor = pegaChave('#txtSetor');
    const cor = pegaChave('#txtCor');
    const tam = pegaChave('#txtTamanho');
    const qualidade = pegaChave('#txtQualidade');
    const deposito = pegaChave('#txtDepositoUsuario');
    const tpInv = $('#radioMaterial').is(':checked') ? 'M' : 'P'
    const subGrupo = pegaChave('#txtSubGrupo');

    const linha = pegaChave('#txtLinha');
    const status = pegaChave('#txtStatus');
    const modelo = pegaChave('#txtModelo');
    const colecao = pegaChave('#txtColecao');
    const marca = pegaChave('#txtMarca');
    const etiqueta = pegaChave('#txtEtiqueta');
    const cliente = pegaChave('#txtCliente');
    const fornecedor = pegaChave('#txtFornecedor');
    const categoria = pegaChave('#txtCategoria');
    const tipoProduto = pegaChave('#txtTipoProduto');

    if (tpInv === 'P') {
      codigo = pegaChave('#txtProduto');
      grupo = pegaChave('#txtGrupo');
    } else {
      codigo = pegaChave('#txtMaterial');
      grupo = pegaChave('#txtGrupoMA');
    }
    if (dtIni == '') {
      throw msgAlerta('Favor preencher o campo de período inicial.');
    }
    if (dtFim == '') {
      throw msgAlerta('Favor preencher o campo de período final.');
    }
    if (qualidade == '' && $('#radioProduto').is('checked')) {
      throw msgAlerta('Favor preencher o campo de qualidade.');
    }
    if (deposito == '') {
      throw msgAlerta('Favor preencher o campo de depósito.');
    }

    const params = `DTINIINV=${dtIni}` +
      `&DTFIMINV=${dtFim}` +
      `&SETOR=${setor}` +
      `&CODIGO=${codigo}` +
      `&COR=${cor}` +
      `&TAM=${tam}` +
      `&QUALIDADE=${qualidade}` +
      `&DEPOSITO=${deposito}` +
      `&TP_INV=${tpInv}` +
      `&GRUPO=${grupo}` +
      `&SUB_GRUPO=${subGrupo}` +
      `&LINHA=${linha}` +
      `&STATUS=${status}` +
      `&MODELO=${modelo}` +
      `&COLECAO=${colecao}` +
      `&MARCA=${marca}` +
      `&ETIQUETA=${etiqueta}` +
      `&CLIENTE=${cliente}` +
      `&FORNECEDOR=${fornecedor}` +
      `&CATEGORIA=${categoria}` +
      `&TIPO_PRODUTO=${tipoProduto}`;
    return params;
  }

  adicionaPesquisaCampos()

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('ESTOQUE')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'CONF_TIPO_BAIXA': {
          if (item.VALOR != '') {
            insereValor('#txtTpBaixa', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
      }
    });
  };
});
