$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaOrdemProducao",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova ordem de produção.",
          position: "right",
        },
      },
      {
        element: "#tabelaOs",
        popover: {
          title: "Tabela Ordem de Produção Simples",
          description: "Aqui estão os dados das ordens de produção cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CADCOMISSAO");
  const tipoCodigo = 'P';

  $('#btnLimparFiltros').on('click', function () {
    $('#btn-limpa-Produto').trigger('click');
    $('#btn-limpa-Material').trigger('click');
    $('#btn-limpa-Representante').trigger('click');
    $('#txtComissaoDe').val('0');
    $('#txtComissaoAte').val('0');
    $('#txtValorDe').val('0');
    $('#txtValorAte').val('0');
    $('#btn-limpa-TabPreco').trigger('click');
    $('#rdProduto').prop('checked', true);
    if (('#rdMaterial').is(':checked')) {
      $('#rdMaterial').prop('checked', false);
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovaOrdemProducao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "comissao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  componenteFiltro('produto', true);
  componenteFiltro('material', true);
  componenteFiltro('representante', true);
  componenteFiltro('tabPreco', true);

  await consultaComissoes();

  async function retornaFiltros() {
    const codigo = tipoCodigo == 'M' ? (await formataListas($('#txtMaterial').val().toString())) : (await formataListas($('#txtProduto').val().toString()));
    const representante = await formataListas($('#txtRepresentante').val().toString());
    const tabelaPreco = await formataListas($('#txtTabPreco').val().toString());
    const tipo = tipoCodigo;
    const comissaoDe = $('#txtComissaoDe').val();
    const comissaoAte = $('#txtComissaoAte').val();
    const valorDe = $('#txtValorDe').val();
    const valorAte = $('#txtValorAte').val();

    return `CODIGO=${codigo}` +
      `&REPRESENTANTE=${representante}` +
      `&TAB_PRECO=${tabelaPreco}` +
      `&TIPO=${tipo}` +
      `&COMISSAO_DE=${comissaoDe}` +
      `&COMISSAO_ATE=${comissaoAte}` +
      `&VALOR_DE=${valorDe}` +
      `&VALOR_ATE=${valorAte}`
  }

  async function consultaComissoes() {
    try {
      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();

      const url = `/sisplan/cadcomissao/v1/consultacomissoes?`;

      const response = await requisicao("GET", url, filtros, '', 90000);

      const json = await response.json();

      if (json.length == 0) {
        msgAlerta('Nenhum registro encontrado!');

        $('#tabelaComissoes').DataTable({
          destroy: true,
          ordering: true,
          lengthChange: false,
          serverside: true,
          "autoWidth": true,
        });

        return;
      }

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      $('#tabelaComissoes').DataTable({
        destroy: true,
        ordering: true,
        lengthChange: false,
        serverside: true,
        "autoWidth": true,
        "data": json,
        "columns": [
          {
            "data": "ID"
          },
          {
            "data": "SEQ"
          },
          {
            "data": "CODIGO"
          },
          {
            "data": "DESC_ITEN"
          },
          {
            "data": "DESC_DE"
          },
          {
            "data": "DESC_ATE"
          },
          {
            "data": "COMISSAO"
          },
          {
            "data": "TIPO"
          },
          {
            "data": "REPRESENTANTE"
          },
          {
            "data": "NOME_REP"
          },
          {
            "data": "TAB_PRE"
          },
          {
            "data": "DESC_TABPRECO"
          },
          {
            "data": "DESCONTO"
          }
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          },
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          targets: [4, 5],
          "className": 'pr-4 text-right'
        }
        ]
      }
      );
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    } finally {
      $.LoadingOverlay("hide");
    }

  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir a O.S." id="btn-Excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $('#tabelaComissoes').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaComissoes').DataTable().row($(this).parents('tr')).data();
      window.location.href = `comissao/${data.SEQ}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaComissoes').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaComissoes').DataTable().row($(this)).data();
      window.location.href = `comissao/${data.SEQ}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#btnIncluir').on('click', async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = 'comissao/create'
    } else {
      msgAlertaSemConfirmacao('Sem permissão pra incluir!');
      return;
    }
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaComissoes();
  });

  $('#rdProduto').on('click', function () {
    $('#ProdutoInfoTour').removeClass('d-none');
    $('#MaterialInfoTour').addClass('d-none');
  });

  $('#rdMaterial').on('click', function () {
    $('#ProdutoInfoTour').addClass('d-none');
    $('#MaterialInfoTour').removeClass('d-none');
  });

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();

      const url = `/sisplan/impressao/v1/imprimiracessocadcomissao?`;

      if ($('#tabelaComissoes').DataTable().data().toArray().length <= 0) {
        msgAlerta('Nenhum registro para ser impresso, por favor verifique! Tente novamente');
        return
      }

      const ordem = `&TELA_ORDENACAO=AcessoCadComissao&`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoCadComissao');
      const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, "GET", 15000, false, 'AcessoCadComissao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function deletaSequenciaComissoes(seq) {
    try {
      const url = `/sisplan/cadcomissao/v1/excluisequencia?`;

      const filtros = `SEQUENCIA=${seq}`
      const response = await requisicao("DELETE", url, filtros, '', 90000);

      if (response.status != 200) {
        msgAlerta(json.mensagem);
        return;
      }

      await criaMensagemSucesso('Sequência de comissões excluída com sucesso!', () => {
        $('#btnConsultar').trigger('click');
      });
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível excluir essa sequência de comissões! Por favor, verifique.');
      return;
    }
  }

  $('#tabelaComissoes').on('click', '#btn-Excluir', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaComissoes').DataTable().row($(this).parents('tr')).data();

      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        msgAguardaConfirmacao(`Todos os registros de comissões com a sequência ${data.SEQ} serão deletados! Você tem certeza que quer excluir esses registros?`, async () => {
          await deletaSequenciaComissoes(data.SEQ);
        }, () => { })
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível excluir essa sequência de comissões! Por favor, verifique.');
      return;
    } finally {
      $.LoadingOverlay('hide');
    }
  });

});