$("#tutorial").on("click", function () {
  $(document).ready(async function () {  
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoBanco",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um banco.",
          position: "right",
        },
      },
      {
        element: "#tabelaAcessoBanco",
        popover: {
          title: "Tabela CadBanco",
          description: "Aqui estão os dados dos bancos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("CADBANCO");

  $("#txtBancoConsulta").autocompleta(
    1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`
  )

  $("#btn-Banco").pesquisa(
    "#txtBancoConsulta",
    "BANCO",
    "NOME_BANCO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`,
    "Pesquisa Banco",
    "cadban"
  );

  $("#btn-limpa-Banco").on("click", function () {
    $("#txtBancoConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovoBanco").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cadbanco/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaBancos(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtBancoConsulta").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  ConsultaBancos();

  async function ConsultaBancos(bBotao = false) {
    try {
      let response;
      $.LoadingOverlay("show");
      let banco =
        pegaChave("#txtBancoConsulta") != ""
          ? ` AND BANCO = '${pegaChave("#txtBancoConsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where":  ["1=1 ${banco}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaAcessoBanco").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "BANCO",
          },
          {
            data: "NOME_BANCO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaAcessoBanco").on("click", "#btn-editar", async function () {

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAcessoBanco").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("CADBANCO", data.BANCO);
      if (registroLiberado) {
        window.location.href = `cadbanco/${data.BANCO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $("#tabelaAcessoBanco").on("dblclick", "tr", async function () {

    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaAcessoBanco").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("CADBANCO", data.BANCO);
      if (registroLiberado) {
        window.location.href = `cadbanco/${data.BANCO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }

  });

  $('#tabelaAcessoBanco').on('click', '#btn-excluir', async function () {

    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaAcessoBanco").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadbanco?", `BANCO=${encodeURIComponent(valorLinha.BANCO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});