$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description: "Código deste cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description: "Adicionamos aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtOcorrencia",
        popover: {
          title: "Ocorrência",
          description: "Este campo é habilitado quando preenchemos o campo de banco. Nele, são carregados os cadastros de ocorrências vinculadas ao banco selecionado.",
          position: "top",
        },
      },
      {
        element: "#txtBanco",
        popover: {
          title: "Banco",
          description: "Adicionamos aqui, um banco para este cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtCarteira",
        popover: {
          title: "Carteira",
          description: "Aqui, adicionamos a carteira deste cadastro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o cadastro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#txtBanco").autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
  $("#btnBanco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, "Pesquisa Conta", "CADBAN");
  $("#btnLimpaBanco").on("click", function () {
    $("#txtBanco").val("");
    $("#txtBanco").focus();
  });

  $("#txtCarteira").autocompleta(1, `JSON={ "tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#btnCarteira").pesquisa("#txtCarteira", "CARTEIRA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CARTEIRA", "camposSelect":[ "CARTEIRA", "DESCRICAO"]}`, "Pesquisa Carteira", "CARTEIRA");
  $("#btnLimpaCarteira").on("click", function () {
    $("#txtCarteira").val("");
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
      txtBanco: {
        required: true,
      }
    },

    messages: {
      txtCodigo: {
        required: "Insira um código.",
      },
      txtDescricao: {
        required: "Insira uma descrição.",
      },
      txtBanco: {
        required: "Informe um banco.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/cadastro_rejeicoes`;
  });




  $("#txtBanco").on("change focus", function () {
    if ($(this).val() != '') {
      $("#txtOcorrencia, #btnOcorrencia, #btnLimpaOcorrencia").prop("disabled", false);
    } else {
      $("#txtOcorrencia, #btnOcorrencia, #btnLimpaOcorrencia").prop("disabled", true);
    }
    const codBanco = pegaChave($("#txtBanco"));
    carregaOcorrencias(codBanco);
  });


  function carregaOcorrencias(codBanco) {
    $("#txtOcorrencia").autocompleta(1, `JSON={ "tabela":"OCORRENCIA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["BANCO = '${codBanco}'"]}`);
    $("#btnOcorrencia").pesquisa("#txtOcorrencia", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OCORRENCIA", "camposSelect":[ "CODIGO", "DESCRICAO", "BANCO"],  "where": ["BANCO = '${codBanco}'"]}`, "Pesquisa Ocorrência", "OCORRENCIA");
    $("#btnLimpaOcorrencia").on("click", function () {
      $("#txtOcorrencia").val("");
    });
  }

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let page = parametros[parametros.length - 1];


  if (page != "" && page != "create") {
    const resultadopage = page.split('&');
    await carregaDados(resultadopage[0], resultadopage[1]);
    $("#txtCodigo, #txtBanco, #btnBanco, #btnLimpaBanco").prop("disabled", true);
  }

  async function carregaDados(codigo, banco) {
    try {
      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"RECUSAS", "camposSelect":["BANCO", "CODIGO", "DESCRICAO", "OCORRENCIA", "CARTEIRA"],
        "where": ["CODIGO = '${codigo}' AND BANCO = '${banco}'"]}`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
      $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

      let nomeBanco = await buscaValor("CADBAN", "NOME_BANCO", "BANCO", jsonStr.RESULT[0][0].BANCO);
      insereValor("#txtBanco", jsonStr.RESULT[0][0].BANCO, nomeBanco.NOME_BANCO);

      if ($("#txtBanco").val() != '') {
        $('#txtBanco').trigger('change');
        $("#txtOcorrencia, #btnOcorrencia, #btnLimpaOcorrencia").prop("disabled", false);
      } else {
        $("#txtOcorrencia, #btnOcorrencia, #btnLimpaOcorrencia").prop("disabled", true);
      }

      let nomeOcorrencia = await buscaValor("OCORRENCIA", "DESCRICAO", "CODIGO", jsonStr.RESULT[0][0].OCORRENCIA);
      if (nomeOcorrencia != undefined) {
        insereValor("#txtOcorrencia", jsonStr.RESULT[0][0].OCORRENCIA, nomeOcorrencia.DESCRICAO);
      }

      let nomeCarteira = await buscaValor("CARTEIRA", "DESCRICAO", "CARTEIRA", jsonStr.RESULT[0][0].CARTEIRA);
      if (nomeCarteira != undefined) {
        $("#txtCarteira, #btnCarteira, #btnLimpaCarteira").prop("disabled", true);
        insereValor("#txtCarteira", jsonStr.RESULT[0][0].CARTEIRA, nomeCarteira.DESCRICAO);
      }
    }
    finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {
      const mPagto = {
        CODIGO: $('#txtCodigo').val(),
        DESCRICAO: $('#txtDescricao').val(),
        OCORRENCIA: pegaChave('#txtOcorrencia'),
        BANCO: pegaChave('#txtBanco'),
        CARTEIRA: pegaChave('#txtCarteira'),
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadastrorejeicao?', `JSON=${encodeURIComponent(JSON.stringify(mPagto))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/cadastro_rejeicoes` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
