$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um CST PIS.",
          position: "right",
        },
      },
      {
        element: "#tabelaTipo",
        popover: {
          title: "Tabela CST PIS",
          description: "Aqui estão os dados dos CST PIS cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("TIPOCONTATO");

  $("#txtTipoContato").autocompleta(1, `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#btn-TipoContato").pesquisa("#txtTipoContato", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa CST PIS", "TIPO_CONTATO");
  $("#btn-limpa-TipoContato").on("click", function () { $("#txtTipoContato").val(""); });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipocontato/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultar();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTipoContato").val("");
  });

  $("#tabelaTipo").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTipo").DataTable().row($(this).parents("tr")).data();
      window.location.href = `tipocontato/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaTipo").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTipo").DataTable().row($(this)).data();
      window.location.href = `tipocontato/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTipo").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  consultar();

  async function consultar() {
    try {
      $.LoadingOverlay("show");

      const cstpis = pegaChave("#txtTipoContato") != "" ? ` AND CODIGO = '${pegaChave("#txtTipoContato")}'` : "";
      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${cstpis}"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaTipo").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }
  
  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/tipocontato?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }
        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

});
