$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoTipoBaixa",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um tipo de baixa.",
          position: "right",
        },
      },
      {
        element: "#tabelaTipoBaixa",
        popover: {
          title: "Tabela Tipos de Baixa",
          description: "Aqui estão os dados dos tipos de baixa cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TIPOBAIXA");

  
  $("#txtTipoBaixaConsulta").autocompleta(1,`JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  
  $("#btnTipoBaixa").pesquisa("#txtTipoBaixaConsulta","CODIGO","DESCRICAO",`/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`,"Pesquisa Tipo Baixa","TABBAI");
  
  $("#btnLimpaTipoBaixa").on("click", function () {
    $("#txtTipoBaixaConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovoTipoBaixa").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipobaixa/create";
    } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  consultaTipoBaixa();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaTipoBaixa();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTipoBaixaConsulta").val("");
  });

  async function consultaTipoBaixa() {
    try {
      $.LoadingOverlay("show");
      let codigo = pegaChave("#txtTipoBaixaConsulta") != "" ? ` AND CODIGO = '${pegaChave("#txtTipoBaixaConsulta")}'` : "";
      const response = await requisicao("GET","/Sisplan/Funcoes/V1/pesquisa?",`JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO", "DEPOSITO_ORIG", "DEPOSITO_DEST", "ATIVO"], "where": ["1=1 ${codigo}"]}`,null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaTipoBaixa").DataTable({
        destroy: true,
        lengthChange: false,

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
          {
            data: "TIPO",
          },
          {
            data: "DEPOSITO_ORIG",
          },
          {
            data: "DEPOSITO_DEST",
          },
          {
            data: "ATIVO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $("#tabelaTipoBaixa").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaTipoBaixa").DataTable().row($(this).parents("tr")).data();
          window.location.href = `tipobaixa/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
        
      });

      $("#tabelaTipoBaixa").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaTipoBaixa").DataTable().row($(this)).data();
          window.location.href = `tipobaixa/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
        
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaTipoBaixa").unbind("click");

  $('#tabelaTipoBaixa').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTipoBaixa").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/tipobaixa?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
