$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtID',
            popover: {
                title: 'ID',
                description: 'Este campo é preenchido automaticamente.',
                position: 'top'
            }
        },
        {
            element: '#rgOperacao',
            popover: {
                title: 'Operação',
                description: 'Aqui, adicionamos a operação do status.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o status.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    await criaPesquisa()

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let statusped = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('STATUSPED', getCookie('usuario'), statusped);
        window.location.href = `${BASE_URI}/statusped`;
    });

    $('#rgOperacao').on('change', async function () {
        $('.divFinanceiro').addClass('d-none')
        $('.divDias').addClass('d-none')
        if ($(this).val() == '') {
            return
        }

        if ($(this).val() == 'opComercial') {
            $('.divFinanceiro').removeClass('d-none')
            $('.divDias').removeClass('d-none')
        } else if ($(this).val() == 'opFinanceiro') {
            $('.divDias').removeClass('d-none')
        } else if ($(this).val() == 'opFinanceiro') {
            $('.divDias').removeClass('d-none')
        } else if ($(this).val() == 'opAlteraPedidoB2B') {
            $('.divFinanceiro').removeClass('d-none')
            $('.divDias').removeClass('d-none')
        }
    })

    $(document).ready(function () {

        $.validator.addMethod("selectNotEmpty", function (value, element, arg) {
            return value != "";
        }, "Selecione uma opção válida.");

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtStatus: {
                    selectNotEmpty: true,
                },
                rgOperacao: {
                    selectNotEmpty: true,

                },
            },
            messages: {
                txtStatus: {
                    selectNotEmpty: "Informe um status válido."
                },
                rgOperacao: {
                    selectNotEmpty: "Informe uma operação válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    let guardaRegistros = {}

    if (statusped != '' && statusped != 'create') {

        if (await liberarRegistro('STATUSPED', statusped) == false) {
            window.location.href = '../statusped';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ 
                            "tabela":"CONFIGSTATUS", 
                            "camposSelect":["CONFIGSTATUS.ID", "CONFIGSTATUS.ID_TIPO", "TIPO.DESCRICAO DESC_TIPO",
                                            "CONFIGSTATUS.OPERACAO", "CONFIGSTATUS.STATUS", "SITPROD.DESCRICAO DESC_STATUS",
                                            "CONFIGSTATUS.FINANCEIRO", "CONFIGSTATUS.DIAS", "CONFIGSTATUS.UTIL", "CONFIGSTATUS.VALIDA_MOEDA"], 
                            "leftjoin":[{"tabela":"TIPO", "condicao":"TIPO.ID_TIPO = CONFIGSTATUS.ID_TIPO"},
                                        {"tabela":"SITPROD", "condicao":"SITPROD.CODIGO = CONFIGSTATUS.STATUS"}],
                            "where": ["CONFIGSTATUS.ID = '${statusped}'"]
                        }`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtID').val(jsonStr.RESULT[0][0].ID);
                    $('#rgOperacao').val(jsonStr.RESULT[0][0].OPERACAO).trigger('change')
                    insereValor('#txtStatus', jsonStr.RESULT[0][0].STATUS, jsonStr.RESULT[0][0].DESC_STATUS)
                    insereValor('#txtTipo', jsonStr.RESULT[0][0].ID_TIPO, jsonStr.RESULT[0][0].DESC_TIPO)
                    $('#txtDias').val(jsonStr.RESULT[0][0].DIAS ?? 0);
                    $('#cbDiasUteis').prop('checked', jsonStr.RESULT[0][0].UTIL == 'S')
                    $('#cbValidaMoeda').prop('checked', jsonStr.RESULT[0][0].VALIDA_MOEDA == 'S')
                    $('.rdFinanceiro').filter('[value="' + jsonStr.RESULT[0][0].FINANCEIRO + '"]').prop('checked', true);
                    guardaRegistros = {
                        TIPO: jsonStr.RESULT[0][0].ID_TIPO,
                        OPERACAO: jsonStr.RESULT[0][0].OPERACAO,
                        VALIDA_MOEDA: jsonStr.RESULT[0][0].VALIDA_MOEDA
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do status: ${error}`);
                }
            } finally {
                $('#rgOperacao').prop('disabled', true)
                $.LoadingOverlay('hide');
            }
        }
    }


    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if ($('#rgOperacao').val() == '') {
                msgAlerta('Operação não informada!');
                return;
            }

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    const statusPed = {};

                    statusPed.OPERACAO_OLD = guardaRegistros.OPERACAO
                    statusPed.TIPO_OLD = guardaRegistros.TIPO
                    statusPed.VALIDA_MOEDA_OLD = guardaRegistros.VALIDA_MOEDA
                    statusPed.ID = $('#txtID').val();
                    statusPed.OPERACAO = $('#rgOperacao').val()
                    statusPed.STATUS = pegaChave('#txtStatus')
                    statusPed.TIPO = pegaChave('#txtTipo')
                    statusPed.FINANCEIRO = $('.rdFinanceiro').filter(':checked').val()
                    statusPed.TELA = $('#rgOperacao option:selected').text();
                    if (!$('.divDias').hasClass('d-none')) {
                        statusPed.DIAS = $('#txtDias').val();
                        statusPed.UTIL = $('#cbDiasUteis').is(':checked') ? 'S' : 'N'
                    }
                    statusPed.VALIDA_MOEDA = $('#cbValidaMoeda').is(':checked') ? 'S' : 'N'
                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/statusped?', `JSON=${encodeURIComponent(JSON.stringify(statusPed))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/statusped`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });

    async function criaPesquisa() {
        componenteFiltro('status', false, false);
        componenteFiltro('tipo', false, false);

    }
});