$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaSolicitacoes',
                popover: {
                    title: 'Tabela Solicitações',
                    description: 'Aqui estão as solicitações cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    ////////////// colunas invisiveis

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas == null || colunas.retaguardaSupervisor == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, retaguardaSupervisor: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, retaguardaSupervisor: novasColunas }))

            $('#tabelaSolicitacoes').DataTable().columns().visible(true);
            $('#tabelaSolicitacoes').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaSolicitacoes').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.retaguardaSupervisor ?? [], ['ID'])
    });
    ////////////// colunas invisiveis

    componenteFiltro('usuario', true, true)
    componenteFiltro('usuario', true, true, 'UsuarioLiber')

    const permissaoUsuarioLogado = await permissaoAcessos("RETAGUARDASUPERVISOR");
    const pedeSenhaCancelaNota = await CopiaParametro("FATURAMENTO", 8);

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Liberar" id="btn-liberar">Liberar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Rejeitar" id="btn-rejeitar">Rejeitar</button>  ' +
            '</div>';
        return retorno;
    };

    consultaSolicitacoes();

    let idIntervalo
    $('#btnConsultar').on('click', async function () {
        await consultaSolicitacoes();
        $('#modal-filtros').modal('hide');

        if (idIntervalo || idIntervalo > 0) return
        idIntervalo = setInterval(() => consultaSolicitacoes(), 60000)

    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtUsuario').empty().trigger('change')
        $('#txtUsuarioLiber').empty().trigger('change')
        $('#txtDtIni').val('1200-01-01')
        $('#txtDtFin').val('2500-12-31')
        $('#txtDtLibIni').val('1200-01-01')
        $('#txtDtLibFin').val('2500-12-31')
        $('#rgPendentes').prop('checked', true)
        $('#rgUsadoNaoUsados').prop('checked', true)
    });

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    async function retornaFiltros() {
        const situacao = $('#rgLiberados').is(':checked') ? 'L' : $('#rgRejeitados').is(':checked') ? 'R' : $('#rgPendentes').is(':checked') ? 'P' : '';
        const usado = $('#rgUsadoUsados').is(':checked') ? 'S' : $('#rgUsadoNaoUsados').is(':checked') ? 'N' : '';
        const dtIni = $('#txtDtIni').val() == '1200-01-01' ? '' : $('#txtDtIni').val()
        const dtFin = $('#txtDtFin').val() == '2500-12-31' ? '' : $('#txtDtFin').val()
        const dtLibIni = $('#txtDtLibIni').val() == '1200-01-01' ? '' : $('#txtDtLibIni').val()
        const dtLibFin = $('#txtDtLibFin').val() == '2500-12-31' ? '' : $('#txtDtLibFin').val()
        const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const filtros = `USERSOL=${await formataListas($('#txtUsuario').val().toString())}` +
            `&USERLIB=${await formataListas($('#txtUsuarioLiber').val().toString())}` +
            `&DTINICIO=${dtIni}` +
            `&DTFINAL=${dtFin}` +
            `&DTLIBERINI=${dtLibIni}` +
            `&DTLIBERFINAL=${dtLibFin}` +
            `&SITUACAO=${situacao}` +
            `&USADO=${usado}` +
            `&EMP_ID=${listaEmpIds}`

        return filtros
    }

    async function consultaSolicitacoes() {
        if ($.fn.DataTable.isDataTable('#tabelaSolicitacoes')) {
            $('#tabelaSolicitacoes').DataTable().destroy();
            $('#tabelaSolicitacoes').empty();
        }
        $.LoadingOverlay("show");
        try {
            const url = "/sisplan/retaguardasupervisor/v1/buscasolicitacoes?";
            const filtros = await retornaFiltros()
            const response = await requisicao("GET", url, filtros, "", 36000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json()
            if (response.status != 200) {
                throw new Error(jsonStr.mensagem);
            }

            if (jsonStr.length <= 0) {
                throw new Error('Nenhum registro encontrado!')
            }

            const keys = Object.keys(jsonStr[0]);
            let dataSetCols = [];

            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k].toUpperCase(),
                    'data': keys[k]
                });
            };

            $('#tabelaSolicitacoes').DataTable({
                destroy: true,
                lengthChange: true,
                serverside: true,
                colReorder: true,
                autoWidth: true,
                columns: dataSetCols,
                data: jsonStr,
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                    {
                        type: "date-br",
                        render(data) {
                            if (data) {
                                return new Intl.DateTimeFormat(
                                    "pt-BR",
                                    {
                                        year: "numeric",
                                        month: "2-digit",
                                        day: "2-digit",
                                        hour: "numeric",
                                        minute: "numeric",
                                        second: "numeric"
                                    })
                                    .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                                    .replace(",", "");
                            } else {
                                return ''
                            }
                        },
                        targets: [10, 12],
                    },
                    {
                        targets: [1],
                        render(data) {
                            if (data) {
                                switch (data) {
                                    case 'R':
                                        return 'REJEITADA'
                                        break;
                                    case 'L':
                                        return 'LIBERADA'
                                        break;
                                    default:
                                        return 'OUTRO'
                                        break;
                                }
                            } else {
                                return 'PENDENTE'
                            }
                        }
                    },
                    {
                        render: function (data) {
                            if (data) {
                                return parseFloat(data).toLocaleString("pt-br", {
                                    maximumFractionDigits: 2,
                                    minimumFractionDigits: 2,
                                });
                            } else {
                                return ''
                            }
                        },
                        targets: [9],
                    }
                ],
                createdRow: function (row, data, dataIndex) {
                    const acao = data.ACAO;
                    if (acao === "L") {
                        $('td', row).eq(1).css('color', 'green');
                    } else if (acao === "R") {
                        $('td', row).eq(1).css('color', 'red');
                    } else if (acao === "") {
                        $('td', row).eq(1).css('color', '#0069d9');
                    }
                    $('td', row).eq(1).css('font-weight', 'bold');
                    $('td', row).eq(2).css('font-weight', 'bold');
                }
            });

            $('#tabelaSolicitacoes_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaSolicitacoes_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                let dados = $("#tabelaSolicitacoes").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Retaguarda Supervisor', '#tabelaSolicitacoes', '', 999, false, false, dados);
            })

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaSolicitacoes').DataTable().columns(colunas.retaguardaSupervisor ?? []).visible(false);
            $('#tabelaSolicitacoes').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.retaguardaSupervisor).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#tabelaSolicitacoes').on('click', '#btn-liberar', async function () {
        $.LoadingOverlay('show')
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                let data = $('#tabelaSolicitacoes').DataTable().row($(this).parents('tr')).data();
                if (data.ACAO != '') {
                    throw new Error(`Solicitação já ${data.ACAO == 'R' ? 'rejeitada' : 'liberada'}. Impossível continuar!`)
                }

                await executaAcao(data.ID, 'L', data.TELA)
            } else {
                msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    $('#tabelaSolicitacoes').on('click', '#btn-rejeitar', async function () {
        $.LoadingOverlay('show')
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                let data = $('#tabelaSolicitacoes').DataTable().row($(this).parents('tr')).data();
                if (data.ACAO != '') {
                    throw new Error(`Solicitação já ${data.ACAO == 'R' ? 'rejeitada' : 'liberada'}. Impossível continuar!`)
                }

                await executaAcao(data.ID, 'R', data.TELA)
            } else {
                msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    async function validacoes(acao, tela) {
        if (!await uMasterOuSupervisor()) {
            throw new Error(`Somente um usuário master ou supervisor pode ${acao == 'R' ? 'rejeitar' : 'liberar'} uma solicitação.`)
        }

        if (tela == 'IMPRESSAONFE' || tela == 'IMPRESSAONFCE') {
            const somenteUsuarioMaster = pedeSenhaCancelaNota == 3 || pedeSenhaCancelaNota == 4 || pedeSenhaCancelaNota == 6
            const usuarioMaster = await UsuarioMasterOuSupervisor()
            if (somenteUsuarioMaster) {
                if (usuarioMaster[0].TIPO != '2')
                    throw new Error(`Somente um usuário Master pode ${acao == 'R' ? 'rejeitar' : 'liberar'} uma solicitação da tela ${tela}.`)
            }
        }
    }

    async function executaAcao(idSol, acao, tela) {
        $.LoadingOverlay('show')
        try {
            await validacoes(acao, tela)

            const response = await requisicao("POST", `/sisplan/retaguardasupervisor/v1/executaacao?`, `ID=${idSol}&STATUS=${acao}&USERLIB=${getCookie('usuario')}`, null, 600000)

            if (!response) {
                return
            }

            const json = await response.json()
            if (response.status != 200) {
                msgErro(json.mensagem)
                return
            }

            toastr.success(`Solicitação ${acao == 'R' ? 'rejeitada' : 'liberada'} com sucesso!`, "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    consultaSolicitacoes()
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }
});