$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir um relatório.',
        position: 'right'
      }
    }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  let options, options2, options3;
  criaDadosGraficos();

  /////COLUNAS INVISIVEIS
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.vendaDetalhada == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhada: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaEmpresas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaEmpresas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaRepresentantes == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaRepresentantes: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaMoedas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaMoedas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaHistorico == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaHistorico: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaItens == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaItens: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaFiscais == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFiscais: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaFinanceiro == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFinanceiro: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.vendaDetalhadaFormasPagto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFormasPagto: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('vendas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhada: novasColunas }))
        $('#tabelaVendas').DataTable().columns().visible(true);
        $('#tabelaVendas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('empresas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaEmpresas: novasColunas }))
        $('#tabelaEmpresas').DataTable().columns().visible(true);
        $('#tabelaEmpresas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('representantes') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaRepresentantes: novasColunas }))
        $('#tabelaRepresentantes').DataTable().columns().visible(true);
        $('#tabelaRepresentantes').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('moedas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaMoedas: novasColunas }))
        $('#tabelaMoedas').DataTable().columns().visible(true);
        $('#tabelaMoedas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('historico') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaHistorico: novasColunas }))
        $('#tabelaHistorico').DataTable().columns().visible(true);
        $('#tabelaHistorico').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('itens') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaItens: novasColunas }))
        $('#tabelaItens').DataTable().columns().visible(true);
        $('#tabelaItens').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('fiscais') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFiscais: novasColunas }))
        $('#tabelaFiscais').DataTable().columns().visible(true);
        $('#tabelaFiscais').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('financeiro') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFinanceiro: novasColunas }))
        $('#tabelaFinanceiro').DataTable().columns().visible(true);
        $('#tabelaFinanceiro').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('formaspagto') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, vendaDetalhadaFormasPagto: novasColunas }))
        $('#tabelaFormasPagto').DataTable().columns().visible(true);
        $('#tabelaFormasPagto').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }


      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('vendas') == 'true') {
      $('#tabelaVendas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhada ?? [], [])
    } else if (localStorage.getItem('empresas') == 'true') {
      $('#tabelaEmpresas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaHistorico ?? [], [])
    } else if (localStorage.getItem('representantes') == 'true') {
      $('#tabelaRepresentantes').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaHistorico ?? [], [])
    } else if (localStorage.getItem('moedas') == 'true') {
      $('#tabelaMoedas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaHistorico ?? [], [])
    } else if (localStorage.getItem('historico') == 'true') {
      $('#tabelaHistorico').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaHistorico ?? [], [])
    } else if (localStorage.getItem('itens') == 'true') {
      $('#tabelaItens').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaItens ?? [], [])
    } else if (localStorage.getItem('fiscais') == 'true') {
      $('#tabelaFiscais').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaFiscais ?? [], [])
    } else if (localStorage.getItem('financeiro') == 'true') {
      $('#tabelaFinanceiro').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaFinanceiro ?? [], [])
    } else if (localStorage.getItem('formaspagto') == 'true') {
      $('#tabelaFormasPagto').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.vendaDetalhadaFormasPagto ?? [], [])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('vendas')
    localStorage.removeItem('historico')
    localStorage.removeItem('itens')
    localStorage.removeItem('fiscais')
    localStorage.removeItem('financeiro')
  })
  /////COLUNAS INVISIVEIS

  addFiltros()
  const parametrosVenda = await BuscaParametrosVenda();
  const bProduto = parametrosVenda[17] == 0;

  if (bProduto) {
    $("#radioProduto").prop("checked", true);
  } else {
    $("#radioMaterial").prop("checked", true);
  }

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaVendas();
    $('#modal-filtros').modal('hide');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCliente').empty().trigger('change')
    $('#txtVendedor').empty().trigger('change')
    $('#txtCaixa').empty().trigger('change')
    $('#txtTipoVenda').empty().trigger('change')
    $('#txtVenda').empty().trigger('change')
    $('#txtNota').empty().trigger('change')
    $('#txtNotaNfce').empty().trigger('change')
    $('#txtDtIni').val('1200-01-01')
    $('#txtDtFin').val('2500-12-31')
    $('#radioProduto').prop('checked', true)
    $('#cbEmitido').prop('checked', true)
    $('#cbPendente').prop('checked', true)
    $('#cbAgrupada').prop('checked', true)
    $('#cbDevolvido').prop('checked', true)
    $('#cbCancelada').prop('checked', true)
    $('#cbSemNfe').prop('checked', false)
    $('#cbComNfe').prop('checked', false)
    $('#cbSemNfce').prop('checked', false)
    $('#cbComNfce').prop('checked', false)
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros(pEmpId = undefined, pCodRep = undefined, pCodMoe = undefined) {
    const item = $('#radioProduto').is(':checked') ? 'P' : 'M';
    const dtIni = $('#txtDtIni').val()
    const dtFin = $('#txtDtFin').val()
    const listaEmpIds = pEmpId ? [pEmpId] : ($('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')]);
    let vendedor = await formataListas($('#txtVendedor').val().toString());

    if (pCodRep) {
      vendedor = `'` + pCodRep + `'`;
    }

    const moeda = pCodMoe != undefined ? pCodMoe : '';

    const filtros = `CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&VENDEDOR=${vendedor}` +
      `&CAIXA=${await formataListas($('#txtCaixa').val().toString())}` +
      `&TIPOVENDA=${await formataListas($('#txtTipoVenda').val().toString())}` +
      `&VENDA=${await formataListas($('#txtVenda').val().toString())}` +
      `&NOTA=${await formataListas($('#txtNota').val().toString())}` +
      `&NOTANFCE=${await formataListas($('#txtNotaNfce').val().toString())}` +
      `&DTINICIO=${dtIni}` +
      `&DTFINAL=${dtFin}` +
      `&ITEM=${item}` +
      `&EMITIDO=${$('#cbEmitido').is(':checked')}` +
      `&PENDENTE=${$('#cbPendente').is(':checked')}` +
      `&AGRUPADA=${$('#cbAgrupada').is(':checked')}` +
      `&DEVOLVIDO=${$('#cbDevolvido').is(':checked')}` +
      `&CANCELADA=${$('#cbCancelada').is(':checked')}` +
      `&NFE=${$('#cbSemNfe').is(':checked') ? 'S' : $('#cbComNfe').is(':checked') ? 'C' : ''}` +
      `&NFCE=${$('#cbSemNfce').is(':checked') ? 'S' : $('#cbComNfce').is(':checked') ? 'C' : ''}` +
      `&TIPOITEM=${$('#radioProduto').is(':checked') ? 'P' : 'M'}` +
      `&EMP_ID=${listaEmpIds}` +
      `&MOEDA=${moeda}`

    return filtros
  }

  async function consultaVendas(pEmpId = undefined, pCodRep = undefined, pCodMoe = undefined) {
    if ($.fn.DataTable.isDataTable('#tabelaVendas')) {
      $('#tabelaVendas').DataTable().destroy();
      $('#tabelaVendas').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaFormasPagto')) {
      $('#tabelaFormasPagto').DataTable().destroy();
      $('#tabelaFormasPagto').empty();
    }
    if (($.fn.DataTable.isDataTable('#tabelaEmpresas')) && !pEmpId) {
      $('#tabelaEmpresas').DataTable().destroy();
      $('#tabelaEmpresas').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaRepresentantes') && !pCodRep) {
      $('#tabelaRepresentantes').DataTable().destroy();
      $('#tabelaRepresentantes').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaMoedas') && (pCodMoe == undefined)) {
      $('#tabelaMoedas').DataTable().destroy();
      $('#tabelaMoedas').empty();
    }
    limpaTabelasAuxiliares()
    $.LoadingOverlay("show");
    try {
      const url = "/sisplan/impressao/v1/buscavendadetalhada?";
      const filtros = await retornaFiltros(pEmpId, pCodRep, pCodMoe)
      const response = await requisicao("GET", url, filtros, "", 36000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json()
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (jsonStr.length <= 0) {
        throw new Error('Nenhum registro encontrado!')
      }

      criaTabelaVendas(jsonStr[0]);

      if (!pEmpId) {
        criaTabelaEmpresas(jsonStr[1]);
      }

      if (!pCodRep) {
        criaTabelaRepresentantes(jsonStr[2]);
      }

      if (pCodMoe == undefined) {
        criaTabelaMoedas(jsonStr[3]);
      }

      montaGraficos(jsonStr[1], jsonStr[2], jsonStr[3], pEmpId, pCodRep, pCodMoe);

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaVendas').on('click', 'tr', async function () {
    $.LoadingOverlay('show')
    try {
      let codven = 0;

      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        $('#tabelaVendas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        codven = $('#tabelaVendas').DataTable().row($(this)).data().CODVEN
      }

      if (codven > 0) {
        await atualizaTabelas(codven, $('#radioProduto').is(':checked') ? 'P' : 'M')
      } else {
        limpaTabelasAuxiliares()
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#tabelaEmpresas').on('click', 'tr', async function () {
    $.LoadingOverlay('show')
    try {
      let empId = undefined;

      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        $('#tabelaEmpresas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        empId = $('#tabelaEmpresas').DataTable().row($(this)).data().EMPRESA
      };

      await consultaVendas(empId);
      limpaTabelasAuxiliares();

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#tabelaRepresentantes').on('click', 'tr', async function () {
    $.LoadingOverlay('show')
    try {
      let codRep = undefined;
      let empId = undefined;

      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        $('#tabelaRepresentantes').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        codRep = $('#tabelaRepresentantes').DataTable().row($(this)).data().CODREP
      };

      if ($('#tabelaEmpresas').DataTable().rows('.selected').data().length > 0) {
        empId = $('#tabelaEmpresas').DataTable().rows('.selected').data()[0].EMPRESA;
      }

      await consultaVendas(empId, codRep);
      limpaTabelasAuxiliares();

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $('#tabelaMoedas').on('click', 'tr', async function () {
    $.LoadingOverlay('show')
    try {
      let codMoe = undefined;
      let codRep = undefined;
      let empId = undefined;

      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        $('#tabelaMoedas').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        codMoe = $('#tabelaMoedas').DataTable().row($(this)).data().MOEDA
      };

      if ($('#tabelaEmpresas').DataTable().rows('.selected').data().length > 0) {
        empId = $('#tabelaEmpresas').DataTable().rows('.selected').data()[0].EMPRESA;
      }

      if ($('#tabelaRepresentantes').DataTable().rows('.selected').data().length > 0) {
        codRep = $('#tabelaRepresentantes').DataTable().rows('.selected').data()[0].CODREP;
      }

      await consultaVendas(empId, codRep, codMoe);
      limpaTabelasAuxiliares();

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function criaTabelaVendas(jsonStr) {
    if (jsonStr.length == 0) return
    const keys = Object.keys(jsonStr[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    };

    $('#tabelaVendas').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat(
                "pt-BR",
                {
                  year: "numeric",
                  month: "2-digit",
                  day: "2-digit",
                  hour: "numeric",
                  minute: "numeric",
                  second: "numeric"
                })
                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                .replace(",", "");
            } else {
              return ''
            }
          },
          targets: [7],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [10, 11, 12, 13],
        },
        {
          targets: 14,
          className: 'pr-4 text-right'
        }
      ]
    });

    $('#tabelaVendas_length').prepend('<button class="buttonColVis" id="buttonColVisVenda"><i class="fas fa-cogs"></i></button>');
    $('#tabelaVendas_length').prepend('<button class="buttonExcel" id="buttonExcelVenda"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelVenda').on('click', async function () {
      let dados = $("#tabelaVendas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda', '#tabelaVendas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisVenda').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('vendas', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaVendas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhada).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaEmpresas(jsonStr) {
    if (jsonStr.length == 0) return

    const keys = Object.keys(jsonStr[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    };

    $('#tabelaEmpresas').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      order: [[4, 'desc']],
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [3],
        },
        {
          targets: [4],
          visible: false,
        }
      ]
    });

    $('#tabelaEmpresas_length').prepend('<button class="buttonColVis" id="buttonColVisEmpresas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEmpresas_length').prepend('<button class="buttonExcel" id="buttonExcelEmpresas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelEmpresas').on('click', async function () {
      let dados = $("#tabelaEmpresas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Empresas', '#tabelaEmpresas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisEmpresas').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('empresas', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaEmpresas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaEmpresas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaRepresentantes(jsonStr) {
    if (jsonStr.length == 0) return

    const keys = Object.keys(jsonStr[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    };

    $('#tabelaRepresentantes').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      order: [[3, 'desc']],
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [2],
        },
        {
          targets: [3],
          visible: false,
        }
      ]
    });

    $('#tabelaRepresentantes_length').prepend('<button class="buttonColVis" id="buttonColVisRepresentantes"><i class="fas fa-cogs"></i></button>');
    $('#tabelaRepresentantes_length').prepend('<button class="buttonExcel" id="buttonExcelRepresentantes"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelRepresentantes').on('click', async function () {
      let dados = $("#tabelaRepresentantes").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Representantes', '#tabelaRepresentantes', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisRepresentantes').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('representantes', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaRepresentantes').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaRepresentantes).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaMoedas(jsonStr) {
    if (jsonStr.length == 0) return

    const keys = Object.keys(jsonStr[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    };

    $('#tabelaMoedas').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      order: [[3, 'desc']],
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [2],
        },
        {
          targets: [3],
          visible: false,
        }
      ]
    });

    $('#tabelaMoedas_length').prepend('<button class="buttonColVis" id="buttonColVisMoedas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaMoedas_length').prepend('<button class="buttonExcel" id="buttonExcelMoedas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelMoedas').on('click', async function () {
      let dados = $("#tabelaMoedas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Moedas', '#tabelaMoedas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisMoedas').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('moedas', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaMoedas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaMoedas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function atualizaTabelas(codven, tipo) {
    limpaTabelasAuxiliares()
    $.LoadingOverlay('show')
    try {
      const url = "/sisplan/impressao/v1/buscavendadetalhada?";
      const response = await requisicao("POST", url, `TIPOITEM=${tipo}&CODVEN=${codven}`, "", 480000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json()
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      if (jsonStr[0].length <= 0) {
        throw new Error('Nenhum registro encontrado!')
      }

      const tbItens = jsonStr[0]
      const tbFiscais = jsonStr[1]
      const tbFinanceiro = jsonStr[2]
      const tbHistorico = jsonStr[3]
      const tbFormasPagto = jsonStr[4];

      if (tbFiscais.length > 0) {
        await montaDataTableFiscais(tbFiscais)
      }
      if (tbItens.length > 0) {
        await montaDataTableItens(tbItens)
      }
      if (tbFinanceiro.length > 0) {
        await montaDataTableFinanceiro(tbFinanceiro)
      }
      if (tbHistorico.length > 0) {
        await montaDataTableHistorico(tbHistorico)
      }
      if (tbFormasPagto.length > 0) {
        await montaDataTableFormasPagto(tbFormasPagto)
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function montaDataTableFiscais(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaFiscais').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [4],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [9, 10, 11],
        }
      ]
    });

    $('#tabelaFiscais_length').prepend('<button class="buttonColVis" id="buttonColVisFiscais"><i class="fas fa-cogs"></i></button>');
    $('#tabelaFiscais_length').prepend('<button class="buttonExcel" id="buttonExcelFiscais"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelFiscais').on('click', async function () {
      let dados = $("#tabelaFiscais").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Documentos Fiscais', '#tabelaFiscais', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisFiscais').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('fiscais', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaFiscais').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaFiscais).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function montaDataTableItens(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaItens').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [19, 20, 21, 22, 23, 24, 25],
        },
        {
          targets: [17, 18],
          className: 'pr-4 text-right'
        }
      ]
    });

    $('#tabelaItens_length').prepend('<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>');
    $('#tabelaItens_length').prepend('<button class="buttonExcel" id="buttonExcelItens"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelItens').on('click', async function () {
      let dados = $("#tabelaItens").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Itens', '#tabelaItens', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisItens').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('itens', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaItens').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaItens).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function montaDataTableFinanceiro(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaFinanceiro').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [3, 4],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [13, 14, 15, 16],
        },
      ]
    });

    $('#tabelaFinanceiro_length').prepend('<button class="buttonColVis" id="buttonColVisFinanceiro"><i class="fas fa-cogs"></i></button>');
    $('#tabelaFinanceiro_length').prepend('<button class="buttonExcel" id="buttonExcelFinanceiro"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelFinanceiro').on('click', async function () {
      let dados = $("#tabelaFinanceiro").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Financeiro', '#tabelaFinanceiro', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisFinanceiro').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('financeiro', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaFinanceiro').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaFinanceiro).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  async function montaDataTableFormasPagto(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaFormasPagto').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [2],
        },
      ]
    });

    $('#tabelaFormasPagto_length').prepend('<button class="buttonColVis" id="buttonColVisFormasPagto"><i class="fas fa-cogs"></i></button>');
    $('#tabelaFormasPagto_length').prepend('<button class="buttonExcel" id="buttonExcelFormasPagto"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelFormasPagto').on('click', async function () {
      let dados = $("#tabelaFormasPagto").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Formas de Pagamento', '#tabelaFormasPagto', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisFormasPagto').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('formaspagto', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaFormasPagto').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaFormasPagto).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  };

  async function montaDataTableHistorico(jsonStr) {
    const dataSetCols = []
    const keys = Object.keys(jsonStr[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaHistorico').DataTable({
      destroy: true,
      lengthChange: true,
      serverside: true,
      search: false,
      filter: false,
      pageLength: 5,
      lengthMenu: [[5, 10, 25, 50, 100], [5, 10, 25, 50, 100]],
      colReorder: true,
      autoWidth: true,
      columns: dataSetCols,
      data: jsonStr,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat(
                "pt-BR",
                {
                  year: "numeric",
                  month: "2-digit",
                  day: "2-digit",
                  hour: "numeric",
                  minute: "numeric",
                  second: "numeric"
                })
                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                .replace(",", "");
            } else {
              return ''
            }
          },
          targets: [2],
        },
        {
          targets: [1],
          render(data) {
            if (data) {
              switch (data) {
                case 'R':
                  return 'REJEITADA'
                  break;
                case 'L':
                  return 'LIBERADA'
                  break;
                default:
                  return 'OUTRO'
                  break;
              }
            } else {
              return 'PENDENTE'
            }
          }
        }
      ]
    });

    $('#tabelaHistorico_length').prepend('<button class="buttonColVis" id="buttonColVisHistorico"><i class="fas fa-cogs"></i></button>');
    $('#tabelaHistorico_length').prepend('<button class="buttonExcel" id="buttonExcelHistorico"><i class="fas fa-file-excel"></i></button>');

    $('#buttonExcelHistorico').on('click', async function () {
      let dados = $("#tabelaHistorico").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Relatório detalhado de Venda - Historico', '#tabelaHistorico', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#buttonColVisHistorico').on('click', async function () {
      $.LoadingOverlay('show')
      try {
        localStorage.setItem('historico', 'true')
        $('#modal-ColunasVisiveis').modal('show');
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaHistorico').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.vendaDetalhadaHistorico).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function limpaTabelasAuxiliares() {
    if ($.fn.DataTable.isDataTable('#tabelaFiscais')) {
      $('#tabelaFiscais').DataTable().destroy();
      $('#tabelaFiscais').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaFinanceiro')) {
      $('#tabelaFinanceiro').DataTable().destroy();
      $('#tabelaFinanceiro').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaHistorico')) {
      $('#tabelaHistorico').DataTable().destroy();
      $('#tabelaHistorico').empty();
    }
  }

  preencheOrdenacaoTela('VendaDetalhada');

  retornaHintRelatorio('btnImprimir', 'RelVendaDetalhada')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirvendadetalhada?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelVendaDetalhada&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('VendaDetalhada');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, 'POST', 100000, false, 'VendaDetalhada', filtros);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function addFiltros() {
    componenteFiltro('cliente', true, true)
    componenteFiltro('vendedor', true, true)
    componenteFiltro('caixa', true, true)
    componenteFiltro('tipoVenda', true, true)
    componenteFiltro('venda', true, true)
    componenteFiltro('nota', true, true)
    componenteFiltro('notaNfce', true, true)

    $('#cbSemNfe').on('click', function () {
      $('#cbComNfe').prop('checked', false)
    })
    $('#cbComNfe').on('click', function () {
      $('#cbSemNfe').prop('checked', false)
    })
    $('#cbSemNfce').on('click', function () {
      $('#cbComNfce').prop('checked', false)
    })
    $('#cbComNfce').on('click', function () {
      $('#cbSemNfce').prop('checked', false)
    })
  }

  async function montaGraficos(dadosEmp, dadosRep, dadosMoeda, pEmpId = undefined, pCodRep = undefined, pCodMoe = undefined) {
    options.series = [];
    options.labels = [];

    options2.series = [];
    options2.labels = [];

    options3.series = [];
    options3.labels = [];

    const g1 = dadosEmp.length > 10 ? 10 : dadosEmp.length;
    const g2 = dadosRep.length > 10 ? 10 : dadosRep.length;
    const g3 = dadosMoeda.length > 10 ? 10 : dadosMoeda.length;

    for (i = 0; i < g1; i++) {
      options.series.push(dadosEmp[i].VALOR);
      options.labels.push(dadosEmp[i].FANTASIA);
    }

    for (i = 0; i < g2; i++) {
      options2.series.push(dadosRep[i].VALOR);
      options2.labels.push(dadosRep[i].NOME);
    }

    for (i = 0; i < g3; i++) {
      options3.series.push(dadosMoeda[i].VALOR);
      options3.labels.push(dadosMoeda[i].DESCRICAO);
    }

    let totalEmpresas = 0;
    let totalRepresentantes = 0;
    let totalMoedas = 0;

    dadosEmp.map(item => {
      totalEmpresas += item.VALOR;
    });

    dadosRep.map(item => {
      totalRepresentantes += item.VALOR;
    });

    dadosMoeda.map(item => {
      totalMoedas += item.VALOR;
    });

    if (!pEmpId) {
      $('#totalEmpresas').text('Total Empresas: ' + formataValorSemRS(totalEmpresas));
      $("#chart").empty();
      const chart = await new ApexCharts(
        document.querySelector("#chart"),
        options
      );
      chart.render();
      setTimeout(() => {
        chart.resetSeries();
      }, 400);
    }

    if (!pCodRep) {
      $('#totalRepresentantes').text('Total Representantes: ' + formataValorSemRS(totalRepresentantes));
      $("#chart2").empty();
      const chart2 = await new ApexCharts(
        document.querySelector("#chart2"),
        options2
      );
      chart2.render();
      setTimeout(() => {
        chart2.resetSeries();
      }, 400);
    }

    if (!pCodMoe) {
      $('#totalMoedas').text('Total Moedas: ' + formataValorSemRS(totalMoedas));
      $("#chart3").empty();
      const chart3 = await new ApexCharts(
        document.querySelector("#chart3"),
        options3
      );
      chart3.render();
      setTimeout(() => {
        chart3.resetSeries();
      }, 400);
    }
  }

  function criaDadosGraficos() {
    options = {
      series: [],
      labels: [],
      chart: {
        type: "pie",
        height: 325,
      },
      legend: {
        show: false,
      },
    };

    options2 = {
      series: [],
      labels: [],
      chart: {
        type: "pie",
        height: 325,
      },
      legend: {
        show: false,
      },
    };

    options3 = {
      series: [],
      labels: [],
      chart: {
        type: "pie",
        height: 325,
      },
      legend: {
        show: false,
      },
    };
  }
});