$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um perfil.",
          position: "right",
        },
      },
      {
        element: "#tabelaPerfil",
        popover: {
          title: "Tabela de Dados",
          description: "Aqui estão os dados dos perfis cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await consultaDados();
  const permissaoUsuarioLogado = await permissaoAcessos("PERFIL");

  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Perfil', '');

  $('#btnLimpaPerfil').on('click', async function () {
    $('#txtPerfil').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = `perfil/create`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = '[ " 1=1 ';

        if ($('#txtCodigo').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtCodigo')}'`
        }

        params += ' " ]'

        $("#tabelaPerfil").DataTable({
          destroy: true,
          lengthChange: false,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: { Authorization: BASIC_AUTH },
            data: {
              EMPRESA: getCookie("empresa"),
              JSON: `{"tabela":"PERFIL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${params}}`,
            },
          },
          columnDefs: [
            {
              targets: [0], render: function (data) {
                return retornaBotaoOpcoes(data);
              },
            },
          ],
        });
        $("input[type='search']").focus();
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function excluiLinha(codigo) {
    let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/perfil?`, `CODIGO=${codigo}`, 15000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr[0].mensagem);
      return;
    }

    toastr
      .success("Exclusão realizada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/perfil`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $("#tabelaPerfil").on("click", "#btn-excluir", async function () {
    msgAlerta('Deseja excluir este registro?', async () => {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        let data = $("#tabelaPerfil").DataTable().row($(this).parents("tr")).data();
        await excluiLinha(data[0]);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    })
  });

  $("#tabelaPerfil").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaPerfil").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("PERFIL", data[0]);
      if (clienteLiberado) {
        window.location.href = `perfil/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaPerfil").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaPerfil").DataTable().row($(this)).data();
      let perfilLiberado = await liberarRegistro("PERFIL", data[0]);
      if (perfilLiberado) {
        window.location.href = `perfil/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
