$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#divTabelaConsumos',
        popover: {
          title: 'Consumos',
          description: 'Aqui se encontram os consumos da ordem de produção informada.',
          position: 'top'
        }
      },
      {
        element: '#txtBarra',
        popover: {
          title: 'Barra',
          description: 'Aqui é possível fazer a baixa bipando uma barra de material.',
          position: 'top'
        }
      },
      {
        element: '#tabLotes',
        popover: {
          title: 'Estoque/Reserva',
          description: 'Aqui se encontram os lotes em estoque/reserva disponíveis.',
          position: 'top'
        }
      },
      {
        element: '#tabBaixas',
        popover: {
          title: 'Baixas',
          description: 'Aqui se encontram as baixas realizadas para a ordem de produção informada.',
          position: 'top'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const url = window.location.href
  const id = url.split('/')[url.split('/').length - 1]

  $('#btnCodigo').pesquisa_serverside(['#txtCodigo', '#txtDescricao', '#txtUnidade'], ['CODIGO', 'DESCRICAO', 'UNIDADE'], ['DESCRICAO', 'DESCRICAO', 'UNIDADE'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE" ], "where": null}', 'Pesquisa Produto', undefined, [true, true, true])
  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').val('')
    $('#txtDescricao').val('')
    $('#txtUnidade').val('')
  })
  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, ID_TAM DESCRICAO"], "where": null }`, ['#txtTamanho'], ['CHAVE'], [], () => { }, [true])
  $('#btnTamanho').pesquisa_serverside(['#txtTamanho'], ['TAM', 'ID_TAM'], ['TAM', 'ID_TAM'], '{"tabela":"TABTAM", "camposSelect":[ "TAM", "ID_TAM" ], "where": null}', 'Pesquisa Tamanho', undefined, [true])
  $('#btnLimpaTamanho').on('click', function () {
    $('#txtTamanho').val('')
  })
  componenteFiltro('cor', false, false)
  componenteFiltro('markup', false, false)

  $('.quatroCasasDecimaisQuantityFormat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 4,
  })

  $('.duasCasasDecimaisCurrencyFormat').maskMoney({
    decimal: ",",
    thousands: "",
    precision: 2,
  })

  function adicionaFormatacaoCurrencyModalMarkup() {
    $('.quatroCasasDecimaisCurrencyFormat').maskMoney({
      decimal: ",",
      thousands: "",
      precision: 4,
    })
  }

  const parametrosCustos = await BuscaParametrosCustos()
  if (parametrosCustos[0]?.VALOR != '1') {
    $('.campoCor').addClass('d-none')
  } else {
    $('.campoCor').removeClass('d-none')
  }

  if (id && id !== 'create') {
    carregarCadastro(id)
  } else {
    carregarCotacoes()
  }

  $('#msform input').keydown(function (event) {
    if (event.key === 'Enter' || event.keyCode === 13) {
      event.preventDefault()

      const inputs = $('#msform input:visible')
      const nextInput = inputs.eq(inputs.index(this) + 1)

      if (nextInput.length) {
        nextInput.focus()
      }
    }
  })

  async function carregarCadastro(chave) {
    $.LoadingOverlay('show')
    buscarDadosCadastro(
      chave
    ).then(({ capa, prazos, itens }) => {
      if (capa) {
        preencheDadosCapa(capa)
      }
      if (itens) {
        criarTabelaItens(itens)
      }
      if (prazos) {
        alimentarPrazosMarkup(prazos)
      }
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar os dados.')
    }).finally(() => {
      $.LoadingOverlay('hide')
    })
  }

  function carregarCotacoes(data) {
    buscarCotacoes(data || new Date()).then(({ precoDolar, precoEuro }) => {
      $('#txtPrecoDolar').val(parseFloat(precoDolar).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }))
      $('#txtPrecoEuro').val(parseFloat(precoEuro).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }))
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar as cotações.')
    })
  }

  async function buscarCotacoes(date) {
    const filtros = {
      data: date || formataData(new Date()),
    }

    const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornarcotacoes?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado || {
        precoDolar: 0,
        precoEuro: 0,
      }
    }
  }

  async function buscarDadosCadastro(chave) {
    const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornardadoscadastro?`, `&ID=${chave}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  function retornarFiltros() {
    return {
      produto: $('#txtCodigo').val(),
      tamanho: pegaChave('#txtTamanho') || '',
      cor: pegaChave('#txtCor') || '',
      markup: pegaChave('#txtMarkup') || '',
      parametroConsumos: $('#selectMedia').val(),
      parametroMaoDeObra: $('input[name="radioMaoDeObra"]').filter(':checked').val(),
    }
  }

  async function retornarItensProduto(filtros) {
    const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornaritensproduto?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      if (resultado) {
        const { itens } = resultado
        return itens
      }
    }
  }

  function preencheDadosCapa(data) {
    const {
      codigo,
      descricao,
      unidade,
      tamanho,
      cor,
      descricaoCor,
      markup,
      descricaoMarkup,
      dataCadastro,
      pesoBruto,
      quebra,
      precoDolar,
      precoEuro,
      idPreco,
    } = data

    insereValor('#txtCodigo', codigo)
    insereValor('#txtDescricao', descricao)
    insereValor('#txtUnidade', unidade)
    insereValor('#txtTamanho', tamanho)
    insereValor('#txtCor', cor, descricaoCor)
    insereValor('#txtMarkup', markup, descricaoMarkup)
    insereValor('#txtCadastro', dataCadastro.substring(0, 10))
    insereValor('#txtPesoBruto', pesoBruto)
    insereValor('#txtQuebra', quebra)
    insereValor('#txtPrecoDolar', precoDolar.toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
    insereValor('#txtPrecoEuro', precoEuro.toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    }))
    insereValor('#txtIdPreco', idPreco)
  }

  function criarTabelaItens(data) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'aplicacao',
        title: 'Aplicação',
      },
      {
        data: 'descricaoAplicacao',
        title: 'Desc. Aplicação',
      },
      {
        data: 'unidade',
        title: 'Unidade',
      },
      {
        data: 'quantidade',
        title: 'Quantidade',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toFixed(5)
          }
          return parseFloat(data).toFixed(5)
        },
      },
      {
        data: 'custo',
        title: 'Custo',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 6,
              minimumFractionDigits: 6,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 6,
            minimumFractionDigits: 6,
          })
        },
      },
      {
        data: 'valor',
        title: 'Valor',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 6,
              minimumFractionDigits: 6,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 6,
            minimumFractionDigits: 6,
          })
        },
      },
      {
        data: 'parte',
        title: 'Parte',
      },
      {
        data: 'descricaoParte',
        title: 'Desc. Parte',
      },
      {
        data: 'setor',
        title: 'Setor',
      },
      {
        data: 'descricaoSetor',
        title: 'Desc. Setor',
      },
    ]

    $("#tabelaItens").DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      autoWidth: true,
      data,
      columns,
    }).draw(false)
  }

  $('#btnBuscarItens').on('click', async function () {
    await carregarDadosProduto()
  })

  async function carregarDadosProduto() {
    try {
      $.LoadingOverlay('show')
      const filtros = retornarFiltros()
      if (validarFiltrosProduto(filtros)) {
        const itens = await retornarItensProduto(filtros)
        criarTabelaItens(itens || [])
      }
    } catch (error) {
      msgErro(error || 'Ocorreu um erro ao buscar os dados.')
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function validarFiltrosProduto(filtros) {
    const parametroBuscarConsumos = filtros.parametroConsumos
    if (!parametroBuscarConsumos) {
      msgErro('Parâmetro 1 dos custos não configurado, impossível continuar.')
      return
    }
    const { produto, tamanho, cor, markup } = filtros
    if (!produto) {
      msgErro('Produto não informado, impossível continuar.')
      return
    }
    if (!tamanho && parametroBuscarConsumos === 'tamanho') {
      msgErro('Tamanho não informado, impossível continuar.')
      return
    }
    if (!cor && parametroBuscarConsumos === 'cor') {
      msgErro('Cor não informada, impossível continuar.')
      return
    }
    if (!markup) {
      msgErro('Markup não informado, impossível continuar.')
      return
    }
    return true
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/formacao_custos`
  })

  $('#txtCodigo').on('input', function () {
    buscarDadosCodigoInformado(
      $(this).val()
    ).then(({ DESCRICAO: descricao, UNIDADE: unidade }) => {
      $('#txtDescricao').val(descricao)
      $('#txtUnidade').val(unidade)
    }).catch((error) => {
      msgErro('Ocorreu um erro ao buscar os dados.')
      console.error(error)
    })
  })

  async function buscarDadosCodigoInformado(produto) {
    const pesquisa = {
      camposSelect: ['DESCRICAO', 'UNIDADE'],
      tabela: 'PRODUTO',
      where: [`CODIGO = '${produto}'`],
    }
    const result = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))
    return result[0] || {
      DESCRICAO: '',
      UNIDADE: '',
    }
  }

  $('#txtCadastro').on('blur', function () {
    const data = new Date($('#txtCadastro').val())
    if (data instanceof Date && !isNaN(data)) {
      carregarCotacoes(data)
    }
  })

  $('#txtMarkup').on('blur', function () {
    carregarPrazosMarkup(pegaChave($(this)))
  })

  function carregarPrazosMarkup(markup) {
    buscarPrazosMarkup(
      markup
    ).then((data) => {
      alimentarPrazosMarkup(data)
    }).catch((error) => {
      msgErro('Ocorreu um erro ao buscar os prazos.')
      console.error(error)
    })
  }

  function alimentarPrazosMarkup({ prazo1, prazo2, prazo3, prazo4, prazo5, prazo6, prazo7, }) {
    if (!prazo1 || prazo1 <= 0) {
      return
    }
    $('#txtPrazo1').val(prazo1)
    $('#txtValorPc1').val('0,00')
    $('#txtValorKg1').val('0,00')
    $('.rowMarkup1').removeClass('d-none')

    if (!prazo2 || prazo2 <= 0) {
      return
    }
    $('#txtPrazo2').val(prazo2)
    $('#txtValorPc2').val('0,00')
    $('#txtValorKg2').val('0,00')
    $('.rowMarkup2').removeClass('d-none')

    if (!prazo3 || prazo3 <= 0) {
      return
    }
    $('#txtPrazo3').val(prazo3)
    $('#txtValorPc3').val('0,00')
    $('#txtValorKg3').val('0,00')
    $('.rowMarkup3').removeClass('d-none')

    if (!prazo4 || prazo4 <= 0) {
      return
    }
    $('#txtPrazo4').val(prazo4)
    $('#txtValorPc4').val('0,00')
    $('#txtValorKg4').val('0,00')
    $('.rowMarkup4').removeClass('d-none')

    if (!prazo5 || prazo5 <= 0) {
      return
    }
    $('#txtPrazo5').val(prazo5)
    $('#txtValorPc5').val('0,00')
    $('#txtValorKg5').val('0,00')
    $('.rowMarkup5').removeClass('d-none')

    if (!prazo6 || prazo6 <= 0) {
      return
    }
    $('#txtPrazo6').val(prazo6)
    $('#txtValorPc6').val('0,00')
    $('#txtValorKg6').val('0,00')
    $('.rowMarkup6').removeClass('d-none')

    if (!prazo7 || prazo7 <= 0) {
      return
    }
    $('#txtPrazo7').val(prazo7)
    $('#txtValorPc7').val('0,00')
    $('#txtValorKg7').val('0,00')
    $('.rowMarkup7').removeClass('d-none')
  }

  async function buscarPrazosMarkup(markup) {
    const filtros = {
      markup
    }
    const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornarprazosmarkup?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado || {
        prazo1: 0,
        prazo2: 0,
        prazo3: 0,
        prazo4: 0,
        prazo5: 0,
        prazo6: 0,
        prazo7: 0,
      }
    }
  }

  $('#btnMarkupProduto').on('click', function () {
    const markup = pegaChave('#txtMarkup')
    if (validarDadosModalMarkup(markup)) {
      carregarModalMarkup(markup)
    }
  })

  function validarDadosModalMarkup(markup) {
    if (!markup) {
      msgErro('Markup não informado, impossível continuar.')
      return
    }

    return true
  }

  function carregarModalMarkup(markup) {
    $.LoadingOverlay('show')
    buscarDadosModalMarkup(
      markup
    ).then(({ indices, dadosCusto }) => {
      if (indices) {
        criarTabelaIndicesModalMarkup(indices)
      }
      if (dadosCusto) {
        alimentarCamposCustoModalMarkup(dadosCusto)
      }
      $('#modalMarkup').modal('show')
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => {
      $.LoadingOverlay('hide')
    })
  }

  async function buscarDadosModalMarkup(markup) {
    const filtros = {
      idPreco: $('#txtIdPreco').val(),
      markup,
    }
    const response = await requisicao("GET", `/Sisplan/formacaocustos/v1/retornardadosmodalmarkup?`, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)

    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado || {
        indices: [],
        dadosCusto: null,
      }
    }
  }

  function criarTabelaIndicesModalMarkup(data) {
    if ($.fn.DataTable.isDataTable('#tabelaIndicesMarkup')) {
      $('#tabelaIndicesMarkup').DataTable().destroy()
      $('#tabelaIndicesMarkup').empty()
    }

    const columns = [
      {
        title: 'Código',
        data: 'codigo',
      },
      {
        title: 'Descrição',
        data: 'descricao',
      },
      {
        title: 'Nacional',
        data: 'nacional',
        render: function (value, _1, _2, { row }) {
          const formattedValue = parseFloat(value).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
          return `<div class="input-group-append">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right quatroCasasDecimaisCurrencyFormat" id="txtNacional${row}" name="txtNacional${row}" placeholder="0,0000">
                  </div>`
        },
      },
      {
        title: 'Exportação',
        data: 'exportacao',
        render: function (value, _1, _2, { row }) {
          const formattedValue = parseFloat(value).toLocaleString("pt-br", {
            maximumFractionDigits: 4,
            minimumFractionDigits: 4,
          })
          return `<div class="input-group-append">
                      <input type="text" value="${formattedValue}" style="min-width: 15ch; max-width: 20ch" class="input-default focus form-control validate text-right quatroCasasDecimaisCurrencyFormat" id="txtExportacao${row}" name="txtExportacao${row}" placeholder="0,0000">
                  </div>`
        },
      },
      {
        title: 'Valor',
        data: 'valor',
        class: "text-right",
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 6,
              minimumFractionDigits: 6,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 6,
            minimumFractionDigits: 6,
          })
        },
      },
      {
        title: 'Tipo',
        data: 'tipo',
      },
    ]

    $("#tabelaIndicesMarkup").DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      info: false,
      filter: false,
      autoWidth: true,
      data,
      columns,
    }).draw(false)
    
    adicionaFormatacaoCurrencyModalMarkup()
  }

  function alimentarCamposCustoModalMarkup({ taxa, dias, prazoAtual, }) {
    insereValor('#txtTaxaMarkup', taxa)
    const { prazo1, prazo2, prazo3, prazo4, prazo5, prazo6, prazo7, } = dias
    if (!prazo1 || prazo1 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo1}">${prazo1}</option>`)
    if (!prazo2 || prazo2 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo2}">${prazo2}</option>`)
    if (!prazo3 || prazo3 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo3}">${prazo3}</option>`)
    if (!prazo4 || prazo4 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo4}">${prazo4}</option>`)
    if (!prazo5 || prazo5 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo5}">${prazo5}</option>`)
    if (!prazo6 || prazo6 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo6}">${prazo6}</option>`)
    if (!prazo7 || prazo7 <= 0) {
      return
    }
    $('#selectDiasMarkup').append(`<option value="${prazo7}">${prazo7}</option>`)
    if (prazoAtual > 0) {
      $('#selectDiasMarkup').val(prazoAtual)
    }
  }

  $('#btnFecharModalMarkup').on('click', function () {
    $('#modalMarkup').modal('hide')
  })

  $(document).keydown(function (e) {
    if (e.which === 121) {
      e.preventDefault()
      $('#btnMarkupProduto').trigger('click')
    }
  })

  $('#modalMarkup').on('hide.bs.modal', function () {
    if ($.fn.DataTable.isDataTable('#tabelaIndicesMarkup')) {
      $('#tabelaIndicesMarkup').DataTable().destroy()
      $('#tabelaIndicesMarkup').empty()
    }
    $('#txtCustoIndustrialMarkup').val('')
    $('#selectDiasMarkup').empty()
    $('#txtTaxaMarkup').val('')
    $('#txtIndiceMarkup').val('')
    $('#txtMarkupSemLucroMarkup').val('')
    $('#txtCustoMarkup').val('')
    $('#txtPrecoAVista').val('')
    $('#txtMarkupFinanceiroMarkup').val('')
    $('#txtIndiceFinanceiroMarkup').val('')
  })
})