let idItens = [];
let atualizaSolicitacao = [];
let solicitacaoInclusa = [];

criaDataTablePadrao('#tabelaItensConsignado', false, false, false, false, true, true, '400px', null, null, [], [], [], [], {}, 2, '', '', false, [], []);

function validaItens() {
    if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
        ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
        ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
        msgAlerta('Ordem de compra sem itens, impossível continuar');
        return false;
    } return true;
};

function totalQuantidade() {
    $('#txtQtdeTotal').val(TruncaDecimaisNova(2, $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[6] }, 0)))
}

function totalValorItem() {
    $('#txtValorTotalItem').val(TruncaDecimaisNova(2, $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[8] }, 0)))
}

function totalValorLiquido() {
    const preco = $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[8] }, 0)
    const desconto = $('#tabelaItensConsignado').DataTable().rows().data().reduce((acc, current) => { return acc + current[9] }, 0)

    const total = preco - desconto

    $('#txtValorTotal').val(TruncaDecimaisNova(2, total))
}

function limpaCamposModalSolicitacao() {
    $("#txtDataEmiDe").val("1200-01-01");
    $("#txtDataEmiAte").val("2500-12-01");
    $("#txtDataEntregaDe").val("1200-01-01");
    $("#txtDataEntregaAte").val("2500-12-01");
    $("#txtSolicitacaoConsulta").val('');
    $("#listaSolicitacaoConsulta").val('');
    $("#txtMaterialConsulta").val('');
    $("#listaMaterialConsulta").val('');
    $("#txtProdutoConsulta").val('');
    $("#listaProdutoConsulta").val('');
    $("#txtGrupoConsulta").val('');
    $("#listaGrupoConsulta").val('');
    $("#txtSubGrupoConsulta").val('');
    $("#listaSubGrupoConsulta").val('');
    $('#chkAprovado').prop('checked', false);
    limpaTabela();
};

function addSelected(add = true) {
    for (let i = 0; i < $('#tabelaSolicitacao').DataTable().rows().data().length; i++) {
        if (add) {
            $($("table#tabelaSolicitacao tr")[i + 1]).addClass("selected");
        } else {
            $($("table#tabelaSolicitacao tr")[i + 1]).removeClass("selected");
        }
    }
};

function botaoSelecionarGrid() {
    return (
        '<div class="form-check">' +
        '<input type="checkbox" class="align-self-center checkSolicitacao" value"" checked>' +
        '</div>'
    );
};

function preencheComZero() {
    setTimeout(() => {
        $('.camposGrade').map((index) => {
            if ($($('.camposGrade')[index]).val() == '') {
                $($('.camposGrade')[index]).val('0');
            }
        });
    }, 100);
};

function limpaCamposProduto() {
    $('#txtProduto').val('');
    $('#txtCor').val('');
    $('#txtTamanho').val('');
    $('#txtTotal').val('');
    $('#txtQtde').val('');
    $('#txtPreco').val('');
    $('#txtDesconto').val('');
};

$('#tabelaItensMaterial').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

$('#tabelaItensProduto').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

async function BuscaPreco(item = {}) {
    let where = '';
    let retorno = '';
    let vPreco = 0;
    let desconto = TruncaDecimaisNova(2, $('#txtDesconto').val())

    if (!Object.keys(item).length > 0) {
        item.codigo = pegaChave('#txtProduto')
        item.cor = pegaChave('#txtCor')
        item.tamanho = pegaChave('#txtTamanho')
        item.tabPreco = pegaChave('#txtTabelaPreco')
    }

    const { codigo, cor, tamanho, tabPreco } = item

    try {
        const getPreco = (query) => retornaJsonPesquisaPadrao(JSON.stringify(query));

        if ($('#txtTipoConsignado').val() === 'N') {
            where = `AND VEN.CODCLI = '${pegaChave('#txtCliente')}'
                    AND VEN.EMP_ID = ${getCookie('g_emp_id')}
                    AND VEN.SITUACAO = 'P'
                    AND VEN.STATUS = ''
                    AND ITENS.TIPO = 'S'
                    AND ITENS.CODIGO = '${codigo}'
                    AND ITENS.COR = '${cor}'
                    AND ITENS.TAM = '${tamanho}'`;

            const pesquisa = {
                tabela: 'VEN_CONSIG',
                innerJoin: [{ tabela: 'VEN_CONSIG_ITENS', condicao: 'VEN.ID = ITENS.ID_VEN_CONSIG', alias: 'ITENS' }],
                camposSelect: ['PRECO', 'DESCONTO', 'QTDE'],
                orderBy: ['PRECO DESC'],
                where: [`1=1 ${where}`]
            };

            retorno = await getPreco(pesquisa);
            if (retorno.length > 0) {
                for (let item of retorno) {
                    const { PRECO, DESCONTO, QTDE } = item;
                    vPreco = DESCONTO > 0 ? PRECO - (PRECO * (DESCONTO / 100)) : PRECO;

                    const itemEncontrado = await verificaItemTabela({
                        codigo,
                        cor,
                        tamanho,
                        preco: vPreco.toFixed(2),
                        qtde: QTDE
                    });

                    if (!itemEncontrado) return;
                }
            }
        } else {
            if ($('#cbTabPreco').is(':checked')) {
                where = `
                        AND CODIGO = '${codigo}'
                        AND REGIAO = '${tabPreco}'
                    `;
                const pesquisa = {
                    tabela: 'TABPRECO',
                    camposSelect: ['PRECO_00 PRECO', '0 DESCONTO'],
                    where: [`1=1 ${where}`]
                };

                retorno = await getPreco(pesquisa);
                if (retorno.length > 0) {
                    const { PRECO } = retorno[0];
                    vPreco = desconto > 0 ? PRECO - (PRECO * (desconto / 100)) : PRECO;
                }
            } else {
                where = `
                        AND CODIGO = '${codigo}'
                        AND COR = '${cor}'
                        AND TAM = '${tamanho}'
                        AND REGIAO = '${tabPreco}'
                    `;
                const pesquisa = {
                    tabela: 'PRECO_COR_TAM',
                    camposSelect: ['PRECO', '0 DESCONTO'],
                    where: [`1=1 ${where}`]
                };

                retorno = await getPreco(pesquisa);
                if (retorno.length > 0) {
                    const { PRECO } = retorno[0];
                    vPreco = desconto > 0 ? PRECO - (PRECO * (desconto / 100)) : PRECO;
                }
            }
        }


        $('#txtPreco').val(vPreco)
        $('#txtTotal').val(vPreco)
        return { preco: vPreco, desconto: desconto }
    } catch (e) {
        console.error('Erro na busca de preço:', e);
    }
}

async function verificaItemTabela(item) {
    const { codigo, cor, tamanho, preco, qtde } = item;

    const tabelaItens = $('#tabelaItensConsginado');

    const rows = tabelaItens.find('tbody tr');

    for (let i = 0; i < rows.length; i++) {
        const row = $(rows[i]);

        const rowCodigo = row.find('td').eq(0).text();
        const rowCor = row.find('td').eq(1).text();
        const rowTamanho = row.find('td').eq(2).text();
        const rowPreco = row.find('td').eq(3).text();
        const rowQtde = row.find('td').eq(4).text();

        if (rowCodigo === codigo && rowCor === cor && rowTamanho === tamanho && rowPreco === preco && rowQtde === qtde) {
            return true;
        }
    }

    return false;
}

async function confirmaItem() {
    try {
        if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
            $('#modalItem').modal('hide');
            return;
        }

        if ($('#txtProdutoGrade').val() == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        }

        let grade = [];
        const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();

        for (let dado of listaDados) {
            const objeto = Object.entries(dado);
            let coluna;
            const colunas = objeto.map(prop => prop[0]);

            for (let i = 0; i < colunas.length; i++) {
                if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
                    coluna = RetornaIdTamFormatado(colunas[i], true);
                    const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
                    const idFormatado = idSemFormatacao.split("value=")[0];
                    const { preco, desconto } = await BuscaPreco({
                        codigo: pegaChave('#txtProdutoGrade'),
                        cor: dado.COR,
                        tamanho: coluna,
                        tabPreco: pegaChave('#txtTabelaPreco')
                    });

                    const quantidade = $(`#${idFormatado}`).val() ? $(`#${idFormatado}`).val() : 0;
                    const retorno = {
                        codigo: pegaChave('#txtProdutoGrade'),
                        descricao: pegaDescricao('#txtProdutoGrade'),
                        tipo: $('#txtTipoConsignado').val(),
                        cor: dado.COR,
                        tamanho: coluna,
                        quantidade: TruncaDecimaisNova(2, quantidade),
                        tabelaPreco: pegaChave('#txtTabelaPreco'),
                        preco: TruncaDecimaisNova(2, preco),
                        desconto: desconto,
                        preco: TruncaDecimaisNova(2, preco),
                        barra: '',
                        barra28: '',
                    };
                    grade.push(retorno);
                }
            }
        }

        grade.forEach(item => {
            if (parseFloat(item.quantidade) > 0) {
                addItem(item);
            }
        });

        totalQuantidade();
        totalValorLiquido();
        totalValorItem();
        $('#modalItem').modal('hide');
        limpaCamposProduto();

    } catch (error) {
        console.error('Erro ao confirmar item:', error);
    }
}

function calcularPrecoTotal() {
    let preco = TruncaDecimaisNova(2, $('#txtPreco').val());
    let desconto = TruncaDecimaisNova(2, $('#txtDesconto').val());
    let quantidade = TruncaDecimaisNova(2, $('#txtQtde').val());

    if (!preco || !quantidade || preco <= 0 || quantidade <= 0) {
        $('#txtTotal').val('');
        return;
    }

    if (desconto === undefined || desconto < 0) {
        desconto = 0;
    }
    let precoFinal = preco;

    if (desconto > 0) {
        if ($('#tpDesconto').val() === '0') {
            precoFinal = preco * (1 - desconto / 100);
        } else {
            precoFinal = preco - desconto;
        }
    }
    if (precoFinal < 0) {
        precoFinal = 0;
    }
    precoFinal *= quantidade;

    $('#txtTotal').val(TruncaDecimaisNova(2, precoFinal));
}

$('#txtDesconto, #txtQtde, #tpDesconto').on('change', calcularPrecoTotal);

async function buscaFotoProduto(codigo, ordem) {
    const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    try {
        const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
        const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

        if (!response) {
            return;
        }
        const jsonStr = await response.json();
        if (response.status != 200) {
            $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
            return;
        }

        const sBase64 = jsonStr;
        $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
        console.error(error);
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
};

function retornaFotoProduto(codigo, ordem) {
    buscaFotoProduto(codigo, ordem);
    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
};

function criptografaCodigo(codigo) {
    return btoa(codigo).replaceAll('=', '');
};

function editaProduto(item, index) {
    insereValor('#txtProduto', item[0], item[1]);
    insereValor('#txtCorProduto', item[2], '');
    insereValor('#txtTamProduto', item[3], '');
    insereValor('#txtDepositoProduto', item[4], '');
    insereValor('#txtCentroCustoProduto', item[6], '');
    insereValor('#txtContaContProduto', item[7], '');
    insereValor('#txtEspecificacaoProduto', item[8]);
    insereValor('#txtCodFornecProduto', item[9]);
    insereValor('#txtUniCompraProduto', item[10]);
    insereValor('#txtUniVendaProduto', item[11]);
    insereValor('#txtICMSProduto', item[12]);
    insereValor('#txtIPIProduto', item[13]);
    insereValor('#txtSTProduto', item[14]);
    insereValor('#txtQtdeProduto', item[15]);
    insereValor('#txtPrecoProduto', item[18]);
    insereValor('#txtDescontoProduto', item[19]);
    insereValor('#txtTotalProduto', item[20]);
    insereValor('#txtTotalIPIProduto', item[21]);
    insereValor('#txtIndexProd', index);
};

function retornaCondicoesPgto() {
    let sCondicoes = '';
    for (let i = 1; i <= 27;) {
        if ((sCondicoes.length % 3) != 0) {
            sCondicoes += ' ';
        } else {
            if ($('#txtCondPagto' + i).val()) {
                sCondicoes += $('#txtCondPagto' + i).val();
            };
            i++;
        }
    }
    return sCondicoes;
};

function adicionaIdExclusao(id_iten) {
    idItens.push({
        ID_ITEN: id_iten
    });
};

function retornaProximaOrdem() {
    let ordem = 0;

    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        ordem = item[24] > ordem ? item[24] : ordem;
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        ordem = item[24] > ordem ? item[24] : ordem;
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        ordem = item[16] > ordem ? item[16] : ordem;
    });

    return ++ordem;
};

function retornaValorFloat(valor) {
    return isNaN(parseFloat(valor)) ? 0 : parseFloat(valor)
};

function retornaItens() {
    let arrItens = [];
    $('#tabelaItensConsignado').DataTable().rows().data().map(item => {
        arrItens.push({
            codigo: item[1],
            cor: item[3],
            tam: item[4],
            quantidade: item[5],
            preco: item[6],
            desconto: item[7],
        })
    });

    return arrItens;
};

function adicionaBotoes() {
    return '<div class="divBtnOpcoes"> ' +
        '       <button class="botaoOpcoes btn-editar" type="button" title="Editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
        '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
        '     </div>';
};

function addItem(sItem) {
    if (!$('#txtTipoConsignado').val()) {
        $('#txtTipoConsignado').val(sItem.tipo)
        $('#txtTipoConsignado').prop('disabled', true)
    }
    if (!$('#txtTabelaPreco').val()) {
        insereValor('#txtTabelaPreco', sItem.tabelaPreco, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: sItem.tabelaPreco })
    }

    const tabelaItensConsignado = $('#tabelaItensConsignado').DataTable()
    const existeItemTabela = tabelaItensConsignado.rows().data().toArray().some((linha) =>
        linha[0] == sItem.CODIGO && linha[2] == sItem.COR && linha[3] == sItem.TAM
    );

    if (existeItemTabela) {
        return msgAlertaSemConfirmacao('Item já foi adicionado no consignado. Por favor, verifique.')
    }

    tabelaItensConsignado.row.add(
        [
            adicionaBotoes(),
            sItem.codigo,
            sItem.descricao,
            sItem.tipo,
            sItem.cor,
            sItem.tamanho,
            sItem.quantidade,
            sItem.tabelaPreco,
            sItem.preco,
            sItem.desconto,
            sItem.preco * sItem.quantidade,
            sItem.barra,
            sItem.barra28,
        ]).draw(false);
};

$('#txtObservacao').on('keydown', function (e) {
    if (e.key === 'Enter') {
        e.preventDefault()
        var cursorPos = this.selectionStart;
        var value = $(this).val();
        $(this).val(value.substring(0, cursorPos) + "\n" + value.substring(cursorPos));
        this.selectionStart = this.selectionEnd = cursorPos + 1;
    }
});

$('#txtBarra').on('blur', async function () {
    const barra = $(this).val()
    if (barra && barra !== '') {
        await bipaBarra(barra);
    }
})

$('#txtBarra').on('keydown', function (e) {
    if (e.key === 'Enter') {
        $('#txtBarra').trigger('blur')
    }
})

async function bipaBarra(barra) {
    $.LoadingOverlay('show')
    try {
        if (!$('#txtTipoConsignado').val()) {
            return msgAlerta('Tipo não informado. Por favor, verifique!')
        }
        if (barra == '') {
            return;
        }
        const tabPreco = pegaChave('#txtTabelaPreco')
        if (!tabPreco || tabPreco === '' || tabPreco === '999') {
            msgErro('Tabela de preço não informada, impossível continuar.')
            return
        }

        const bBarraLog = await CopiaParametro('SISTEMA', 0);
        let barraLog = false;
        let barra28 = '';
        if ((bBarraLog === '1') || (bBarraLog === '2')) {
            barra28 = await extraiBarra28(barra);
            if (barra28 && (barra28 != '')) {
                barraLog = barra;
                barra = barra28;
            }
        }

        if (!barraLog && (bBarraLog == '2')) {
            msgAlerta('Necessário bipar uma barra log.', undefined, undefined, () => { $('#txtBarra').val('').focus() });
            $('#txtBarra').val('').focus();
            return;
        }

        await bipaBarraProduto(barraLog || barra, tabPreco);
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao bipar a barra, tente novamente.')
    } finally {
        $(`#txtBarra`).val('');
        $(`#txtBarra`).focus();
        $.LoadingOverlay('hide')
    }
}
async function bipaBarraProduto(barra, tabelaPreco) {
    try {
        const tipoBarra = await retornaTipoBarra(barra)

        const dadosBarra = await retornaProdutoBarra(barra, tipoBarra === 'barra_log')
        if (dadosBarra && dadosBarra.length > 0) {
            const item = dadosBarra[0];

            let precoTabPreco;
            // if (BuscaPorCorETam == 1) {
            precoTabPreco = await retornaPrecoCorTamProdutoAoBiparBarra(tabelaPreco, item.CODIGO, item.COR, item.TAM);
            // } else {
            //     precoTabPreco = await retornaPrecoProduto(tabelaPreco, item.CODIGO);
            // }
            if (!precoTabPreco || precoTabPreco === 0) {
                msgErro('Preço na tabela de preço informada está zerado, impossível continuar.')
                return
            }

            const dados = $('#tabelaItensConsignado').DataTable().rows().data().toArray()
            const indiceProdutoEncontrado = dados.findIndex(e =>
                e[1] === item.CODIGO &&
                e[4] === item.COR &&
                e[5] === item.TAM
            )
            if (tipoBarra !== 'barra_log') {
                const parametroValidarEstoque = await CopiaParametro('PEDIDO', 3)
                if (parametroValidarEstoque !== '0') {
                    const objProduto = {
                        CODIGO: item.CODIGO,
                        COR: item.COR,
                        TAM: item.TAM,
                        DEPOSITO: pegaChave('#txtDeposito'),
                        QTDE: indiceProdutoEncontrado !== -1 ? dados[indiceProdutoEncontrado][7] : 0
                    }
                    let response = await requisicao("POST", `/Sisplan/pedido/V1/validaestoquebarra?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}&PARAMETRO_ESTOQUE=${parametroValidarEstoque}`, JSON.stringify(objProduto));

                    if (!response) {
                        return;
                    }

                    let msgResposta = await response.json();
                    if (response.status != 200) {
                        msgErro(msgResposta.mensagem);
                        return;
                    }
                }
            } else {
                if (listaBarrasLog.find(e => e.BARRA === barra)) {
                    msgErro('Barra já foi bipada, favor verificar.')
                    return;
                }

                if (!await validaBarraLogLiberada(barra.replaceAll('#', '[HASHTAG]'))) {
                    msgErro('Barra já foi lida, favor verificar.')
                    return;
                }

                listaBarrasLog.push({
                    BARRA: barra,
                    CODIGO: item.CODIGO,
                    COR: item.COR,
                    TAM: item.TAM
                })
            }

            if (indiceProdutoEncontrado !== -1) {
                const dadosIndice = $('#tabelaItensConsignado').DataTable().row(indiceProdutoEncontrado).data()
                dadosIndice[6] = parseFloat(dadosIndice[6]) + 1
                let grade = [{
                    codigo: dadosIndice[1],
                    descricao: dadosIndice[2],
                    tipo: dadosIndice[3],
                    cor: dadosIndice[4],
                    tamanho: dadosIndice[5],
                    quantidade: dadosIndice[6],
                    tabelaPreco: dadosIndice[7],
                    preco: parseFloat(dadosIndice[8]),
                    desconto: dadosIndice[9],
                    precoTotal: parseFloat(dadosIndice[8]) * dadosIndice[6],
                    barra: dadosIndice[11],
                    barra28: dadosIndice[12],
                }]

                // if ($('#cbRegraPromocao').prop('checked') && (tabelaPreco && tabelaPreco !== '' && tabelaPreco !== '999')) {
                //     grade = await aplicaRegraPromocao(grade)
                // }

                // grade[0] = { ...grade[0], ORDEM: 1 } // feito gravar como 1 pois é assim que está fixo nos outros lugares

                const table = $('#tabelaItensConsignado').DataTable();

                //const rowNode = 
                table.row(indiceProdutoEncontrado).data([
                    adicionaBotoes(),
                    grade[0].codigo,
                    grade[0].descricao,
                    grade[0].tipo,
                    grade[0].cor,
                    grade[0].tamanho,
                    grade[0].quantidade,
                    grade[0].tabelaPreco,
                    grade[0].preco,
                    grade[0].desconto,
                    grade[0].precoTotal,
                    grade[0].barra,
                    grade[0].barra28,
                ]).draw(false).node();

                // const input = $(rowNode).find('[id^="txtLote_"]');
                // const inputDeposito = $(rowNode).find('[id^="txtDeposito_"]');
                // const idItem = input.attr('id').split('_')[1];
                // const codigo = grade[0].CODIGO;
                // const cor = grade[0].COR;
                // const tam = grade[0].TAM;

                // pesquisaLote(input, idItem, 'P', codigo, cor, tam, inputDeposito.val());
                // const idItemDeposito = inputDeposito.attr('id').split('_')[1];
                // pesquisaDeposito(inputDeposito, idItemDeposito);
            } else {
                let grade = [{
                    codigo: item.CODIGO,
                    descricao: item.DESCRICAO,
                    tipo: $('#txtTipoConsignado').val(),
                    cor: item.COR,
                    tamanho: item.TAM,
                    deposito: pegaChave('#txtDeposito'),
                    quantidade: 1,
                    tabelaPreco: tabelaPreco,
                    preco: precoTabPreco,
                    desconto: 0,
                    precoTotal: precoTabPreco,
                    barra: barra,
                    barra28: ''
                }]

                // if ($('#cbRegraPromocao').prop('checked') && (tabelaPreco && tabelaPreco !== '' && tabelaPreco !== '999')) {
                //     grade = await aplicaRegraPromocao(grade)
                // }

                // grade[0] = { ...grade[0], PRECO_ORIG: precoTabPreco }

                addItem(grade[0])
            }

            totalQuantidade()
            totalValorLiquido()
            totalValorItem()

            // $('.selected').removeClass('selected')
            // $($('#tabelaItensConsignado tbody tr')[indiceProdutoEncontrado !== -1 ? indiceProdutoEncontrado : $('#tabelaItensConsignado').DataTable().rows().count() - 1]).click();
            // $('#tabelaItensConsignado').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
        } else {
            msgErro('Barra não encontrada, favor verificar.')
            return
        }
    } finally {
        $(`#txtBarra`).val('');
        $(`#txtBarra`).focus();
    }
}

async function retornaPrecoCorTamProdutoAoBiparBarra(sTabPreco, sCodProd, sCor, sTam) {
    const dadosSelect = {
        tabela: 'PRECO_COR_TAM',
        camposSelect: ['PRECO'],
        where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}' AND COR = '${sCor}' AND TAM = '${sTam}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
        return;
    }
    if (retornoSelect.length == 0) {
        return;
    }

    return retornoSelect[0].PRECO;
};

async function retornaPrecoProduto(sTabPreco, sCodProd) {
    const dadosSelect = {
        tabela: 'TABPRECO',
        camposSelect: ['PRECO_00'],
        where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
        return;
    }
    if (retornoSelect.length == 0) {
        return;
    }
    return retornoSelect[0].PRECO_00;
};

async function retornaProdutoBarra(sBarra, bBarraLog) {
    let barra28 = sBarra.substr(0, 6);
    if (bBarraLog) {
        barra28 = await extraiBarra28(sBarra);
    }
    const deposito = pegaChave('#txtDeposito');

    if (deposito == '') {
        msgAlerta('Depósito não informado, impossível continuar!');
        SomAlerta(BASE_URI, true);
        return;
    }

    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM"],
    "innerjoin": [
        { "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR"}
    ],
    "where": ["PA_ITEN.DEPOSITO = '${deposito}' AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barra28}' OR PA_ITEN.BARRACLI = '${sBarra}')"]}`);

    try {
        let response = await requisicao('GET', url, params, null);
        if (!response) {
            return '';
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            SomAlerta(BASE_URI, true);
            return '';
        }

        return jsonStr.RESULT[0];

    } catch (error) {
        console.error(error);
        SomAlerta(BASE_URI, true);
        msgErro('Não foi possível buscar os dados da barra.');
        return '';
    }
}

$("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
        txtCliente: {
            required: true,
        },
        txtVendedor: {
            required: true,
        },
        txtStatus: {
            required: true,
        },
    },
    messages: {
        txtCliente: {
            required: "Informe um cliente",
        },
        txtVendedor: {
            required: "Informe um vendedor.",
        },
        txtStatus: {
            required: "Informe um status.",
        },
    },
    errorElement: "span",
    errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
    },
    highlight(element) {
        $(element).addClass("is-invalid");
    },
    unhighlight(element) {
        $(element).removeClass("is-invalid");
    },
    invalidHandler(e, validator) {
        if (validator.errorList.length) {
            console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
        }
    },

    async submitHandler(form, event) {
        event.preventDefault();
        try {
            $.LoadingOverlay("show");
            try {
                const consignado = {
                    data: pegaValor('#dtIni'),
                    codcli: pegaChave('#txtCliente'),
                    vendedor: pegaChave('#txtVendedor'),
                    dias: pegaValor('#txtDias'),
                    dataAcerto: pegaValor('#dtAcerto'),
                    valorMinimo: pegaValor('#txtValorMinimo'),
                    deposito: pegaChave('#txtDeposito'),
                    obs: pegaValor('#txtObservacao'),
                    itens: retornaItens(),
                };

                let response = await requisicao("POST", `/sisplan/consignado/v1/gravar?`, '', consignado);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr
                    .success("Cadastro efetuado com sucesso!", "Confirmação", {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/consignado`;
                        },
                    })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
            } catch (error) {
                console.error(error);
                msgAlerta('Não foi possível gravar os dados do consignado!');
            }

        } finally {
            $.LoadingOverlay("hide");
        }
    },
});

// async function gravaDados() {
//     $.LoadingOverlay('show');
//     try {
//         // if (idItens.length > 0) {
//         //     const itensExcluir = {
//         //         NUMERO: pegaValor('#txtNumero'),
//         //         ITENS: idItens
//         //     };
//         //     await requisicao('POST', '/sisplan/consignado/v1/gravar?', '', JSON.stringify(itensExcluir), 90000); //Necessário fazer no post pois o delete não envia o body
//         // };

//         const consignado = {
//             numeroDocumento: pegaValor('#txtNumero'),
//             data: pegaValor('#dtIni'),
//             codcli: pegaChave('#txtCliente'),
//             vendedor: pegaChave('#txtVendedor'),
//             dias: pegaValor('#txtDias'),
//             dataAcerto: pegaValor('#dtAcerto'),
//             valorMinimo: pegaValor('#txtValorMinimo'),
//             deposito: pegaChave('#txtDeposito'),
//             itens: retornaItens(),
//         };

//         const response = await requisicao('POST', '/sisplan/consignado/v1/gravar?', '', JSON.stringify(consignado), 90000);

//         if (!response) {
//             $.LoadingOverlay('hide');
//             return;
//         }

//         const jsonStr = await response.json();
//         if (response.status != 200) {
//             $.LoadingOverlay('hide');
//             msgAlerta(jsonStr.mensagem);
//             return;
//         }

//         $.LoadingOverlay('hide');
//         criaMensagemSucesso(`Ordem de compra ${pegaValor('#txtNumero')} gravada com sucesso!`, () => { window.location.href = `${BASE_URI}/consignado`; });
//     } catch (error) {
//         console.error(error);
//         $.LoadingOverlay("hide");
//         msgAlerta(`Não foi possível gravar os dados da ordem de compra: ${error}`);
//     }
// };

function retornaMultiplicacao(value1, value2, value3) {
    let valor = (value1 * value2);
    valor = valor - (value3 > 0 ? (valor * (value3 / 100)) : 0);
    return valor;
};

function adicionaPaginacao() {
    $(".next").click(async function () {
        let validator = $("#msform").validate();
        let liberado = true;

        if ($(this).attr("id") == "avancar1") {
            validator.element("#txtCliente");
            validator.element("#txtVendedor");
            validator.element("#txtStatus");
        }

        if (!(validator.element("#txtCliente") && validator.element("#txtVendedor") && validator.element("#txtStatus"))) {
            liberado = false;
        }

        if ($(this).attr("id") == "avancarItens") {
            liberado = validaItens();
        }

        if (liberado) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();
            $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
            nextFs.show();
            currentFs.animate({
                opacity: 0,
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    nextFs.css({
                        opacity,
                    });
                },
                duration: 600,
            });
            $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);
        }
    });

    $(".previous").click(async function () {
        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();

        $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");

        previousFs.show();

        currentFs.animate({
            opacity: 0,
        }, {
            step(now) {
                opacity = 1 - now;

                currentFs.css({
                    display: "none",
                    position: "relative",
                });
                previousFs.css({
                    opacity,
                });
            },
            duration: 600,
        });
    });
};

$(document).ready(async function () {

    async function setaDatas() {
        await setarDataAtual('txtDataEntrega');
        await setarDataAtual('txtDtEmissao');
    };

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    adicionaPaginacao();
    adicionaMascaraCampos();
    adicionaValidacoes();
    await setaDatas();

    function adicionaValidacoes() {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtCliente: {
                    required: true,
                },
                txtVendedor: {
                    required: true,
                },
                txtDeposito: {
                    required: true,
                },
                txtStatus: {
                    required: true,
                },
            },
            messages: {
                txtCliente: {
                    required: "Informe um cliente.",
                },
                txtVendedor: {
                    required: "Informe um vendedor.",
                },
                txtDeposito: {
                    required: "Informa um depósito.",
                },
                txtStatus: {
                    required: "Informe um status",
                },
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });
    };

    $('#txtSolicitacao').on('keydown', (event) => {
        const keyName = event.key;

        if (keyName === 'F8') {
            event.preventDefault();
            $('#modal-Solicitacao').modal('show');
        };
    });

    await validaEdicao();

    async function buscaConsignado(id) {
        $.LoadingOverlay('show')
        try {

            const response = await requisicao('GET', '/sisplan/consignado/v1/buscaconsignado?', `&ID=${id}`, ``, 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgAlerta(jsonStr.mensagem);
                return;
            }

            return jsonStr

        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAdicionar').on('click', function () {
        $('#modalItem').modal('show');
    });

    async function validaEdicao() {
        const sId = $(window.location.href.split('/')).get(-1);

        if (sId == 'create') {
            $('#txtDocumento').val(parseInt(await RetornaProximo('VEN_CONSIG', 'VEN_CONSIG', 'ID', 0)))
            return;
        };

        $.LoadingOverlay('show');
        try {
            const dados = await buscaConsignado(sId);

            insereValor('#txtDocumento', dados.numeroDocumento);
            insereValor('#txtCliente', dados.codcli, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: dados.codcli });
            insereValor('#txtVendedor', dados.vendedor, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: dados.vendedor });
            insereValor('#txtDeposito', dados.deposito, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.deposito });
            insereValor('#txtStatus', dados.status, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.status });
            insereValor('#dtIni', dados.data.slice(0, 10));
            insereValor('#txtHora', dados.data.slice(11, 19));
            insereValor('#txtDias', dados.dias);
            insereValor('#dtAcerto', formataDataComTraco(dados.dataAcerto));
            insereValor('#txtValorMinimo', dados.valorMinimo);
            insereValor('#txtObservacao', dados.observacao);
            insereValor('#txtTipoConsignado', dados.tipo);

            $('.campoDeposito').prop('disabled', dados.deposito)
            $('#txtDeposito').blur()

            dados.itens.map(item => { addItem(item) });

            totalQuantidade()
            totalValorLiquido()
            totalValorItem()
            $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    componenteFiltro('cliente', false, false)
    componenteFiltro('representante', false, false, 'Vendedor')
    componenteFiltro('status')
    componenteFiltro('depositoUsuario', false, false, 'Deposito', [], false, rotinaSaidaDeposito)
    componenteFiltro('tabPreco', false, false, 'TabelaPreco')

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $("#btnProduto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btnLimpaProduto').on('click', function () { $('#txtProduto, #txtValor, #txtQuantidadeEstoque').val('') });
    componenteFiltro('cor', false, false)
    componenteFiltro('tamanho2', false, false, 'Tamanho')

    $('#txtProdutoGrade').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $("#btnProdutoGrade").pesquisa_serverside(["#txtProdutoGrade"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btnLimpaProdutoGrade').on('click', function () { $('#txtProdutoGrade, #txtValorGrade, #txtQuantidadeEstoqueGrade').val('') });

    rotinaSaidaProduto()
    rotinaSaidaCor()

    function rotinaSaidaDeposito() {
        $("#txtDeposito").on("blur", async function () {
            const sDeposito = pegaChave("#txtDeposito");

            $("#txtProduto").autocompleta(
                1,
                `JSON={"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                ['#txtTotal'],
                ['CUSTO'],
                ['CUSTO'],
                BuscaPreco
            );

            $('#btnProduto').pesquisa_serverside(
                ['#txtProduto', '#txtTotal'],
                ['PRODUTO.CODIGO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                ['PRODUTO.DESCRICAO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                `{"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "camposWhereServerSide":["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                'Pesquisa de Produto',
                BuscaPreco,
                [false, true]
            );

            $('#btnLimpaProduto').on('click', function () {
                $('#txtProduto').val('')
            })

            rotinaSaidaProduto()
        })
    }

    function rotinaSaidaProduto() {
        $("#txtProduto").on("blur", async function () {
            $("#txtCor").autocompleta(
                1,
                `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND QUANTIDADE > 0)"], "orderBy": ["COR ASC"]}`,
                [],
                [],
                [],
                BuscaPreco
            );

            $("#btnCor").pesquisa_array(
                ["#txtCor"],
                ["CHAVE"],
                ["DESCRICAO"],
                `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND QUANTIDADE > 0)"], "orderBy": ["COR ASC"]}`,
                "Pesquisa Cor",
                "cadcor",
                BuscaPreco
            )

            $('#btnLimpaCor').on('click', function () {
                $('#txtCor').val('')
            })

            rotinaSaidaCor()
        });
    }

    function rotinaSaidaCor() {
        $("#txtCor").on("blur", async function () {
            $("#txtTamanho").autocompleta(
                1,
                `JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "FAIXA DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND COR='${pegaChave(
                    "#txtCor"
                )}' AND QUANTIDADE > 0)"], "orderBy": ["TAM ASC"]}`,
                [],
                [],
                [],
                BuscaPreco
            );

            $("#btnTamanho").pesquisa_array(
                ["#txtTamanho"],
                ["CHAVE"],
                ["DESCRICAO"],
                `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABTAM", "camposSelect": ["TAM CHAVE", "FAIXA DESCRICAO"], "where": ["TAM IN (SELECT DISTINCT TAM FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND COR='${pegaChave(
                    "#txtCor"
                )}' AND QUANTIDADE > 0)"], "orderBy": ["TAM ASC"]}`,
                "Pesquisa Tamanho",
                "TABTAM",
                BuscaPreco
            )

            $('#btnLimpaCor').on('click', function () {
                $('#txtCor').val('')
            })
        });
    }

    $("#Totais").on('click', function () {
        if (!$('#multiCollapseExample4').hasClass('show')) {
            geraTotais();
        }
    });

    $('#txtFrete').on('blur', function () {
        insereValor('#txtFretePagamento', pegaValor('#txtFrete'))
    });

    // $('.camposGrade').on('blur', function () {
    //     $("#tabelaGradeProduto").DataTable().columns.adjust().draw(false);   
    // });

    // $('#avancar1').on('click', function () {
    //     totalizarItens();
    // });

    $('#modalItem').on('hidden.bs.modal', function (_) {
        $('#txtProdutoGrade').val('');
        if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
            $('#tabelaGradeProduto').DataTable().destroy();
            $('#tabelaGradeProduto').empty();
        };
    });

    $('#txtProdutoGrade').on('blur', async function () {
        const codigo = pegaChave('#txtProdutoGrade');

        if (codigo == '') {
            return;
        };
        if ((await buscaValor('PRODUTO', 'ATIVO', 'CODIGO', codigo)).ATIVO == 'N') {
            msgAlerta('Produto inativo, impossível continuar.');
            limpaValor('#txtProduto');
            return;
        };

        await explodeGradeProduto(codigo);
    });

    async function explodeGradeProduto(codigo) {
        $.LoadingOverlay('show');
        try {
            let tam;
            if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
                $('#tabelaGradeProduto').DataTable().destroy();
                $('#tabelaGradeProduto').empty();
            };

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
            }

            for (let i = 0; i < parseInt(jsonStr.length); i++) {
                const colunas = Object.keys(jsonStr[i]);
                const tamanhos = [];
                colunas.forEach((coluna) => {
                    if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
                        tamanhos.push(coluna);
                    }
                });

                tamanhos.sort();

                const jsonObject = jsonStr.map(obj => {
                    const newObject = { ...obj };
                    delete newObject.CODIGO;
                    delete newObject.POSICAO;
                    Object.keys(obj).forEach(key => {
                        tam = RetornaIdTamFormatado(key);
                        if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
                            newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="${jsonStr[i][tam]}">`;
                            newObject[tam.split('HIFEN')[1]] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="0">`;
                            delete newObject[tam];
                        }
                    });
                    return { ...newObject };
                });

                if (i == 0) {
                    const titulosFixos = ['COR', 'DESC_COR'];
                    const titulosGeral = [...titulosFixos, ...tamanhos];
                    const titulos = titulosGeral.map(titulo => {
                        const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
                        const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
                        return objeto;
                    });
                    criaDataTablePadrao('#tabelaGradeProduto', false, false, false, false, true, false, '250px', jsonObject, titulos);
                }
            }

        } finally {
            $.LoadingOverlay('hide');

            $('.camposGrade').on('blur', function () {
                preencheComZero();
            });

            $('.camposGrade').maskMoney({
                decimal: ".",
                thousands: "",
                precision: 0,
            });
            preencheComZero();
        }
    };

    $("#voltarAcesso").on("click", async function () {
        window.location.href = `${BASE_URI}/consignado`;
    });

    function adicionaMascaraCampos() {
        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == '') {
                $(this).val('0.00');
            }
        });
    };

    $('#tabelaItensProduto').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensProduto').DataTable().row($(this).parents('tr')).data();
        if (itens[23] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaProduto(itens, index);
    });

    $('#tabelaItensConsignado').on('click', '.btn-excluir', async function () {
        adicionaIdExclusao($('#tabelaItensConsignado').DataTable().row($(this).parents('tr')).data()[0]);
        $('#tabelaItensConsignado').DataTable().row($(this).parents('tr')).remove().draw(false);
        // totalizarItens();
    })

    function AdicionarMaterial() {
        const codigo = pegaChave('#txtMaterial');
        const descricao = pegaDescricao('#txtMaterial');
        const cor = pegaChave('#txtCorMaterial');
        const deposito = pegaChave('#txtDepositoMaterial');
        const contaContabil = pegaChave('#txtContaContMaterial');
        const centroCusto = pegaChave('#txtCentroCustoMaterial');
        const codFornecec = pegaValor('#txtCodFornecMaterial');
        const especificacao = $('#txtEspecificacaoMaterial').val();
        const unidade = $('#txtUnidadeMaterial').val();
        const uni_compra = $('#txtUniCompraMaterial').val();
        const icms = $('#txtICMSMaterial').val();
        const divisor = $('#txtDivisorMaterial').val();
        const st = $('#txtSTMaterial').val();
        const ipi = $('#txtIPIMaterial').val();
        const qtde = $('#txtQtdeMaterial').val();
        const preco = $('#txtPrecoMaterial').val();
        const desconto = ($('#txtDescontoMaterial').val() == '') ? 0 : $('#txtDescontoMaterial').val();
        const totalIPI = $('#txtTotalIPIMaterial').val();
        const totalItem = $('#txtTotalItemMaterial').val();
        const indice = pegaValor('#txtIndexMat');
        const ordem = retornaProximaOrdem();

        if (codigo == '') {
            msgAlerta('Material não informado, impossível continuar');
            return;
        };

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        };

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        };

        if ((preco == '') || (preco == 0)) {
            msgAlerta('Preço não informado, impossível continuar.');
            return;
        }

        try {
            if (indice == '') {
                $('#tabelaItensMaterial').DataTable().row.add(
                    [
                        codigo,
                        descricao,
                        cor,
                        deposito,
                        retornaFotoProduto(codigo, ordem),
                        contaContabil,
                        centroCusto,
                        codFornecec,
                        especificacao,
                        unidade,
                        uni_compra,
                        icms,
                        divisor,
                        st,
                        ipi,
                        qtde,
                        0,
                        0,
                        preco,
                        desconto,
                        totalIPI,
                        totalItem,
                        0,
                        'A',
                        ordem,
                        '',
                        '1899-01-01',
                        adicionaBotoes()
                    ]).draw(false);
            } else {
                let data_old = $('#tabelaItensMaterial').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cor;
                data_old[3] = deposito;
                data_old[4] = retornaFotoProduto(codigo, data_old[24]);
                data_old[5] = contaContabil;
                data_old[6] = centroCusto;
                data_old[7] = codFornecec;
                data_old[8] = especificacao;
                data_old[9] = unidade;
                data_old[10] = uni_compra;
                data_old[11] = icms;
                data_old[12] = divisor;
                data_old[13] = st;
                data_old[14] = ipi;
                data_old[15] = qtde;
                data_old[18] = preco;
                data_old[19] = desconto;
                data_old[20] = totalIPI;
                data_old[21] = totalItem;
                $('#tabelaItensMaterial').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposMaterial();
        }
    };

    function AdicionarProduto() {
        const codigo = pegaChave('#txtProduto');
        const descricao = pegaDescricao('#txtProduto');
        const cor = pegaChave('#txtCor');
        const tam = pegaChave('#txtTamanho');
        const deposito = pegaChave('#txtDeposito');
        const qtde = TruncaDecimaisNova(2, $('#txtQtde').val());
        const preco = TruncaDecimaisNova(2, $('#txtPreco').val());
        const precoTotal = TruncaDecimaisNova(2, $('#txtTotal').val());
        const desconto = ($('#txtDesconto').val() == '') ? 0 : TruncaDecimaisNova(2, $('#txtDesconto').val());
        const tipo = $('#txtTipoConsignado').val()
        const tabPreco = pegaChave('#txtTabelaPreco')
        const barra = ''
        const barra28 = ''

        if (codigo == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        }

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        }

        if (tam == '') {
            msgAlerta('Tamanho não informado, impossível continuar');
            return;
        }

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }

        if ((preco == '') || (preco == 0)) {
            msgAlerta('Preço não informado, impossível continuar.');
            return;
        }

        try {
            const tabelaItensConsignado = $('#tabelaItensConsignado').DataTable()

            const existeItemTabela = tabelaItensConsignado.rows().data().toArray().some((linha) =>
                linha[0] == codigo && linha[2] == cor && linha[3] == tam
            );

            if (existeItemTabela) {
                return msgAlertaSemConfirmacao('Item já foi adicionado no consignado. Por favor, verifique.')
            }

            tabelaItensConsignado.row.add(
                [
                    adicionaBotoes(),
                    codigo,
                    descricao,
                    tipo,
                    cor,
                    tam,
                    qtde,
                    tabPreco,
                    preco,
                    desconto,
                    precoTotal,
                    barra,
                    barra28
                ]).draw(false);

        } finally {
            limpaCamposProduto();
        }
    };

    $('#btnGradeProduto').on('click', async function () {
        if (pegaValor('#txtDeposito') == '') {
            msgAlertaSemConfirmacao('Necessário informar um depósito!');
            return;
        }

        // if ((pegaValor('#txtPrecoProduto') <= 0) || (pegaValor('#txtPrecoProduto') == '')) {
        //     msgAlertaSemConfirmacao('Necessário informar o preço!');
        //     return;
        // }
        $('#modalItem').modal('show');
    });

    $('#btnAdicionarProduto').on('click', async function () {
        if (!$('#txtTabelaPreco').val()) {
            return msgAlerta('Tabela de preço não informada. Por favor, verifique!')
        }
        if (!$('#txtTipoConsignado').val()) {
            return msgAlerta('Tipo não informado. Por favor, verifique!')
        }
        AdicionarProduto();
        totalQuantidade()
        totalValorLiquido()
        totalValorItem()
    });

    $('#btnConfirmarItem').on('click', async function () {
        if (!$('#txtTabelaPreco').val()) {
            return msgAlerta('Tabela de preço não informada. Por favor, verifique!')
        }
        if (!$('#txtTipoConsignado').val()) {
            return msgAlerta('Tipo não informado. Por favor, verifique!')
        }
        confirmaItem();
        totalQuantidade()
        totalValorLiquido()
        totalValorItem()
    });

    $('#btnConsultarSolicitacao').on('click', async function () {
        await buscaSolicitacao();
        $('#check_todos').prop('checked', true);
    });

    $('#check_todos').on('click', async function () {
        $('.checkSolicitacao').prop('checked', $('#check_todos').prop('checked'));
        addSelected($('#check_todos').prop('checked'));
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");

            $("#tabelaItensConsignado").DataTable().columns.adjust().draw(false);
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "DadosEntregaAba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Observacoes").collapse("show");
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "ObservacoesAba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "Totais") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "Itens") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Material").collapse("show");
                        $("#ItensMaterial").collapse("show");
                    }
                } else if (Element.node.id == "produto") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Produto").collapse("show");
                        $("#itensProduto").collapse("show");
                    }
                } else if (Element.node.id == "servico") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Servico").collapse("show");
                        $("#itensServico").collapse("show");
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "documento-tab" ||
                    Element.node.id == "documentoaba"
                ) {
                    if (!$("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == 'VoltarGeral') {
                    $('#VoltarGeral').trigger('click');
                } else if (Element.node.id == "voltarItens") {
                    $('#voltarItens').trigger('click');
                }
            },
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    // if (pegaChave('#txtCliente') == '') {
                    //     insereValor('#txtFornecedor', ' ', ' ')
                    // };

                    $('#avancar1').trigger('click');
                } else if ((Element.node.id == 'avancarItens')) {
                    if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
                        ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
                        ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
                        insereValor('#txtServico', ' ', ' ');
                        insereValor('#txtQtdeServico', '1');
                        insereValor('#txtPrecoServico', '1');
                        $('#btnAdicionarServico').trigger('click');
                    };
                    $('#avancarItens').trigger('click');
                }

            },
        });

        driver.defineSteps([{
            element: "#geral-tab",
            popover: {
                title: "Aba Geral",
                description: "Clique aqui para abrir a aba geral.",
                position: "top",
            },
        },
        {
            element: "#geral",
            popover: {
                title: "Cadastro Geral",
                description: "Aqui você pode informar os dados gerais de cadastro da ordem de compra.",
                position: "bottom",
            },
        },
        {
            element: "#multiCollapseExample1",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados gerais de cadastro.",
                position: "top",
            },
        },
        {
            element: "#txtFornecedor",
            popover: {
                title: "Campo Fornecedor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDataEntrega",
            popover: {
                title: "Campo Entrega",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtSolicitacao",
            popover: {
                title: "Campo Solicitação",
                description: "Informando uma solicitação, ao sair do campo irá importar os dados da solicitação. Contém a opção da tecla F8 para abrir modal e buscar os dados da solicitação para ser importado.",
                position: "top",
            },
        },
        {
            element: "#DadosEntregaAba",
            popover: {
                title: "Dados de Entrega",
                description: "Aqui ficam os dados de entrega.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample2",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados de entrega.",
                position: "top",
            },
        },
        {
            element: "#ObservacoesAba",
            popover: {
                title: "Observações",
                description: "Aqui ficam as observações.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample3",
            popover: {
                title: "Observações",
                description: "Esses são os campos que você informará as observações.",
                position: "top",
            },
        },
        {
            element: "#Totais",
            popover: {
                title: "Totalizadores",
                description: "Aqui fica os totalizadores.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample4",
            popover: {
                title: "Totalizadores",
                description: "Esses são os Totais.",
                position: "top",
            },
        },
        {
            element: "#voltarAcesso",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Acesso.",
                position: "top",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: "#VoltarGeral",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Geral.",
                position: "top",
            },
        },
        {
            element: "#Itens",
            popover: {
                title: "Itens",
                description: "Clique aqui para abrir os itens.",
                position: "top",
            },
        },
        {
            element: "#MaterialAba",
            popover: {
                title: "Material (Quantidade de registros)",
                description: "Clique aqui para abrir os materiais.",
                position: "top",
            },
        },
        {
            element: "#ItensMaterial",
            popover: {
                title: "Campos Material",
                description: "Aqui você pode informar os dados dos materiais.",
                position: "top",
            },
        },
        {
            element: "#txtMaterial",
            popover: {
                title: "Campo Material",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoMaterial",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorMaterial",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeMaterial",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoMaterial",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarMaterial",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensMaterial_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os materiais da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#produto",
            popover: {
                title: "Produto (Quantidade de registros)",
                description: "Clique aqui para abrir os produtos.",
                position: "top",
            },
        },
        {
            element: "#itensProduto",
            popover: {
                title: "Campos Produto",
                description: "Aqui você pode informar os dados dos produtos.",
                position: "top",
            },
        },
        {
            element: "#txtProduto",
            popover: {
                title: "Campo Produto",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoProduto",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorProduto",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtTamProduto",
            popover: {
                title: "Campo Tamanho",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeProduto",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoProduto",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnGradeProduto",
            popover: {
                title: "Botão Grade",
                description: "Clique aqui para adicionar o produto pela grade. Necessário informar o campo depósito.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarProduto",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensProduto_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os produtos da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#servico",
            popover: {
                title: "Serviço (Quantidade de registros)",
                description: "Clique aqui para abrir os serviços.",
                position: "top",
            },
        },
        {
            element: "#itensServico",
            popover: {
                title: "Campos Serviço",
                description: "Aqui você pode informar os dados dos serviços.",
                position: "top",
            },
        },
        {
            element: "#txtServico",
            popover: {
                title: "Campo Serviço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeServico",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoServico",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarServico",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensServico_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os serviços da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#avancarItens",
            popover: {
                title: "Botão Avançar",
                description: "Clique aqui para avançar para a aba Pagamento.",
                position: "left",
            },
        },
        {
            element: "#voltarItens",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Itens.",
                position: "top",
            },
        },
        {
            element: '#tourFinanceiro',
            popover: {
                title: 'Pagamento',
                description: 'Aqui estão os dados de pagamento.',
                position: 'top'
            }
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });
});
