$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdemCompra',
        popover: {
          title: 'Tabela Ordem Compra',
          description: 'Aqui estão os dados das ordens de compra cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

const columnsGridPrincipal = [
  { "data": "id", "title": "ID" },
  { "data": "codcli", "title": "Cliente" },
  { "data": "nome", "title": "Nome" },
  { "data": "data", "title": "Data" },
  { "data": "dataAcerto", "title": "Data de Acerto" },
  { "data": "situacao", "title": "Situação" },
  { "data": "descricaoSituacao", "title": "Desc. Situação" },
  { "data": "status", "title": "Status" },
  { "data": "descricaoStatus", "title": "Desc. Status" },
  { "data": "deposito", "title": "Depósito" },
  { "data": "depositoEnt", "title": "Deposito Entrada" },
  { "data": "codrep", "title": "Vendedor" },
  { "data": "nomeRepresentante", "title": "Nome" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "valorMinimo", "title": "Valor Mínimo" },
  { "data": "tipo", "title": "Tipo" },
  { "data": "descricaoTipo", "title": "Desc. Tipo" },
  { "data": "dias", "title": "Dias" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "valor", "title": "Valor" },
  { "data": "codven", "title": "Venda" },
  { "data": "dataEmissao", "title": "Data de Emissão" },
  { "data": "quantidadeExp", "title": "Quantidade Expedida" },
  { "data": "quanitdadeFat", "title": "Quantidade Faturada" },
  { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
  { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
]

const columnsGridItens = [
  { "data": "codigo", "title": "Código" },
  { "data": "descricao", "title": "Descrição" },
  { "data": "cor", "title": "Cor" },
  { "data": "descricaoCor", "title": "Desc. Cor" },
  { "data": "tamanho", "title": "Tamanho" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "preco", "title": "Desc. Preço" },
  { "data": "precoTotal", "title": "Preço Total" },
  { "data": "quantidadeExp", "title": "Quantidade Expedida" },
  { "data": "quantidadeFat", "title": "Quantidade Faturada" },
  { "data": "quantidadeDev", "title": "Quantidade Devolvida" },
  { "data": "quantidadeFatDev", "title": "Quantidade FatDev" },
  { "data": "data", "title": "Data" },
  { "data": "dataAcerto", "title": "Data de Acerto" },
  { "data": "situacao", "title": "Situação" },
  { "data": "descricaoSituacao", "title": "Desc. Situação" },
  { "data": "status", "title": "Status" },
  { "data": "descricaoStatus", "title": "Desc. Status" },
  { "data": "tipo", "title": "Tipo" },
  { "data": "descricaoTipo", "title": "Desc. Tipo" },
  { "data": "deposito", "title": "Depósito" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "codrep", "title": "Vendedor" },
  { "data": "precoLiquido", "title": "Preço Líquido" },
]

const columnsGridAcerto = [
  { "data": "codigo", "title": "Código" },
  { "data": "descricao", "title": "Descrição" },
  { "data": "cor", "title": "Cor" },
  { "data": "descricaoCor", "title": "Desc. Cor" },
  { "data": "tamanho", "title": "Tamanho" },
  { "data": "preco", "title": "Preço" },
  { "data": "tabelaPreco", "title": "Tabela de Preço" },
  { "data": "quantidade", "title": "Quantidade" },
  { "data": "barra28", "title": "Barra28" },
]


async function validaAlteraOrdemCompra(sNumero) {
  const dadosSelect = {
    tabela: 'CO_ITEN',
    camposSelect: ['CO_ITEN.NUMERO'],
    leftJoin: [{ tabela: 'COMPRA', condicao: 'COMPRA.NUMERO   = CO_ITEN.NUMERO' }],
    where: [`CO_ITEN.NUMERO = '${sNumero}' AND CO_ITEN.SITUACAO <> 'B' AND COMPRA.EMP_ID = ${getCookie('emp_id')}`]
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
  if (!retornoSelect) {
    return;
  }
  if (retornoSelect.length > 0) {
    return true;
  }
  return false;
};

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_COMPRA");

  addFuncoesBotoes();
  await buscaGridPrincipal();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await buscaGridPrincipal();
  });

  $('#txtOrdemCompraConsulta').on('blur', function () {
    let OrdemCompra = $('#txtOrdemCompraConsulta').val();
    if (OrdemCompra.includes("[")) {
      OrdemCompra = pegaChave($('#txtOrdemCompraConsulta'));
    } else {
      OrdemCompra = $('#txtOrdemCompraConsulta').val();
    }
    OrdemCompra = OrdemCompra.replace('\w', '');
    const listaOrdemCompra = $('#txtListaOrdemCompra').val();
    if (OrdemCompra == '') {
      return;
    }
    $('#txtListaOrdemCompra').val((listaOrdemCompra == '') ? `'${OrdemCompra}'` : `${listaOrdemCompra},'${OrdemCompra}'`);
    $('#txtOrdemCompraConsulta').val('');
    $('#txtOrdemCompraConsulta').focus();
  });

  $('#txtOrdemCompraConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtOrdemCompraConsulta').trigger('blur');
      $('#txtOrdemCompraConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "consignado/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaConsignado').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaConsignado').DataTable().row($(this).parents('tr')).data();
      window.location.href = `consignado/${data.id}`;
      // else {
      //   msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      // }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-imprimirItem', async function () {
    try {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();
      const numero = data[0]

      const pesquisa = {
        tabela: 'CO_ITEN',
        camposSelect: ['NUMERO'],
        where: [`NUMERO = '${numero}'`, `STATUS_COMPRA = 'L'`],
        limit: 1,
      }

      const [resultadoSelect] = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
      if (!resultadoSelect) {
        await imprimirItem({ numero })
        return
      }

      msgAlerta(
        'Deseja enviar a ordem de compra para o fornecedor?',
        () => null,
        () => imprimirItem({ numero }),
        () => {
          enviarOrdemCompra({ numero })
        },
        () => null,
        true,
      )
      return
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao validar os dados.')
    }
  });

  const imprimirItem = async ({ numero }) => {
    $.LoadingOverlay('show');
    try {
      const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;
      const filtros = retornaFiltros(`'${numero}'`);
      const ordem = `&TELA_ORDENACAO=acesso_ordem_compra&ORDEM_ORDENACAO=1`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompraA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompraA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }


    } catch (error) {
      console.error(error);
      msgErro('Ocorreu um erro ao realizar a impressão.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  const enviarOrdemCompra = async ({ numero }) => {
    try {
      requisicao(
        'PATCH',
        '/sisplan/ordem_compra/v1/enviarordemcompra?',
        ``,
        numero,
        30000
      ).then((response) => {
        if (!response || response.status !== 204) {
          toastr.error("Ocorreu um erro ao enviar a ordem de compra!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 1000,
            fadeOut: 1000,
            onHidden() {
              imprimirItem({ numero })
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          })
          return
        }

        toastr.success("Ordem de compra enviada com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            imprimirItem({ numero })
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
    } catch (error) {
      console.error(`Ocorreu um erro ao enviar ordem de compra para o fornecedor\n${error}.`);
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelOrdemCompraAcesso')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;

        const filtros = retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_ordem_compra&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompraA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompraA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaConsignado').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaConsignado').DataTable().row($(this)).data();
      // if (await validaAlteraOrdemCompra(data[0])) {
      window.location.href = `consignado/${data.id}`;
      // } else {
      //   msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      // }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaOrdemCompra").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '</div>';

    retornaHintRelatorio('btn-imprimirItem', 'RelOrdemCompraA')
    return retorno;
  };


  function retornaFiltros() {
    const sDtIni = $('#dtIni').val();
    const sDtFim = $('#dtFim').val();
    const sDtAcertoIni = $('#dtAcertoIni').val();
    const sDtAcertoFim = $("#dtAcertoFim").val();
    const sCliente = pegaChave("#txtCliente");
    const sStatus = pegaChave('#txtStatus');
    const sVendedor = pegaChave('#txtVendedor');
    const sRegiao = pegaChave('#txtTabPreco');
    const sId = pegaChave('#txtConsignado');
    const sSituacao = $('input[name="rdListar"]:checked').val();

    const filtros =
      `&DT_INI=${sDtIni}` +
      `&DT_FIM=${sDtFim}` +
      `&DT_ACERTO_INI=${sDtAcertoIni}` +
      `&DT_ACERTO_FIM=${sDtAcertoFim}` +
      `&CLIENTE=${sCliente}` +
      `&STATUS=${sStatus}` +
      `&VENDEDOR=${sVendedor}` +
      `&REGIAO=${sRegiao}` +
      `&ID=${sId}` +
      `&SITUACAO=${sSituacao}`;

    return filtros;
  };


  function retornaFiltrosAuxiliares() {
    const tabela = $('#tabelaConsignado').DataTable()

    const tabelaConsignado = tabela.row($('.selected')).data()

    if (!tabelaConsignado) return

    const sDtAcerto = tabelaConsignado?.dataAcerto.split('T')[0];
    const sCliente = tabelaConsignado?.codcli;
    const sId = tabelaConsignado?.id;

    const filtros =
      `&DATA_ACERTO=${sDtAcerto}` +
      `&CLIENTE=${sCliente}` +
      `&ID=${sId}`;

    return filtros;
  };

  async function buscaGridPrincipal() {
    try {
      $.LoadingOverlay("show");
      const params = retornaFiltros()

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridprincipal?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      $("#tabelaConsignado").DataTable({
        destroy: true,
        search: false,
        filter: false,
        lengthChange: false,
        scrollX: true,
        scrollCollapse: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridPrincipal,
        data: jsonStr.gridPrincipalConsignado ? jsonStr.gridPrincipalConsignado : [],
        columnDefs: [
          {
            type: 'date-br',
            targets: [3, 4, 21],
            render: function (data) {
              if (data != undefined && data != '') {
                x = data.slice(0, 10).split('-');
                hora = data.split(' ')[1]
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`
                } else {
                  return `${x} ${hora} `;
                }
              } else {
                return ''
              }
            }
          },
          {
            render(data, type, row) {
              return retornaBotaoOpcoes(data);
            },
            targets: 0,
          }
        ],
        rowCallback: function (row, data) {
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
          }
        },
      });

      setTimeout(async () => { $("#tabelaConsignado tbody tr td")[0].click() }, 50)
      setTimeout(async () => { await buscaGridAuxiliares() }, 250)

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $("#tabelaConsignado tbody").on("click", "tr", async function () {
    $("#tabelaConsignado tbody tr td")[0].click();
    $("#tabelaConsignado tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");

    setTimeout(async () => { await buscaGridAuxiliares() }, 50)
  });

  async function buscaGridAuxiliares() {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy();
      $('#tabelaItens').empty();
    }
    if ($.fn.DataTable.isDataTable('#tabelaAcerto')) {
      $('#tabelaAcerto').DataTable().destroy();
      $('#tabelaAcerto').empty();
    }
    try {
      // $.LoadingOverlay("show");
      const params = retornaFiltrosAuxiliares()
      if (!params) return

      const response = await requisicao('GET', '/sisplan/consignado/v1/buscagridsauxiliares?', params);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const jsonStr = await response.json();

      $("#tabelaItens").DataTable({
        destroy: true,
        filter: false,
        lengthChange: false,
        search: false,
        paginate: false,
        info: false,
        pageLength: 5,
        scrollY: '250px',
        scrollX: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridItens,
        data: jsonStr.gridItens ? jsonStr.gridItens : [],
        rowCallback: function (row, data) {
          if (data.tipo === 'D') {
            $(row).css('color', 'red');
          }
        }
      });

      $("#tabelaAcerto").DataTable({
        destroy: true,
        filter: false,
        lengthChange: false,
        search: false,
        paginate: false,
        info: false,
        pageLength: 5,
        scrollY: '250px',
        scrollX: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: columnsGridAcerto,
        data: jsonStr.gridAcerto ? jsonStr.gridAcerto : [],
      });

      $('.dataTables_scrollBody #tabelaItens').addClass('bordinha')
      $('.dataTables_scrollBody #tabelaAcerto').addClass('bordinha')
    } catch (error) {
      console.error(error);
    } finally {
      // $.LoadingOverlay("hide");
    }
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/ordem_compra/v1/ordem_compra?', `NUMERO=${encodeURIComponent(valorLinha[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function addFuncoesBotoes() {
    componenteFiltro('cliente', false, false)
    componenteFiltro('vendedor', false)
    componenteFiltro('status', false)
    componenteFiltro('tabPreco')
    componenteFiltro('consignado', false, false)

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtCliente').val('');
      $('#txtVendedor').val('');
      $('#txtStatus').val('');
      $("#txtTabPreco").val('');
      $("#dtIni").val("1200-01-01");
      $("#dtFim").val("2500-12-01");
      $("#dtAcertoIni").val("1200-01-01");
      $("#dtAcertoFim").val("2500-12-01");
      $("#txtConsignado").val('');
    });
  };

});