$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#btnConciliar',
            popover: {
                title: 'Botão Conciliar',
                description: 'Clique aqui para ir para a tela de Conciliação',
                position: 'right'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para imprimir o relatório',
                position: 'right'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CONCILIA");

    //autocomplete
    $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

    //btnconsultar
    $('#btn-ContaConsulta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta');

    //btnLimpar
    $('#btn-limpa-Conta').on('click', function () {
        $('#txtConta').val('')
        $('#txtBanco').val('')
    })

    $('#btnLimparFiltros').click(async function () {
        $('#txtConta').val('')
        $('#txtBanco').val('')
        $('#txtConciliacao').val('')
        $('#txtDocumento').val('')
        $('#rdConciliarTodos').prop('checked', true)
        $('#rdTipoTodos').prop('checked', true)
        $('#dtPeriodoDe').val('1200-01-01')
        $('#dtPeriodoAte').val('2500-12-31')
    });

    $('#txtConta').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const pesquisaParam = {
                    tabela: "CADCONTA",
                    camposSelect: [
                        "CADBAN.BANCO",
                        "CADBAN.NOME_BANCO"
                    ],
                    leftJoin: [
                        { tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },
                    ],
                    where: [`CADCONTA.CONTA = '${pegaChave('#txtConta')}'`],
                };

                let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    $('#txtBanco').val(`${jsonStr[0].BANCO} - ${jsonStr[0].NOME_BANCO}`)
                }
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function retornaFiltros() {
        const conciliado = $('#rdConciliarConciliado').is(':checked') ? 0 : $('#rdConciliarConciliar').is(':checked') ? 1 : 2
        const tipo = $('#rdTipoPagamento').is(':checked') ? 0 : $('#rdTipoPagamento').is(':checked') ? 1 : 2
        const filtros =
            `PERIODODE=${$('#dtPeriodoDe').val()}` +
            `&PERIODOATE=${$('#dtPeriodoAte').val()}` +
            `&CONTA=${pegaChave('#txtConta')}` +
            `&BANCO=${pegaChave('#txtBanco')}` +
            `&DOCUMENTO=${$('#txtDocumento').val()}` +
            `&CONCILIACAO=${$('#txtConciliacao').val()}` +
            `&CONCILIADO=${conciliado}` +
            `&TIPO=${tipo}`;
        return filtros;
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoConcilia')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/concilia/v1/imprimiracesso?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoConcilia');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelAcessoConcilia');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function buscaRegistrosMovimento() {
        const url = "/sisplan/concilia/v1/consultaacessomovto?";
        const filtros = await retornaFiltros();
        try {
            $.LoadingOverlay("Show");
            try {
                const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                var jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    async function criaDataTableMovto() {
        if ($.fn.DataTable.isDataTable('#tabelaMovimento')) {
            $('#tabelaMovimento').DataTable().destroy();
            $('#tabelaMovimento').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaConcilia')) {
            $('#tabelaConcilia').DataTable().destroy();
            $('#tabelaConcilia').empty();
        }
        try {
            $.LoadingOverlay('show')
            const jsonStr = await buscaRegistrosMovimento();

            if (jsonStr.length <= 0) {
                msgAlerta('Nenhum registro encontrado!')
                return;
            }

            const dataCols = []

            const keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataCols.push({
                    title: k,
                    data: k,
                });
            });

            $("#tabelaMovimento").DataTable({
                destroy: true,
                sort: true,
                colReorder: {
                    fixedColumnsLeft: 2
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [4, 5, 6]
                    },
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        },
                        targets: [9],
                        "className": 'pr-4 text-right'
                    },
                ]
            });

            $('#tabelaMovimento tbody').on('click', 'tr', async function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                } else {
                    $('#tabelaMovimento').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                    await criaDataTableConcilia($('#tabelaMovimento').DataTable().row($(this)).data().LANC_CON)
                }
            });

            $('#tabelaMovimento tbody tr:first').trigger('click')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function buscaRegistrosConcilia(lancamento) {
        const url = "/sisplan/concilia/v1/consultaacessoconcilia?";
        const filtros = await retornaFiltros();
        try {
            const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}&LANCAMENTO=${lancamento}`, "", 360000);

            if (!response) {
                return;
            }

            var jsonStr = await response.json()
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
            }

            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        }
    }

    async function criaDataTableConcilia(lancamento) {
        if ($.fn.DataTable.isDataTable('#tabelaConcilia')) {
            $('#tabelaConcilia').DataTable().destroy();
            $('#tabelaConcilia').empty();
        }
        $.LoadingOverlay("Show");
        try {
            if (lancamento <= 0) {
                return;
            }
            const jsonStr = await buscaRegistrosConcilia(lancamento);

            if (jsonStr.length <= 0) {
                return;
            }

            $('#titleExtrato').removeClass('d-none')

            const dataCols = []

            const keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataCols.push({
                    title: k,
                    data: k,
                });
            });

            $("#tabelaConcilia").DataTable({
                destroy: true,
                sort: true,
                paging: true,
                filter: false,
                info: true,
                pageLength: 5,
                order: false,
                destroy: true,
                colReorder: {
                    fixedColumnsLeft: 2
                },
                autoWidth: true,
                data: jsonStr,
                columns: dataCols,
                columnDefs: [
                    {
                        type: "date-br",
                        render(data) {
                            return new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                        },
                        targets: [3]
                    },
                    {
                        render(data) {
                            return parseFloat(data).toLocaleString("pt-br", {
                                minimumFractionDigits: 2,
                            });
                        },
                        targets: [4],
                        "className": 'pr-4 text-right'
                    },
                ]
            });
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    $("#tabelaConcilia").on('draw.dt', function (){
        $('#tabelaConcilia_length').addClass('d-none')
    })

    $('#btnConciliar').on('click', function () {
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                window.location.href = `concilia/create`;
            } else {
                msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
        } catch (error) {
            console.error();
        }
    })

    $('#btnConsultar').on('click', async function () {
        if ($('#txtConta').val() == '') {
            msgAlerta('Selecione uma conta');
            return;
        }
        $.LoadingOverlay("Show");
        try {
            try {
                $('#titleExtrato').removeClass('d-none')
                await criaDataTableMovto();
            } catch (error) {
                console.error(error);
                msgErro("Erro ao buscar os dados");
            }
        } finally {
            $("#modal-filtros").modal("hide");
            $.LoadingOverlay("hide");
        }
    });
});