$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para descrever o status cadastrado ou um novo status.',
        position: 'top'
      }
    },
    {
      element: '#radiogroup',
      popover: {
        title: 'Tipo do Status',
        description: 'Esse é um campo obrigatório, ele serve para definir para qual tipo será definido o status.',
        position: 'top'
      }
    },
    {
      element: '#bloquear',
      popover: {
        title: 'Opções de bloqueio',
        description: 'Aqui podemos selecionar os tipo de bloqueio que o status poderá realizar.',
        position: 'top'
      }
    },
    {
      element: '#opcoes',
      popover: {
        title: 'Opções',
        description: 'Aqui podemos selecionar as opções que o status pode ter.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o status.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  // aqui vem o código da tela
  // autocompleta
  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  // pesquisa
  $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"]}`, 'Consulta Cor', 'CADCOR');

  // limpacampo
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codigostatus = parametros[parametros.length - 1];

  if (codigostatus != "" && codigostatus != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO", "DESCRICAO", "TIPO", "BLOQ_FAT", "BLOQ_PROD", "BLOQ_BAIXA", "REMESSA_FABRICA", "BLOQ_EXPEDICAO", "COR",
        "BLOQ_OP", "PADRAO", "BLOQ_CONSUMO", "BLOQ_INC_CONSUMO", "LIMPA_NATUREZA", "BLOQ_ITEMPED", "ATIVO", "FORCA_VENDA", "BLOQ_COM_FV", "BLOQ_PED_B2B",
      "ORCAMENTO", "SAC", "BLOQ_SOURCING", "BLOQ_QTDE_MAX", "DISTRIBUI_LOTE", "DISTRIBUI_IGUAL", "DESEN_EST", "ORCA_MAT"], 
            "where": ["CODIGO = '${codigostatus}'"]}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        const mudarCheckedComponente = {
          'PRO': () => $('#slTipo').val('1'),
          'PED': () => $('#slTipo').val('2'),
          'MAQ': () => $('#slTipo').val('3'),
          'SER': () => $('#slTipo').val('4'),
          'MAT': () => $('#slTipo').val('5'),
          'WEB': () => $('#slTipo').val('6'),
          'MAL': () => $('#slTipo').val('7'),
          'CRM': () => $('#slTipo').val('8'),
          'EST': () => $('#slTipo').val('9'),
          'OC': () => $('#slTipo').val('10'),
          'FRE': () => $('#slTipo').val('11'),
          'ENT': () => $('#slTipo').val('12'),
          'PRE': () => $('#slTipo').val('13')
        };

        mudarCheckedComponente[jsonStr.RESULT[0][0].TIPO]();

        $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

        if (jsonStr.RESULT[0][0].COR != "") {
          await concatenaCor(jsonStr.RESULT[0][0].COR);  // Puxar a cor cadastrada no status
        }

        $("#txtNumero").val(jsonStr.RESULT[0][0].CODIGO);

        if (jsonStr.RESULT[0][0].BLOQ_FAT == "S") {
          $('#cbBloqFaturamento').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_PROD == "S") {
          $('#cbBloqProduto').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_BAIXA == "S") {
          $('#cbBloqBaixa').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].REMESSA_FABRICA == "S") {
          $('#cbOpcoesRemessaFabrica').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_EXPEDICAO == "S") {
          $('#cbBloqExpedicao').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_OP == "S") {
          $('#cbBloqOrdemProducao').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].PADRAO == "S") {
          $('#cbOpcoesPadrao').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_CONSUMO == "S") {
          $('#cbBloqAltConsumo').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_INC_CONSUMO == "S") {
          $('#cbBloqInclusaoConsumo').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].LIMPA_NATUREZA == "S") {
          $('#cbOpcoesLimparNatureza').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_ITEMPED == "S") {
          $('#cbBloqAltItensPed').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].ATIVO == "S") {
          $('#cbOpcoesAtivo').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].FORCA_VENDA == "S") {
          $('#cbOpcoesForcaVendas').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_COM_FV == "S") {
          $('#cbBloqComercial').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_PED_B2B == "S") {
          $('#cbBloqAltPedB2B').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].ORCAMENTO == "S") {
          $('#cbOpcoesOrcamento').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].SAC == "S") {
          $('#cbOpcoesSAC').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_SOURCING == "S") {
          $('#cbBloqSourcing').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].BLOQ_QTDE_MAX == "S") {
          $('#cbBloqQtdeMaxRegiao').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].DISTRIBUI_LOTE == "S") {
          $('#cbOpcoesDistribuirLotes').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].DISTRIBUI_IGUAL == "S") {
          $('#cbOpcoesDistribuirIgualLotes').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].DESEN_EST == "S") {
          $('#cbOpcoesDesenEstampa').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].ORCA_MAT == "S") {
          $('#cbOpcoesOrcamentoMaterial').prop('checked', true);
        }
      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function concatenaCor(sCodCor) {
    let resposta = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"CADCOR", 
          "camposSelect":["DESCRICAO"], 
          "where": ["COR = '${sCodCor}'"]}`,
      null
    );
    let jsonString = await resposta.json();
    if (jsonString.RESULT[0][0] != 0) {
      insereValor($("#txtCor"), sCodCor, jsonString.RESULT[0][0].DESCRICAO);
    }
    return
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/cadstatus`;
  })

  async function gravaStatus() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }

      let selectValue = $("#slTipo").val();
      if (selectValue <= 0) {
        msgAlerta('Selecione um Tipo');
        return;
      }

      let status = {}
      if ($('#slProduto').is(':checked')) {
        status.TIPO = 'PRO'
      } else if ($('#slPedido').is(':checked')) {
        status.TIPO = 'PED'
      } else if ($('#slMaquina').is(':checked')) {
        status.TIPO = 'MAQ'
      } else if ($('#slServico').is(':checked')) {
        status.TIPO = 'SER'
      } else if ($('#slMaterial').is(':checked')) {
        status.TIPO = 'MAT'
      } else if ($('#slInspecao').is(':checked')) {
        status.TIPO = 'WEB'
      } else if ($('#slMalharia').is(':checked')) {
        status.TIPO = 'MAL'
      } else if ($('#slCRM').is(':checked')) {
        status.TIPO = 'CRM'
      } else if ($('#slEstampa').is(':checked')) {
        status.TIPO = 'EST'
      } else if ($('#slOrdCompra').is(':checked')) {
        status.TIPO = 'OC'
      } else if ($('#slSisFrete').is(':checked')) {
        status.TIPO = 'FRE'
      } else if ($('#slEntidade').is(':checked')) {
        status.TIPO = 'ENT'
      } else if ($('#slPreco').is(':checked')) {
        status.TIPO = 'PRE'
      };

      status.CODIGO = $('#txtNumero').val() == '' ? await RetornaProximo("CODIGO", "SITPROD", "CODIGO", 5) : $('#txtNumero').val();
      status.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      status.COR = pegaChave('#txtCor');
      status.BLOQ_PROD = $("#cbBloqProduto").is(":checked") ? 'S' : 'N';
      status.BLOQ_BAIXA = $("#cbBloqBaixa").is(":checked") ? 'S' : 'N';
      status.BLOQ_CONSUMO = $("#cbBloqAltConsumo").is(":checked") ? 'S' : 'N';
      status.BLOQ_ITEMPED = $("#cbBloqAltItensPed").is(":checked") ? 'S' : 'N';
      status.BLOQ_FAT = $("#cbBloqFaturamento").is(":checked") ? 'S' : 'N';
      status.BLOQ_INC_CONSUMO = $("#cbBloqInclusaoConsumo").is(":checked") ? 'S' : 'N';
      status.BLOQ_OP = $("#cbBloqOrdemProducao").is(":checked") ? 'S' : 'N';
      status.BLOQ_EXPEDICAO = $("#cbBloqExpedicao").is(":checked") ? 'S' : 'N';
      status.BLOQ_SOURCING = $("#cbBloqSourcing").is(":checked") ? 'S' : 'N';
      status.BLOQ_QTDE_MAX = $("#cbBloqQtdeMaxRegiao").is(":checked") ? 'S' : 'N';
      status.BLOQ_COM_FV = $("#cbBloqComercial").is(":checked") ? 'S' : 'N';
      status.BLOQ_PED_B2B = $("#cbBloqAltPedB2B").is(":checked") ? 'S' : 'N';
      status.ATIVO = $("#cbOpcoesAtivo").is(":checked") ? 'S' : 'N';
      status.PADRAO = $("#cbOpcoesPadrao").is(":checked") ? 'S' : 'N';
      status.FORCA_VENDA = $("#cbOpcoesForcaVendas").is(":checked") ? 'S' : 'N';
      status.LIMPA_NATUREZA = $("#cbOpcoesLimparNatureza").is(":checked") ? 'S' : 'N';
      status.ORCAMENTO = $("#cbOpcoesOrcamento").is(":checked") ? 'S' : 'N';
      status.SAC = $("#cbOpcoesSAC").is(":checked") ? 'S' : 'N';
      status.REMESSA_FABRICA = $("#cbOpcoesRemessaFabrica").is(":checked") ? 'S' : 'N';
      status.DISTRIBUI_LOTE = $("#cbOpcoesDistribuirLotes").is(":checked") ? 'S' : 'N';
      status.DISTRIBUI_IGUAL = $("#cbOpcoesDistribuirIgualLotes").is(":checked") ? 'S' : 'N';
      status.ORCA_MAT = $("#cbOpcoesOrcamentoMaterial").is(":checked") ? 'S' : 'N';
      status.DESEN_EST = $("#cbOpcoesDesenEstampa").is(":checked") ? 'S' : 'N';

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/cadstatus?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(status)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Status: ${status.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadstatus`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    await gravaStatus()
  })
});
