function criaTabelaAplicacoesCaracteristicas(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button type="button" class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaAplicacoesCaracteristicas')) {
        $('#tabelaAplicacoesCaracteristicas').DataTable().destroy();
        $('#tabelaAplicacoesCaracteristicas').empty();
    }

    const columns = [
        {
            data: 'TECIDO_FIXO',
            title: 'Tecido'
        },
        {
            data: 'DESC_TECIDO',
            title: 'Desc. Tecido'
        },
        {
            data: 'COD_APL',
            title: 'Aplicação'
        },
        {
            data: 'DESCRICAO',
            title: 'Desc. Aplicação'
        },
        {
            data: 'QTDE',
            title: 'Qtde'
        },
        {
            data: 'QTDE_TECIDO',
            title: 'Qtde Tecido'
        },
        {
            data: 'SUBSTITUIR_CORTE',
            title: 'Substituir Corte'
        },
        {
            data: 'SUBCARACTERISTICA',
            title: 'Subcaracterística'
        },
    ]

    $("#tabelaAplicacoesCaracteristicas").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: true,
        info: false,
        columnDefs: [
            {
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            }
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false)
    selectFirstRecordCaracteristicas()
}

function habilitaEdicaoAplicacoesCaracteristica() {
    $('.aplicacoesCaracteristicaControl').prop('disabled', false)
    $('#btnIncluirAplicacoesCaracteristica').addClass('d-none')
    $('#btnConfirmarAplicacoesCaracteristica').removeClass('d-none')
    $('#btnDesistirAplicacoesCaracteristica').removeClass('d-none')
    $('#btnConfirmarSubcaracteristica').prop('disabled', true)
    $('#btnDesistirSubcaracteristica').prop('disabled', true)
}

function desabilitaEdicaoAplicacoesCaracteristica() {
    $('.aplicacoesCaracteristicaControl').prop('disabled', true)
    $('#btnIncluirAplicacoesCaracteristica').removeClass('d-none')
    $('#btnConfirmarAplicacoesCaracteristica').addClass('d-none')
    $('#btnDesistirAplicacoesCaracteristica').addClass('d-none')
    $('#txtTecidoFixoAplicacoesCaracteristica').val('')
    $('#txtQuantidadeAplicacoesCaracteristica').val('')
    $('#txtQuantidadeTecidoAplicacoesCaracteristica').val('')
    $('#cbSubstituirAplicacoesCaracteristica').prop('checked', false)
    $("#tabelaAplicacoesCaracteristicas tr").removeClass("selected")
    if ($('#btnConfirmarConsumosCaracteristica').hasClass('d-none')) {
        $('#btnConfirmarSubcaracteristica').prop('disabled', false)
        $('#btnDesistirSubcaracteristica').prop('disabled', false)
    }
}

function insereValoresEdicaoAplicacoesCaracteristica(data) {
    insereValor('#txtTecidoFixoAplicacoesCaracteristica', data.TECIDO_FIXO, data.DESC_TECIDO)
    insereValor('#txtQuantidadeAplicacoesCaracteristica', data.QTDE)
    insereValor('#txtQuantidadeTecidoAplicacoesCaracteristica', data.QTDE_TECIDO)
    $('#cbSubstituirAplicacoesCaracteristica').prop('checked', data.SUBSTITUIR_CORTE === 'S')
}

function adicionaRegistroAplicacoesCaracteristica(data) {
    try {
        const datatable = $('#tabelaAplicacoesCaracteristicas').DataTable()
        const selectedRow = datatable.rows(".selected")
        const datatableData = datatable.rows({ search: 'applied' }).data().toArray()
        const editingRegister = selectedRow.data().toArray()

        if (!editingRegister || editingRegister.length === 0) {
            if (datatableData.find(e => e.TECIDO_FIXO === data.TECIDO_FIXO)) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            datatable.row.add(data).draw(false)
        } else {
            const [index] = selectedRow.indexes().toArray()
            const existingRegisterCount = datatableData.filter((e, i) => e.TECIDO_FIXO === data.TECIDO_FIXO && index !== i)

            if (existingRegisterCount && existingRegisterCount.length > 0) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            if (editingRegister.length > 1) {
                throw new Error()
            }

            datatable.row(index).data(data).draw(false)
        }
        filtraAplicacoesSubcaracteristicas({ ...data, OPCIONAL: data.SUBCARACTERISTICA })
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao inserir/editar o registro, por favor tente novamente.')
    } finally {
        desabilitaEdicaoAplicacoesCaracteristica()
    }
}

function filtraAplicacoesSubcaracteristicas({ COD_APL: aplicacao, OPCIONAL: subcaracteristica }) {
    $('#tabelaAplicacoesCaracteristicas').DataTable().column(2).search(`^${aplicacao.trim()}$|^$`, true, false).column(7).search(`^${subcaracteristica.trim()}$|^$`, true, false).draw(false)
}

function atualizaValoresAplicacoesSubcaracteristicas({ COD_APL, DESCRICAO, SUBCARACTERISTICA }) {
    const datatable = $("#tabelaAplicacoesCaracteristicas").DataTable()
    const visibleRowsIndexes = datatable.rows({ search: 'applied' }).indexes()
    visibleRowsIndexes.each(function (index) {
        const data = datatable.row(index).data()
        datatable.row(index).data({ ...data, COD_APL, DESCRICAO, SUBCARACTERISTICA }).draw(false)
    })
}

function removeAplicacoesSubcaracteristicas(data) {
    const { COD_APL: aplicacao, OPCIONAL: subcaracteristica } = data
    const datatableData = $('#tabelaAplicacoesCaracteristicas').DataTable().data().toArray()
    const dataFiltered = datatableData.filter(e => e.COD_APL !== aplicacao || e.SUBCARACTERISTICA !== subcaracteristica)
    criaTabelaAplicacoesCaracteristicas(dataFiltered)
}