$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta dos Cadastros de Informações Complementares.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoCad',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de Informações Complementares.',
                    position: 'right'
                }
            },
            {
                element: '#tabelacadinfcomplementar',
                popover: {
                    title: 'Tabela Informações Complementares',
                    description: 'Aqui estão todos as Informações Complementares cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADINFCOMPLEMENTAR");

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    ConsultaInfComplementar();

    $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"TABREF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

    $('#btnConsultaCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABREF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Informações Complementares', 'cadInfComplementar');

    $('#btnLimpaCodigo, #btnLimparFiltros').on('click', function () {
        $('#txtCodigo').val('');
    });


    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        await ConsultaInfComplementar(true);
        $('#modal-filtros').modal('hide');
    });

    async function ConsultaInfComplementar() {
        try {
            $.LoadingOverlay("show");
            let response;

            const codigo = pegaChave('#txtCodigo') != '' ? ` AND CODIGO = ${pegaChave('#txtCodigo')}` : '';

            response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ 
                        "tabela":"TABREF", 
                        "camposSelect":["CODIGO", "DESCRICAO"],  
                        "where": ["1=1 ${codigo}"]}`, null);


            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelacadinfcomplementar').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                filter: false,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
        }
    }

    $('#btnNovoCad').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadinfcomplementar/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelacadinfcomplementar').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelacadinfcomplementar').DataTable().row($(this).parents('tr')).data();
            window.location.href = `cadinfcomplementar/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelacadinfcomplementar').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelacadinfcomplementar').DataTable().row($(this)).data();
            window.location.href = `cadinfcomplementar/${data.CODIGO}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelacadinfcomplementar').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelacadinfcomplementar").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadinfcomplementar?", `CODIGOINFCOMPLEMENTAR=${valorLinha.CODIGO}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

});