$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#dtEntregaNova',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para definir uma previsão de entrega.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para alterar a moeda de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtCondPagto',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para alterar a condição de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "top",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Alteração do Pedido B2B.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO"], "orderBy": ["CODMOE ASC"], "where": null }`, [], [], [], callbackSaidaMoeda);
  $("#btnMoeda").off();
  $("#btnMoeda").unbind("pesquisa_array");
  $("#btnMoeda").pesquisa_array(["#txtMoeda"], ["CODMOE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "orderBy": ["CODMOE ASC"], "where": null}`, "Pesquisa Moeda", "MOEDA", callbackSaidaMoeda);
  $('#btnLimpaMoeda').on('click', function () {
    $('#txtMoeda').val('')
  })

  $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnCondPagto').pesquisa('#txtCondPagto', 'CODCOND', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":["CODCOND", "DESCRICAO"]}`, 'Pesquisa Condição de Pagamento', 'CONDICAO');
  $('#btnLimpaCondPagto').on('click', function () {
    $('#txtCondPagto').val('');
  });

  $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
  $('#btnTransportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
  $('#btnLimpaTransportadora').on('click', function () {
    $('#txtTransportadora').val('');
  });

  $('#txtCEPPersonalizado').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":["CEP CHAVE, NOMCEP DESCRICAO"], "where": null}`);
  $('#btn-CEPPersonalizado').pesquisa('#txtCEPPersonalizado', 'CEP', 'NOMCEP', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCEP", "camposSelect":[ "CEP", "NOMCEP" ], "where": null}', 'Pesquisa CEP', 'CADCEP');
  $('#btn-limpa-CEPPersonalizado').on('click', function () { $('#txtCEPPersonalizado').val('') });

  $('#txtCEPPersonalizado').on('focusout', async function () {
    if (pegaChave(this) != '') {
      await buscaDadosCep(pegaChave(this));
    }
  });

  const colunasTabelaItens = [
    { data: 'CODIGO', title: 'Código' },
    { data: 'DESCRICAO', title: 'Descrição' },
    { data: 'COR', title: 'Cor' },
    { data: 'DESC_COR', title: 'Desc_Cor' },
    { data: 'QTDE', title: 'Quantidade' },
    { data: 'PRECO', title: 'Valor Líquido Vendido' },
  ]

  async function temCondicoesEspecificas(iMoeda) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["moeda = ${iMoeda}"] }`,
        null
      );

      if (!response) {
        return false;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return false;
      }
      let bTemCondicoes = jsonStr.RESULT[0].length > 0;
      return bTemCondicoes;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da moeda.");
      return false;
    }
  }

  async function callbackSaidaMoeda() {
    const codmoeda = $('#txtMoeda').attr('data-chave');
    if (!codmoeda) return
    $('#txtCondPagto').val('')
    if ((codmoeda != '') && (await temCondicoesEspecificas(codmoeda))) {
      $('#txtCondPagto').unbind('autocompleta');
      $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND CHAVE", "DESCRICAO"], "where": ["CONDICAO.CODCOND IN (SELECT COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.MOEDA=${codmoeda})"]}`, [], [], []);
      $('#btnCondPagto').off();
      $('#btnCondPagto').unbind('pesquisa_array');
      $('#btnCondPagto').pesquisa_array(['#txtCondPagto'], ['CODCOND'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CONDICAO.CODCOND", "CONDICAO.DESCRICAO"], "leftJoin": [{"tabela": "COND_MOEDA", "CONDICAO": "CONDICAO.CODCOND = COND_MOEDA.CODCOND"}], "where": ["COND_MOEDA.MOEDA=${codmoeda}"], "orderBy": ["CONDICAO.CODCOND"]}`, 'Pesquisa Condição de Pagamento', 'CONDICAO');
    } else {
      // volta as condições normais
      $('#txtCondPagto').unbind('autocompleta');
      $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND CHAVE", "DESCRICAO"], "where": null}`, [], [], []);
      $('#btnCondPagto').off();
      $('#btnCondPagto').unbind('pesquisa_array');
      $('#btnCondPagto').pesquisa_array(['#txtCondPagto', '#txtNrParcelas'], ['CODCOND'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO"], "where": null, "orderBy": ["CODCOND"]}', 'Pesquisa Condição de Pagamento', 'CONDICAO');
    }
  }

  async function buscaDadosCep(cep) {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/cep/v1/cep?';
      const filtros = `CEP=${cep}`;
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        return;
      }

      insereValor('#txtEnderecoPersonalizado', jsonStr.nOMCEP);
      insereValor('#txtNumeroPersonalizado', '');
      insereValor('#txtBairroPersonalizado', jsonStr.bAIRRO);
      insereValor('#txtComplementoPersonalizado', '');
      insereValor('#txtCidadeEstadoPersonalizado', jsonStr.nOMCIDADE + ' / ' + jsonStr.eSTCEP);
    } catch (error) {
      msgErro('Erro na rotina buscaDadosCep: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  };


  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let altpedidob2b = parametros[parametros.length - 1];

  if (altpedidob2b != "") {
    if (await liberarRegistro('ALTPEDIDOSB2B', altpedidob2b) == false) {
      window.location.href = '../altpedidob2b';
    } else {
      try {
        try {
          $.LoadingOverlay("show");
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={
            "tabela": "PEDIDO",
            "camposSelect": [
              "PEDIDO.NUMERO",
              "PEDIDO.MOEDA",
              "PEDIDO.CODCLI",
              "MOEDA.DESCRICAO DESCMOEDA",
              "PEDIDO.COND_PAGTO",
              "CONDICAO.DESCRICAO DESCCOND",
              "PEDIDO.TAB_TRANS",
              "TABTRAN.NOME",
              "PEDIDO.OBS",
              "PEDIDO.ENTREGA",
              "PEDIDO.DT_FATURA"
            ],
            "leftjoin": [
              {
                "tabela": "TABTRAN",
                "condicao": "TABTRAN.CODIGO = PEDIDO.TAB_TRANS"
              },
              {
                "tabela": "CONDICAO",
                "condicao": "CONDICAO.CODCOND = PEDIDO.COND_PAGTO"
              },
              {
                "tabela": "MOEDA",
                "condicao": "MOEDA.CODMOE = PEDIDO.MOEDA"
              }
            ],
            "where": [
              "PEDIDO.NUMERO = '${altpedidob2b}'"
            ]
          }`,
            null
          );

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return;
          }
          $("#dtEntregaNova").val(jsonStr.RESULT[0][0].ENTREGA);
          $("#dtFatura").val(jsonStr.RESULT[0][0].DT_FATURA);
          insereValor("#txtMoeda", jsonStr.RESULT[0][0].MOEDA, jsonStr.RESULT[0][0].DESCMOEDA);
          callbackSaidaMoeda()
          insereValor("#txtCondPagto", jsonStr.RESULT[0][0].COND_PAGTO, jsonStr.RESULT[0][0].DESCCOND);
          insereValor("#txtTransportadora", jsonStr.RESULT[0][0].TAB_TRANS, jsonStr.RESULT[0][0].NOME);
          $("#txtObservacao").val(jsonStr.RESULT[0][0].OBS);
          await preencheEnderecosEntrega(jsonStr.RESULT[0][0].CODCLI);

          $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["MOEDA.CODMOE CHAVE, MOEDA.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}],  "where": ["ENT_MOEDA.CODCLI = '${jsonStr.RESULT[0][0].CODCLI}'"] }`, [], [], [], callbackSaidaMoeda);
          $("#btnMoeda").pesquisa_array(["#txtMoeda"], ["CODMOE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "MOEDA.CODMOE", "MOEDA.DESCRICAO" ], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}], "where": ["ENT_MOEDA.CODCLI = '${jsonStr.RESULT[0][0].CODCLI}' "]}`, "Pesquisa Moeda", "MOEDA", callbackSaidaMoeda);
        } catch (error) {
          console.error(error);
          msgAlerta(`Não foi possível buscar os dados:`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('ALTPEDIDOSB2B', getCookie('usuario'), altpedidob2b);
    window.location.href = `${BASE_URI}/altpedidob2b`;
  });

  $('#btnGravar').on('click', async function () {
    await gravarPedido()
  })

  async function preencheEnderecosEntrega(codcli) {
    try {
      const url = '/sisplan/pedidob2b/v1/dadosentregacliente?';
      const filtros = `CODCLI=${codcli}`
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const complemento = jsonStr[0].COMPLEMENTO != '' ? `- ${jsonStr[0].COMPLEMENTO}` : '';
      $(`#txtEnderecoEntidade`).val(`${jsonStr[0].ENDERECO}, ${jsonStr[0].NUMERO} ${complemento}`);
      $(`#txtComplementoEntidade`).val(jsonStr[0].COMPLEMENTO);
      $(`#txtNumeroEntidade`).val(jsonStr[0].NUMERO);
      $(`#txtBairroEntidade`).val(jsonStr[0].BAIRRO);
      $(`#txtCepEntidade`).val(jsonStr[0].CEP);
      $(`#txtCidadeEstadoEntidade`).val(jsonStr[0].CIDADE_NOME + ' / ' + jsonStr[0].COD_UF);

      const complementoEntrega = jsonStr[0].COMP_ENT != '' ? `- ${jsonStr[0].COMP_ENT}` : '';
      $(`#txtEnderecoEntrega`).val(`${jsonStr[0].END_ENT}, ${jsonStr[0].NUM_ENT} ${complementoEntrega}`);
      $(`#txtComplementoEntrega`).val(jsonStr[0].COMP_ENT);
      $(`#txtNumeroEntrega`).val(jsonStr[0].NUM_ENT);
      $(`#txtBairroEntrega`).val(jsonStr[0].BAIRRO_ENT);
      $(`#txtCepEntrega`).val(jsonStr[0].CEP_ENT);
      $(`#txtCidadeEstadoEntrega`).val(jsonStr[0].CIDADE_NOME_ENT + ' / ' + jsonStr[0].COD_UF_ENT);

      const complementoCobranca = jsonStr[0].COMP_COB != '' ? `- ${jsonStr[0].COMP_COB}` : '';
      $(`#txtEnderecoCobranca`).val(`${jsonStr[0].END_COB}, ${jsonStr[0].NUM_COB} ${complementoCobranca}`);
      $(`#txtComplementoCobranca`).val(jsonStr[0].COMP_COB);
      $(`#txtNumeroCobranca`).val(jsonStr[0].NUM_COB);
      $(`#txtBairroCobranca`).val(jsonStr[0].BAIRRO_COB);
      $(`#txtCepCobranca`).val(jsonStr[0].CEP_COB);
      $(`#txtCidadeEstadoCobranca`).val(jsonStr[0].CIDADE_NOME_COB + ' / ' + jsonStr[0].COD_UF_COB);

      $(`#txtInscricao`).val(jsonStr[0].INSCRICAO);
      await preencheDadosEnderecoPersonalizado();

    } catch (error) {
      msgErro('Erro na rotina buscaDadosEntrega: ' + error.message);
    }
  }

  async function preencheDadosEnderecoPersonalizado() {
    try {
      $.LoadingOverlay('show')
      let response = await requisicao(
        "GET",
        "/sisplan/funcoes/v1/pesquisa?",
        `JSON={
        "tabela": "PEDIDO",
        "camposSelect": [
          "CLI_CEP",
          "CLI_END",
          "CLI_NUM",
          "CLI_COMPL",
          "CLI_BAIRRO",
          "CLI_DDD",
          "CLI_FONE",
          "CLI_RECEBEDOR"
        ],
        "where": [
          "NUMERO = '${altpedidob2b}'"
        ]
      }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#txtEnderecoPersonalizado').val(jsonStr.RESULT[0][0].CLI_END.split(' - ')[0])
      $('#txtComplementoPersonalizado').val(jsonStr.RESULT[0][0].CLI_COMPL)
      $('#txtNumeroPersonalizado').val(jsonStr.RESULT[0][0].CLI_NUM)
      $('#txtBairroPersonalizado').val(jsonStr.RESULT[0][0].CLI_BAIRRO)
      insereValor('#txtCEPPersonalizado', jsonStr.RESULT[0][0].CLI_CEP, { tabela: 'CADCEP', campoBusca: 'NOMCEP', campoWhere: 'CEP', valorWhere: jsonStr.RESULT[0][0].CLI_CEP })
      const codmun = (await buscaValor('CADCEP', 'CODMUN', 'CEP', jsonStr.RESULT[0][0].CLI_CEP)).CODMUN
      const nomeCidade = (await buscaValor('CIDADE', 'NOME', 'CODIGO', codmun)).NOME
      $('#txtCidadeEstadoPersonalizado').val(nomeCidade)

      $(`#txtDDD`).val(jsonStr.RESULT[0][0].CLI_DDD);
      $(`#txtTelefone`).val(jsonStr.RESULT[0][0].CLI_FONE);
      $(`#txtRecebedor`).val(jsonStr.RESULT[0][0].CLI_RECEBEDOR);
      // $(`#txtTelefone`).prop(`disabled`, true);
      // $(`#txtDDD`).prop(`disabled`, true);
      // $(`#txtRecebedor`).prop(`disabled`, true);

    } catch (error) {
      console.log('Erro na função: preencheDadosEnderecoPersonalizado')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function retornaRegrasStatusAlteracaoPedido(tipo) {
    const pesquisa = {
      camposSelect: ["STATUS, FINANCEIRO"],
      tabela: "CONFIGSTATUS",
      where: [`OPERACAO = '${'opAlteraPedidoB2B'}' AND ID_TIPO = ${tipo} AND VALIDA_MOEDA = 'N'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

    if ((jsonStr) && (jsonStr.length > 0)) {
      return {
        status: jsonStr[0].STATUS,
        financeiro: jsonStr[0].FINANCEIRO
      }
    }
  }

  async function validaAlteradoMoedaOuCondPagto(pedido) {
    const pesquisa = {
      camposSelect: ["MOEDA, COND_PAGTO, ID_TIPO, STATUS, FINANCEIRO"],
      tabela: "PEDIDO",
      where: [`NUMERO = '${altpedidob2b}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));

    if ((!jsonStr) && (jsonStr.length == 0)) {
      return;
    }

    const regras = await retornaRegrasStatusAlteracaoPedido(jsonStr[0].ID_TIPO);
    const moedaGravada = jsonStr[0].MOEDA
    const condPagtoGravada = jsonStr[0].COND_PAGTO
    const statusGravada = jsonStr[0].STATUS
    const financeiroGravada = jsonStr[0].FINANCEIRO
    if (regras) {
      if ((moedaGravada != pedido.moeda) || (pedido.condpagto != condPagtoGravada)) {
        const statusValidaMoeda = await buscaValor('CONFIGSTATUS', 'STATUS', [`OPERACAO = 'opAlteraPedidoB2B' AND ID_TIPO = '${jsonStr[0].ID_TIPO}' AND VALIDA_MOEDA`], ['S'])
        pedido.financeiro = regras.financeiro == 'BLOQUEADO' ? '0' : '1'
        pedido.status = statusValidaMoeda?.STATUS ? statusValidaMoeda?.STATUS : regras.status
      } else if (regras?.status !== '') {
        pedido.financeiro = regras.financeiro
        pedido.status = regras.status
      } else {
        pedido.financeiro = financeiroGravada
        pedido.status = statusGravada
      }
    }
  }

  async function retornaDescAuxCondicao(codcond) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "CONDICAO", "camposSelect": ["DESCRICAO_AUX"],"where": ["CODCOND = '${codcond}' "] } `);

    if (json.length == 0) {
      return {
        DESCRICAO_AUX: '',
      };
    }
    return json[0];
  }

  async function gravarPedido() {
    $.LoadingOverlay('show')
    try {
      if ($('#dtEntregaNova').val() == '') {
        msgAlerta('A Data de Entrega não foi preenchida. Impossível continuar.');
        return;
      } else if ($('#txtMoeda').val() == '') {
        msgAlerta('A Moeda não foi preenchida. Impossível continuar.');
        return;
      } else if ($('#txtCondPagto').val() == '') {
        msgAlerta('A Condição de Pagamento não foi preenchida. Impossível continuar');
        return;
      }
      if ($('#dtEntregaNova').val() < $('#dtFatura').val()) {
        return msgAlerta('A data de entrega não pode ser menor que a dava prevista para o faturamento. Verifique!')
      }
      if (!validaEnderecoPreenchido()) {
        msgAlerta('Nenhum endereço de entrega preenchido!');
        $(`#enderecoEntregaPedido .collapseEnderecoEntregas`).trigger('click')
        return false;
      }
      if ($('#radioPersonalizadoEntidade').is(':checked')) {
        if (!$('#txtNumeroPersonalizado').val()) {
          abreCollapse()
          return msgAlerta('É necessário informar um número para o endereço personalizado. Verifique!')
        }
        if (!$('#txtEnderecoPersonalizado').val()) {
          abreCollapse()
          return msgAlerta('É necessário informar um endereço personalizado. Verifique!')
        }
        if (!$('#txtBairroPersonalizado').val()) {
          abreCollapse()
          return msgAlerta('É necessário informar um bairro para o endereço personalizado. Verifique!')
        }
        if (!$('#txtCEPPersonalizado').val()) {
          abreCollapse()
          return msgAlerta('É necessário informar um CEP válido. Verifique!')
        }
      }
      const dadosEntregaCliente = retornaDadosEntregaCliente();

      let pedido = {
        cli_cep: dadosEntregaCliente.cli_cep,
        cli_end: dadosEntregaCliente.cli_end,
        cli_num: dadosEntregaCliente.cli_num,
        cli_compl: dadosEntregaCliente.cli_compl,
        cli_bairro: dadosEntregaCliente.cli_bairro,
        cli_ddd: dadosEntregaCliente.cli_ddd,
        cli_fone: dadosEntregaCliente.cli_fone,
        cli_recebedor: dadosEntregaCliente.cli_recebedor,
        tipoEndereco: dadosEntregaCliente.tipoEndereco,
        numero: altpedidob2b,
        dataentrega: $('#dtEntregaNova').val(),
        moeda: pegaChave('#txtMoeda'),
        condpagto: pegaChave('#txtCondPagto'),
        pgto: (await retornaDescAuxCondicao(pegaChave('#txtCondPagto'))).DESCRICAO_AUX,
        transp: pegaChave('#txtTransportadora'),
        obs: $("#txtObservacao").val().toUpperCase(),
      }

      await validaAlteradoMoedaOuCondPagto(pedido);

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/altpedidob2b?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(pedido)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/altpedidob2b`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function abreCollapse() {
    if (!$('#collapseEnderecoEntrega').hasClass('show')) {
      $(`#enderecoEntregaPedido .collapseEnderecoEntregas`).trigger('click')
      if (!$('#collapseEnderecoEntregaPersonalizado').hasClass('show')) {
        $(`#enderecoEntregaPersonalizado .collapseEnderecoEntregaPersonalizados`).trigger('click')
      }
    }
  }

  function retornaDadosEntregaCliente() {
    const retorno = {
      cli_cep: '',
      cli_end: '',
      cli_num: '',
      cli_compl: '',
      cli_bairro: '',
      cli_ddd: pegaValor(`#txtDDD`),
      cli_fone: pegaValor(`#txtTelefone`),
      cli_recebedor: pegaValor(`#txtRecebedor`),
      tipoEndereco: ''
    };

    if (isChecked(`#radioEndEntidade`)) {
      retorno.cli_end = pegaValor(`#txtEnderecoEntidade`);
      retorno.cli_compl = pegaValor(`#txtComplementoEntidade`);
      retorno.cli_num = pegaValor(`#txtNumeroEntidade`);
      retorno.cli_bairro = pegaValor(`#txtBairroEntidade`);
      retorno.cli_cep = pegaValor(`#txtCepEntidade`);
      retorno.tipoEndereco = 'entidade';
    } else if (isChecked(`#radioEntregaEntidade`)) {
      retorno.cli_end = pegaValor(`#txtEnderecoEntrega`);
      retorno.cli_compl = pegaValor(`#txtComplementoEntrega`);
      retorno.cli_num = pegaValor(`#txtNumeroEntrega`);
      retorno.cli_bairro = pegaValor(`#txtBairroEntrega`);
      retorno.cli_cep = pegaValor(`#txtCepEntrega`);
      retorno.tipoEndereco = 'entrega_entidade';
    } else if (isChecked(`#radioCobrancaEntidade`)) {
      retorno.cli_end = pegaValor(`#txtEnderecoCobranca`);
      retorno.cli_compl = pegaValor(`#txtComplementoCobranca`);
      retorno.cli_num = pegaValor(`#txtNumeroCobranca`);
      retorno.cli_bairro = pegaValor(`#txtBairroCobranca`);
      retorno.cli_cep = pegaValor(`#txtCepCobranca`);
      retorno.tipoEndereco = 'cobranca';
    } else if (isChecked(`#radioPersonalizadoEntidade`)) {
      retorno.cli_end = pegaValor(`#txtComplementoPersonalizado`) != '' ? `${pegaValor(`#txtEnderecoPersonalizado`)} - ${pegaValor(`#txtComplementoPersonalizado`)}` : pegaValor(`#txtEnderecoPersonalizado`);
      retorno.cli_compl = pegaValor(`#txtComplementoPersonalizado`);
      retorno.cli_num = pegaValor(`#txtNumeroPersonalizado`);
      retorno.cli_bairro = pegaValor(`#txtBairroPersonalizado`);
      retorno.cli_cep = pegaChave(`#txtCEPPersonalizado`);
      retorno.tipoEndereco = 'personalizado';
    }

    return retorno;
  }

  function validaEnderecoPreenchido() {
    if ((!isChecked(`#radioCobrancaEntidade`)) && (!isChecked(`#radioEntregaEntidade`)) && (!isChecked(`#radioEndEntidade`)) && (!isChecked(`#radioPersonalizadoEntidade`))) {
      return false
    }
    return true
  }

  $('#btnItens').on('click', async function (event) {
    event.preventDefault();
    $('#modal-itens').modal('show');
    await tabelaItenspedido();
  });

  async function pesquisaItensPedido() {
    const pesquisa = {
      tabela: "PED_ITEN",
      camposSelect: ["PED_ITEN.CODIGO", "MATERIAL.DESCRICAO", "PED_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PED_ITEN.QTDE", "PED_ITEN.PRECO"],
      leftJoin: [
        { tabela: "MATERIAL", condicao: "MATERIAL.CODIGO = PED_ITEN.CODIGO" },
        { tabela: "CADCOR", condicao: "CADCOR.COR = PED_ITEN.COR" }
      ],
      where: [`PED_ITEN.NUMERO = '${altpedidob2b}'`]
    }
    return retornaJsonPesquisaPadrao(JSON.stringify(pesquisa)).then(result => result)
  }

  async function tabelaItenspedido() {
    pesquisaItensPedido().then((itens) => {
      $.LoadingOverlay("show");

      if ($.isEmptyObject(itens)) {
        return $('#tabelaItensPedido').html(`<p class='d-flex justify-content-center border-Field' style="padding-top: 6px !important;">Nenhum registro encontrado</p>`);
      }

      if ($.fn.dataTable.isDataTable('#tabelaItensPedido')) { $('#tabelaItensPedido').DataTable().clear().destroy() }

      criaDataTablePadrao('#tabelaItensPedido', true, true, false, true, false, true, true, itens, colunasTabelaItens);

      $("#tabelaItensPedido").DataTable().columns.adjust().draw(false);
    }).catch((error) => {
      console.error(error);
      msgErro("Não foi possível buscar os itens deste pedido.");
    }).finally(() => {
      $.LoadingOverlay("hide");
    })
  }
});
