$(document).ready(async function () {
  $('#txtEstatisticasTipoVenda').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
  $('#btnEstatisticasTipoVenda').pesquisa('#txtEstatisticasTipoVenda', 'ID', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa Tipo Venda', 'VENDA_TIPO');

  $('#btnEstatisticasLimpaTipoVenda').on('click', function () {
    limpaValor('#txtEstatisticasTipoVenda');
  });

  $('#btnEstatisticasLimparFiltros').on('click', function () {
    limpaValor('#txtEstatisticasTipoVenda');
    $('#txtEstatisticasVendaDe').val('1200-01-01');
    $('#txtEstatisticasVendaAte').val('2500-12-01');
  });

  $('#btnEstatisticasConsultarFiltros').on('click', function () {
    $('#modalEstatisticasFiltros').modal('hide');
    $('#btnEstatisticaConsultar').click();
  });

  $('#btnEstatisticasSelecionarEmpresas').on('click', function () {
    carregaTodasEmpresas();
  });

  async function carregaTotalPago(codcli) {

    const pesquisa = {
      camposSelect: ["SUM(VALOR2) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`,
        `((VALOR2[SOMA]JUROS) <= (VALOR_PAGO[SOMA]DESCONTO[SOMA]VAL_DEV ))`,
        `(SITUACAO <> 'P')`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaTotalPago').html(Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor));
  }

  $('#custom-tabs-one-profile-tab').on('click', function () {
    setTimeout(() => {
      $('#btnEstatisticaConsultar').click();
    }, 1000);
  });

  async function carregaTotalEmAberto(codcli) {

    const pesquisa = {
      camposSelect: ["SUM(VALOR2) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`,
        `((VALOR2[SOMA]JUROS) > (VALOR_PAGO[SOMA]DESCONTO[SOMA]VAL_DEV ))`,
        `(SITUACAO <> 'P')`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaTotalEmAberto').html(Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor));
  }

  async function carregaTotalEmAtraso(codcli) {

    const pesquisa = {
      camposSelect: ["SUM(VALOR2) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`,
        `((VALOR2[SOMA]JUROS) > (VALOR_PAGO[SOMA]DESCONTO[SOMA]VAL_DEV ))`,
        `(SITUACAO <> 'P')`,
        `DT_VENCTO < CURRENT_DATE`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaTotalEmAtraso').html(Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor));
  }

  async function carregaMaiorCompra(codcli) {

    const pesquisa = {
      camposSelect: ["MAX(VALOR) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaMaiorCompra').html(Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor));
  }

  async function carregaMenorCompra(codcli) {

    const pesquisa = {
      camposSelect: ["MIN(VALOR) VALOR "],
      tabela: "RECEBER",
      where: [`CODCLI = '${codcli}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaMenorCompra').html(Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor));
  }

  async function carregaUltimaCompra(codcli) {

    const pesquisa = {
      camposSelect: ["VENDA.VALOR", "(SELECT SUM(QUANTIDADE) QTDE FROM [ITVENDA] ITVENDA WHERE ITVENDA.CODVEN = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDA.EMP_ID) QTDE"],
      tabela: "VENDA",
      where: [`VENDA.CODCLI = '${codcli}'`],
      orderBy: ['VENDA.DATA DESC'],
      limit: 1
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    const qtde = jsonStr[0].QTDE;
    $('#txtEstatisticaUltimaCompraValor').html(`Valor: ${Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor)}`);
    $('#txtEstatisticaUltimaCompraQtde').html(`Qtde: ${qtde}`);
  }

  async function carregaValorDevolvido(codcli) {

    const pesquisa = {
      camposSelect: ["SUM(VENDA.VALOR) VALOR"],
      tabela: "VENDA",
      where: [`VENDA.CODCLI = '${codcli}' AND DEVOLUCAO=1`],
      groupBy: ['VENDA.VALOR'],
      limit: 1
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaValorDevolvido').html(`Valor: ${Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor)}`);
  }

  async function carregaValorCancelado(codcli) {

    const pesquisa = {
      camposSelect: ["SUM(VENDA.VALOR) VALOR"],
      tabela: "VENDA",
      where: [`VENDA.CODCLI = '${codcli}' AND CANCELADA=1`],
      limit: 1
    };

    const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisa)));
    const valor = jsonStr[0].VALOR;
    $('#txtEstatisticaValorCancelado').html(`Valor: ${Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor)}`);
  }

  async function carregaTotalizadoresGerais() {
    const codcli = pegaChave('#txtEstatisticaCliente');
    await carregaTotalPago(codcli);
    await carregaTotalEmAberto(codcli);
    await carregaTotalEmAtraso(codcli);
    await carregaMaiorCompra(codcli);
    await carregaMenorCompra(codcli);
    await carregaUltimaCompra(codcli);
    await carregaValorDevolvido(codcli);
    await carregaValorCancelado(codcli);
  }

  async function BuscarVendasCliente(codcli) {
    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    const dataIni = `'${$('#txtEstatisticasVendaDe').val()}'`;
    const dataFim = `'${$('#txtEstatisticasVendaAte').val()}'`;
    const tipoVenda = pegaChave('#txtEstatisticasTipoVenda');
    const sPendente = $('#cbPendente').prop('checked');
    const sDevolvido = $('#cbDevolvido').prop('checked');
    const sEmitido = $('#cbEmitido').prop('checked');
    const sAgrupada = $('#cbAgrupada').prop('checked');

    const sCancelada = $('#cbCancelada').is(':checked') ? 1 : 0;
    const todos = sCancelada == '1' && sEmitido && sDevolvido && sPendente && sAgrupada;
    var opcao = '';
    let whereStatus = `AND ( `;
    if (sEmitido) {
      if (sAgrupada) {
        whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1))`;
      } else {
        whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) = 0))`;
      }
    }
    if (sDevolvido) {
      if (whereStatus != `AND ( `) {
        whereStatus += ' OR ';
      }
      whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND (((VENDA.TROCA = 1) OR (VENDA.DEVOLUCAO = 1)) AND VENDA.ORCAMENTO = 0))`;
    }
    if (sPendente) {
      if (whereStatus != `AND ( `) {
        whereStatus += ' OR ';
      }
      whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0)`;
    }

    if (sCancelada == 1) {
      if (whereStatus != `AND ( `) {
        whereStatus += ' OR ';
      }
      whereStatus += `((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S') OR (((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO = 'S') AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)))`;
    }
    if (sAgrupada) {
      if (whereStatus != `AND ( `) {
        whereStatus += ' OR ';
      }
      if (sCancelada == 0) {
        whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0 AND ((SELECT CANCELADA FROM [VENDA] WHERE CODVEN = VENDA.CDAGRUPADA) = 0))`
      } else {
        whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)`;
      }
    }
    whereStatus += ') ';

    if (todos) {
      whereStatus = '';
    }

    if (whereStatus != 'AND ( ) ') {
      opcao = whereStatus;
    }

    const pesquisaParam = {
      tabela: "VENDA",
      camposSelect: [
        "VENDA.CODVEN",
        "VENDA.TIPO_VENDA",
        "CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'PENDENTE'" +
        "WHEN ((SELECT CANCELADA FROM VENDA_001 WHERE CODVEN = VENDA.CDAGRUPADA) = 1) THEN 'CANCELADA'" +
        "WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0) THEN 'AGRUPADA'" +
        "WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'" +
        "WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'FECHADA'" +
        "WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'DEVOLUCAO/TROCA'" +
        "ELSE 'Orcamento' END STATUS",
        "VENDA_TIPO.DESCRICAO DESC_TIPO",
        "VENDA.DATA",
        "SUM(ITVENDA.QUANTIDADE) QTDE",
        "SUM(ITVENDA.TOTAL_LIQ) VALOR",
        "CASE WHEN (VENDA.DEVOLUCAO = 0) THEN 0 WHEN (VENDA.DEVOLUCAO <> 0) THEN VENDA.VALOR END VAL_DEVOL",
        // "(SELECT SUM(ITV_DEV.VALOR) VALOR_DEV FROM ITVENDA_001 ITV_DEV WHERE ITV_DEV.CODVEN = VENDA.CODVEN AND ITV_DEV.EMP_ID = VENDA.EMP_ID AND ITV_DEV.TROCA='S') VAL_DEVOL",
        "CASE WHEN (VENDA.CANCELADA = 0) THEN 0 WHEN (VENDA.CANCELADA <> 0) THEN VENDA.VALOR END VAL_CANC",
        "VENDA.EMP_ID",
        "EMPRESA.EMP_NOME LOJA",
        "(SELECT MAX(FATURA) FATURA FROM [NOTA] NOTA WHERE NOTA.CODVEN = VENDA.CODVEN AND NOTA.EMP_ID = VENDA.EMP_ID) FATURA"
      ],
      leftJoin: [
        { tabela: 'VENDA_TIPO', condicao: 'VENDA_TIPO.ID = VENDA.TIPO_VENDA' },
        { tabela: 'ITVENDA', condicao: 'ITVENDA.CODVEN = VENDA.CODVEN AND ITVENDA.EMP_ID = VENDA.EMP_ID' },
        { tabela: 'EMPRESA', condicao: 'VENDA.EMP_ID = EMPRESA.EMP_ID' }
      ],
      where: [`VENDA.CODCLI = '${codcli}' AND VENDA.EMP_ID IN (${listaEmpIds})`,
      `VENDA.DATA BETWEEN ${dataIni} AND ${dataFim} ${whereStatus}`],
      groupBy: ['VENDA.CODVEN'
        , 'VENDA.TIPO_VENDA'
        , 'VENDA.CANCELADA'
        , 'VENDA.FECHADA'
        , 'VENDA.DEVOLUCAO'
        , 'VENDA.AGRUPADA'
        , 'VENDA.CDAGRUPADA'
        , 'VENDA.TROCA'
        , 'VENDA.VALOR'
        , 'VENDA.ORCAMENTO'
        , 'VENDA.CONSIG_FINALIZADO'
        , 'VENDA.IMPRESSO'
        , 'VENDA_TIPO.DESCRICAO'
        , 'VENDA.DATA'
        , 'VENDA.EMP_ID'
        , 'EMPRESA.EMP_NOME'],
      orderBy: ['VENDA.DATA DESC']
    };
    if (tipoVenda !== '') {
      pesquisaParam.where.push(`VENDA.TIPO_VENDA = ${tipoVenda}`);
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    $("#tabelaEstatisticaVendas").DataTable({
      destroy: true,
      order: false,
      search: false,
      filter: false,
      lengthChange: false,
      serverside: false,
      autoWidth: true,
      data: jsonStr,
      columns: [
        {
          data: "CODVEN",
          title: "CODVEN"
        },
        {
          data: "DESC_TIPO",
          title: "DESC_TIPO"
        },
        {
          data: "STATUS",
          title: "STATUS"
        },
        {
          data: "DATA",
          title: "DATA"
        },
        {
          data: "QTDE",
          title: "QTDE"
        },
        {
          data: "VALOR",
          title: "VALOR"
        },
        {
          data: "VAL_DEVOL",
          title: "VAL_DEVOL"
        },
        {
          data: "VAL_CANC",
          title: "VAL_CANC"
        },
        {
          data: "EMP_ID",
          title: "EMP_ID"
        },
        {
          data: "LOJA",
          title: "LOJA"
        },
        {
          data: "FATURA",
          title: "FATURA"
        },
      ],
      columnDefs: [
        {
          "type": 'date-br',
          "targets": 3,
          "render": function (data) {
            if (data != undefined) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            } else {
              return ''
            }
          }
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-br', {
              style: 'currency',
              currency: 'BRL'
            });
          },
          "targets": [5, 6, 7]
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-br', {
              style: 'currency',
              currency: 'BRL'
            });
          },
          "targets": 6
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-br', {
              style: 'currency',
              currency: 'BRL'
            });
          },
          "targets": 7
        }
      ]
    });

    const totalQtde = $("#tabelaEstatisticaVendas").DataTable().data().toArray().reduce((total, curr) => curr.QTDE + total, 0);

    const totalValor = $("#tabelaEstatisticaVendas").DataTable().data().toArray().reduce((total, curr) => curr.VALOR + total, 0);
    $('#txtTotalEstatisticaQuantidade').val(totalQtde);
    $('#txtTotalEstatisticaValor').val(totalValor);
    $("#tabelaEstatisticaVendas").DataTable().columns.adjust().draw(false);

    $('#tabelaEstatisticaVendas tbody').on('click', 'tr', async function () {
      async function retornaDadosItens(codven, empId) {
        const pesquisaParam = {
          tabela: 'ITVENDA',
          camposSelect: ['ITVENDA.CODIGO', `CASE WHEN ITVENDA.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
            'ITVENDA.COR', 'CADCOR.DESCRICAO DESC_COR', 'ITVENDA.TAM', 'ITVENDA.QUANTIDADE', 'ITVENDA.PRECO_LIQ'],
          leftJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
          { tabela: 'PRODUTO', condicao: `PRODUTO.CODIGO = ITVENDA.CODIGO AND ITVENDA.TIPO =  'P'` },
          { tabela: 'MATERIAL', condicao: `MATERIAL.CODIGO = ITVENDA.CODIGO AND ITVENDA.TIPO = 'M'` }],
          where: [`ITVENDA.CODVEN = ${codven} AND ITVENDA.EMP_ID = ${empId} `]
        };
        const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        return response;
      }
      async function retornaDadosPagamento(codven, empId) {
        const pesquisaParam = {
          tabela: 'CONDIVENDA',
          camposSelect: ['CONDIVENDA.CDMOEDA', `MOEDA.DESCRICAO`,
            'COUNT(ITCONDIVENDA.CDITCONDIVENDA) PARCELAS',
            'SUM(ITCONDIVENDA.VALOR_PAGO) VALOR_PAGO'],
          leftJoin: [{ tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = CONDIVENDA.CDMOEDA' },
          { tabela: 'ITCONDIVENDA', condicao: `CONDIVENDA.CDCONDIVENDA = ITCONDIVENDA.CDCONDIVENDA` }],
          where: [`CONDIVENDA.CDVENDA = ${codven} AND CONDIVENDA.EMP_ID = ${empId} `],
          groupBy: ['CONDIVENDA.CDMOEDA', 'MOEDA.DESCRICAO']
        };
        const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        return response;
      }

      $('#tabelaEstatisticaVendas tbody tr.selected').removeClass('selected');
      $(this).addClass('selected');
      $('#modalEstatisticasVenda').modal('show');
      let data = $('#tabelaEstatisticaVendas').DataTable().row($(this)).data();
      const itens = await retornaDadosItens(data.CODVEN, data.EMP_ID);
      const pagamentos = await retornaDadosPagamento(data.CODVEN, data.EMP_ID);
      const colunasItens = itens.length > 0 ? Object.entries(itens[0]).map(item => ({
        title: item[0],
        data: item[0]
      })) : [];
      const colunasPagamentos = pagamentos.length > 0 ? Object.entries(pagamentos[0]).map(item => ({
        title: item[0],
        data: item[0]
      })) : [];
      if (colunasItens.length == 0) {
        $('#tabelaEstatisticaItens').DataTable().clear().draw(false);
      } else {
        criaDataTablePadrao('#tabelaEstatisticaItens', false, false, false, false, true, false, false, itens, colunasItens, []);
      }

      if (colunasPagamentos.length == 0) {
        $('#tabelaEstatisticaPagamento').DataTable().clear().draw(false);
      } else {
        criaDataTablePadrao('#tabelaEstatisticaPagamento', false, false, false, false, true, false, false, pagamentos, colunasPagamentos, []);
      }
    });
  }

  // $("#btnEstatisticasImprimir").on("click", async function () {
  //   try {
  //     $.LoadingOverlay("show");
  //     try {
  //       const sPendente = $('#cbPendente').prop('checked');
  //       const sDevolvido = $('#cbDevolvido').prop('checked');
  //       const sEmitido = $('#cbEmitido').prop('checked');
  //       const sAgrupada = $('#cbAgrupada').prop('checked');
  //       const url = `/sisplan/impressao/v1/imprimeestatisticas?EMITIDO=${sEmitido}&DEVOLVIDO=${sDevolvido}&PENDENTE=${sPendente}&AGRUPADA=${sAgrupada}&`;
  //       const Filtros = await retornaFiltros();
  //       const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstatisticas');
  //       const arquivo = await GeraRelatorio(`${url}${Filtros}`, "GET", 100000, false, 'RelEstatisticas');

  //       if (arquivo != undefined) {
  //         if (!bImprimeAutomatico) {
  //           window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
  //         }
  //         await limparRelatorios();
  //       }
  //     } catch (error) {
  //       console.error(error);
  //     }
  //   } finally {
  //     $.LoadingOverlay("hide");
  //   }
  // });

  async function retornaFiltros() {
    try {
      const sDataIni = $('#txtEstatisticasVendaDe').val();
      const sDataFim = $('#txtEstatisticasVendaAte').val();
      const sCliente = pegaChave('#txtEstatisticaCliente')
      const sTipoVenda = pegaChave('#txtEstatisticasTipoVenda');
      const sEmpIDs = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)) : [getCookie('emp_id')];

      const retorno =
        `DATAINI=${sDataIni}` +
        `&DATAFIM=${sDataFim}` +
        `&TIPO_VENDA=${sTipoVenda}` +
        `&CLIENTE=${sCliente}` +
        `&EMP_IDS=${sEmpIDs}`;

      return retorno;

    } catch (error) {
      console.error(error);
    }
  }

  $('#btnEstatisticaConsultar').on('click', async function () {
    await BuscarVendasCliente(pegaChave('#txtEstatisticaCliente'));
    await carregaTotalizadoresGerais();
  });

  $('#btnEstatisticaFiltros').on('click', async function () {
    $('#modalEstatisticasFiltros').modal('show');
  });

});