$(document).ready(async function () {
    criarTabelaGrade([], [])
    criarTabelaKits([])
    criarTabelaOfs([])
    criarTabelaTag([], [])

    function adicionarFormatacaoCampos() {
        $('.campoInteger').off('maskMoney')
        $('.campoInteger').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 0,
        })
    }

    componenteFiltro(
        'produto',
        false,
        false,
        '',
        [],
        false,
        () => {
            setTimeout(() => {
                const codigo = pegaChave('#txtProduto')
                if (!codigo) {
                    return
                }
                adicionarEventosOrdemProducao(codigo)
                carregarDadosProduto(codigo)
            }, 0)
        },
    )

    componenteFiltro('subColecao', false, false, 'Tag')

    function adicionarEventosOrdemProducao(codigo) {
        componenteFiltro('ordemProducao', false, false, 'NumOF', [`CODIGO = '${codigo}'`])
        $('#txtNumOF').prop('disabled', false)
        $('#btnNumOF').prop('disabled', false)
        $('#btnLimpaNumOF').prop('disabled', false)
    }

    $('#btnLimpaProduto').on('click', function () {
        desabilitarCamposDependentesDoProduto()
    })

    function desabilitarCamposDependentesDoProduto() {
        $('#txtNumOF').prop('disabled', true)
        $('#btnNumOF').prop('disabled', true)
        $('#btnLimpaNumOF').prop('disabled', true)
    }

    function carregarDadosProduto(codigo) {
        $.LoadingOverlay('show')
        buscarDadosProduto(codigo)
            .then((dados) => {
                if (!dados) {
                    return
                }
                criarTabelaKits(dados.kits)
                criarTabelaOfs(dados.ofs)
                const data = transformarDadosTabelaGrade(dados.grade)
                const columns = retornarColunasTabelaGrade(dados.tamanhos)
                criarTabelaGrade(data, columns)
                criarTabelaTag([], [])
            })
            .catch((error) => {
                console.error(error)
                msgErro('Ocorreu um erro ao carregar os dados do produto.')
            })
            .finally(() => $.LoadingOverlay('hide'))
    }

    async function buscarDadosProduto(codigo) {
        const response = await requisicao("GET", `/sisplan/reltagkit/v1/produto?`, `CODIGO=${encodeURIComponent(codigo)}`, '', 3600000)

        const json = await response.json()

        if (!json) {
            return
        }

        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
            throw mensagem?.mensagem
        }

        return resultado
    }

    function criarTabelaKits(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaKits')) {
            $('#tabelaKits').DataTable().destroy()
            $('#tabelaKits').empty()
        }

        const columns = [
            {
                data: 'numero',
                title: 'Número',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'cor',
                title: 'Cor',
            },
            {
                data: 'descCor',
                title: 'Desc. Cor',
            },
        ]

        $("#tabelaKits").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
        }).draw(false)
    }

    function criarTabelaOfs(data = []) {
        if ($.fn.DataTable.isDataTable('#tabelaOfs')) {
            $('#tabelaOfs').DataTable().destroy()
            $('#tabelaOfs').empty()
        }

        const columns = [
            {
                data: 'numero',
                title: 'Número',
            },
            {
                data: 'ativos',
                title: 'Quantidade',
            },
        ]

        $("#tabelaOfs").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
        }).draw(false)
    }

    function criarTabelaGrade(data = [], columns = []) {
        if ($.fn.DataTable.isDataTable('#tabelaGrade')) {
            $('#tabelaGrade').DataTable().destroy()
            $('#tabelaGrade').empty()
        }

        $("#tabelaGrade").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '250px',
        }).draw(false)
        adicionarFormatacaoCampos()
    }

    function transformarDadosTabelaGrade(grade) {
        try {
            const data = []

            grade.forEach((cor) => {
                let datatableItem = {
                    cor: cor.codigo,
                    descCor: cor.descricao,
                }
                cor.tamanhos.forEach((tam) => {
                    datatableItem[tam.codigo] = retornarInputQtde(tam.qtde, cor.codigo, tam.codigo)
                })
                datatableItem = { ...datatableItem, qtdeKits: retornarInputQtde(cor.qtdeKits, cor.codigo, 'qtdeKits') }
                data.push(datatableItem)
            })

            return data
        } catch (error) {
            console.error(error)
            return []
        }
    }

    function retornarColunasTabelaGrade(tamanhos) {
        try {
            const columns = [
                {
                    title: 'Cor',
                    data: 'cor',
                },
                {
                    title: 'Desc. Cor',
                    data: 'descCor',
                }
            ]

            tamanhos.forEach((tam) => {
                columns.push({
                    title: tam,
                    data: tam,
                })
            })

            columns.push({
                title: 'Qtde Kits',
                data: 'qtdeKits'
            })

            return columns
        } catch (error) {
            console.error(error)
            return []
        }
    }

    function retornarInputQtde(qtde, cor, tam) {
        const valor = (safeParseInt(qtde) ?? 0)
        return `<div
              class="input-group-append">
                <input
                  type="text"
                  value="${valor}"
                  class="input-default focus form-control validate text-right campoInteger"
                  id="txtQtde_${cor}_${tam}"
                  placeholder="0"
                  style="max-width: 120px"
                >
            </div>`
    }

    $('#btnGerar').on('click', function () {
        const dados = retornarDadosGerar()
        if (!validarDadosGerar(dados)) {
            return
        }
        gerar(dados)
    })

    function validarDadosGerar(dados) {
        if (!dados.codigoProduto) {
            msgErro('Produto não informado, impossível continuar.')
            return false
        }

        if (!dados.codigoTag) {
            msgErro('Tag não informada, impossível continuar.')
            return false
        }

        if (!dados.numeroKit) {
            msgErro('Produto sem kit cadastrado, impossível continuar.')
        }

        return true
    }

    function validarDadosImprimir(dados) {
        if (!dados.codigoProduto) {
            msgErro('Produto não informado, impossível continuar.')
            return false
        }

        if (!dados.codigoTag) {
            msgErro('Tag não informada, impossível continuar.')
            return false
        }

        if (!dados.numeroKit) {
            msgErro('Produto sem kit cadastrado, impossível continuar.')
            return false
        }

        if (!dados.dados || dados.dados === "[]") {
            msgErro('Nenhuma barra gerada, impossível continuar.')
            return false
        }

        return true
    }

    function retornarDadosGerar() {
        const codigoProduto = pegaChave('#txtProduto')
        const numeroKit = $('#tabelaKits').DataTable().data().toArray()?.[0]?.numero ?? ""
        const codigoTag = pegaChave('#txtTag')
        const numeroOf = pegaChave('#txtNumOF')
        const grade = retornarGradeGerar()
        const dados = $('#tabelaTag').DataTable().rows().count() > 0 ? JSON.stringify($('#tabelaTag').DataTable().data()?.toArray()) : "[]"

        return {
            codigoProduto,
            numeroKit,
            codigoTag,
            numeroOf,
            grade,
            colunaInicial: RelTagKit.colunaInicial,
            dados,
        }
    }

    function retornarGradeGerar() {
        const datatable = $('#tabelaGrade').DataTable()
        const tamanhosProduto = datatable.columns().dataSrc().toArray().filter((it) => !['cor', 'descCor'].includes(it))

        const grade = datatable.data().toArray().map((it) => {
            const cor = {
                codigo: it.cor,
                descricao: it.descCor,
                tamanhos: []
            }

            tamanhosProduto.forEach((tam) => {
                const codigoTamanho = tam === 'qtdeKits' ? 'Kits' : tam
                cor.tamanhos.push({
                    codigo: codigoTamanho,
                    qtde: safeParseInt($(`#txtQtde_${it.cor}_${tam}`).val()) ?? 0
                })
            })

            return cor
        })

        return grade
    }

    async function gerar(dados) {
        try {
            $.LoadingOverlay('show')
            const resultado = await buscarDadosGerar(dados)

            if (!resultado) {
                return
            }
            RelTagKit.colunaInicial = resultado.colunaInicial ?? 0

            const dadosAtualizados = JSON.parse(resultado.dados)

            const colunas = Object.keys(dadosAtualizados?.[0] ?? []).map((it) => ({ title: it, data: it }))

            criarTabelaTag(dadosAtualizados, colunas)
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao gerar as barras.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function buscarDadosGerar(dados) {
        const response = await requisicao("POST", `/sisplan/reltagkit/v1/tag?`, ``, JSON.stringify(dados), 3600000)

        const json = await response.json()

        if (!json) {
            return
        }

        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
            throw mensagem?.mensagem
        }

        return resultado
    }

    function retornarColunasTabelaGrade(tamanhos) {
        try {
            const columns = [
                {
                    title: 'Cor',
                    data: 'cor',
                },
                {
                    title: 'Desc. Cor',
                    data: 'descCor',
                }
            ]

            tamanhos.forEach((tam) => {
                columns.push({
                    title: tam,
                    data: tam,
                })
            })

            columns.push({
                title: 'Qtde Kits',
                data: 'qtdeKits'
            })

            return columns
        } catch (error) {
            console.error(error)
            return []
        }
    }

    function criarTabelaTag(data = [], columns = []) {
        if ($.fn.DataTable.isDataTable('#tabelaTag')) {
            $('#tabelaTag').DataTable().destroy()
            $('#tabelaTag').empty()
        }

        $("#tabelaTag").DataTable({
            info: false,
            order: false,
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '250px',
        }).draw(false)
    }

    $('#btnLimpar').on('click', function () {
        limpar()
        desabilitarCamposDependentesDoProduto()
    })

    function limpar() {
        $('#txtProduto').val('')
        criarTabelaKits([])
        criarTabelaGrade([], [])
        criarTabelaTag([], [])
        criarTabelaOfs([])
        $('#txtProduto').focus()
    }

    $('#btnImprimir').on('click', async function () {
        const dados = retornarDadosGerar()
        if (!validarDadosImprimir(dados)) {
            return
        }
        imprimir(dados)
    })

    async function imprimir(dados) {
        try {
            $.LoadingOverlay('show')
            const imprimirAutomatico = await verificaImprimirAutomatico('RelTagKit');
            let arquivo = await GeraRelatorio(
                `/sisplan/reltagkit/v1/relatorio?`,
                'POST',
                600000,
                false,
                'RelTagKit',
                JSON.stringify(dados),
            )
            if (arquivo != undefined) {
                if (!imprimirAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank')
                }
                await limparRelatorios()
            }
        } catch (e) {
            console.error(e)
            msgErro('Ocorreu um erro ao imprimir.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

})

window.RelTagKit = window.RelTagKit || {}

RelTagKit.colunaInicial = 0