<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Análise de Solicitações</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2512.9.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="dist/css/sisplan.newColorsButtons.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="dist/css/sisplan.adjustDataTableButtons.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2512.9.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.9.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2512.9.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2512.9.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.2512.9.1" />
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2512.9.1">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <link rel="stylesheet" type="text/css" href="../dist/css/sisplan.newColorsButtons.css?versao=3.2512.9.1" />
</head>
<style>
  .table.dataTable tbody td {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }

  .table.dataTable thead th {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }

  table.dataTable {
    margin-top: 0.3125rem !important;
  }

.info-box {
  background-color: #1F2937; /* cinza escuro do fundo */
  border-radius: 6px;
  box-shadow: 0 2px 6px rgba(0,0,0,.3);
  color: #fff;
}

.info-box-icon {
  width: 50px;
  height: 50px;
  min-width: 50px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 6px;
  font-size: 1.4rem;
}

.info-box-content {
  margin-left: 12px;
  line-height: 1.3;
}

:root {
  --info-box-bg: #ffffff;
  --info-box-text: #111827;
}

body.dark-mode {
  --info-box-bg: #1F2937; 
  --info-box-text: #ffffff;
}

.info-box {
  background-color: var(--info-box-bg);
  border-radius: 6px;
  box-shadow: 0 2px 6px rgba(0,0,0,.1);
  color: var(--info-box-text);
}

.info-box-text,
.info-box-number {
  color: var(--info-box-text);
}
</style>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 d-flex align-items-center">
              <h1 class="m-0 text-dark">Relatório de Análise de Solicitações</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="card-body">
                  <div class="row">
                    <div class="col-12">
                      <div class="buttons">
                        <button class="btn btnFiltros btn-sisp" id="btnFiltros" style="height: 38px!important; max-height: 38px!important" type="button"><span class="fas fa-filter"></span> Filtros</button>
                        <button class="btn btnFiltros btn-sisp" id="btnImprimir" style="height: 38px!important; max-height: 38px!important" type="button"><i class="fas fa-print"></i> Imprimir</button>
                        <button class="btn btnFiltros btn-sisp dropdown-toggle" style="height: 38px!important; max-height: 38px!important" type="button" id="dropdownDashboard" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <i class="fas fa-chart-line"></i>
                          Dash
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownDashboard">
                          <a class="dropdown-item" id="graficoVazio" style="cursor: pointer">Nenhum</a>
                          <a class="dropdown-item" id="graficoPadrao" style="cursor: pointer">Padrão</a>
                          <a class="dropdown-item" id="graficoColuna" style="cursor: pointer">Coluna</a>
                          <a class="dropdown-item" id="graficoBarra" style="cursor: pointer">Barra</a>
                          <a class="dropdown-item" id="graficoPizza" style="cursor: pointer">Pizza</a>
                          <a class="dropdown-item" id="graficoLinha" style="cursor: pointer">Linha</a>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card col-sm-12 mt-3">
                    <div class="container-fluid">
                      <div class="row">

                      <div class="col-md-2">
                        <div class="row">
                          <span class="info-box-text text-lg col-md-12 ml-0 pl-0 mt-4" style="color: var(--info-box-texto-rel); height: 0.5vh">Data: <span id="txtPeriodoFiltrado" style="color: #FF0000" class="bold"> </span></span>
                        </div>
                        <div class="row">
                          <span class="info-box-text text-lg col-md-12 ml-0 pl-0 mt-4" style="color: var(--info-box-texto-rel); height: 0.5vh">Repres.: <span id="txtRepresFiltrado" style="color: #FF0000" class="bold"> </span></span>
                        </div>
                      </div>

                        <!-- Sem Análise -->
                        <div class="col-md-2 mb-3 mt-3">
                          <div id="qtdeTotalSemAnalise" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #EAB308;">
                              <i class="fas fa-clipboard"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Sem Análise</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalSemAnalise">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Programação -->
                        <div class="col-md-2 mb-3 mt-3">
                          <div id="qtdeTotalProgramacao" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #6366F1;">
                              <i class="fas fa-cogs"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Programação</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalProgramacao">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Concluído -->
                        <div class="col-md-2 mb-3 mt-3">
                          <div id="qtdeTotalConcluido" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #22C55E;">
                              <i class="fas fa-clipboard-check"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Concluído</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalConcluido">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Rejeitado -->
                        <div class="col-md-2 mb-3 mt-3">
                          <div id="qtdeTotalRejeitado" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #EF4444;">
                              <i class="fas fa-times"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Rejeitado</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalRejeitado">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Total Realizado -->
                        <div class="col-md-2 mb-3 mt-3">
                          <div id="qtdeTotalRealizado" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #22C55E;">
                              <i class="fas fa-check"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Total Realizado</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalRealizado">0</span>
                            </div>
                          </div>
                        </div>

                      <div class="col-md-2">
                        <div class="row">
                          <span class="info-box-text text-lg col-md-12 ml-0 pl-0 mt-4" style="color: var(--info-box-texto-rel); height: 0.5vh">Gestor: <span id="txtGestorFiltrado" style="color: #FF0000" class="bold"> </span></span>
                        </div>
                        <div class="row">
                          <span class="info-box-text text-lg col-md-12 ml-0 pl-0 mt-4" style="color: var(--info-box-texto-rel); height: 0.5vh">Projeto: <span id="txtProjetoFiltrado" style="color: #FF0000" class="bold"> </span></span>
                        </div>
                      </div>

                        <!-- Analisado -->
                        <div class="col-md-2 mb-3">
                          <div id="qtdeTotalAnalisado" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #3B82F6;">
                              <i class="fas fa-eye"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Analisado</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalAnalisado">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Aprovação -->
                        <div class="col-md-2 mb-3">
                          <div id="qtdeTotalAprovacao" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #10B981;">
                              <i class="fas fa-dollar-sign"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Aprovação</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalAprovacao">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Aprovado -->
                        <div class="col-md-2 mb-3">
                          <div id="qtdeTotalAprovado" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #06B6D4;">
                              <i class="fas fa-clipboard-check"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Aprovado</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalAprovado">0</span>
                            </div>
                          </div>
                        </div>

                        <!-- Total Geral -->
                        <div class="col-md-2 mb-3">
                          <div id="qtdeTotal" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #64748B;">
                              <i class="fas fa-clipboard-list"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Total Geral</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotal">0</span>
                            </div>
                          </div>
                        </div>

                        <div class="col-md-2 mb-3">
                          <div id="qtdeTotalClientes" class="info-box d-flex align-items-center p-3">
                            <span class="info-box-icon text-white" style="background-color: #FF7518;">
                              <i class="fas fa-user"></i>
                            </span>
                            <div class="info-box-content ml-2">
                              <span class="info-box-text text-lg" style="color: var(--info-box-texto-rel); height: 3vh">Total Clientes</span>
                              <span class="info-box-number font-weight-bold text-lg" style="color: var(--info-box-texto-rel)" id="txtQtdeTotalClientes">0</span>
                            </div>
                          </div>
                        </div>

                      </div>
                    </div>

                    <div class="row d-flex justify-content-center" style="margin-top: 20px;">
                      <!-- <div class="col-4" id="graficoRelAnaliseSolicitacoes">
                      </div> -->
                    <div class="col-4" id="divGraficoAnaliseSolicitacoes">
                      <div class="w-100 h-full" id="graficoAnaliseSolicitacoes"></div>
                    </div>
                    <div class="col-4 d-none" id="graficoRelAnaliseSolicitacoes">
                    </div>
                    <div class="col-4" id="graficoRelAnaliseSolicitacoes1">
                    </div>
                    <div class="col-4" id="graficoRelAnaliseSolicitacoes2">
                    </div>
                    </div>

                    <div class="row">
                      <div class="col-sm-3 table-responsive mt-4">
                        <table id="tabelaHorasProjeto" class="table table-sm-sisp table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                      <div class="col-sm-5 table-responsive mt-4">
                        <table id="tabelaSolicitacoesCliente" class="table table-sm-sisp table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                      <div class="col-sm-4 table-responsive mt-4">
                        <table id="tabelaSolicitacoesConsultor" class="table table-sm-sisp table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-4 col-sm-6 col-12">
                <label data-error="wrong" data-success="right" for="dtCadastroDe">Cadastro De/Até: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control" id="dtCadastroDe" name="dtCadastroDe" class="form-control">
                    <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control" id="dtCadastroAte" name="dtCadastroAte" class="form-control">
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-4 col-sm-4 col-12 mt-2">
                <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-xl-4 col-4 form-group mt-2">
                <div class="icheck-primary"><input type="checkbox" value="S" class="checkfiltros" id="cbConsideraCliente" data-placement="top" checked><label for="cbConsideraCliente" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os clientes selecionados na pesquisa, se desmarcado, desconsidera os clientes selecionados na pesquisa e filtra por todos as outros clietnes."></label>
                    <label data-error="wrong" style="padding-left: 0px !important" data-success="right" for="txtCliente">Cliente: </label>
                </div>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-sm-4 col-12 mt-2">
                <label data-error="wrong" data-success="right" for="txtGestor">Gestor: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtGestor" name="txtGestor" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGestor" name="btnGestor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGestor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4 col-sm-4 col-12 mt-2">
                <label data-error="wrong" data-success="right" for="txtTecnico">Técnico: </label>
                <div class="relative">
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtTecnico" name="txtTecnico" multiple="multiple"></select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTecnico" name="btnTecnico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTecnico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-2 col-sm-2 col-12 mt-2">
                <div class="form-group">
                  <label>Status: </label>
                  <select class="form-control select2 select2-danger" id="selectStatus" name="selectStatus" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="T">Todas</option>
                    <option value="S">Sem Análise</option>
                    <option value="P">Programação</option>
                    <option value="C">Concluído</option>
                    <option value="R">Rejeitado</option>
                    <option value="A">Analisado</option>
                    <option value="V">Aprovação</option>
                    <option value="O">Aprovado</option>
                  </select>
                </div>
              </div>
              <div class="col-md-2 col-sm-2 col-12 mt-2">
                <div class="form-group">
                  <label>Em Projeto: </label>
                  <select class="form-control select2 select2-danger" id="selectProjeto" name="selectProjeto" data-dropdown-css-class="select2-danger" style="width: 100%;">
                    <option selected="selected" value="T">Todos</option>
                    <option value="S">Sim</option>
                    <option value="N">Não</option>
                  </select>
                </div>
              </div>
              
            </div>
          </div>
          <div class="modal-footer justify-content-start pl-0">
            <div class="row col-12">
              <div class="col-md-4 col-sm-4 col-12">
                <!-- <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div> -->
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                  <button class="btn btn-danger btn-sisp marginBtnH" id="btnLimparFiltros">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
  </main><!-- /.wrapper -->
  <?php include_once('../../modais.php'); ?>

  <script src="plugins/jquery/jquery.min.js?versao=3.2512.9.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2512.9.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2512.9.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2512.9.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2512.9.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2512.9.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2512.9.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2512.9.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2512.9.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2512.9.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2512.9.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.2512.9.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2512.9.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.2512.9.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2512.9.1"></script>
  <script src="utils/funcoes.js?versao=3.2512.9.1"></script>
  <script src="utils/cookies.js?versao=3.2512.9.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2512.9.1"></script>
  <script src="config.js?versao=3.2512.9.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2512.9.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2512.9.1"></script>
  <script src="graficos/graficos.js?versao=3.2512.9.1"></script>
  <script src="plugins/high-charts/highcharts.js"></script>
  <script src="plugins/high-charts/highcharts-3d.js"></script>
  <script src="plugins/high-charts/cylinder.js"></script>
  <script src="plugins/high-charts/exporting.js"></script>
  <script src="plugins/high-charts/export-data.js"></script>
  <script src="pages/relanalise_solicitacoes/graficos.js?versao=3.2512.9.1"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELANALISESOLICITACOES');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relanalise_solicitacoes/relanalise_solicitacoes.js?versao=3.2512.9.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>