$("#tutorial").on("click", function () {
  $(document).ready(function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#valortotal",
        popover: {
          title: "Total a Receber",
          description:
            "Aqui você poderá ver o total que recebeu e ainda receberá.",
          position: "right",
        },
      },
      {
        element: "#valor",
        popover: {
          title: "Valor",
          description: "Aqui você poderá ver o valor somado das duplicatas da lista.",
          position: "right",
        },
      },
      {
        element: "#valorpago",
        popover: {
          title: "Total Pago",
          description: "Aqui você poderá ver o valor que foi recebido.",
          position: "right",
        },
      },
      {
        element: "#valorsaldo",
        popover: {
          title: "Total Saldo",
          description: "Aqui você poderá o valor que está pendente.",
          position: "left",
        },
      },
      {
        element: "#valorsaldoselecionadas",
        popover: {
          title: "Total Saldo Selecionadas",
          description: "Aqui você poderá o valor que está pendente somente das duplicatas que foram selecionadas.",
          position: "left",
        },
      },
      {
        element: "#abreBotoes",
        popover: {
          title: "Leque de botões",
          description: "Você pode clicar aqui para abrir outras possibilidades de botões da tela.",
          position: "right",
        },
        // afterNext: function (nextStepIndex, stepElement) {
        //   $('#abreBotoes').trigger('click');
        // },
      },
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Você pode clicar aqui para filtrar sua consulta.",
          position: "right",
        },
      },
      {
        element: "#btn-novoReceber",
        popover: {
          title: "Botão Novo",
          description:
            "Você pode clicar aqui para adicionar um contas a receber.",
          position: "right",
        },
      },
      {
        element: "#tabelaTour",
        popover: {
          title: "Duplicatas",
          description:
            "Aqui você verá todos os contas a receber que você possui.",
          position: "top",
        },
      },
    ]);
    // inicio tour
    driver.start();
  });
});

$(document).ready(async function () {

  const campos = retornaIdCamposConsulta('#modal-filtros input, #modal-filtros select');
  let tempoSegundosPix = 300;
  const parametrosVenda = await BuscaParametrosVenda();
  const parametrosReceber = await BuscaParametrosReceber();
  let bRemoverClienteSPC = null;

  let validouSenhaSupervisorBaixa = false;

  const columnsObservacao = [
    { data: "ID", title: 'Id' },
    { data: "NUMERO", title: 'Número' },
    { data: "OBS", title: 'Observação', width: '600px !important' },
    { data: "MOTIVO", title: 'Motivo', width: '200px' },
    { data: "USUARIO", title: 'Usuário' },
    { data: "DATA", title: 'Dt.Cadastro' },
    { data: "EMP_ID", title: 'EmpId' },
  ]

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.acessoReceber == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoReceber: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoReceber: novasColunas }))

      $('#tabelaReceber').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaReceber').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const permissaoUsuarioLogado = await permissaoAcessos("RECEBER");
  await setarDataAtual("txtDTPagamento");
  await setarDataAtual("txtDTContabilizacao");
  await setarDataAtual("txtDTPagamentoAnt");
  await setarDataAtual("txtDTContabilizacaoAnt");
  await setarDataAtual("txtVenctoI");
  await setarDataAtual("txtVenctoF");


  const configuracoes = {
    '0': { checked: false, disabled: false, readonly: false },
    '1': { checked: true, disabled: true, readonly: true },
    '2': { checked: true, disabled: false, readonly: false },
    '3': { checked: false, disabled: true, readonly: true }
  };

  (async function () {
    const { VALOR } = (parametrosReceber[6]);
    $('#cbNaoLancaCc').prop(configuracoes[VALOR]);
    $('#cbNaoLancaCcAnt').prop(configuracoes[VALOR]);
  })();

  await addBandeira();
  adicionaMascaraCampos();
  preencheOrdenacaoTela('Receber');
  if (await apenasClientesVinculadosAoRepresentante()) {
    bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentanteConsulta', '#btn-RepresentanteConsulta', '#btn-limpa-RepresentanteConsulta');
  }

  const bValCambial = await CopiaParametro("SISTEMA", 5) == '1';

  if (bValCambial) {
    $('.valCambial').removeClass('d-none');
  }

  const lancaCaixa = (await CopiaParametro("RECEBER", 0)) == "1";

  let response = await requisicao(
    "GET",
    "/Sisplan/Funcoes/v1/pesquisa?",
    `JSON={ "tabela":"PERMISSOES_TELA",
            "camposSelect":["PERMISSAO"],
            "where": ["USUARIO = '${getCookie(
      "cod_usuario"
    )}' AND EMP_ID = ${getCookie(
      "emp_id"
    )} AND TELA = 'RECEBER' AND ACAO = 'ALTERAR_CHECK_CAIXA'"]}`,
    null
  );
  if (!response || response.status != 200) {
    return;
  }
  let jsonStr = await response.json();

  let podeAlterarCheck;
  if (jsonStr.RESULT[0].length > 0) {
    podeAlterarCheck = jsonStr.RESULT[0][0].PERMISSAO == "S";
  } else {
    podeAlterarCheck = false;
  }

  const FormatoDtNovo = "DD/MM/YYYY";

  function primeiroDia() {
    let agora = new Date();
    let primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
    return primeiroDia;
  }

  var primeiroDia = primeiroDia();
  var dataISO = primeiroDia.toISOString();
  var dataString = dataISO.substr(0, 10);


  $("#txtClasse").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtClasseAnt").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtClasseJuros").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );

  $('#txtClienteConsulta').pesquisa_variosServerside(3, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
  $("#txtRepresentanteConsulta").autocompleta(
    3,
    `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where":["ativo = 'S'"]}`
  );

  $("#txtMoeda").autocompleta(
    1,
    `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": null, "orderBy": ["CODMOE"]}`,
    ["#txtTipoMoeda"],
    ["TIPO"],
    ["TIPO"]
  );

  $("#txtConta").autocompleta(
    1,
    `JSON={ "tabela":"cadconta", "camposSelect":[ "conta chave", "descricao descricao"], "where": null}`
  );

  $("#txtHistorico").autocompleta(
    1,
    `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`
  );

  $("#txtHistoricoAnt").autocompleta(
    1,
    `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`
  );

  $("#txtChequeSituacao").autocompleta(
    1,
    `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtChequeClasse").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtChequeRepresentante").autocompleta(
    3,
    `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"]}`
  );
  $("#txtChequeCliente").autocompleta(
    3,
    `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );
  $("#txtChequeHistorico").autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
  $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
  $('#btn-limpa-condicao').on('click', function () {
    limpaValor('#txtCondicaoDePagamento');
    limpaValor('#txtNrParcelas');
  });

  $("#btn-ChequeClasse").pesquisa(
    "#txtChequeClasse",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-ChequeCliente").pesquisa(
    "#txtChequeCliente",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`,
    "Pesquisa Cliente",
    "entidade"
  );
  $("#btn-ChequeRepresentante").pesquisa(
    "#txtChequeRepresentante",
    "CODREP",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`,
    "Pesquisa Representante",
    "represen"
  );
  $("#btn-ChequeSituacao").pesquisa(
    "#txtChequeSituacao",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Situação",
    "tabsit"
  );
  $("#btnChequeHistorico").pesquisa("#txtChequeHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, "Pesquisa Histórico", "HISTCP");

  $("#btn-limpa-ChequeClasse").on("click", function () {
    $("#txtChequeClasse").val("");
  });

  $("#btn-limpa-ChequeCliente").on("click", function () {
    $("#txtChequeCliente").val("");
  });

  $("#btn-limpa-ChequeRepresentante").on("click", function () {
    $("#txtChequeRepresentante").val("");
  });

  $("#btn-limpa-ChequeSituacao").on("click", function () {
    $("#txtChequeSituacao").val("");
  });

  $("#btnLimpaChequeHistorico").on("click", function () {
    $("#txtChequeHistorico").val("");
  });

  $('#txtGuia').autocompleta(1, `JSON={ "tabela": "REPRESEN", "camposSelect": ["CODREP CHAVE", "NOME DESCRICAO"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP = 'U'"]}`);
  $("#btnGuia").pesquisa_serverside(['#txtGuia'], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": ["ATIVO = 'S'", "GRUPO_REP = 'U'"]}`, 'Pesquisa Guia');
  $("#btnLimpaGuia").on("click", function () {
    $("#txtGuia").val("");
  });

  $("#btn-Classe").pesquisa(
    "#txtClasse",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-ClasseAnt").pesquisa(
    "#txtClasseAnt",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-ClasseJuros").pesquisa(
    "#txtClasseJuros",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );

  $('#btn-ClienteConsulta').pesquisa_serversideSel('#txtClienteConsulta', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ", "FANTASIA"], "where": null}`, 'Pesquisa de Cliente');
  $("#btn-RepresentanteConsulta").pesquisa_array(
    ["#txtRepresentanteConsulta"],
    ["CODREP"],
    ["NOME"],
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"], "where": ["ativo = 'S'"]}`,
    "Pesquisa Representante",
    "represen"
  );
  $("#btnMoeda").pesquisa_array(
    ["#txtMoeda", "#txtTipoMoeda"],
    ["CODMOE", "TIPO"],
    ["DESCRICAO", "TIPO"],
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao", "TIPO"], "orderBy": ["CODMOE"]}',
    "Pesquisa Moeda",
    "MOEDA"
  );
  $("#btnConta").pesquisa(
    "#txtConta",
    "CONTA",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "conta", "descricao"]}`,
    "Pesquisa Conta",
    "cadconta"
  );
  if (!lancaCaixa) {
    $("#btnCaixa").pesquisa(
      "#txtCaixa",
      "CODIGO",
      "DESCRICAO",
      '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
      "Pesquisa Tabela",
      "CAIXA_LOJA"
    );

    $("#txtCaixa").autocompleta(
      1,
      `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`
    );
  }
  $("#btn-Historico").pesquisa(
    "#txtHistorico",
    "HISTORICO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`,
    "Pesquisa Histórico",
    "histcp"
  );
  // $("#btn-SituacaoBaixa").pesquisa(
  //   "#txtSituacaoBaixa",
  //   "CODIGO",
  //   "DESCRICAO",
  //   `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`,
  //   "Pesquisa Situação",
  //   "tabsit"
  // );
  $("#btn-HistoricoAnt").pesquisa(
    "#txtHistoricoAnt",
    "HISTORICO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`,
    "Pesquisa Histórico",
    "histcp"
  );

  $('#btnObservacaoMotivo').pesquisa('#txtObservacaoMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#txtObservacaoMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnLimpaObservacaoMotivo').on('click', function () { $('#txtObservacaoMotivo').val('') })

  componenteFiltro('moeda', true, true, 'MoedaConsulta')
  componenteFiltro('classe', true, true, 'ClasseGerConsulta')
  componenteFiltro('caixa', true, true, 'NumeroCaixa')
  componenteFiltro('situacao', true, true, 'SituacaoConsulta')
  componenteFiltro('historico', true, true, 'HistoricoConsulta')
  componenteFiltro('conta', true, true, 'ContaConsulta')
  componenteFiltro('banco', true, true, 'BancoConsulta')
  componenteFiltro("grupoCli", true);
  componenteFiltro("perfil", true);


  $("#btn-limpa-Historico").on("click", function () {
    $("#txtHistorico").val("");
  });

  // $("#btn-limpa-SituacaoBaixa").on("click", function () {
  //   $("#txtSituacaoBaixa").val("");
  // });

  $("#btn-limpa-HistoricoAnt").on("click", function () {
    $("#txtHistoricoAnt").val("");
  });

  $("#btn-limpa-Classe").on("click", function () {
    $("#txtClasse").val("");
  });

  $("#btn-limpa-ClasseAnt").on("click", function () {
    $("#txtClasseAnt").val("");
  });

  $("#btn-limpa-ClasseJuros").on("click", function () {
    $("#txtClasseJuros").val("");
  });

  $("#btn-limpa-Caixa").on("click", function () {
    $("#txtCaixa").val("");
  });

  $("#btn-limpa-ClienteConsulta").on("click", function () {
    $('#txtClienteConsulta').empty().trigger('change');
  });
  $("#btn-limpa-Conta").on("click", function () {
    $('#txtConta').val('');
  });

  $("#btn-limpa-RepresentanteConsulta").on("click", function () {
    $("#txtRepresentanteConsulta").val("");
  });

  $('#txtNumeroChConsulta').pesquisa_variosServerside(1, `{ "tabela": "RECEBER", "camposSelect": ["NUMERO_CH", "STATUS"], "where": ["NUMERO_CH <> ''"], "groupBy":["NUMERO_CH", "STATUS"]}`, 'NUMERO_CH', 'STATUS');
  $("#btnNumeroChConsulta").pesquisa_serversideSel('#txtNumeroChConsulta', `{"tabela":"RECEBER", "camposSelect":["NUMERO_CH", "STATUS"], "where": ["NUMERO_CH <> ''"], "groupBy":["NUMERO_CH", "STATUS"]}`, 'Pesquisa Número Cheque');
  $("#btnLimpaNumeroChConsulta").on("click", function () {
    $("#txtNumeroChConsulta").empty().trigger('change');
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btn-novoReceber").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "receber/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#checkCaixa").on("click", async function () {
    if ($("#checkCaixa").prop("checked") == true) {
      $("#checkCaixa").prop("checked", true);
      $("#lancaCaixa").removeClass("d-none");
      $("#divMoeda").removeClass("col-lg-9");
      await VinculaCaixaComUsuario();
      $("#txtCaixa").val(sessionStorage.getItem("g_caixa_logado"));
      if (
        sessionStorage.getItem("g_caixa_logado") == null ||
        sessionStorage.getItem("g_caixa_logado") == "undefined" ||
        sessionStorage.getItem("g_caixa_logado") == undefined
      ) {
        $("#txtCaixa").val("");
      } else {
        await preencheContaVendaCaixa(pegaChave(sessionStorage.getItem("g_caixa_logado")))
      }
    } else {
      $("#checkCaixa").prop("checked", false);
      $("#lancaCaixa").addClass("d-none");
      $("#divMoeda").removeClass("col-lg-6");
      $("#divMoeda").addClass("col-lg-9");
    }
  });

  $("#btnLimparFiltros").on("click", function () {
    // modal empresas
    $('#modal-empresas').find('input[type="checkbox"]').prop('checked', false);
    $(`#cbEmpresa-${getCookie('emp_id')}`).prop('checked', true);

    // selects
    $('#modal-filtros').find('select').val('').trigger('change');
    $("#txtSituacao").val("Em Aberto").trigger('change');

    // datas
    $("#txtDataEmiI").val("1200-01-01");
    $("#txtDataEmiF").val("2500-12-31");
    $("#txtVenctoI").val("1200-01-01");
    $("#txtVenctoF").val("2500-12-31");
    $("#txtPagamentoI").val("1200-01-01");
    $("#txtPagamentoF").val("2500-12-31");

    // autocompletas 
    if (!$('#txtRepresentanteConsulta').attr('disabled')) {
      limpaValor('#txtRepresentanteConsulta');
    }
    limpaValor('#txtClienteConsulta');
    limpaValor('#txtGuia');
    limpaValor('#txtMoedaConsulta');
    limpaValor('#txtClasseGerConsulta');
    limpaValor('#txtSituacaoConsulta');
    limpaValor('#txtHistoricoConsulta');
    limpaValor('#txtBancoConsulta');
    limpaValor('#txtContaConsulta');
    limpaValor('#txtNumeroCaixa');
    limpaValor('#txtNumeroChConsulta');
    $('#txtGrupoCli').empty().trigger('change');
    $('#txtPerfil').empty().trigger('change');

    // aqui limpa todos os campos tipo text checkbox e number...    
    $('#modal-filtros').find('input[type="text"]').val('');
    $('#modal-filtros').find('input[type="checkbox"]').prop('checked', false);
    $('#modal-filtros').find('input[type="number"]').val('');

    // limpa os filtros do cache do navegador
    limparFiltrosCache('filtrosAcessoReceber');

    // limpa as ordenações e seleciona a primeira
    preencheOrdenacaoTela('Receber');
  });

  async function verificaMoedaTef(codMoeda) {

    const pesquisa = {
      tabela: 'MOEDA',
      camposSelect: ['TEF'],
      where: [`CODMOE = ${codMoeda}`]
    }
    //adicionar where dos filtros
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return json[0].TEF == 'S';
  }

  async function verificaMoedaPix(codMoeda) {

    const pesquisa = {
      tabela: 'MOEDA',
      camposSelect: ['TIPO'],
      where: [`CODMOE = ${codMoeda}`]
    }

    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return json[0].TIPO == '5';
  }

  async function verificaMoedaPixSemIntegracao(codMoeda) {

    const pesquisa = {
      tabela: 'MOEDA',
      camposSelect: ['FORMA_PAGTO'],
      where: [`CODMOE = ${codMoeda}`]
    }

    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return json[0].FORMA_PAGTO == '20';
  }

  $("#txtMoeda").on("focusout", async function () {

    if ($("#txtMoeda").val() == "") {
      $("#divNSU").addClass("d-none");
      $("#divCondicoesDePagamento").addClass("d-none");
      return;
    }
    await verificaMoeda();

    if ($('#txtMoeda').val() != '') {
      atualizaValorPago();
      atualizaValorTotal();
      atualizaTotalDesconto();
      atualizaTotalJuros();
      calculaTroco();

      const possuiTroco = await moedaPossuiTroco(pegaChave('#txtMoeda'));

      if (!$("#divCondicoesDePagamento").hasClass('d-none')) {
        $('#txtCondicaoDePagamento').focus();
      }

      habilitaTroco(possuiTroco);
      buscaCondicoes(pegaChave(this));
    } else {
      $('#txtClasse').val('')
      $('#txtClasseJuros').val('')
      $('#txtConta').val('')
      $('#txtHistorico').val('')
    }
  });

  function habilitaTroco(possuiTroco = false) {
    if (possuiTroco) {
      $("#divTroco").removeClass("d-none");
      $("#divValorRecebido").removeClass("d-none");
    } else {
      $("#divTroco").addClass("d-none");
      $("#divValorRecebido").addClass("d-none");
    }
  };

  function calculaTroco() {
    const valorPago = parseFloat($("#txtTotalPago").val()).toFixed(2);
    let valorRecebido = parseFloat($('#txtValorRecebido').val())
    if (isNaN(valorRecebido)) {
      valorRecebido = 0;
    }
    const troco = (valorRecebido - valorPago) > 0 ? (valorRecebido - valorPago) : 0;
    if (isNaN(troco)) {
      troco = 0;
    }
    $("#txtTroco").val(
      parseFloat(troco).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  };

  $('#txtValorRecebido').on('blur', function () {
    calculaTroco();
    $("#txtValorRecebido").val(
      parseFloat($(this).val()).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  });

  async function moedaPossuiTroco(moeda) {
    try {
      $.LoadingOverlay('show');
      try {
        let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"MOEDA", "camposSelect":["GERA_TROCO"],"where": ["CODMOE = '${moeda}'"]}`, null);

        if (!response) {
          return;
        }

        let jsonMoeda = await response.json();
        if (response.status != 200) {
          jsonMoeda['RESULT'][0].mensagem;
          return;
        }
        if (jsonMoeda['RESULT'][0][0]['GERA_TROCO'] == 'S') {
          return true;
        } else {
          return false;
        }

      } catch (error) {
        console.error(error);
        msgErro('Erro ao buscar os dados da moeda!' + error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function montaJsonTef(codMoeda) {
    try {
      const pesquisa = {
        tabela: 'MOEDA',
        camposSelect: ['TEF', 'TIPO_CARTAO'],
        where: [`CODMOE = ${codMoeda}`]
      }
      //adicionar where dos filtros
      const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      const dados = {
        formaPagamento: [{
          Tipo_Cartao: json[0].TIPO_CARTAO,
          Qtde_Parcela: pegaChave('#txtNrParcelas'),
          UsaTEF: json[0].TEF == 'S',
          ImprimeGR: false,
          Valor: parseFloat($("#txtTotalPago").val()).toFixed(2),
          DescricaoMoeda: pegaDescricao('#txtMoeda'),
          CodCondivenda: '',
          CodMoedaECF: '',
        }]
      }

      return dados;

    } catch (error) {
      console.error(error);
    }
  }

  async function verificaChamaTef() {
    try {
      const json = await montaJsonTef(pegaChave('#txtMoeda'));
      const url = '/tef/vendamanualtef?';
      const response = await requisicao_ecf('POST', url, '', JSON.stringify(json), 900000);

      if (!response) {
        return false;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return false;
      }

      jsonStr.Moeda = pegaChave("#txtMoeda");

      return jsonStr;

    } catch (error) {
      console.error(error);
    }
  }

  async function preencheInformacaoMoeda(infosMoeda) {
    $('#txtClasse').val('');
    $('#txtClasseJuros').val('');
    $('#txtHistorico').val('');
    $('#txtConta').val('');
    insereValor($("#txtHistorico"), infosMoeda[0].CODHISTORICO, infosMoeda[0].DESC_HISTORICO);
    insereValor($("#txtClasse"), infosMoeda[0].CLASSE, infosMoeda[0].DESC_CLASSE);
    insereValor($("#txtClasseBaixa"), infosMoeda[0].CLASSE, infosMoeda[0].DESC_CLASSE);
    insereValor($("#txtConta"), infosMoeda[0].CONTA, infosMoeda[0].CONTA);

    if ($('#txtConta').val() == '') {
      let conta = await retornaValorCadPadrao('RECEBER', 'CONTA')

      if (conta) {
        insereValor('#txtConta', conta, conta)
      }
    }

    if (parametrosReceber[7].VALOR == 1) {

      if ($('#txtConta').val() != '') {
        $('#txtConta').prop('disabled', true);
        $('#btnConta').prop('disabled', true);
        $('#btn-limpa-Conta').prop('disabled', true);
      } else {
        $('#txtConta').prop('disabled', false);
        $('#btnConta').prop('disabled', false);
        $('#btn-limpa-Conta').prop('disabled', false);
      }
    }
  }

  async function verificaMoeda() {
    const moeda = pegaChave("#txtMoeda");
    const classe = $('#txtClasse').val();
    const historico = $('#txtHistorico').val();
    const conta = $('#txtConta').val();
    const url = "/sisplan/moeda/v1/consultamoeda?";
    try {
      const response = await requisicao("GET", url, `MOEDA=${moeda}`, "", 120000);

      if (!response) {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
        return;
      }

      if (response.status != 200) {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
        return;
      }

      const infosMoeda = await response.json();

      if (parametrosReceber[9].VALOR == 1) {
        aplicaDescAuto(infosMoeda[0].DESC_AUTO);
      }

      if (classe != "" || historico != "" || conta != "") {

        await msgAguardaConfirmacao("Existem informações nos campos Histórico, Conta e Classe. Deseja preenche-los com as informações do cadastro de moeda?",
          async () => {
            await preencheInformacaoMoeda(infosMoeda);
            await rotinaGeraLog("MODAL_BAIXA_RECEBER", infosMoeda[0].MOEDA, `O USUÁRIO ${getCookie("g_usuario_logado")} OPTOU POR UTILIZAR AS INFORMAÇÕES DO CADASTRO DE MOEDA`, "Alteração");
          },
          async () => { await rotinaGeraLog("MODAL_BAIXA_RECEBER", infosMoeda[0].MOEDA, `O USUÁRIO ${getCookie("g_usuario_logado")} OPTOU POR MANTER AS INFORMAÇÕES DO MODAL DE BAIXAS DO RECEBER`, "Alteração"); },
        );


      } else {
        await preencheInformacaoMoeda(infosMoeda)
      }

      if (infosMoeda[0].TIPO == "3" && infosMoeda[0].TEF == "N") {
        $("#divNSU").removeClass("d-none");
        $("#divCondicoesDePagamento").removeClass("d-none");
      } else {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
      }

      $('#cbNaoLancaCc').prop('checked', (infosMoeda[0].TIPO == "3" || infosMoeda[0].TIPO == "1"));
      $('#cbNaoLancaCc').prop('disabled', (infosMoeda[0].TIPO == "3" || infosMoeda[0].TIPO == "1"));
    } catch (error) {
      console.error(error);
    }

  }

  async function VinculaCaixaComUsuario() {
    const _url = "/sisplan/funcoes/v1/pesquisa?";
    const nomeUsuario =
      getCookie("cod_usuario") == "0000" ? "SISPLAN" : getCookie("usuario");
    const _usuarioCaixa = `JSON={"tabela": "VENDA_CAIXA", 
          "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO"], 
          "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"],
          "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}]}`;
    try {
      const response = await requisicao("GET", _url, _usuarioCaixa, null);
      if (!response) {
        msgErro("Erro ao buscar caixas vinculados ao usuário.");
        return;
      }

      if (response.status == 200) {
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length >= 1) {
          const sCaixa = `[${jsonStr.RESULT[0][0].NRCAIXA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
          sessionStorage.setItem("g_caixa_logado", sCaixa);
          // $("#txtCaixa").attr("disabled", true);
          // $("#btn-limpa-Caixa").addClass("d-none");
          // $("#btn-impostor").removeClass("d-none");
          // $("#btnCaixa").addClass("d-none");
          $("#btnCaixa").pesquisa(
            "#txtCaixa",
            "CODIGO",
            "DESCRICAO",
            `/sisplan/funcoes/v1/pesquisa?JSON={ 
              "tabela":"caixa_loja", 
              "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
              "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
              "where": ["VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
            }`,
            "Pesquisa Tabela",
            "CAIXA_LOJA"
          );

          $("#txtCaixa").autocompleta(
            1,
            `JSON={ 
              "tabela":"caixa_loja", 
              "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
              "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
              "where": ["VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
            }`
          );
        } else {
          $("#btnCaixa").pesquisa(
            "#txtCaixa",
            "CODIGO",
            "DESCRICAO",
            '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
            "Pesquisa Tabela",
            "CAIXA_LOJA"
          );

          $("#txtCaixa").autocompleta(
            1,
            `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`
          );
        }
      } else {
        msgErro("Erro ao buscar caixas vinculados ao usuário.");
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro("Erro ao buscar caixas vinculados ao usuário.");
    }
  }

  $("#btn-impostor").on("click", async function () {
    function abrePesquisaCaixa() {
      $("#btnCaixa").trigger("click");
    }
    await senhaSupervisor(`Usuário com caixa vinculado.`, abrePesquisaCaixa, '', false, undefined, undefined, undefined, false, 'ACESSORECEBER');
  });

  function atualizaTotais() {
    $("#txt_val_total").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(8).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(8).data().filter((value, index) => $("#tabelaReceber").DataTable().row(index).data().STATUS !== 'ANTE').sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val_pago").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(9).data().filter((value, index) => $("#tabelaReceber").DataTable().row(index).data().STATUS !== 'ANTE').sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val_saldo").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(12).data().filter((value, index) => $("#tabelaReceber").DataTable().row(index).data().STATUS !== 'ANTE').sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_desconto").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(10).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_juros_multa_calc").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(11).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    const valAntecipacao = $("#tabelaReceber").DataTable().column(8).data().filter((value, index) => $("#tabelaReceber").DataTable().row(index).data().STATUS === 'ANTE').sum();
    $("#txtvalorAntecipacao").html(
      parseFloat(
        valAntecipacao
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txtsaldoAntecipacao").html(
      parseFloat(
        valAntecipacao - $("#tabelaReceber").DataTable().column(9).data().filter((value, index) => $("#tabelaReceber").DataTable().row(index).data().STATUS === 'ANTE').sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_valmoeda").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(40).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_valpagomoeda").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(41).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_saldomoeda").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(40).data().sum() - $("#tabelaReceber").DataTable().column(41).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    let totalAtraso = 0
    const hoje = new Date()

    $("#tabelaReceber")
      .DataTable()
      .rows()
      .data()
      .toArray()
      .forEach((linha) => {
        const dataVencimento = new Date(linha.DT_VENCTO);
        const saldo = parseFloat(linha.SALDO);
        if (dataVencimento < hoje && !isNaN(saldo)) {
          totalAtraso += saldo;
        }
      });

    $("#txt_em_atraso").html(
      totalAtraso.toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );
  }

  // botoes do grid
  function botaoSelecionarGrid() {
    return (
      '<div class="form-check">' +
      '<div class="icheck-primary"><input type="checkbox" class="align-self-center checkReceber" value""><label></label></div>' +
      "</div>"
    );
  }

  function retornaBotaoOpcoes(sNumero) {
    return (
      '   <div class="dropdown" width="200px!important"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      "      " + sNumero + " " +
      "    </button> " +
      '    <div class="dropdown-menu" style="min-width: 2rem; width:200px; text-align:left"> ' +
      '    <a id="btnEdit" class="dropdown-item" href="#"><i class="fas fa-edit"></i> Editar</a>' +
      '    <a id="btnVisualizar" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg"><i class="far fa-eye"></i> Visualizar Dados</a>' +
      '    <a id="btnItensVenda" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-itens-venda-modal-lg"><i class="far fa-list-alt"></i> Itens da Venda</a>' +
      '    <a id="btnExcluir" class="dropdown-item" href="#"> <i class="fas fa-trash"></i> Excluir</a>' +
      '    <a id="btnLancRateio" class="dropdown-item" href="#"> <i class="fas fa-sitemap"></i> Rateio</a>' +
      '    <a id="btnAnexos" class="dropdown-item" href="#"> <i class="fas fa-folder-open"></i> Gestão Documentos</a>' +
      '    <a id="btnObservacao" class="dropdown-item" href="#"> <i class="fas fa-plus"></i> Incluir Observação</a>' +
      "    </div>" +
      "</div>"
    );
  }

  function retornaBotaoEstornar(data) {
    return (
      '<div style="text-align:center;"> ' +
      '   <div class="dropdown" width="150px!important"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      `      ${data}` +
      "    </button> " +
      '    <div class="dropdown-menu" style="min-width: 2rem; width:150px; text-align:left"> ' +
      '    <a id="btnEstornar" class="dropdown-item"  >Estornar</a>' +
      `    <a id="btnImprimirBaixaUnica" class="dropdown-item"  ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout BaixasReceber.FR3"' : ''}>Imprimir Baixa</a>` +
      "    </div>" +
      "  </div>" +
      "</div>"
    );
  }

  async function pegaValoresModalBaixa() {
    try {
      let table = $("#tabelaBaixar").DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto = {};
      // pegar valor pago
      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          CODCLI: pegaChave("#txtClienteVisual"),
          NSU: $('#txtNsuVisual').val(),
          SALDO: $("#txtSaldoVisual", objeto.SALDO).val(),
          VALOR: $("#txtValorPagoVisual", objeto.VALOR).val(),
          DT_EMISSAO: `${$("#txtDTEmissaoVisual").val()}`,
          NOTAFISCAL: `${$("#txtNotaFiscalVisual").val()}`,
          NUMERO: rows.data()[i].NUMERO,
          LANCAMENTO: rows.data()[i].LANCAMENTO,
          DT_PAGTO: rows.data()[i].DT_PAGTO,
          VALOR_PAGO: rows.data()[i].VALOR_PAGO,
          MOEDA: rows.data()[i].MOEDA,
          DESC_MOEDA: rows.data()[i].DESC_MOEDA,
          DESCONTO: 0,
          JUROS: rows.data()[i].NUMERO,
        };

        valores.push(objeto);
        objeto = {};
      }

      return valores;

    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  $('#btnImprimirBaixasVisual').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      const nBaixas = await pegaValoresModalBaixa();
      let numeros = [];
      for (let i = 0; i < nBaixas.length; i++) {
        numeros.push(nBaixas[i].NUMERO);
      }

      const listaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#ModalVisualizarBaixa').modal('hide');
    }

  });

  retornaHintRelatorio('btnImprimirBaixas', 'BaixasReceber')
  retornaHintRelatorio('btnImprimir', 'Receber')
  retornaHintRelatorio('btnImprimirBaixasVisual', 'BaixasReceber')

  $('#btnImprimirBaixas').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      let arrNumeros = [];
      const data = $("#tabelaReceber").DataTable().rows(".selected").data();

      data.map(item => { arrNumeros.push(item.NUMERO); });

      const listaNumeros = `'${arrNumeros.toString().replaceAll(",", "','")}'`;

      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}&DT_PAGTO_DE=${$('#txtPagamentoI').val()}&DT_PAGTO_ATE=${$('#txtPagamentoF').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }

  });

  async function pegaValoresBaixaUnica(table) {
    try {
      lancamento = table.LANCAMENTO
      let valores = [];
      let objeto = {};
      // pegar valor pago
      objeto = {
        LANCAMENTO: lancamento,
      };

      valores.push(objeto);
      objeto = {};

      return valores;

    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  $("#tabelaBaixar").on("click", "#btnImprimirBaixaUnica", async function () {
    $.LoadingOverlay('show');
    try {
      const table = $('#tabelaBaixar').DataTable().row($(this).parents("tr")).data();

      const nBaixas = await pegaValoresBaixaUnica(table);

      let lancamento = [];
      for (let i = 0; i < nBaixas.length; i++) {
        lancamento.push(nBaixas[i].LANCAMENTO);
      }

      url = `/sisplan/impressao/v1/receber?LANCAMENTO=${lancamento}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#ModalVisualizarBaixa').modal('hide');
    }

  });

  async function buscaBaixas(numeroReceber) {
    let url = `/sisplan/Receber/v1/BaixaReceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `numero=${numeroReceber}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      jsonStr = jsonStr.map((retorno) => ({
        ...retorno,
        DT_PAGTO: retorno.DT_PAGTO.slice(0, 10),
      }));
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta("Não Existem Baixas Cadastradas");
    }
  }

  async function buscaHistorico(numeroReceber) {
    let url = `/sisplan/receber/v1/historicoreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      // jsonStr = jsonStr.map((retorno) => ({
      //   ...retorno,
      //   DT_PAGTO: retorno.DT_PAGTO.slice(0, 10),
      // }));
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta("Não Existem Baixas Cadastradas");
    }
  }

  async function buscaAntecipacoes(numeroReceber, status) {
    let url = `/sisplan/receber/v1/antecipacoesreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}&STATUS=${status}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  async function buscaRelacionamentoCheques(numeroReceber, numCheq, AgenCheq, BancoCheq, ContaCheq) {
    let url = `/sisplan/receber/v1/relacionamentochequesreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}&NUM_CH=${numCheq}&AGEN_CH=${AgenCheq}&BANCO_CH=${BancoCheq}&CONTA_CH=${ContaCheq}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  async function rotinaDeletarReceber(data, pEstornar = "") {
    try {
      const estornar = pEstornar === "" ? "" : "&ESTORNAR=S";
      const response = await requisicao(
        "DELETE",
        "/Sisplan/receber/v1/receber?",
        `NUMERO=${data.NUMERO}&LANCAMENTO=${data.LANCAMENTO}&STATUS=${data.STATUS}&NOTAFATURA=${data.FATURA}${estornar}`,
        null
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      toastr
        .success("Duplicata Excluída com Sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      console.error(error);
      msgErro("Erro ao excluir o registro.");
    }
  }
  const formataDataRec = (data) => {
    if (!data) {
      return '';
    }
    const [dataParte] = data.split(' ');
    const [ano, mes, dia] = dataParte.split('-');
    const dataFormatada = `${dia}/${mes}/${ano}`;
    return dataFormatada;
  };

  async function verificaValoresEmAbertoCliente(cliente, numero) {
    try {
      const data = $("#tabelaReceber").DataTable().rows(".selected").data().toArray();

      if (data.length == 0) {
        return;
      }

      const arrNumeros = data.map(item => item.NUMERO);

      const listaNumeros = `'${arrNumeros.toString().replaceAll(",", "','")}'`;
      const response = await requisicao("GET", "/sisplan/receber/v1/valoresemabertocliente?", `LISTA=${listaNumeros}&CLIENTE=${cliente}&NUMERO=${numero}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        console.error(error);
        msgErro("Erro ao verificar valores em aberto!");
        return;
      }

      const jsonStr = await response.json();
      if (jsonStr.length > 0) {
        const duplicatas = jsonStr.map(rec => `Número: ${rec.NUMERO}, vencimento: ${formataDataRec(rec.DT_VENCTO)} \r\n`);
        msgAlerta(`Há duplicatas em aberto para esse cliente com vencimento inferior ao selecionado, verifique.\r\n\r\n${duplicatas.toString().replaceAll(',Número:', 'Número:')}`);
      }

    } catch (error) {
      console.error(error);
    }
  }


  $("#tabelaReceber").on("click", "#btnLancRateio", async function () {
    const table = $("#tabelaReceber").DataTable();
    const data = table.row($(this).parents("tr")).data();
    $('#txtNumeroRateio').val(data.NUMERO)
    $('#txtClasseRateio').val(data.CLASSE)
    $('#txtTipoRateio').val('CR')
    $('#txtValorRateio').val(data.VALOR.toFixed(2))
    $('#txtDataRateio').val(formataData(new Date()))
    $('#txtNumeroAnt').val(data.NUMERO)
    $('#txtDataVencto').val(data.DT_VENCTO)
    $('#txtDuplicata').val('')
    $('#txtNumeroOC').val('')
    $('#txtCentroCustoFixo').val('')
    $('#txtEmpId').val(0)
    $('#modalLancRateio').modal('show');
  })

  $("#tabelaReceber").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaReceber').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data.NUMERO, data.FATURA, 'ACESSO_RECEBER');
  });

  $("#tabelaReceber").on('click', "#btnObservacao", async function () {
    const data = $('#tabelaReceber').DataTable().row($(this).parents('tr')).data();

    await abreModalObservacao(data);
  });

  async function abreModalObservacao(data) {
    const observacao = await buscaObservacoesTitulo(data.NUMERO);
    const ID = (observacao.length + 1)
    $('#txtIdObservacao').val(ID)
    $('#txtObservacaoNumero').val(data.NUMERO)
    $('#txtObservacaoUsuario').val(getCookie('g_usuario_logado'))
    await setarDataAtual("dtObservacaoCadastro")

    if ($.fn.DataTable.isDataTable('#tabelaObservacoes')) {
      $('#tabelaObservacoes').DataTable().destroy();
      $('#tabelaObservacoes').empty();
    }

    $("#tabelaObservacoes").DataTable({
      paging: false,
      filter: false,
      destroy: true,
      autoWidth: true,
      data: observacao,
      columns: columnsObservacao,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
          targets: 5,
        }
      ],
    });

    $('#modalObservacao').modal('show')
  }


  async function buscaObservacoesTitulo(numero) {
    const pesquisa = {
      camposSelect: ['HIST_FINAN.ID', 'HIST_FINAN.NUMERO', 'HIST_FINAN.USUARIO', 'HIST_FINAN.DATA', "(HIST_FINAN.MOTIVO || '-' || MENSAGEM.DESCRICAO) MOTIVO", 'HIST_FINAN.OBS', 'HIST_FINAN.EMP_ID'],
      tabela: 'HIST_FINAN',
      leftJoin: [{ tabela: "MENSAGEM", condicao: "HIST_FINAN.MOTIVO = MENSAGEM.CODMEN" }],
      where: [`HIST_FINAN.NUMERO = '${numero}'`, `HIST_FINAN.TIPO = 'O'`],
      orderBy: [`HIST_FINAN.ID ASC`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (!jsonStr.length) {
      return []
    } else {
      return jsonStr
    }
  }

  $('#btnGravarObservacao').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      if ($('#txtObservacaoMotivo').val() === '') {
        throw msgAlerta('Necessário informar um motivo, verifique!')
      }
      if ($('#txtAreaObservacao').val() === '') {
        throw msgAlerta('Necessário informar uma observação, verifique!')
      }
      const body = {
        id: $('#txtIdObservacao').val(),
        numero: $('#txtObservacaoNumero').val(),
        usuario: $('#txtObservacaoUsuario').val(),
        data: $('#dtObservacaoCadastro').val(),
        motivo: pegaChave('#txtObservacaoMotivo'),
        tipo: 'O',
        observacao: $('#txtAreaObservacao').val(),
      }

      let response = await requisicao("POST", `/sisplan/receber/v1/observacao?`, '', JSON.stringify(body), 30000);

      if (!response) {
        return
      }

      const observacao = await buscaObservacoesTitulo($('#txtObservacaoNumero').val())
      $("#tabelaObservacoes").DataTable({
        paging: false,
        filter: false,
        destroy: true,
        autoWidth: true,
        data: observacao,
        columns: columnsObservacao,
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ],
      });

      toastr
        .success(`Nova observação cadastrada para o título: ${$('#txtObservacaoNumero').val()}!`, "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden: async function () {
            const observacao = await buscaObservacoesTitulo($('#txtObservacaoNumero').val());
            const ID = (observacao.length + 1)
            $('#txtIdObservacao').val(ID)
          }
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      await limpaCamposModalObs()

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function limpaCamposModalObs() {
    await setarDataAtual("dtObservacaoCadastro");
    // $('#txtObservacaoNumero').val('')
    // $('#txtObservacaoUsuario').val('')
    $('#txtObservacaoMotivo').val('')
    $('#txtAreaObservacao').val('')
  }

  $('#modalObservacao').on('hidden.bs.modal', async function () {
    await limpaCamposModalObs()
  })

  $("#tabelaReceber").on("click", "#btnExcluir", async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      try {
        $.LoadingOverlay("show");
        const table = $("#tabelaReceber").DataTable();
        const data = table.row($(this).parents("tr")).data();
        const iLancamento = data.LANCAMENTO;

        try {
          const json = await retornaJsonPesquisaPadrao(
            `{ "tabela":"receberb", "camposSelect":["numero"], "where": ["lancamento = ${iLancamento}"] }`
          );
          const titulos = json.map((data) => data.NUMERO);

          if (json) {
            if (json.length > 0) {
              msgAlerta(
                `Existem baixas atreladas a esse título, ao excluir, será estornado as baixas dos títulos: ${titulos.toLocaleString()}. Deseja continuar?`,
                () => { },
                () => { },
                () => rotinaDeletarReceber(data, "S")
              );
              return;
            }
          }

          msgAlerta("Deseja realmente deletar esse Registro?", () =>
            rotinaDeletarReceber(data, "S")
          );
        } catch (error) {
          msgErro("Erro ao excluir título.");
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
        $("#btnConsultar").trigger("click");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function buscaReceber() {
    const url = `/Sisplan/Receber/V1/Receber?`;
    const sParams = await retornaFiltros();

    try {
      let response = await requisicao("GET", url, sParams, null, 300000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }

      let jsonStr = await response.json();

      jsonStr.map((item) => {
        item.SALDOTOTAL = item.JUROS != '' ? (parseFloat(item.JUROS) + item.SALDO) : item.SALDO;
      });

      return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados.");
    }
  }



  // selecionar grid
  $("#tabelaReceber").on("click", "td", async function () {
    selecionarLinhaTabela("#tabelaReceber", "checkReceber", this);
    atualizaTotalSelecionadas();

    const duplicataAtualSelecionada = $($(this).children().children().children()).prop('checked');
    if (duplicataAtualSelecionada) {
      const dados = $('#tabelaReceber').DataTable().row($(this).closest('tr')).data();
      await verificaValoresEmAbertoCliente(dados.CODCLI, dados.NUMERO);
    }

    if ($("#tabelaReceber").DataTable().rows(".selected").data().length <= 0) {
      $("#btnBaixar").prop("disabled", true);
      $("#btnBaixarComAntecipacao").prop("disabled", true);
    }
  });

  $(document).on('change', '#check_todos', function () {
    let isChecked = $('#check_todos').prop('checked');
    let table = $('#tabelaReceber').DataTable();

    // Iterar sobre todas as páginas
    table.rows().every(function () {
      let row = $(this.node());
      row.find('.checkReceber').prop('checked', isChecked);

      if (isChecked) {
        row.addClass('selected');
      } else {
        row.removeClass('selected');
      }
    });
    atualizaTotalSelecionadas();
    if ($('#check_todos').is(':checked', true)) {
      $("#btnBaixar").prop("disabled", false);
      $("#btnBaixarComAntecipacao").prop("disabled", false);
    } else {
      $("#btnBaixar").prop("disabled", true);
      $("#btnBaixarComAntecipacao").prop("disabled", true);
    }
    // liberaBotaoBaixa()
  });


  function dataMesAtual(dateString) {
    const dateParts = dateString.split("/");
    const day = parseInt(dateParts[0], 10);
    const month = parseInt(dateParts[1], 10) - 1;
    const year = parseInt(dateParts[2], 10);
    const dateToCheck = new Date(year, month, day);

    const currentDate = new Date();
    return (
      dateToCheck.getMonth() === currentDate.getMonth() &&
      dateToCheck.getFullYear() === currentDate.getFullYear()
    );
  }

  function removeColunasExcel() {
    let retorno;
    retorno = `
    for (let i = 0; i < dados.length; i++) {
      delete dados[i]['CODREP'];
      delete dados[i]['LANCAMENTO'];
      delete dados[i]['EMP_ID'];
      delete dados[i]['EMP_ID_1'];
      delete dados[i]['CLASSE'];
      delete dados[i]['OBS'];
      delete dados[i]['NRO_CUPOM'];
      delete dados[i]['DIAS'];
      delete dados[i]['TAXA'];
  }`;
    return retorno
  }



  $("#btnConsultar").on("click", async function () {
    try {
      $.LoadingOverlay("Show");
      try {
        salvarFiltrosCache('filtrosAcessoReceber', campos);
        let jsonStr = await buscaReceber();

        jsonStr.forEach(item => { item.SEL = botaoSelecionarGrid() })

        let dataCols = [{
          title: `<div class="icheck-primary" for="check_todos" id="cbTodos">
                    <input class="form-check-input" type="checkbox" id="check_todos">
                    <label for="check_todos" value="option5" data-toggle="tooltip" data-placement="top" title="Selecionar todos os registros"></label>
                </div>`,
          data: 'SEL'
        },
        {
          title: 'Número',
          data: 'NUMERO'
        },
        {
          title: 'Fatura',
          data: 'FATURA'
        },
        {
          title: 'Cod Cli.',
          data: 'CODCLI'
        },
        {
          title: 'Cliente',
          data: 'CLIENTE'
        },
        {
          title: 'Data Emissão',
          data: "DT_EMISSAO",
        },
        {
          title: 'Data Vencimento',
          data: "DT_VENCTO",
        },
        {
          title: 'Valor Total',
          data: "VALOR",
        },
        {
          title: 'Valor',
          data: "VALOR2",
        },
        {
          title: 'Valor Pago',
          data: "VALOR_PAGO",
        },
        {
          title: 'Desconto',
          data: "DESCONTO",
        },
        {
          title: 'Juros',
          data: "JUROS",
        },
        {
          title: 'Saldo',
          data: "SALDO",
        },
        {
          title: 'Status',
          data: "STATUS",
        },
        {
          title: 'Dias Atraso',
          data: "DIAS_ATRASO",
        },
        {
          title: 'NSU',
          data: "CARTAO_NSU",
        },
        {
          title: 'Bandeira',
          data: "BANDEIRA",
        },
        {
          title: 'Taxa Bandeira',
          data: "TAXA_BANDEIRA",
        },
        {
          title: 'Empresa',
          data: "EMP_PAT",
        },
        {
          title: 'Emp_Multa',
          data: "EMP_MULTA",
        },
        {
          title: 'Caixa',
          data: "CAIXA",
        },
        {
          title: 'Moeda',
          data: "MOEDA",
        },
        {
          title: 'Desc_moeda',
          data: "DESC_MOEDA"
        },
        {
          title: 'Bordero',
          data: "BORDERO"
        },
        {
          title: 'NRBanco',
          data: "NRBANCO"
        },
        {
          title: 'Histórico',
          data: "HISTORICO"
        },
        {
          title: 'Desc_Histórico',
          data: "DESC_HISTORICO"
        },
        {
          title: 'Situação',
          data: "SITUACAO"
        },
        {
          title: 'Desc_situação',
          data: "DESC_SITUACAO"
        },
        {
          title: 'Classe',
          data: "CLASSE"
        },
        {
          title: 'Desc_classe',
          data: "DESC_CLASSE"
        },
        {
          title: 'Conta',
          data: "CONTA_CHEQUE"
        },
        {
          title: 'Desc_Conta',
          data: "DESC_CONTA"
        },
        {
          title: 'Docto_Integra',
          data: "DOCTO_INTEGRA"
        },
        {
          title: 'CNPJ',
          data: "CNPJ"
        },
        {
          title: 'Tipo_Entidade',
          data: "TIPO_ENTIDADE"
        },
        {
          title: 'Agência Cheque',
          data: "AGENCIA_CH"
        },
        {
          title: 'Número Cheque',
          data: "NUMERO_CH"
        },
        {
          title: 'Banco Cheque',
          data: "BANCO_CH"
        },
        {
          title: 'Conta Cheque',
          data: "CONTA_CH"
        },
        {
          title: 'Emissor Cheque',
          data: "EMISSOR_CH"
        },
        {
          title: 'Valor Moeda',
          data: "VALOR_MOEDA"
        },
        {
          title: 'Pago Moeda',
          data: "VALPAGO_MOEDA"
        },
        {
          title: 'Taxa Moeda',
          data: "TAXA_MOEDA"
        },
        {
          title: 'ID',
          data: "ID"
        },
        ]

        let table = $("#tabelaReceber").DataTable({
          destroy: true,
          sort: true,
          colReorder: {
            fixedColumnsLeft: 2
          },
          autoWidth: true,
          // order: [[6, "asc"]], 
          //Removi por que não estava deixando a tela
          //ser ordenada pelo campo ordem impressão, acredito que em
          //casos assim, para não manter fixo no fonte
          //o certo seria criar uma nova ordenação na api.
          data: jsonStr,
          columns: dataCols,
          columnDefs: [
            {
              type: "date-br",
              render(data) {
                return new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
              },
              targets: 5,
            },
            {
              type: "date-br",
              render(data, type, row) {
                x = data.slice(0, 10).split("-");
                let icone = "";
                const dataVencimento = new Date(`${row.DT_VENCTO} 23:59:59`);
                if (dataVencimento < new Date()) {
                  icone =
                    '<i class="fas fa-history iconeVencido" style="color: red" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                } else {
                  icone =
                    '<i class="fas fa-history" style="display: none" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                }
                const retornaData = new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
                return (dataMesAtual(retornaData)) ? `<span title="Vencimento dentro do mês atual" style="color: red">${retornaData}</span> ${icone}`
                  : `<span>${retornaData}</span> ${icone}`;
              },
              targets: 6,
            },
            {
              className: "ColunaVermelha pr-4 text-right",
              targets: 12,
              render(data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  minimumFractionDigits: 2,
                });
              },
            },
            {
              targets: 14,
              createdCell: function (td, cellData) {
                if (cellData != 0) {
                  $(td).addClass('ColunaVermelha');
                }
              },
              render(data) {
                return data.toFixed(0)
              }
            },
            {
              render(data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  minimumFractionDigits: 2,
                });
              },
              targets: [7, 8, 9, 10, 11, 17, 41, 42, 43],
              "className": 'pr-4 text-right'
            },
            {
              render(data, type, row) {
                return retornaBotaoOpcoes(row.NUMERO);
              },
              targets: 1,
            },
            {
              visible: false,
              targets: [33, 34, 35, 44],
            },

            {
              render(data) {
                return new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
              },
              targets: 5,
            },
          ],
        });


        $('#tabelaReceber tbody tr td [data-toggle="tooltip"]').tooltip();

        $(document).on("click", ".paginate_button", function () {
          $('#tabelaReceber tbody tr td [data-toggle="tooltip"]').tooltip();
        });

        atualizaTotais();
        atualizaTotalSelecionadas();



        $("#tabelaReceber").on("click", "#btnEdit", async function () {
          if ((permissaoUsuarioLogado.ALTERA == "S")) {
            const data = $("#tabelaReceber").DataTable().row($(this).parents("tr")).data();
            const receberLiberado = await verificarRegistro(
              "RECEBER",
              data.NUMERO
            );
            if (receberLiberado) {
              // if (data.VALOR_PAGO > 0) {
              //   msgAlerta('Duplicata já possui baixa, impossível alterar.');
              //   return;
              // }

              const novoNumero = btoa(data.NUMERO + '/*/' + data.EMP_ID.toString());
              window.location.href = `receber/${novoNumero}`;
            }
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });
        $("#tabelaReceber").on("click", ".btnOpcao", async function () {
          $(".checkReceber").prop("checked", false);
          $("tr").removeClass("selected");
        });
        $("#modal-filtros").modal("hide");
        $("#btnBaixar").prop("disabled", true);
        $("#btnBaixarComAntecipacao").prop("disabled", true);

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaReceber_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaReceber_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');
        $("#tabelaReceber_length").parent().css("align-content", "end");

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = `/Sisplan/Receber/V1/Receber?`;
          const filtros = await retornaFiltros();
          const removeColunas = removeColunasExcel();
          await exportaCSV(url, filtros, false, null, 'Relatório de Receber', '#tabelaReceber', removeColunas);
        })

        $('#tabelaReceber').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.acessoReceber).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar as Baixas");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaReceber').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    const colunasVisiveis = cols.slice(2)
    adicionaColunas(colunasVisiveis, colunasInvisiveis.acessoReceber ?? [''])
  })

  async function retornaFiltros() {
    const sNumero = $("#txtNumero").val() === '' ? '' : `'${$("#txtNumero").val()}'`;
    const sFatura = $("#txtFatura").val();
    const sDataEmiI = moment($("#txtDataEmiI").val()).format("DD/MM/YYYY");
    const sDataEmiF = moment($("#txtDataEmiF").val()).format("DD/MM/YYYY");
    const sDataVenctoI = moment($("#txtVenctoI").val()).format("DD/MM/YYYY");
    const sDataVenctoF = moment($("#txtVenctoF").val()).format("DD/MM/YYYY");
    const sDataPagamentoI = moment($("#txtPagamentoI").val()).format("DD/MM/YYYY");
    const sDataPagamentoF = moment($("#txtPagamentoF").val()).format("DD/MM/YYYY");
    const sCliente = await formataListas($('#txtClienteConsulta').val().toString());
    const sRepresentante = $("#txtRepresentanteConsulta")
      .val()
      .substring(1, $("#txtRepresentanteConsulta").val().indexOf("] - "));
    const sMoeda = await formataListas($("#txtMoedaConsulta").val().toString())
    const sCartaoPresente = pegaValor("#txtCartaoPresente");
    const componentesStatus = ['cbDUPL', 'cbANTE', 'cbORCA', 'cbCHEQ', 'cbCHDE', 'cbDESD', 'cbAGRU', 'cbCANC', 'cbDEVO', 'cbAVDD', 'cbPRESENTE'];
    const sStatus = componentesStatus
      .filter(id => $(`#${id}`).prop('checked')) // Filtra os componentes que estão checados
      .map(id => id.replace('cb', ''))           // Remove o prefixo 'cb'
      .map(item => `'${item}'`)                  // Adiciona aspas simples em cada item
      .join(', ');                               // Junta tudo em uma string separada por vírgulas
    // const sStatus = $("#Status").val() === 'TODOS' ? '' : $("#Status").val();
    const sSituacao = $("#txtSituacao").val();
    const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sClasseGer = await formataListas($("#txtClasseGerConsulta").val().toString());
    const sNumeroCaixa = await formataListas($('#txtNumeroCaixa').val().toString());
    const sGuia = pegaChave('#txtGuia');
    const bordero = $('#txtBordero').val();
    const sSituacaoPesquisa = await formataListas($('#txtSituacaoConsulta').val().toString());
    const sHistoricoPesquisa = await formataListas($('#txtHistoricoConsulta').val().toString());
    const sBancoPesquisa = await formataListas($('#txtBancoConsulta').val().toString());
    const sContaPesquisa = await formataListas($('#txtContaConsulta').val().toString());
    const sNumeroChPesquisa = await formataListas($('#txtNumeroChConsulta').val().toString());
    const sGrupoCliente = await formataListas($('#txtGrupoCli').val().toString());
    const sGrupoEconomico = await formataListas($('#txtPerfil').val().toString());
    const pOrdenacao = $('#txtOrdem').val();
    const pStatusNFe = $('#selectStatusNFe').val();
    const pSituacaoNFe = $('#selectSituacaoNFe').val();
    let dupsSelecionadas = await buscaDuplicatasSelecionadas();
    const pEmissorCh = $('#txtEmissorCH').val();
    const pNSU = $('#txtNSU').val();

    if (dupsSelecionadas.length > 0) {
      dupsSelecionadas = await formataListas(dupsSelecionadas.toString());
    } else {
      dupsSelecionadas = '';
    }

    const filtros = `GRUPOCLI=${sGrupoCliente}&GRUPOECONOMICO=${sGrupoEconomico}&NUMERO=${sNumero}&FATURA=${sFatura}&DTEMISSAOI=${sDataEmiI}&DTEMISSAOF=${sDataEmiF}&DTVENCIMENTOI=${sDataVenctoI}&DTVENCIMENTOF=${sDataVenctoF}` +
      `&STATUS=${sStatus}&CLIENTE=${sCliente}&REPRESENTANTE=${sRepresentante}&SITUACAO=${sSituacao}&MOEDA=${sMoeda}&CARTAO_PRESENTE=${sCartaoPresente}` +
      `&EMP_ID=${sEmpID}&DTPAGAMENTOI=${sDataPagamentoI}&DTPAGAMENTOF=${sDataPagamentoF}&CLASSEGER=${sClasseGer}&NRCAIXA=${sNumeroCaixa}&GUIA=${sGuia}&BORDERO=${bordero}` +
      `&SITUACAO_CONSULTA=${sSituacaoPesquisa}&HISTORICO_CONSULTA=${sHistoricoPesquisa}&BANCO_CONSULTA=${sBancoPesquisa}&CONTA_CONSULTA=${sContaPesquisa}&NUMERO_CH=${sNumeroChPesquisa}` +
      `&ORDEM_ORDENACAO=${pOrdenacao}&TELA_ORDENACAO=${'Receber'}&SITUACAO_NFE=${pSituacaoNFe}&STATUS_NFE=${pStatusNFe}&DUPLICATAS_SELECIONADAS=${dupsSelecionadas}&NSU=${pNSU}&EMISSOR_CH=${pEmissorCh}`;

    return filtros;
  };

  $(document).mouseup(function (e) {
    var container = $(".lista-botoes");
    if (!container.is(e.target) && container.has(e.target).length === 0 && e.target != $('#abreBotoes')[0] && e.target != $('.seta-cima-baixo')[0]) {
      container.fadeOut();
      if ($('.seta-cima-baixo').hasClass('fa-angle-double-up')) {
        $('.seta-cima-baixo').removeClass('fa-angle-double-up')
        $('.seta-cima-baixo').addClass('fa-angle-double-down')
      }
    }
  });

  $('#abreBotoes').click(function () {
    $('.lista-botoes').slideToggle();
    if ($('.seta-cima-baixo').hasClass('fa-angle-double-down')) {
      $('.seta-cima-baixo').removeClass('fa-angle-double-down')
      $('.seta-cima-baixo').addClass('fa-angle-double-up')
    }
    else if ($('.seta-cima-baixo').hasClass('fa-angle-double-up')) {
      $('.seta-cima-baixo').removeClass('fa-angle-double-up')
      $('.seta-cima-baixo').addClass('fa-angle-double-down')
    }
  });

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('RECEBER')

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'CLASSE': {
          adicionaValorPadraoVarios('classeGerConsulta', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'MOEDA': {
          adicionaValorPadraoVarios('moedaConsulta', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
          break;
        }
        case 'STATUS': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#Status').val(item.VALOR).change();
          } else {
            $('#Status').val('DUPL').change();
          }

          break;
        }
        case 'SITUACAO': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#txtSituacao').val(item.VALOR).change();
          } else {
            $('#txtSituacao').val('Em Aberto').change();
          }

          break;
        }
        case 'EMISSAO_DE': {
          if (item.VALOR == 'S') {
            $('#txtDataEmiI').val(dataString);
          } else {
            $('#txtDataEmiI').val();
          }

          break;
        }

        case 'VENCIMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtVenctoI').val(dataString);
          } else {
            $('#txtVenctoI').val();
            $("#btnFiltros").one("click", function (e) {
              $("#txtVenctoI").val("1200-01-01");
              $("#txtVenctoF").val("2500-12-01");
            });
          }

          break;
        }

        case 'PAGAMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtPagamentoI').val(dataString);
          } else {
            $('#txtPagamentoI').val();
          }

          break;
        }
      }
    });
  }

  $("#tabelaReceber").on("click", "#btnVisualizar", async function () {
    $('#tabHistorico').trigger('click')
    setTimeout(() => {
      $('#tabBaixas').trigger('click')
    }, 200)
    try {
      $.LoadingOverlay("show");
      let table = $("#tabelaReceber").DataTable();
      let data = table.row($(this).parents("tr")).data();

      carregaTabelaBaixas(data)
      carregaTabelaHistorico(data)
      carregaTabelaAntecipacoes(data)
      carregaTabelaRelacionamentoCheques(data)
      carregaTabelaObservacoes(data)

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function carregaTabelaBaixas(data) {
    try {
      let nsu = '';
      let codAutorizacao = ''
      let baixas = await buscaBaixas(data.NUMERO);

      $("#tabelaBaixar").DataTable({
        destroy: true,

        autoWidth: true,
        data: baixas,
        columns: [
          {
            data: "NUMERO",
          },
          {
            data: "LANCAMENTO",
          },
          {
            data: "DT_PAGTO",
          },
          {
            data: "VALOR2",
          },
          {
            data: "VALOR_PAGO",
          },
          {
            data: "MOEDA",
          },
          {
            data: "DESC_MOEDA",
          },
          {
            data: "DESCONTO",
          },
          {
            data: "JUROS",
          },
          {
            data: "VAL_DEV",
          },
          {
            data: "DESP_COBRANCA",
          }
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoEstornar(data);
            }
          },
          {
            render: $.fn.dataTable.render.moment(FormatoDtNovo),
            targets: 2,
          },
          {
            targets: 3,
            visible: false,
          },
        ],
      });

      try {
        let response;
        response = await requisicao(
          "GET",
          "/sisplan/funcoes/v1/pesquisa?",
          `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.CODCLI", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = RECEBER.CODCLI"}], "where": ["RECEBER.NUMERO = '${data.NUMERO}'"]}`,
          null
        );

        if (!response) {
          cliente = "";
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          return;
        }

        cliente = `[${jsonStr.RESULT[0][0].CODCLI}] - ${jsonStr.RESULT[0][0].NOME}`;
      } catch (error) {
        console.error(error);
        cliente = "";
      }

      try {
        let response;
        response = await requisicao(
          "GET",
          "/sisplan/funcoes/v1/pesquisa?",
          `JSON={ "tabela":"RECEBER", "camposSelect":["CARTAO_NSU", "CODIGO_AUTORIZACAO"], "where": ["NUMERO = '${data.NUMERO}'"]}`,
          null
        );

        if (!response) {
          nsu = "";
          codAutorizacao = "";
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          return;
        }

        nsu = `${jsonStr.RESULT[0][0].CARTAO_NSU}`;
        codAutorizacao = `${jsonStr.RESULT[0][0].CODIGO_AUTORIZACAO}`;
      } catch (error) {
        console.error(error);
        nsu = "";
        codAutorizacao = "";
      }

      $("#txtClienteVisual").val(cliente);
      $("#txtDTemissaoVisual").val(data.DT_EMISSAO.slice(0, 10));
      $("#txtNotaFiscalVisual").val(data.FATURA);
      $("#txtSaldoVisual").val(data.SALDO);
      $("#txtValorPagoVisual").val(data.VALOR);
      $("#txtNsuVisual").val(nsu);
      $("#txtBandeiraVisual").val(data.BANDEIRA);
      $("#txtTaxaBandeiraVisual").val(data.TAXA_BANDEIRA);
      $("#txtCodigoAutorizacaoVisual").val(codAutorizacao);
    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaAntecipacoes(data) {
    try {
      const status = data.STATUS == 'DUPL' || data.STATUS == 'CHEQ' ? 'ANTE' : 'DUPL'
      const antecipacoes = await buscaAntecipacoes(data.NUMERO, status);

      const columns = [
        {
          data: "DT_PAGTO",
          title: 'Pagto',
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
        },
        { data: "NUMERO", title: 'Número' },
        {
          data: "VALOR_PAGO",
          title: 'Valor Pago',
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          className: 'pr-4 text-right'
        },
        { data: "BANCO", title: 'Banco' },
        { data: "TABELA", title: 'Tabela' },
      ]

      $("#tabelaAntecipacoes").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: antecipacoes,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaRelacionamentoCheques(data) {
    try {
      const relacionamentoCheques = await buscaRelacionamentoCheques(data.NUMERO, data.NUMERO_CH, data.AGENCIA_CH, data.BANCO_CH, data.CONTA_CH);

      const columns = [
        { data: "NUM_AP", title: 'Número' },
        {
          data: "VAL_BAIXADO",
          title: 'Valor Baixado',
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          className: 'pr-4 text-right'
        },
        { data: "EMP_DUPLI", title: 'Empresa' },
        { data: "CODCRE", title: 'Codcre' },
        { data: "NOME", title: 'Nome' },
        { data: "TIPO", title: 'Tipo' },
      ]

      $("#tabelaRelacionamentoCheques").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: relacionamentoCheques,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaHistorico(data) {
    try {
      let historico = await buscaHistorico(data.NUMERO);

      const columns = [
        { data: "ORDEM", title: 'Ordem' },
        { data: "DATA", title: 'Data' },
        { data: "TIPO", title: 'Tipo' },
        { data: "BANCO", title: 'Banco' },
        { data: "CONTA", title: 'Conta' },
        { data: "CARTEIRA", title: 'Carteira' },
        { data: "OCORRENCIA", title: 'Ocorrência' },
        { data: "VALOR", title: 'Valor' },
        { data: "DT_RETORNO", title: 'Data Retorno' }
      ]

      $("#tabelaHistorico").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: historico,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaObservacoes(data) {
    try {
      let observacoes = await buscaObservacoesTitulo(data.NUMERO);

      $("#tabelaVisualizarObservacoes").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: observacoes,
        columns: columnsObservacao,
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  $("#tabelaReceber").on("click", "#btnItensVenda", async function () {
    $.LoadingOverlay("show");
    try {

      const data = $("#tabelaReceber").DataTable().row($(this).parents("tr")).data();

      const pesquisaParam = {
        tabela: 'ITVENDA',
        camposSelect: [
          'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
          'ITVENDA.COR', 'CADCOR.DESCRICAO DESC_COR', 'ITVENDA.TAM', 'ITVENDA.VALOR'
        ],
        leftJoin: [
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' }
        ],
        where: [`ITVENDA.CODVEN = ${data.NRO_CUPOM}`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if ((jsonStr.length == 0) || (data.NRO_CUPOM == 0)) {
        msgAlerta('Duplicata não originada de uma venda.', null, null, () => { $('#modalItensVenda').modal('hide'); }, () => { $('#modalItensVenda').modal('hide'); });
        return;
      }

      let dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaItensVenda', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [], [], [5]);

      insereValor('#txtNumeroItens', data.NUMERO);
      insereValor('#txtVenda', data.NRO_CUPOM);

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
    finally {
      $.LoadingOverlay("hide");
      setTimeout(() => {
        $("#tabelaItensVenda").DataTable().columns.adjust().draw(false);
      }, 200);
    }
  });

  $('#btnImprimirItens').on('click', async function () {
    event.preventDefault();
    await imprimirRomaneio(pegaValor('#txtVenda'), BASE_URI);
  });

  $("#tabelaBaixar").on("click", "#btnEstornar", async function () {
    $.LoadingOverlay("show");
    try {
      let table = $("#tabelaBaixar").DataTable();
      let data = table.row($(this).parents("tr")).data();
      try {
        pNumero = data.NUMERO;
        pLancamento = data.LANCAMENTO;

        await validarEstornarCheques(pNumero, pLancamento)

        let response = await requisicao(
          "POST",
          "/Sisplan/receber/V1/Estornar?",
          `LANCAMENTO=${pLancamento}&NUMERO=${pNumero}`
        );

        if (!response) {
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        $("#txtSaldoVisual").val(
          parseFloat($("#txtSaldoVisual").val()) + parseFloat(data.VALOR_PAGO)
        );

        // table.rows().remove().draw(false);
        table.row($(this).parents("tr")).remove().draw(false);

        toastr
          .success("Baixa estornada com Sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            async onHidden() {
              $('#ModalVisualizarBaixa').modal('hide')
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#btnConsultar").trigger("click");
    }
  });

  $("#modalBaixarComAntecipacao").on("hidden.bs.modal", function () {
    $("#txtClasseAnt").val("");
    $("#txtHistoricoAnt").val("");
  });

  $("#modalBaixar").on("hidden.bs.modal", function () {
    $("#divNSU").addClass("d-none");
    $("#divCondicoesDePagamento").addClass("d-none");
    $("#txtNsu").val("");
    $("#select_bandeira").val("").change();
    $("#txtMoeda").val("");
    $("#txtConta").val("");
    $("#checkCaixa").prop("checked", lancaCaixa);
    $("#txtClasse").val("");
    $("#txtClasseJuros").val("");
    // $("#txtClasseBaixa").val("");
    $("#txtHistorico").val("");
    // $("#txtHistoricoBaixa").val("");
    $("#btnConsultar").trigger("click");
    $("#checkCaixa").prop("disabled", false);
    $("#checkCaixa").prop("checked", false);
    $("#lancaCaixa").addClass("d-none");
    // $("#divMoeda").removeClass("col-lg-6");
    // $("#divMoeda").addClass("col-lg-9");
    $("#txtTotalDesconto").val("");
    $("#txtTotalJuros").val("");
    $("#txtValorRecebido").val("");
    $("#txtTroco").val("");
    $("#txtValorRecebidoDistribuir").val("");
    habilitaTroco();
  });

  async function addBandeira() {
    var dados = await RetornaBandeiras();
    for (const bandeira of dados) {
      var optionText = bandeira.DESCRICAO;
      var optionValue = bandeira.DESCRICAO;
      $('#select_bandeira').append(`<option value="${optionValue}">
                                                 ${optionText}
                                              </option>`);

    }
  };

  async function RetornaBandeiras() {
    var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
    var _params = `JSON={ "tabela":"bandeira", "camposSelect":["id", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

    try {
      var response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }
      return jsonStr['RESULT'][0];
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as bandeiras de cartões');
    }
  };

  async function carregaBaixas(numeros) {
    $.LoadingOverlay("show");
    try {
      const diasToleranciaJuros = parseInt(await retornaValorCadPadrao('RECEBER', 'DIAS_TOLERANCIA_JUROS')) || 0;
      const controlaDiasUteis = parseInt(await retornaValorCadPadrao('RECEBER', 'DIAS_UTEIS')) || 0;
      let response;
      let jsonStr;
      const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
        ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : getCookie('emp_id');

      response = await requisicao("GET", "/Sisplan/Receber/v1/Receber?", `LISTANUMERO=${numeros}&EMP_ID=${sEmpID}`);

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        console.error(error);
        msgErro("Erro ao buscar as duplicatas!");
        return;
      }
      $("#txtCaixa").val("");
      $("#txtMoeda").val("");
      if ($("#checkCaixa").prop("checked") == true) {
        $("#checkCaixa").trigger("click");
      }
      if (lancaCaixa) {
        $("#checkCaixa").trigger("click");
      }
      if (!podeAlterarCheck) {
        $("#checkCaixa").prop("disabled", true);
      }

      await $("#tabelaBaixarContas").DataTable({
        order: false,
        paging: false,
        filter: false,
        destroy: true,
        autoWidth: true,
        data: jsonStr,
        columns: [
          {
            data: "NUMERO",
          },
          {
            data: "CODCLI",
          },
          {
            data: "CLIENTE",
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: "VALOR2",
          },
          {
            data: "VALOR_MOEDA",
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: "SALDO",
          },
          {
            data: "DT_VENCTO",
          },
          {
            data: null,
          },
          {
            data: "SALDO_ORIGINAL"
          },
          {
            data: "DT_PAGTO"
          }
        ],
        columnDefs: [
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [6, 11, 14],
            "className": 'pr-4 text-right'
          },
          {
            targets: 3,
            data: null,
            defaultContent: retornaInputs(true, false, false, false),
          },
          {
            targets: 4,
            data: null,
            defaultContent: retornaInputs(false, false, false, true),
          },
          {
            targets: 5,
            data: null,
            defaultContent: retornaInputs(false, true, false, false),
          },
          {
            targets: 8,
            data: null,
            defaultContent: retornaInputs(false, false, false, false, false, true),
          },
          {
            targets: 9,
            data: null,
            defaultContent: retornaInputs(false, false, false, false, false, false, true),
          },
          {
            targets: 10,
            data: null,
            defaultContent: retornaInputs(false, false, true, false),
          },
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 12,
          },
          {
            targets: 13,
            data: null,
            defaultContent: retornaInputs(false, false, false, false, true),
          },
          {
            targets: bValCambial ? 15 : [7, 8, 9, 15],
            visible: false
          }
        ],
      });

      // executa isso depois de carregar o datatable
      let countRow = $("#tabelaBaixarContas").DataTable().rows().count();
      let tableBaixar = $("#tabelaBaixarContas").DataTable().rows().data();
      for (let i = 0; i < countRow; i++) {
        const taxa = parseFloat(await retornaValorCadPadrao('RECEBER', 'PERC_JUROS')) || parseFloat(jsonStr[i].TAXA);
        if (taxa > 0) {
          const dias = jsonStr[i].DIAS;

          let dataUtilizar = tableBaixar[i].DT_VENCTO;
          if (tableBaixar[i].DT_PAGTO && new Date(tableBaixar[i].DT_PAGTO) > new Date(tableBaixar[i].DT_VENCTO)) {
            dataUtilizar = tableBaixar[i].DT_PAGTO;
          }

          const diaUtil = controlaDiasUteis == "1" ? await verificarDiaUtil(dataUtilizar, false) : dataUtilizar;
          const dataVencto = new Date(`${diaUtil} 00:00:00`);
          const date = new Date();
          let diasVencto = (date.getTime() - dataVencto.getTime()) / (1000 * 3600 * 24);
          if (diasVencto < 0) {
            diasVencto = 0;
          }
          diasVencto = Math.trunc(diasVencto);
          const diasValidarAplicacaoJuros = Math.trunc(diasVencto) - diasToleranciaJuros;

          let juros = 0;
          if (diasValidarAplicacaoJuros > dias) {
            juros = (jsonStr[i].SALDO / 100) * ((taxa / 30) * diasVencto);
            if (isNaN(juros)) {
              juros = 0;
            }

            if (jsonStr[i].EMP_MULTA > 0) {
              juros = ((jsonStr[i].SALDO / 100) * jsonStr[i].EMP_MULTA) + juros;
            }
          }
          $($(".txtJuros")[i]).val(juros.toFixed(2));
        }

        $($(".txtvalorPago")[i]).val(tableBaixar[i].SALDO);
        $($(".txtvalorPago")[i]).attr("data-valor-old", tableBaixar[i].SALDO);
      }

      const listaMoedasCliente = await verificaMoedasCliente(jsonStr[0].CODCLI);

      if (listaMoedasCliente.length > 0) {
        $("#txtMoeda").autocompleta(
          1,
          `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": ["CODMOE IN (${listaMoedasCliente})"], "orderBy": ["CODMOE"]}`,
          ["#txtTipoMoeda"],
          ["TIPO"],
          ["TIPO"]
        );

        $("#btnMoeda").pesquisa_array(
          ["#txtMoeda", "#txtTipoMoeda"],
          ["CODMOE", "TIPO"],
          ["DESCRICAO", "TIPO"],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO", "TIPO"], "where": ["CODMOE IN (${listaMoedasCliente})"], "orderBy": ["CODMOE"]}`,
          "Pesquisa Moeda",
          "MOEDA"
        );
      } else {
        $("#txtMoeda").autocompleta(
          1,
          `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": null, "orderBy": ["CODMOE"]}`,
          ["#txtTipoMoeda"],
          ["TIPO"],
          ["TIPO"]
        );

        $("#btnMoeda").pesquisa_array(
          ["#txtMoeda", "#txtTipoMoeda"],
          ["CODMOE", "TIPO"],
          ["DESCRICAO", "TIPO"],
          '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao", "TIPO"], "orderBy": ["CODMOE"]}',
          "Pesquisa Moeda",
          "MOEDA"
        );

      }

      $("#txtMoeda").on("blur", async function () {

        if ($("#txtMoeda").val() == "") {
          $("#divNSU").addClass("d-none");
          $("#divCondicoesDePagamento").addClass("d-none");
          return;
        }
        atualizaValorPago();
        atualizaValorTotal();
        atualizaTotalDesconto();
        atualizaTotalJuros();
        calculaTroco();

        const possuiTroco = await moedaPossuiTroco(pegaChave('#txtMoeda'));

        if (!$("#divCondicoesDePagamento").hasClass('d-none')) {
          $('#txtCondicaoDePagamento').focus();
        } 

        habilitaTroco(possuiTroco);
      });

      $(".valoresInput")
        .inputmask("numeric", {
          min: 0,
          positionCaretOnClick: "select",
          digits: 2,
        })
        .on("focus", function () {
          let that = $(this);
          setTimeout(function () {
            that.select();
          }, 1);
        });

      if (jsonStr.length == 1) {
        if ($('#txtMoeda').val() == '' && jsonStr[0]?.DESC_MOEDA) {
          insereValor('#txtMoeda', jsonStr[0]?.MOEDA, jsonStr[0]?.DESC_MOEDA);
          insereValor('#txtTipoMoeda', jsonStr[0]?.TIPO_MOEDA, jsonStr[0]?.TIPO_MOEDA);
        }
        if ($('#txtConta').val() == '' && jsonStr[0]?.CONTA_CHEQUE) {
          insereValor('#txtConta', jsonStr[0]?.CONTA_CHEQUE, jsonStr[0]?.DESC_CONTA);
        }
        if ($('#txtClasse').val() == '' && jsonStr[0]?.CLASSE) {
          insereValor('#txtClasse', jsonStr[0]?.CLASSE, jsonStr[0]?.DESC_CLASSE);
        }
        if ($('#txtHistorico').val() == '' && jsonStr[0]?.HISTORICO) {
          insereValor('#txtHistorico', jsonStr[0]?.HISTORICO, jsonStr[0]?.DESC_HISTORICO);
        }
      }

      if (bValCambial) {
        await carregaTaxaMoeda(pegaChave('#txtMoeda'));
      }
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function carregaTaxaMoeda(codMoe) {
    if (codMoe == '') {
      return;
    }

    const pesquisa = {
      tabela: "valor_moeda",
      camposSelect: ["valor"],
      where: [`moeda = ${codMoe} and dt_cotacao = '${retornaDataAtual()}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (jsonStr.length == 0) {
      msgAlerta('Não existe cotação cadastrada para a moeda selecionada na data atual.');
      return;
    }

    $('.txtTaxaMoeda').val(parseFloat(jsonStr[0].VALOR));
  }

  async function validaDadosABaixar(dados) {
    let dadosValidados = [];
    const validaJaBaixado = async (dado) => {
      if (dado.VALOR2 == dado.VALOR_PAGO) {
        msgAlertaSemConfirmacao(`Numero: ${dado.NUMERO} já está baixada!`);
        return false;
      }
      return true;
    };
    const validaDesdobradoOuAgrupado = async (dado) => {
      if (dado.STATUS === "DESD" || dado.STATUS === "AGRU") {
        await msgAlertaSemConfirmacao(
          `Numero: ' ${dado.NUMERO} ' é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };
    const validaTipoCheque = async (dado) => {
      if (dado.STATUS === "CHCA") {
        await msgAlertaSemConfirmacao(
          `Numero: ${dado.NUMERO} é um título de Cheque. Impossível Baixar.`,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };
    const validaTipoAntecipacao = async (dado) => {
      if (dado.STATUS === "ANTE") {
        await msgAlertaSemConfirmacao(
          `Numero: ${dado.NUMERO} é um título de Antecipação. Impossível Baixar. `,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };

    if (dados.filter(dado => dado.CODCLI != dados[0].CODCLI).length > 0) {
      await msgAlertaSemConfirmacao(
        `Não é possível realizar baixa com antecipação para clientes diferentes, verifique.`,
        "modalBaixar"
      );
      return false;
    }

    dadosValidados = false;
    for (let i in dados) {
      if ((await validaJaBaixado(dados[i]))
        && (await validaDesdobradoOuAgrupado(dados[i]))
        && (await validaTipoCheque(dados[i]))
        && (await validaTipoAntecipacao(dados[i]))) {
        dadosValidados = true;
      } else {
        return false;
      }
    };
    return dadosValidados;
  }

  async function carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols) {
    if (!$.isEmptyObject(dataSet[0])) {
      const keys = Object.keys(dataSet[0]);
      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }
      const array_colunas_invisiveis = [6, 7];

      dataSetCols[0].render = function (data, type, row, meta) {
        $('.campoCheckManual').unbind('change');
        const sProp = (row.VALOR_PAGO > 0) ? 'checked' : '';

        return `${'<div class="group-default form-group">' +
          '<div class="relative">' +
          '<input '}${sProp}  style="height:15px" type="checkbox" id="check_col_${[meta.row]}_row_${[meta.col]
          }" class="input-default focus form-control validate campoCheckManual"> ` +
          `</div>` +
          `</div>`;
      };

      dataSetCols[2].type = 'date-br';
      dataSetCols[2].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };
      dataSetCols[3].type = 'date-br';
      dataSetCols[3].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };

      try {
        $('#tabelaAntecipacoesABaixar').DataTable({
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          "columns": dataSetCols,
          "data": dataSet,
          columnDefs: [{
            targets: array_colunas_invisiveis,
            visible: true,
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            "targets": [4, 5],
            "className": 'pr-4 text-right'
          }
          ],
        });
      } catch (error) {
        console.log(error)
      }
      // const tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(4, {}).data().sum()).toFixed(2));
      // const tot_antecipacao_pago = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(5, {}).data().sum()).toFixed(2));
      // const val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
      // const saldo_antecipacao = tot_antecipacao - tot_antecipacao_pago;
      // let saldo_geral = val_total_itens - saldo_antecipacao;
      // if (saldo_geral < 0) {
      //   saldo_geral = 0;
      // }
    }
  }

  async function carregaAntecipacoes(sCodCli) {
    const bParametroAntecipacaoOutrasEmpresas = parametrosVenda[62] == 1 ?? false;
    const url = `/Sisplan/Vendas/v1/Antecipacao?`;
    const dataCols = [];
    let data = [];
    try {

      if (bParametroAntecipacaoOutrasEmpresas) {
        $('.emp_ID').removeClass('d-none');
      }

      const response = await requisicao('GET', url, `CLIENTE=${sCodCli}`, null);

      if (!response) {
        return;
      }

      data = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      await carregaTabelaAntecipacaoSelecaoManual(data, dataCols);

    } catch (error) {
      console.error(error);
      msgAlerta('Não foi possível buscar as antecipações.');
    }
  }
  $('#btnAbreGeraBoleto').on('click', function () {
    const listaBloqueto = []
    $("#tabelaReceber").DataTable().rows(".selected").data().toArray().map((item) => {
      listaBloqueto.push({
        FATURA: item.FATURA,
        NUMERO: item.NUMERO,
        BORDERO: 0,
        CODCLI: item.CODCLI
      });
    })
    if (listaBloqueto <= 0) {
      throw msgAlerta('É necessário selecionar ao menos uma duplicata para gerar boleto, verifique!')
    }
    localStorage.removeItem('registros')
    localStorage.setItem('registros', JSON.stringify(listaBloqueto));
    parent.abrirEmNovaAbaIFrame('Relatório de Bloqueto', `${BASE_URI}/relbloqueto/create`)
    $('#btnConsultar').trigger('click')
    // window.location.href = `relbloqueto/create`;
  })

  $('#btnBaixarComAntecipacao').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const dados = $("#tabelaReceber").DataTable().rows(".selected").data().toArray();
        const listaDuplicatas = [];
        if (await validaDadosABaixar(dados)) {
          dados.forEach(dado => listaDuplicatas.push(dado.NUMERO));
          const listaNumeros = `'${listaDuplicatas.toString().replaceAll(",", "','")}'`;
          await carregaAntecipacoes(dados[0].CODCLI);

          const totalSelecionado = $("#tabelaReceber").DataTable().rows(".selected")
            .data()
            .toArray()
            .reduce((total, reg) => total += reg.SALDO, 0);

          $("#txtSaldoAPagarAnt").html(
            parseFloat(totalSelecionado).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
            })
          );
          $("#modalBaixarComAntecipacao").modal("show");
        }
      } catch (error) {
        console.error(error);
        $("#modalBaixarComAntecipacao").modal("hide");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnBaixar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let sNumero = [];
        let data = $("#tabelaReceber").DataTable().rows(".selected").data();

        for (let i = 0; i < data.length; i++) {
          if (data[i].SALDO <= 0) {
            msgAlertaSemConfirmacao(`Numero: ${data[i].NUMERO} já está baixada!`);
            return;
          }

          if (data[i].STATUS === "DESD" || data[i].STATUS === "AGRU") {
            msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `,
              "modalBaixar"
            );
            return;
          }

          if (data[i].STATUS === "CHCA") {
            msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um título de Cheque. Impossível Baixar.`,
              "modalBaixar"
            );
            return;
          }

          if (data[i].STATUS === "ANTE") {
            msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um título de Antecipação. Impossível Baixar. `,
              "modalBaixar"
            );
            return;
          }
          sNumero.push(data[i].NUMERO);
        }

        const ListaNumeros = `'${sNumero.toString().replaceAll(",", "','")}'`;

        await carregaBaixas(ListaNumeros);

        if (parametrosReceber[7].VALOR == 1) {
          $('#txtClasse').prop('disabled', true);
          $('#btn-Classe').prop('disabled', true);
          $('#btn-limpa-Classe').prop('disabled', true);
          $('#txtConta').prop('disabled', true);
          $('#btnConta').prop('disabled', true);
          $('#btn-limpa-Conta').prop('disabled', true);
          $('#txtHistorico').prop('disabled', true);
          $('#btn-Historico').prop('disabled', true);
          $('#btn-limpa-Historico').prop('disabled', true);
        }

        // $("#txtTotalValor").val(parseFloat($('#tabelaBaixarContas').DataTable().column(5).data().sum()).toLocaleString('pt-BR', {
        //     style: 'currency',
        //     currency: 'BRL'
        // }));

        atualizaValorPago();
        atualizaValorTotal();
        atualizaTotalDesconto();
        atualizaTotalJuros();
        calculaTroco();
        verificarNumeroRegistros();

        $("#modalBaixar").modal("show");
      } catch (error) {
        console.error(error);
        $("#modalBaixar").modal("hide");
        msgErro("Erro ao Realizar baixa");
      }
    } finally {
      $('.txtDesconto').prop('disabled', parametrosReceber[8].VALOR == '1');
      $('.txtPercDesconto').prop('disabled', parametrosReceber[8].VALOR == '1');

      $(".txtJuros").trigger("blur");
      $.LoadingOverlay("hide");
    }
  });

  function atualizaValorPago() {
    let total = 0;
    for (let i = 0; i < $(".txtvalorPago").length; i++) {
      total += parseFloat($($(".txtvalorPago")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalPago").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaValorTotal() {
    let total = parseFloat(
      $("#tabelaBaixarContas").DataTable().column(6).data().sum()
    );
    for (let i = 0; i < $(".txtJuros").length; i++) {
      total += parseFloat(
        $($(".txtJuros")[i]).val() != undefined
          ? $($(".txtJuros")[i]).val()
          : "0"
      );
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalValor").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaTotalDesconto() {
    let total = 0;
    for (let i = 0; i < $(".txtDesconto").length; i++) {
      total += parseFloat($($(".txtDesconto")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalDesconto").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaTotalJuros() {
    let total = 0;
    for (let i = 0; i < $(".txtJuros").length; i++) {
      total += parseFloat($($(".txtJuros")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalJuros").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function retornaInputs(bDesconto = false, bJuros = false, bValor = false, bPercDesc = false, bObs = false, bValPagMoeda = false, bTaxaMoeda = false) {
    if (bDesconto) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important; width: 75px;" class="input-default focus form-control validate valoresInput txtDesconto">`;
    }
    if (bJuros) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important; width: 70px;" class="input-default focus form-control validate valoresInput txtJuros">`;
    }
    if (bValor) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important; width: 90px;" class="input-default focus form-control validate valoresInput txtvalorPago">`;
    }
    if (bPercDesc) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtPercDesconto">`;
    }
    if (bObs) {
      return `<input type="text" style="background-color: transparent!important; width: 200px" class="input-default focus form-control txtObsBaixa">`;
    }
    if (bValPagMoeda) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important; width: 90px; text-align: right;" class="input-default focus form-control validate valoresInput txtValorPagoMoeda">`;
    }
    if (bTaxaMoeda) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important; width: 90px; text-align: right;" class="input-default focus form-control validate valoresInput txtTaxaMoeda">`;
    }
  }

  async function pegaValoresCartoes() {
    const cartoes = $("#tabelaParcelas").DataTable().data().toArray();
    const classe = pegaChave("#txtClasse");
    const historico = pegaChave('#txtHistorico');
    const codcli = pegaChave("#txtChequeCliente");
    const nome = pegaDescricao("#txtChequeCliente");
    const moeda = pegaChave('#txtMoeda');
    const valorTotal = +$('#txt_cred_valor_total').val();
    const nsu = $('#txtNsu').val();
    const bandeira = $('#select_bandeira').val();
    const codCond = pegaChave('#txtCondicaoDePagamento');

    const dados = cartoes.map((cheque, index) => {
      const dataVencimento = $($(".campoVencimento")[index]).val();
      const valorCredito = parseFloat(parseFloat($($(".campoValor")[index]).val()).toFixed(2));

      return {
        NUMERO: "",
        LANCAMENTO: "",
        FATURA: "",
        CODCLI: codcli,
        CPF_CNPJ: cheque.CPF_CNPJ,
        NOME: nome,
        VALOR: valorTotal,
        VAL_ORIGIN: valorTotal,
        VALOR2: valorCredito,
        VALOR_PAGO: 0,
        VAL_DEV: 0,
        DESCONTO: 0,
        DT_VENCTO: `${dataVencimento}T00:00:00Z`,
        DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        DT_COMREC: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        STATUS: "DUPL",
        HISTORICO: historico,
        CLASSE: classe,
        EMP_ID: getCookie('emp_id'),
        EMPRESA: getCookie('empresa'),
        MOEDA: moeda,
        PARCELA: index,
        CARTAO_NSU: nsu,
        BANDEIRA: bandeira,
        CONDICAO: codCond,
        CODREP: cheque.CodRep
      };
    });
    return dados;
  }

  async function pegaValoresCheques() {
    const cheques = $("#tabelaParcelas").DataTable().data().toArray();
    const classe = pegaChave("#txtChequeClasse");
    const situacao = pegaChave("#txtChequeSituacao");
    const representante = pegaChave("#txtChequeRepresentante");
    const codcli = pegaChave("#txtChequeCliente");
    // const nome = pegaDescricao("#txtChequeCliente");
    const historico = pegaChave('#txtChequeHistorico');

    const dados = cheques.map((cheque, index) => {
      const dataVencimento = $($(".campoVencimento")[index]).val();
      const banco =
        $($(".campoBanco")[index]).val() != undefined
          ? $($(".campoBanco")[index]).val()
          : "";
      const agencia =
        $($(".campoAgencia")[index]).val() != undefined
          ? $($(".campoAgencia")[index]).val()
          : "";
      const conta =
        $($(".campoConta")[index]).val() != undefined
          ? $($(".campoConta")[index]).val()
          : "";
      const numero =
        $($(".campoNumero")[index]).val() != undefined
          ? $($(".campoNumero")[index]).val()
          : "";
      const valorCheque = parseFloat(
        parseFloat($($(".campoValor")[index]).val()).toFixed(2)
      );
      const cnpj =
        $($(".campoCPFCNPJ")[index]).val() != undefined
          ? $($(".campoCPFCNPJ")[index]).val()
          : "";
      const nome =
        $($(".campoNome")[index]).val() != undefined
          ? $($(".campoNome")[index]).val()
          : "";

      return {
        NUMERO: "",
        LANCAMENTO: "",
        FATURA: "",
        AGENCIA: agencia,
        BANCO: banco,
        CODCLI: codcli,
        CPF_CNPJ: cnpj,
        CONTA: conta,
        NOME: nome,
        VALOR: valorCheque,
        VALOR2: valorCheque,
        DT_VENCTO: `${dataVencimento}T00:00:00Z`,
        DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        STATUS: "CHEQ",
        CODREP: representante,
        SITUACAO: situacao,
        CLASSE: classe,
        NUMERO_CH: numero,
        AGENCIA_CH: agencia,
        BANCO_CH: banco,
        CNPJ_CH: cnpj,
        CONTA_CH: conta,
        CONTA_CHEQUE: pegaChave('#txtConta'),
        EMISSOR_CH: nome,
        HISTORICO: historico,
        MOEDA: pegaChave("#txtMoeda"),
      };
    });
    return dados;
  }

  async function pegaValoresReceber(bImprimir = false) {
    try {
      let classe = '.checkReceber:checked'
      let receberSelecionado = $(classe).toArray();

      if ((!receberSelecionado.length > 0) && (bImprimir)) {
        classe = '.checkReceber';
        receberSelecionado = $('#tabelaReceber').DataTable().data().toArray();
      }

      const lista = receberSelecionado.map((item, i) => {
        let receber;
        if ((classe == '.checkReceber:checked') || (!bImprimir)) {
          receber = $('#tabelaReceber')
            .DataTable()
            .row($($(classe)[i])
              .closest('tr'))
            .data();
        } else {
          receber = $('#tabelaReceber').DataTable().row(i).data()
        }

        return {
          VALOR_PAGO: parseFloat(receber.SALDO),
          DESCONTO: 0,
          JUROS: 0,
          CODCLI: receber.CODCLI,
          CODREP: receber.CODREP,
          DT_EMISSAO: receber.DT_EMISSAO,
          DT_VENCTO: receber.DT_VENCTO,
          EMP_ID: receber.EMP_ID,
          EMP_ID_1: receber.EMP_ID_1,
          FATURA: receber.FATURA,
          LANCAMENTO: 0,
          NUMERO: receber.NUMERO,
          OBS: receber.OBS,
          SALDO: parseFloat(receber.SALDO),
          STATUS: receber.STATUS,
          VALOR: receber.VALOR,
          VALOR2: receber.VALOR2,
          CLASSE: pegaChave("#txtClasseAnt"),
          HISTORICO: pegaChave("#txtHistoricoAnt"),
          DT_PAGTO: `${$("#txtDTPagamentoAnt").val()}`,
          DT_CONT: `${$("#txtDTContabilizacaoAnt").val()}`,
          NAO_LANCA_CC: isChecked('#cbNaoLancaCcAnt')
        };
      });
      return lista;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  async function pegaValoresAntecipacao() {
    try {
      const antecipacoesSelecionadas = $('.campoCheckManual:checked').toArray();
      const objeto = antecipacoesSelecionadas.map((item, i) => {
        const antecipacao = $('#tabelaAntecipacoesABaixar')
          .DataTable()
          .row($($('.campoCheckManual:checked')[i])
            .closest('tr'))
          .data();
        return {
          VALOR_PAGO: antecipacao.VALOR,
          VALOR2: antecipacao.VALOR,
          EMPRESA: getCookie('empresa'),
          LANCAMENTO: 0,
          NUMERO: antecipacao.DUPLICATA,
          CLASSE: pegaChave("#txtClasseAnt"),
          HISTORICO: pegaChave("#txtHistoricoAnt"),
          DT_PAGTO: `${$("#txtDTPagamentoAnt").val()}`,
          DT_CONT: `${$("#txtDTContabilizacaoAnt").val()}`,
          JUROS: 0,
          VALOR_DEV: 0,
          QT_DEV: 0,
          DESCONTO: 0,
          SALDO_ANTECIPACAO: antecipacao.VALOR
        };
      });
      return objeto;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores das antecipações");
    }
  }

  async function pegaValoresBaixa() {
    try {
      let table = $("#tabelaBaixarContas").DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto = {};
      // pegar valor pago
      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          VALOR_PAGO: parseFloat(
            $($("#tabelaBaixarContas").find(".txtvalorPago")[i]).val()
          ),
          DESCONTO: $($("#tabelaBaixarContas").find(".txtDesconto")[i]).val(),
          JUROS: $($("#tabelaBaixarContas").find(".txtJuros")[i]).val(),
          CODCLI: rows.data()[i].CODCLI,
          CLIENTE: rows.data()[i].CLIENTE,
          CODREP: rows.data()[i].CODREP,
          DT_EMISSAO: rows.data()[i].DT_EMISSAO,
          DT_VENCTO: rows.data()[i].DT_VENCTO,
          EMP_ID: rows.data()[i].EMP_ID,
          EMP_ID_1: rows.data()[i].EMP_ID_1,
          FATURA: rows.data()[i].FATURA,
          LANCAMENTO: 0,
          NUMERO: rows.data()[i].NUMERO,
          OBS: $($("#tabelaBaixarContas").find(".txtObsBaixa")[i]).val(),
          SALDO: parseFloat(parseFloat(rows.data()[i].SALDO).toFixed(2) - (parseFloat($($("#tabelaBaixarContas").find(".txtvalorPago")[i]).val()).toFixed(2) - parseFloat($($("#tabelaBaixarContas").find(".txtJuros")[i]).val()).toFixed(2))).toFixed(2),
          SALDO_A_PAGAR: parseFloat(parseFloat(rows.data()[i].SALDO).toFixed(2)),
          STATUS: rows.data()[i].STATUS,
          VALOR: rows.data()[i].VALOR,
          VALOR2: rows.data()[i].VALOR2,
          CLASSE: pegaChave("#txtClasse", objeto.CLASSE),
          HISTORICO: pegaChave("#txtHistorico", objeto.HISTORICO),
          DT_PAGTO: `${$("#txtDTPagamento").val()}`,
          DT_CONT: `${$("#txtDTContabilizacao").val()}`,
          MOEDA: pegaChave("#txtMoeda", objeto.MOEDA),
          NAO_LANCA_CC: isChecked('#cbNaoLancaCc'),
          CONTA: pegaChave('#txtConta'),
          LOG: getCookie('emp_id') != rows.data()[i].EMP_ID ? `BAIXA NA EMPRESA ${getCookie('empresa')}, DUPLICATA: ` : `BAIXA DUPLICATA: `,
          CONCATENAOBS: 'S',
          CLASSE_JUROS: pegaChave("#txtClasseJuros", objeto.CLASSE_JUROS),
        };

        if (bValCambial) {
          objeto.VALPAGO_MOEDA = parseFloat($($(".txtValorPagoMoeda")[i]).val()) || 0;
          objeto.TAXA_MOEDA = parseFloat($($(".txtTaxaMoeda")[i]).val()) || 0;
        } else {
          objeto.VALPAGO_MOEDA = 0;
          objeto.TAXA_MOEDA = 0;
        }

        if (isChecked('#cbNaoLancaCc')) {
          objeto.LOG += ' - Usuário optou por não lançar no Conta Corrente'
        }

        if (podeAlterarCheck) {
          if ($("#checkCaixa").prop("checked") == true) {
            objeto.LOG += ` - Usuário optou por lançar o valor no caixa `;
          } else {
            objeto.LOG += ` - Usuário optou por não lançar o valor no caixa `;
          }
        }

        if (!$("#divNSU").hasClass("d-none")) {
          objeto.NSU = $("#txtNsu").val();
          objeto.BANDEIRA = $('#select_bandeira').val();
        }

        if ($("#checkCaixa").prop("checked") == true) {
          objeto.NRCAIXA = pegaChave("#txtCaixa", objeto.NRCAIXA);
          objeto.LANCAMANUAL = 1;
        } else {
          objeto.LANCAMANUAL = 0;
        }

        valores.push(objeto);
        objeto = {};
      }
      return valores;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  async function buscaDuplicatasSelecionadas() {
    try {
      const duplicatasSelecionadas = [];
      $("#tabelaReceber").DataTable().rows().every(function () {
        const row = $(this.node());
        if (row.find(".checkReceber").prop("checked")) {
          duplicatasSelecionadas.push(this.data().NUMERO);
        }
      });

      return duplicatasSelecionadas;
    } catch (error) {
      console.error(error);
      return 0
    }
  };

  async function retornaDadosGerenciaisImpressao(params) {
    try {
      const response = await requisicao(
        "GET",
        "/sisplan/cupom/v1/cupomgerencialbaixareceber?",
        params
      );
      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro("Erro ao buscar dados de cupom gerencial.");
        return;
      }

      const jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      msgErro("Erro ao buscar dados de cupom gerencial.");
      console.error(error);
    }
  }
  async function imprimirCupomGerencialBaixa(baixas) {
    const paramRelGerencial = (await CopiaParametro("RECEBER", 1)) ?? "0";
    if (paramRelGerencial == 0) {
      return;
    }

    const url = `/cupom/imprimircupombaixa?`;
    for (let i = 0; i < baixas.length; i++) {
      const baixa = baixas[i];
      const objeto = {
        numero: baixa.NUMERO,
        codven: "",
        nrCupom: "",
        moeda: baixa.MOEDA,
        codcli: baixa.CODCLI,
        cnpj: "",
        valDesconto: baixa.DESCONTO,
        valor: baixa.VALOR2,
        valPago: baixa.VALOR_PAGO,
        valJuros: baixa.JUROS,
        lista: [],
      };
      const nrVias = paramRelGerencial;
      const params = `JSON=${JSON.stringify(objeto)}&NR_VIAS=${nrVias}`;

      try {
        const dadosImpressao = await retornaDadosGerenciaisImpressao(
          params,
          paramRelGerencial
        );
        const response = await requisicao_ecf(
          "POST",
          url,
          `JSON=${encodeURIComponent(JSON.stringify(dadosImpressao))}`,
          "",
          30000
        );

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro("Erro ao imprimir cupom gerencial.");
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro("Erro ao imprimir cupom gerencial.");
      }
    }
  }

  async function RetornaCNPJ(sCodCli) {
    try {
      let url = `/sisplan/funcoes/v1/pesquisa?`;
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"entidade", "camposSelect":["cnpj"], "where": ["codcli = '${sCodCli}'"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      let cnpj = jsonStr.RESULT[0][0].CNPJ;
      return cnpj;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados do cliente.");
    }
  }

  $("#txtChequeCliente").on("blur", async function () {
    const sCodCli = pegaChave("#txtChequeCliente");
    const sNome = pegaDescricao("#txtChequeCliente");
    const sCnpj = await RetornaCNPJ(pegaChave("#txtChequeCliente"));
    $("#tabelaParcelas")
      .DataTable()
      .data()
      .toArray()
      .forEach((cheque, index) => {
        const data = cheque;
        data.CPF_CNPJ = sCnpj;
        data.Nome = sNome;
        data.CodCli = sCodCli;
        $("#tabelaParcelas").DataTable().row(index).data(data);
      });
    adicionaEventosCamposTabela();
  });

  async function RetornaVencimentos(iCodCondicao) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrVencimentos = [];
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let nrParcelas = jsonStr.RESULT[0].length;
      let dataAtual = new Date();
      for (let index = 0; index < nrParcelas; index++) {
        let novoPrazo = new Date();
        let nrDia = jsonStr.RESULT[0][index].PRAZO;
        novoPrazo.setDate(dataAtual.getDate() + nrDia);
        arrVencimentos.push(formataData(novoPrazo));
      }
      return arrVencimentos;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function montaTelaParcelas(sTipo = 'cheque') {
    if (sTipo != 'cheque') {
      $('#btn-adicionar-cheque').addClass('d-none');
    } else {
      $('#btn-adicionar-cheque').removeClass('d-none');
    }

    let dataSet = [];
    let dataSetCols = [];
    const iNumParcelas = +pegaChave('#txtNrParcelas');
    const iCodCondicao = +pegaChave('#txtCondicaoDePagamento');
    const valorTotal = parseFloat($("#txtTotalPago").val()).toFixed(2);
    let valorParcela = 0;
    if (sTipo == 'cheque') {
      valorParcela = parseFloat($("#txtTotalPago").val()).toFixed(2);
    } else {
      valorParcela = parseFloat(parseFloat(valorTotal / iNumParcelas).toFixed(2));
    }
    let guardaValor = valorParcela;
    let diferenca = 0;
    let arrayVencimentos;

    if (valorTotal > valorParcela * iNumParcelas || valorTotal < valorParcela * iNumParcelas) {
      diferenca = parseFloat(parseFloat(valorTotal - valorParcela * iNumParcelas).toFixed(2));
    }

    arrayVencimentos = await RetornaVencimentos(iCodCondicao);
    let columnKeys = sTipo == 'cheque' ? [
      "Nome",
      "CPF_CNPJ",
      "Banco",
      "Agência",
      "Conta",
      "Número",
      "Vencimento",
      "Valor",
      "CodCli",
      "Ações",
      "Impressão",
      "Ler_Cheque",
    ] : [
      "Nome",
      "CPF_CNPJ",
      "Vencimento",
      "Valor",
      "CodCli",
      "Ações",
    ];
    const sNome = $("#tabelaBaixarContas").DataTable().data().toArray()[0].CLIENTE;
    const sCodCli = $("#tabelaBaixarContas").DataTable().data().toArray()[0].CODCLI;
    const sCnpj = await RetornaCNPJ($("#tabelaBaixarContas").DataTable().data().toArray()[0].CODCLI);
    const codRep = $("#tabelaBaixarContas").DataTable().data().toArray()[0].CODREP;
    insereValor("#txtChequeCliente", $("#tabelaBaixarContas").DataTable().data().toArray()[0].CODCLI, sNome);
    const idColunaValor = sTipo == 'cheque' ? 7 : 3;
    const idColunaVencimento = sTipo == 'cheque' ? 6 : 2;
    $("#txt_cred_valor_total").val(valorTotal);
    $("#modalParcelas-titulo").html(`Pagamento com ${sTipo == 'cheque' ? 'Cheque' : 'Cartão'}`);

    columnKeys.forEach((item) => {
      dataSetCols.push({
        title: item,
        data: item,
      });
    });

    if (sTipo == 'cheque') {

      dataSetCols[0].render = function (data, type, row) {
        return `<input type="text" value="${data}" class="input-default focus form-control campoNome required" style="min-width: 200px;">`;
      };

      dataSetCols[1].render = function (data, type, row) {
        return `<input type="text" value="${data}" class="input-default focus form-control campoCPFCNPJ required" style="min-width: 150px;">`;
      };

      dataSetCols[2].render = function (data, type, row, meta) {
        return `<input type="text" placeholder="Banco" id="banco_col_${[
          meta.row,
        ]}_row_${[
          meta.col,
        ]}" class="input-default focus form-control validate campoBanco" required="required"> `;
      };
      dataSetCols[3].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoAgencia required">`;
      };
      dataSetCols[4].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoConta required">`;
      };
      dataSetCols[5].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoNumero required">`;
      };
      dataSetCols[9].render = function (data, type, row) {
        return `<button type="button" class="btn btn-sm btn-danger campoExcluirCheque">Excluir</button>`;
      };
      dataSetCols[10].render = function (data, type, row) {
        return '<button title="Imprimir na impressora de cheque" class="btn btn-primary btnCheque"><i class="fas fa-print"></i></button>';
      };
      dataSetCols[11].render = function (data, type, row) {
        return '<button title="Ler cheque" class="btn btn-primary btnLerCheque"><i class="fas fa-download"></i></button>';
      };
    }

    dataSetCols[idColunaVencimento].type = "date-br";
    dataSetCols[idColunaVencimento].render = function (data, type, row) {
      return `<input style="width: 85%" type="date" ${sTipo == 'cheque' ? '' : 'disabled'} value="${data}" class="input-default focus form-control campoVencimento required">`;
    };

    dataSetCols[idColunaValor].render = function (data, type, row) {
      return `<input style="width: 100%" type="number" step="0.01" value="${parseFloat(
        data
      ).toFixed(
        2
      )}" class="input-default focus form-control campoValor required " ${sTipo == 'cheque' ? '' : 'disabled'}>`;
    };

    if (sTipo == 'cheque') {
      dataSet.push({
        Nome: sNome,
        CPF_CNPJ: sCnpj,
        Banco: "",
        Agência: "",
        Conta: "",
        Número: "",
        Vencimento: "",
        Valor: valorParcela,
        CodCli: sCodCli,
        Ações: ""
      });
    } else {
      for (let i = 0; i < iNumParcelas; i++) {
        if (diferenca > 0 && i == 0) {
          valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          diferenca = 0;
        } else {
          valorParcela = guardaValor;
        }
        if (diferenca < 0 && i == iNumParcelas - 1) {
          valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
        }
        dataSet.push({
          Nome: sNome,
          CPF_CNPJ: sCnpj,
          Vencimento: arrayVencimentos[i],
          Valor: valorParcela,
          CodCli: sCodCli,
          Ações: "",
          CodRep: codRep
        });
      }
    }

    if ($.fn.DataTable.isDataTable('#tabelaParcelas')) {
      $('#tabelaParcelas').DataTable().destroy();
    }
    $('#tabelaParcelas tbody').empty();
    $('#tabelaParcelas thead').empty();

    $("#tabelaParcelas").DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      autowidth: true,
      columns: dataSetCols,
      data: dataSet,
      columnDefs: [
        {
          targets: sTipo == 'cheque' ? 8 : 4,
          visible: false,
        },
      ],
    });

    adicionaEventosCamposTabela();
    if (sTipo != 'cheque') {
      $('#btn_confirmar_cred').trigger('click');
    } else {
      $("#modalParcelas").modal("show");
    }
  }

  async function efetuaBaixaComCheque() {
    try {
      let possuiNome = true;
      let possuiCPF_CNPJ = true;
      let possuiBanco = true;
      let possuiAgencia = true;
      let possuiConta = true;
      let possuiNumero = true;
      let vencimentosInValidos = true;
      for (let i = 0; i < $(".campoBanco").length; i++) {
        possuiNome =
          $($(".campoNome")[i]).val() != "undefined" &&
          $($(".campoNome")[i]).val() != "";
        possuiCPF_CNPJ =
          $($(".campoCPFCNPJ")[i]).val() != "undefined" &&
          $($(".campoCPFCNPJ")[i]).val() != "";
        possuiBanco =
          $($(".campoBanco")[i]).val() != "undefined" &&
          $($(".campoBanco")[i]).val() != "";
        possuiAgencia =
          $($(".campoAgencia")[i]).val() != "undefined" &&
          $($(".campoAgencia")[i]).val() != "";
        possuiConta =
          $($(".campoConta")[i]).val() != "undefined" &&
          $($(".campoConta")[i]).val() != "";
        possuiNumero =
          $($(".campoNumero")[i]).val() != "undefined" &&
          $($(".campoNumero")[i]).val() != "";
        vencimentosInValidos =
          new Date($($(".campoVencimento")[i]).val()) == "Invalid Date";
      }
      if (vencimentosInValidos) {
        msgAlerta("Data de vencimento inválida, verifique");
        return;
      }
      if (!possuiNome) {
        msgAlerta("Necessário informar o campo Nome, verifique");
        return;
      }
      if (!possuiCPF_CNPJ) {
        msgAlerta("Necessário informar o campo CPF_CNPJ, verifique");
        return;
      }
      if (possuiBanco == false) {
        msgAlerta("Necessário informar o campo Banco, verifique");
        return;
      }
      if (possuiAgencia == false) {
        msgAlerta("Necessário informar o campo Agência, verifique");
        return;
      }
      if (possuiConta == false) {
        msgAlerta("Necessário informar o campo Conta, verifique");
        return;
      }
      if (possuiNumero == false) {
        msgAlerta("Necessário informar o campo Número, verifique");
        return;
      }

      if ($("#txtChequeCliente").val() === "") {
        msgAlerta("Necessário informar o campo Cliente, verifique");
        return;
      }

      if ($("#txtChequeRepresentante").val() === "") {
        msgAlerta("Necessário informar o campo Representante, verifique");
        return;
      }

      if ($("#txtChequeSituacao").val() === "") {
        msgAlerta("Necessário informar o campo Situação, verifique");
        return;
      }

      if ($("#txtChequeClasse").val() === "") {
        msgAlerta("Necessário informar o campo Classe, verifique");
        return;
      }

      if ($("#txtChequeHistorico").val() === "") {
        msgAlerta("Necessário informar o campo Histórico, verifique");
        return;
      }

      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if ((valorTotal > totalCheques) || (isNaN(totalCheques))) {
        msgErro(
          "Soma de Valores dos cheques deve ser maior/igual ao valor a pagar, verifique"
        );
        return;
      }

      const listaBaixas = await pegaValoresBaixa();
      const listaCheques = await pegaValoresCheques();
      const objeto = { listaCheques, listaBaixas };

      const response = await requisicao(
        (receber = "POST"),
        "/Sisplan/receber/V1/baixarecebercomcheque?",
        "",
        `JSON=${JSON.stringify(objeto)}`,
        300000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      const listaLancamentosBaixasReceber = jsonStr.listaBaixas.map(baixa => baixa.lancamento);

      await imprimeBaixasReceber(listaLancamentosBaixasReceber, true);

      toastr
        .success("Baixa efetuado com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function efetuaBaixaComCartao() {
    $.LoadingOverlay('show');
    try {
      let vencimentosInValidos = true;
      for (let i = 0; i < $(".campoVencimento").length; i++) {
        vencimentosInValidos =
          new Date($($(".campoVencimento")[i]).val()) == "Invalid Date";
      }
      if (vencimentosInValidos) {
        msgAlerta("Data de vencimento inválida, verifique");
        return;
      }

      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if (valorTotal !== totalCheques) {
        msgErro(
          "Soma de valores deve ser igual ao valor a pagar, verifique"
        );
        return;
      }

      const listaBaixas = await pegaValoresBaixa();
      const listaCartoes = await pegaValoresCartoes();
      const objeto = { listaBaixas, listaCartoes };

      const response = await requisicao(
        (receber = "POST"),
        "/Sisplan/receber/V1/baixarecebercomcartao?",
        "",
        `JSON=${JSON.stringify(objeto)}`,
        300000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      const listaLancamentosBaixasReceber = [];

      for (let index = 0; index < jsonStr.listaBaixas.length; index++) {
        listaLancamentosBaixasReceber.push(jsonStr.listaBaixas[index].lancamento);
      }

      await imprimeBaixasReceber(listaLancamentosBaixasReceber);

      toastr
        .success("Baixa efetuado com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $("#btn_confirmar_cred").on("click", async function () {
    $("#btn_confirmar_cred").prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      const baixaComCheque = $('#modalParcelas-titulo').html().toUpperCase().indexOf('CHEQUE') > 0;
      if (baixaComCheque) {
        await efetuaBaixaComCheque();
      } else {
        await efetuaBaixaComCartao();
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#btn_confirmar_cred").prop('disabled', false);
    }
  });

  function adicionaEventosCamposTabela() {
    // faz o rateio dos totais das outros
    $(".campoValor").on("change", function () {
      $(this).addClass("alterado");
      let qtdeParaRatear =
        $(".campoValor").length - $(".campoValor.alterado").length;
      let valorAlterado = 0;
      for (let i = 0; i < $(".campoValor.alterado").length; i++) {
        valorAlterado =
          parseFloat(valorAlterado.toFixed(2)) +
          parseFloat(
            parseFloat($($(".campoValor.alterado")[i]).val()).toFixed(2)
          );
      }
      // if (valorAlterado > parseFloat($("#txt_cred_valor_total").val())) {
      //   msgAlerta("valor da parcela não pode ser maior que o valor total.");
      //   $("#btn_dividir_valor").trigger("click");
      // } else {
      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if (valorTotal >= totalCheques) {
        valorParaRatear = $("#txt_cred_valor_total").val() - valorAlterado;
        let valorRateio = parseFloat(valorParaRatear / qtdeParaRatear).toFixed(
          2
        );
        for (let i = 0; i < $(".campoValor").length; i++) {
          if (!$($(".campoValor")[i]).hasClass("alterado")) {
            $($(".campoValor")[i]).val(valorRateio);
          }
        }
      }
      // }
    });

    // for (let i = 0; i < $(".campoBanco").length; i++) {
    //   $(`#banco_col_${i}_row_2`).pesquisa(
    //     `#banco_col_${i}_row_2`,
    //     "BANCO",
    //     "NOME_BANCO",
    //     '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
    //     "Pesquisa Banco",
    //     "cadban"
    //   );
    // }

    $(".campoExcluirCheque").unbind("click");
    $(".campoExcluirCheque").on("click", function () {
      const recNo = this.closest("tr").rowIndex - 1;
      if (recNo === 0) {
        msgErro("Não é possível excluir o primeiro cheque.");
        return;
      }
      $("#tabelaParcelas")
        .DataTable()
        .row($(this).parents("tr"))
        .remove()
        .draw(false);
    });

    $(".btnLerCheque").on("click", async function () {
      try {
        try {
          $(this).attr("disabled", "true");
          $.LoadingOverlay("show");
          const posicao = $(this).parents("tr")[0].rowIndex - 1;
          await LerCheque(posicao);
        } finally {
          $.LoadingOverlay("hide");
          $(this).removeAttr("disabled");
        }
      } catch (error) {
        msgErro("Erro ao ler cheque.");
        $(this).removeAttr("disabled");
      }
    });

    $(".btnCheque").on("click", async function () {
      try {
        try {
          $(this).attr("disabled", "true");
          $.LoadingOverlay("show");
          const posicao = $(this).parents("tr")[0].rowIndex - 1;
          await imprimirCheque(posicao);
        } finally {
          $.LoadingOverlay("hide");
          $(this).removeAttr("disabled");
        }
      } catch (error) {
        msgErro("Erro ao imprimir cheque.");
        $(this).removeAttr("disabled");
      }
    });

    $(".campoBanco").on("blur", function () {
      for (let i = 0; i < $(".campoBanco").length; i++) {
        if ($($(".campoBanco")[i]).val() == "") {
          $($(".campoBanco")[i]).val($(this).val());
        }
      }
    });

    $(".campoAgencia").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        for (let i = 0; i < $(".campoAgencia").length; i++) {
          if ($($(".campoAgencia")[i]).val() == "") {
            $($(".campoAgencia")[i]).val($(this).val());
          }
        }
      }
    });

    $(".campoConta").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        for (let i = 0; i < $(".campoConta").length; i++) {
          if ($($(".campoConta")[i]).val() == "") {
            $($(".campoConta")[i]).val($(this).val());
          }
        }
      }
    });

    $(".campoNumero").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        if ($(this).val() == "") {
          return;
        }
        for (let i = 0; i < $(".campoNumero").length; i++) {
          if ($($(".campoNumero")[i]).val() == "") {
            $($(".campoNumero")[i]).val(parseInt($(this).val()) + i);
          }
        }
      }
    });

    $('.campoAgencia').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoAgencia').trigger('blur');
      }
    });

    $('.campoConta').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoConta').trigger('blur');
      }
    });

    $('.campoNumero').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoNumero').trigger('blur');
      }
    });
  }

  $("#btn-adicionar-cheque").on("click", function () {
    const dados = $("#tabelaParcelas").DataTable().data().toArray()[0];
    const novoCheque = {
      Nome: dados.Nome,
      CPF_CNPJ: dados.CPF_CNPJ,
      Banco: "",
      Agência: "",
      Conta: "",
      Número: "",
      Vencimento: "",
      Valor: "",
      CodCli: dados.CodCli,
    };

    $("#tabelaParcelas").DataTable().row.add(novoCheque).draw(false);
    adicionaEventosCamposTabela();
  });

  $("#btn_dividir_valor").on("click", function () {
    let qtdeParcelas = $(".campoValor").length;
    let valorTotal = parseFloat(
      parseFloat($("#txt_cred_valor_total").val()).toFixed(2)
    );
    let valorParcela = parseFloat((valorTotal / qtdeParcelas).toFixed(2));
    let guardaValor = valorParcela;

    if (
      valorTotal > valorParcela * qtdeParcelas ||
      valorTotal < valorParcela * qtdeParcelas
    ) {
      var diferenca = parseFloat(
        parseFloat((valorTotal - valorParcela * qtdeParcelas).toFixed(2))
      );
    }

    for (let i = 0; i < qtdeParcelas; i++) {
      $($(".campoValor")[i]).removeClass("alterado");
      if (diferenca > 0 && i == 0) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
        diferenca = 0;
      } else {
        valorParcela = guardaValor;
      }
      if (diferenca < 0 && i == qtdeParcelas - 1) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
      }
      $($(".campoValor")[i]).val(valorParcela);
    }
  });

  $('#btn-baixarAnt').on('click', async function () {

    if ($("#txtClasseAnt").val() == "") {
      msgAlerta("Classe não informada!");
      $("#btn-ClasseAnt").trigger("click");
      return;
    }

    if ($("#txtHistoricoAnt").val() == "") {
      msgAlerta("Histórico não informado!");
      $("#btn-HistoricoAnt").trigger("click");
      return;
    }

    if ($('.campoCheckManual:checked').toArray().length == 0) {
      msgAlerta('Nenhuma antecipação selecionada, impossível continuar.');
      return;
    }

    const listaBaixas = await pegaValoresReceber();
    const listaAntecipacoes = await pegaValoresAntecipacao();
    const objeto = { listaAntecipacoes, listaBaixas };

    const response = await requisicao(
      'POST',
      "/Sisplan/receber/V1/baixarecebercomantecipacao?",
      "",
      `JSON=${JSON.stringify(objeto)}`,
      300000
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    toastr
      .success("Baixa efetuado com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        async onHidden() {
          window.location.href = `${BASE_URI}/receber`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  });

  $('#btnImprimir').on('click', async function () {
    try {
      try {
        $.LoadingOverlay('show');
        // let numeros = [];
        // const duplicatas = await pegaValoresReceber(true);
        // for (let i = 0; i < duplicatas.length; i++) {
        //   numeros.push(duplicatas[i].NUMERO);
        // }

        // const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;
        const sParams = await retornaFiltros();

        const bImprimeAutomatico = await verificaImprimirAutomatico('Receber');
        arquivo = await GeraRelatorio(`/sisplan/impressao/v1/acesso_receber?${sParams}&`, "GET", 100000, false, 'Receber');
        if (arquivo != undefined && arquivo != "") {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (err) {
        console.error(err);
        msgErro('Erro ao imprimir relatório.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#btn-baixar").on("click", async function () {
    $("#btn-baixar").prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      if ($("#txtMoeda").val() == "") {
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        $("#btnMoeda").trigger("click");
        throw new Error("Moeda não informada!");
      }
      if ($("#txtCaixa").val() == "" && $("#checkCaixa").prop("checked")) {
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        $("#btnCaixa").trigger("click");
        throw new Error("Caixa não informado!");
      }
      if (!$("#divNSU").hasClass("d-none") && $("#txtNsu").val() == "") {
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        $("#txtNsu").focus();
        throw new Error("NSU não informado!");
      }
      if (($("#txtClasse").val() == "") && (parametrosReceber[7].VALOR == 1)) {
        await verificaMoeda();
      }
      if ($("#txtClasse").val() == "") {
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        if (parametrosReceber[7].VALOR != 1) {
          $("#btn-Classe").trigger("click");
        }
        throw new Error("Classe não informada!");
      }
      if ($("#txtHistorico").val() == "") {
        if ($('#scrollToBottomBtn').hasClass('fa-arrow-up')) {
          $('#scrollToBottomBtn').removeClass('fa-arrow-up')
          $('#scrollToBottomBtn').addClass('fa-arrow-down')
        }
        if (parametrosReceber[7].VALOR != 1) {
          $("#btn-Historico").trigger("click");
        }
        throw new Error("Histórico não informado!");
      }

      let valDesconto = 0;
      $('.txtDesconto').map((index, item) => {
        valDesconto += item.value;
      });

      if ((parametrosReceber[8].VALOR == '2') && (valDesconto > 0) && (!validouSenhaSupervisorBaixa)) {
        await senhaSupervisor('Necessário digitar senha do supervisor para dar desconto.', () => {
          validouSenhaSupervisorBaixa = true;
          $("#btn-baixar").trigger('click');
        }, '', false, undefined, undefined, undefined, false, 'ACESSORECEBER');
        return;
      }
      validouSenhaSupervisorBaixa = false;

      const usaTef = await verificaMoedaTef(pegaChave('#txtMoeda'));
      const moedaPix = await verificaMoedaPix(pegaChave('#txtMoeda'));
      const moedaPixSemIntegracao = moedaPix ? false : await verificaMoedaPixSemIntegracao(pegaChave('#txtMoeda'));

      if ($('#tabelaBaixarContas tbody tr').length == 0 || $('#tabelaBaixarContas tbody tr td.dataTables_empty').length) {
        throw new Error("Não existem registros para baixar no momento. Verifique!");
      }

      const conta = pegaChave("#txtConta");
      const dataContabilizacao = $("#txtDTContabilizacao").val();
      await validarPeriodoConciliado(conta, formataDataBonita(dataContabilizacao), "CT");

      let table = $("#tabelaBaixarContas").DataTable();
      let rows = table.rows();
      let count = rows.count();
      let response;
      let Baixas = {};
      let numeros = [];
      let dadosTEF = "";
      let paramsNFCE = "";
      let dadosPIX = "";
      const parametroMantemModalBaixasAberto = parametrosReceber[16].VALOR == "1";
      const listaReceber = [];
      

      // valida se tem saldo
      for (let i = 0; i < rows[0].length; i++) {
        if (rows.data()[i].SALDO == 0 && $($(".txtDesconto")[0]).val() == 0) {
          $("#tabelaBaixarContas").DataTable().rows([i]).remove().draw(false);
          if (rows[0].length == 1) {
            $("#modalBaixar").modal("hide");
          }
          throw new Error("Registro já está baixado!");
        }
        const Receber = {
          NUMERO: rows.data()[i].NUMERO,
          ID: rows.data()[i].ID
        };        
        listaReceber.push(Receber);
      }

      Baixas = await pegaValoresBaixa();

      const numeroDuplicataSPC = await duplicataSPC(Baixas[0].CODCLI);
      let bAbort = false;
      if (numeroDuplicataSPC != "") {
        const duplicataSPC = Baixas.find(item => item.NUMERO == numeroDuplicataSPC);
        if (duplicataSPC) {
          await msgAguardaConfirmacao(`Cliente ${duplicataSPC.CODCLI} - ${duplicataSPC.CLIENTE} consta no SPC/Serasa com a duplicata ${duplicataSPC.NUMERO}. Deseja removê-lo para baixar a(s) duplicata(s)?`
            , async () => {
              await rotinaGeraLog('ACESSO_RECEBER', duplicataSPC.CODCLI, `Usuário selecionou a opção de remover o cliente do SPC ao efetuar a baixa da duplicata ${duplicataSPC.NUMERO}.`, 'Inclusão');
              const BoaVistaSPC = await retornaDadosBaixa(duplicataSPC);
              await removerClienteSPC(BoaVistaSPC);
            }
            , async () => {
              await rotinaGeraLog('ACESSO_RECEBER', duplicataSPC.CODCLI, `Usuário não removeu o cliente do SPC, o processo de baixa foi abortado. Duplicata: ${duplicataSPC.NUMERO}`, 'Inclusão');
              bAbort = true;
            });
          if (bAbort) {
            throw new Error("O processo de baixa foi abortado.");
          }
        }
      }

      if (["1", "3"].includes(pegaChave("#txtTipoMoeda")) && !usaTef) {
        montaTelaParcelas(pegaChave("#txtTipoMoeda") == '1' ? 'cheque' : 'cartao');
        return;
      }

      if (!await validaMoedaBaixa(Baixas)) {
        return;
      }

      if (usaTef) {
        dadosTEF = await verificaChamaTef();
        if (!dadosTEF) {
          return;
        } else {
          paramsNFCE = await converteNFCEPagamentoIntegrado(Baixas[0].CODCLI, parseFloat($("#txtTotalPago").val()).toFixed(2), pegaChave('#txtMoeda'), dadosTEF, "", "", {}, -1, false, 0, listaReceber);
          if (paramsNFCE === false) {
            return;
          }
        }
      } else if (moedaPixSemIntegracao) {
        paramsNFCE = await converteNFCEPagamentoIntegrado(Baixas[0].CODCLI, parseFloat($("#txtTotalPago").val()).toFixed(2), pegaChave('#txtMoeda'), '', 'N');
        if (paramsNFCE === false) {
          return;
        }
      } else if (moedaPix) {
        dadosPIX = await rotinaPagamentoPix();
        if (!dadosPIX) {
          return;
        } else {
          paramsNFCE == await converteNFCEPagamentoIntegrado(Baixas[0].CODCLI, parseFloat($("#txtTotalPago").val()).toFixed(2), pegaChave('#txtMoeda'), '', 'S', dadosPIX.cob.txid);
          if (paramsNFCE === false) {
            return;
          }
        }
      }

      const listaLancamentosBaixasReceber = [];

      for (let i = 0; i < count; i++) {
        if (parseFloat(Baixas[i].VALOR_PAGO) <= 0 && parseFloat(Baixas[i].DESCONTO) <= 0) {
          throw new Error("Valor pago não pode ser 0.");
        }
        if (Baixas[i].SALDO < 0) {
          throw new Error("Valor pago não pode ser maior que o valor da duplicata.");
        }

        response = await requisicao(
          "POST",
          "/Sisplan/Receber/V1/BaixaReceber?",
          paramsNFCE,
          `JSON=${encodeURIComponent(JSON.stringify(Baixas[i]))}`
        );
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let sErro = await response.json();
          throw new Error(sErro.mensagem);
        }

        const jsonBaixaReceber = await response.json();

        listaLancamentosBaixasReceber.push(jsonBaixaReceber.lancamento);
      }

      await imprimeBaixasReceber(listaLancamentosBaixasReceber);

      for (let i = 0; i < Baixas.length; i++) {
        numeros.push(Baixas[i].NUMERO);
      }

      const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

      toastr
        .success("Duplicata baixada com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 2000,
          fadeOut: 1000,
          async onHidden() {
            $("#tabelaBaixarContas").DataTable().rows().remove().draw(false);
            await carregaBaixas(ListaNumeros);
            if (parseFloat(Baixas.SALDO) == 0) {
              $("#modalBaixar").modal("hide");
            }
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
      if (!parametroMantemModalBaixasAberto) {
        $("#modalBaixar").modal("hide");
      }
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
      $("#btn-baixar").prop('disabled', false);
    }
  });

  async function retornaDadosBaixa(baixa) {
    const entidade = await buscaValor('ENTIDADE', ['CNPJ, TIPO'], 'CODCLI', baixa.CODCLI);
    const docto_integra = (await buscaValor('RECEBER', ['DOCTO_INTEGRA'], 'NUMERO', baixa.NUMERO)).DOCTO_INTEGRA;
    return {
      valor_duplicata: baixa.VALOR_PAGO.toString(),
      cnpj: entidade.CNPJ,
      dt_emissao: `${baixa.DT_EMISSAO}T00:00:00Z`,
      dt_vencto_ajustada: `${baixa.DT_VENCTO}T00:00:00Z`,
      codcli: baixa.CODCLI,
      tipo: entidade.TIPO,
      num_docto: docto_integra,
      numero: baixa.NUMERO
    };
  }

  function dadosDuplicatasDesdobradasSPC(duplicataSPC) {
    return {
      valor_duplicata: duplicataSPC.VALOR_PAGO.toString(),
      cnpj: duplicataSPC.CNPJ,
      dt_emissao: `${duplicataSPC.DT_EMISSAO}T00:00:00Z`,
      dt_vencto_ajustada: `${duplicataSPC.DT_VENCTO}T00:00:00Z`,
      codcli: duplicataSPC.CODCLI,
      tipo: duplicataSPC.TIPO_ENTIDADE,
      num_docto: duplicataSPC.DOCTO_INTEGRA,
      numero: duplicataSPC.NUMERO
    };
  }

  function validaTagPreenchida(json) {
    let naoPreenchido = [];

    for (var chave in json) {
      if (json.hasOwnProperty(chave)) {
        if (chave == 'bvcdlCodigoCdl' && !json[chave]) {
          naoPreenchido.push('CODIGOCDL')
        }
        if (chave == 'bvcdlCodigoAssociado' && !json[chave]) {
          naoPreenchido.push('CODIGOASSOCIADO')
        }
        if (chave == 'bvcdlCodigoFilial' && !json[chave]) {
          naoPreenchido.push('CODIGOFILIAL')
        }
        if (chave == 'bvcdlSenha' && !json[chave]) {
          naoPreenchido.push('SENHA')
        }
        if (chave == 'bvcdlUsuario' && !json[chave]) {
          naoPreenchido.push('USUARIO')
        }
        if (chave == 'bvcdlWsdl' && !json[chave]) {
          naoPreenchido.push('WSDL')
        }
        if (chave == 'bvcdlUrl' && !json[chave]) {
          naoPreenchido.push('URL')
        }
        if (chave == 'bvcdlWsdlConsulta' && !json[chave]) {
          naoPreenchido.push('WSDLCONSULTA')
        }
        if (chave == 'bvcdlUrlConsulta' && !json[chave]) {
          naoPreenchido.push('URLCONSULTA')
        }
      }
    }
    return naoPreenchido;
  }

  async function imprimeBaixasReceber(listaLancamentosBaixas = [], chq = false) {
    let listaNumeros = '';
    let listaBaixasReceber = '';
    let url = '';
    const nBaixas = await pegaValoresBaixa();
    if (!chq) {
      let numeros = [];
      for (let i = 0; i < nBaixas.length; i++) {
        numeros.push(nBaixas[i].NUMERO);
      }

      listaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;
      listaBaixasReceber = `'${listaLancamentosBaixas.toString().replaceAll(',', "','")}'`;
      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}&LANCAMENTO=${listaBaixasReceber}`;
    } else {
      let arrNumeros = [];
      data = $("#tabelaReceber").DataTable().rows(".selected").data();

      data.map(item => { arrNumeros.push(item.NUMERO); });

      listaNumeros = `'${arrNumeros.toString().replaceAll(",", "','")}'`;
      const dtPagto = $('#txtDTPagamento').val();
      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}&DT_PAGTO_DE=${dtPagto}&DT_PAGTO_ATE=${dtPagto}`;
    }
    const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
    arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
    if (arquivo != undefined && arquivo != "") {
      if (!bImprimeAutomatico) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
      }
      await limparRelatorios();
    }

    if (!chq) {
      await imprimirCupomGerencialBaixa(nBaixas);
    }
  }

  $("#tabelaBaixarContas").on("blur", ".txtvalorPago", async function () {
    const index = $("#tabelaBaixarContas").DataTable().row($(this).closest("tr")).index();
    const valor = parseFloat($(this).val());
    const saldo = parseFloat($("#tabelaBaixarContas").DataTable().rows($(this).closest("tr")[0]).data()[0].SALDO);
    const valorCalculado = parseFloat((saldo + parseFloat($($(".txtJuros")[index]).val())).toFixed(2));

    if (valor > valorCalculado) {
      msgAlerta("Valor não pode ser maior que o Saldo");
      $(this).val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).closest("tr").find(".txtDesconto").val("0");
      if (bValCambial) {
        $($(".txtTaxaMoeda")[index]).val(TruncaDecimaisNova(2, valorCalculado / (parseFloat($($(".txtValorPagoMoeda")[index]).val()) || 0)));
      }
    }
    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();

    if (bValCambial && !(valor > valorCalculado)) {
      const taxaMoeda = parseFloat($($(".txtTaxaMoeda")[index]).val()) || 0;
      const valorMoeda = parseFloat($($(".txtValorPagoMoeda")[index]).val()) || 0;

      if (taxaMoeda > 0 && valorMoeda > 0) {
        $($(".txtTaxaMoeda")[index]).val(TruncaDecimaisNova(2, valor / (parseFloat($($(".txtValorPagoMoeda")[index]).val()) || 0)));
      }
    }
  });

  $("#tabelaBaixarContas").on("blur", ".txtValorPagoMoeda", async function () {
    if (!bValCambial) {
      return;
    }

    const index = $("#tabelaBaixarContas").DataTable().row($(this).closest("tr")).index();
    const valor = parseFloat($(this).val()) || 0;
    const taxa = parseFloat($($(".txtTaxaMoeda")[index]).val()) || 0;
    const valPago = TruncaDecimaisNova(2, valor * taxa);

    $($(".txtvalorPago")[index]).val(valPago).blur();
  });

  $("#tabelaBaixarContas").on("blur", ".txtTaxaMoeda", async function () {
    if (!bValCambial) {
      return;
    }

    const index = $("#tabelaBaixarContas").DataTable().row($(this).closest("tr")).index();
    const taxa = parseFloat($(this).val()) || 0;
    const valor = parseFloat($($(".txtValorPagoMoeda")[index]).val()) || 0;
    const valPago = TruncaDecimaisNova(2, valor * taxa);

    $($(".txtvalorPago")[index]).val(valPago).blur();
  });

  $("#tabelaBaixarContas").on("change", ".txtPercDesconto", async function () {
    const valTotal = parseFloat(
      $("#tabelaBaixarContas")
        .DataTable()
        .rows($(this).closest("tr")[0])
        .data()[0].SALDO
    );
    const percDesc = parseFloat($(this).val());
    const valDesc = TruncaDecimaisNova(2, (valTotal * percDesc) / 100);
    const index = $(this).closest("tr")[0].rowIndex - 1;
    $($(this).closest("tr")[0].childNodes[3].childNodes[0]).val(valDesc);
    $($(this).closest("tr")[0].childNodes[3].childNodes[0]).trigger('blur');
  });

  // desconto
  $("#tabelaBaixarContas").on("blur", ".txtDesconto", async function () {
    if (
      $($(this).closest("tr")[0].childNodes[5].childNodes[0]).val() > 0 &&
      $(this).val() > 0
    ) {
      msgAlerta("Não é possível ter juros e desconto na mesma duplicata.");
      $(this).val(0);
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }
    if ($($(this).closest("tr")[0].childNodes[5].childNodes[0]).val() > 0) {
      return;
    }
    if (parseFloat($(this).val()) < 0) {
      msgAlerta("Desconto não pode ser menor que 0!");
      $(this).val(0);
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }
    let desconto = parseFloat($(this).val());
    let saldo = parseFloat($("#tabelaBaixarContas").DataTable().rows($(this).closest("tr")[0]).data()[0].SALDO_ORIGINAL);
    let novoValor = 0;
    let valorPago = saldo - desconto;
    const percDesc = TruncaDecimaisNova(2, (desconto / saldo) * 100);

    if (valorPago < 0) {
      msgAlerta("Valor pago não pode ser menor que 0!");
      $(this).closest("tr").find(".txtvalorPago").val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).val("0");
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }

    $(this)
      .closest("tr")
      .find(".txtvalorPago")
      .val(await TruncaDecimais(2, valorPago, novoValor));

    $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(percDesc);

    if (novoValor > saldo) {
      msgAlerta("Valor não pode ser maior que o Saldo");
      $(this).closest("tr").find(".txtvalorPago").val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).val("0");
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
    }

    $("#tabelaBaixarContas").DataTable().cell($(this).closest("tr"), 8).data(valorPago);
    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();
    const valorRecebido = parseFloat($('#txtValorRecebidoDistribuir').val())
    if (!isNaN(valorRecebido) && valorRecebido > 0) {
      distribuiValor()
    }
  });

  $("#tabelaBaixarContas").on("blur", ".txtJuros", async function () {
    if ($($(this).closest("tr")[0].childNodes[3].childNodes[0]).val() > 0 && $(this).val() > 0) {
      msgAlerta("Não é possível ter juros e desconto na mesma duplicata.");
      $(this).val(0);
      return;
    }
    if ($($(this).closest("tr")[0].childNodes[3].childNodes[0]).val() > 0) {
      return;
    }
    if (parseFloat($(this).val()) < 0) {
      msgAlerta("Juros não pode ser menor que 0!");
      $(this).val(0);
      return;
    }
    let juros = parseFloat($(this).val());
    let saldo = parseFloat($("#tabelaBaixarContas").DataTable().rows($(this).closest("tr")[0]).data()[0].SALDO_ORIGINAL);

    if (isNaN(juros)) {
      juros = 0;
    }
    if (isNaN(saldo)) {
      saldo = 0;
    }
    let novoValor = 0;
    let valorPago = saldo + juros;
    let valorTotal = await TruncaDecimais(2, valorPago, novoValor);

    $(this).closest("tr").find(".txtvalorPago").val(valorTotal);
    $("#tabelaBaixarContas").DataTable().cell($(this).closest("tr"), 8).data(valorTotal);

    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();

    const valorRecebido = parseFloat($('#txtValorRecebidoDistribuir').val())
    if (!isNaN(valorRecebido) && valorRecebido > 0) {
      distribuiValor()
    }
  });

  await carregaValoresPadroes();

  await restaurarFiltrosCache('filtrosAcessoReceber', campos);

  $(document).keypress(function (e) {
    if (e.which == 13) {
      e.preventDefault();
    }
  });

  $('#checkTodasEmpresas').on('change', function () {
    if ($('#checkTodasEmpresas')[0].checked == true) {
      carregaEmpresasDisponiveis();
    }
  });


  function atualizaTotalSelecionadas() {
    const data = $("#tabelaReceber").DataTable().rows(".selected").data();
    let valor = 0;

    for (let i = 0; i < data.length; i++) {
      valor += data[i].SALDOTOTAL
    }

    $("#txt_val_selecionadas").html(
      parseFloat(valor).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

  }

  function adicionaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == '') {
        $(this).val('0.00');
      }
    });
  };

  async function LerCheque(posicao) {
    try {

      let response = await requisicao_ecf('GET', '/cheque/imprimircheque?', "", "", 50000);

      if (!response) {
        msgErro("Não foi possível comunicar com a apiLocal.");
        return;
      }

      if (response.status != 200) {
        const mensagemErro = await response.text();
        msgErro(`Erro ao Ler cheque. ${mensagemErro}`);
        return;
      }

      response = await response.json();
      $($(".campoBanco")[posicao]).val(response.banco);
      $($(".campoAgencia")[posicao]).val(response.agencia);
      $($(".campoConta")[posicao]).val(response.conta);
      $($(".campoNumero")[posicao]).val(response.numero);

      return;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function imprimirCheque(posicao) {
    try {
      if ($($(".campoVencimento")[posicao]).val() == '') {
        msgAlerta('Necessário informar um vencimento válido.');
        $($(".campoVencimento")[posicao]).focus();
        return;
      }
      const empId = getCookie('emp_id');

      const pesquisa = {
        camposSelect: ['EMPRESA.EMP_CIDADE'],
        tabela: 'EMPRESA',
        where: [`EMPRESA.EMP_ID = ${empId}`]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
      const cidade = jsonStr[0].EMP_CIDADE;

      const cheque = {
        banco: $($('.campoBanco')[posicao]).val(),
        cidade: cidade,
        data: $($(".campoVencimento")[posicao]).val(),
        valor: $($('.campoValor')[posicao]).val()
      };

      response = await requisicao_ecf('POST', '/cheque/imprimircheque?', "", JSON.stringify(cheque), 50000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const mensagemErro = await response.text();
        msgErro(`Erro ao imprimir cheque. ${mensagemErro}`);
        return;
      }

      return;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function buscaMultaEmpresa() {
    try {
      const empId = getCookie('emp_id');

      const pesquisa = {
        camposSelect: ['EMPRESA.EMP_MULTA'],
        tabela: 'EMPRESA',
        where: [`EMPRESA.EMP_ID = ${empId}`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      return jsonStr[0].EMP_MULTA == null || jsonStr[0].EMP_MULTA == '' ? 0 : jsonStr[0].EMP_MULTA;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function buscaCondicoes(moeda) {
    if ((moeda != '') && (await temCondicoesEspecificas(moeda))) {
      $('#txtCondicaoDePagamento').unbind('autocompleta');
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${moeda})"]}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
      $('#btn-CondicaoDePagamento').off();
      $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${moeda})"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
    } else {
      $('#btn-CondicaoDePagamento').off();
      $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
      $('#txtCondicaoDePagamento').unbind('autocompleta');
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    }
    return;
  }

  async function temCondicoesEspecificas(iMoeda) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["moeda = ${iMoeda}"] }`,
        null
      );

      if (!response) {
        return false;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return false;
      }
      let bTemCondicoes = jsonStr.RESULT[0].length > 0;
      return bTemCondicoes;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da moeda.");
      return false;
    }
  }

  function montaJsonPix(nome, valor, numero) {
    return {
      calendario: {
        expiracao: 290
      },
      devedor: {
        cpf: '00000000000',
        nome: nome
      },
      valor: {
        original: parseFloat(valor).toFixed(2)
      },
      chave: "",
      solicitacaoPagador: `Duplicata ${numero}`
    }

  }

  async function rotinaPagamentoPix() {
    try {
      $.LoadingOverlay('show');
      const codigoMoeda = pegaChave('#txtMoeda');
      const valor = parseFloat($("#txtTotalPago").val()).toFixed(2);
      const nome = $("#tabelaBaixarContas").DataTable().data().toArray()[0].CLIENTE;
      const numero = $("#tabelaBaixarContas").DataTable().data().toArray()[0].NUMERO;
      const url = '/sisplan/pix/v1/criar?';
      const pixObject = montaJsonPix(nome, valor, numero);
      const response = await requisicao('POST', url, `JSON=${encodeURIComponent(JSON.stringify(pixObject))}&MOEDA=${codigoMoeda}`, '', 300000);

      if (!response) {
        msgErro('Erro ao tentar realizar pagamento via pix.');
        return false;
      }
      const jsonRetorno = await response.json();
      if (response.status != 200) {
        msgErro('Erro ao tentar realizar pagamento via pix.');
        return false;
      } else {
        tempoSegundosPix = 300;
        const parsedJson = JSON.parse(jsonRetorno.mensagem);
        const txid = parsedJson.cob.txid;
        if (!parsedJson.base64) {
          var qrcodjs = new QRious({
            value: parsedJson.cob.brcode
          });
          parsedJson.base64 = qrcodjs.toDataURL().replace("data:image/png;base64,", "");
        }

        const pixBase64 = parsedJson.base64;
        $('#txtPixCopiaCola').val(parsedJson.cob.brcode);
        const codCli = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CODCLI;
        const numero = await getWhatsapp(codCli);
        $('#txtNumeroCelular').val(numero);
        $('#modalPix').modal({
          backdrop: 'static',
          keyboard: false
        })
        // $('#modalPix').modal('show');

        const idTimer = atualizaContador();
        try {
          $('#modalPixBody').html(`<img style="width: 200px" src="data:image/png;base64,${pixBase64}" alt="pix code" />`);
          $('#modalPixBody').append('<br/><h4>Aguardando pagamento...</h4>');
          $('#modalPixBody').append(`<br/><h3 id="contadorPix">${tempoSegundosPix}</h3>`);
          $('#btn-cancelar-pix').off();
          $('#btn-cancelar-pix').on('click', function () {
            clearInterval(idTimer);
            tempoSegundosPix = 0;
            $.LoadingOverlay('hide');
          });

          $('#btn-imprimir-pix').off();
          $('#btn-imprimir-pix').on('click', async function () {
            try {
              $.LoadingOverlay('show');
              try {
                // alterado a rota
                const url = `/sisplan/impressao/v1/imprimirrelpix?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelPix');
                const objeto = {
                  VALOR: valor,
                  QRCODE: parsedJson.cob.brcode
                }
                const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'RelPix', `JSON=[${JSON.stringify(objeto)}]`);
                if (arquivo != undefined) {
                  if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                  }
                  await limparRelatorios();
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          });

          const retornoPix = await aguardaPagamentoPix(txid, codigoMoeda);
          if (retornoPix === "CONCLUIDA") {
            return parsedJson;
          } else {
            return false;
          }

        } finally {
          $('#modalPix').modal('hide');
          $.LoadingOverlay('hide');
          clearInterval(idTimer);
          tempoSegundosPix = 0;
        }
      }
    } catch (error) {
      msgErro('Erro ao tentar realizar pagamento via pix.');
      console.error(error);
      return false;
    }
  }

  const aguardaPagamentoPix = async (txid, moeda) => {
    const url = '/sisplan/pix/v1/consultar?';
    let status = 'ATIVA';
    let tentativasComErro = 0;
    while ((tempoSegundosPix > 0) && (status === 'ATIVA') && (tentativasComErro < 6)) {
      try {
        const response = await requisicao('GET', url, `TXID=${txid}&MOEDA=${moeda}`, '', 10000);
        if (response.status == '200') {
          const jsonRetorno = await response.json();
          const parsedJson = JSON.parse(jsonRetorno.mensagem);
          status = parsedJson.status;
        }
        await aguardarXSegundos(10000);
      } catch (error) {
        tentativasComErro = tentativasComErro + 1;
        console.error(error);
      }
    }
    return status;
    // return new Promise(function(resolve) {
    //   setTimeout((resolve), tempo * 60 * 1000);
    // });
  }

  $("#btnWppPix").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const codCli = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CODCLI;
      const nomeCliente = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CLIENTE;
      const celular = $('#txtNumeroCelular').val();
      const pixCopiaCola = $('#txtPixCopiaCola').val();
      await enviaWhatsAppPix(codCli, nomeCliente, celular, pixCopiaCola, 'ACESSO_RECEBER_PIX')
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  const atualizaContador = () => {
    return setInterval(() => {
      tempoSegundosPix = tempoSegundosPix - 1;
      $('#contadorPix').html(tempoSegundosPix > 0 ? tempoSegundosPix : 0);
    }, 1000)
  }

  function aguardarXSegundos(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
  }

  function aplicaDescAuto(desconto) {
    for (let i = 0; i < $(".txtPercDesconto").length; i++) {
      $($(".txtPercDesconto")[i]).val(desconto);
    }
    $(".txtPercDesconto").trigger("change");
  }

  async function veioDaOrdemServico() {
    let duplicata = [JSON.parse(localStorage.getItem('duplicataservico'))] ?? [];
    let cliente = [JSON.parse(localStorage.getItem('clienteservico'))] ?? [];
    if (duplicata.length > 0 && duplicata[0] != null) {
      limparFiltrosCache('filtrosAcessoReceber')
      $('#txtNumero').val(duplicata[0].DUPLICATA)
      $('#txtVenctoI').val('1200-01-01')
      $('#txtVenctoF').val('2500-12-31')
      $('#txtEmissaoI').val('1200-01-01')
      $('#txtEmissaoF').val('2500-12-31')
      $('#txtPagamentoI').val('1200-01-01')
      $('#txtPagamentoF').val('2500-12-31')
      $('#txtSituacao').val('Todos')

      $('#btnConsultar').trigger('click')
    } else if (cliente.length > 0 && cliente[0] != null) {

      limparFiltrosCache('filtrosAcessoReceber')
      $('#txtClienteConsulta').empty().trigger('change');
      await insereValorPesquisaVarios('txtClienteConsulta', 'CODCLI', 'NOME', cliente)
      const date = new Date();
      const primeiroDiaMes = new Date(date.getFullYear(), date.getMonth(), 1);
      const ultimoDiaMes = new Date(date.getFullYear(), date.getMonth() + 1, 0);

      $('#txtVenctoI').val(formataData(primeiroDiaMes))
      $('#txtVenctoF').val(formataData(ultimoDiaMes))
      $('#txtNumero').val('')
      $('#txtFatura').val('')

      $('#btnConsultar').trigger('click')
    }

    localStorage.removeItem('duplicataservico')
    localStorage.removeItem('clienteservico')
  }

  window.addEventListener('storage', async function (event) {
    if (event.key == 'duplicataservico') {
      await veioDaOrdemServico();
    } else if (event.key == 'clienteservico') {
      await veioDaOrdemServico();
    }
  });

  await veioDaOrdemServico();

  if ($('#checkTodasEmpresas').prop('checked')) {
    await carregaEmpresasDisponiveis(false);
    $('.form-check-input.empresa_selecionada').prop('checked', true);
    // $('#modal-empresas').modal('hide');
    // $('#btn-confirmar-empresas').click();
  }

  $('#modal-empresas').on('hidden.bs.modal', function () {
    const maisdeumaempresaselecionada = $('.form-check-input.empresa_selecionada:checked').length > 1;
    $('#checkTodasEmpresas').prop('checked', maisdeumaempresaselecionada);
  });


  if (localStorage.getItem('@venda.cliente')) {
    const dados = localStorage.getItem('@venda.cliente');
    $("#txtClienteConsulta").append(new Option(dados, pegaChave(dados), true, true));
    $('#txtClienteConsulta').trigger('change');
    const dia01 = primeiroDia;
    const dia01ISO = dia01.toISOString();
    const dia01String = dia01ISO.substr(0, 10);
    // $('#txtVenctoI').val(dia01String);
    $('#txtVenctoF').val('2500-12-31');
    localStorage.removeItem("@venda.cliente");
    $('#btnConsultar').trigger('click');
  }
  else if (localStorage.getItem('faturaByVenda')) {
    const dados = localStorage.getItem('faturaByVenda').split('&');
    $('#txtFatura').val(dados[0]);
    $("#txtClienteConsulta").append(new Option(`[${$.trim(dados[1].split('-')[0])}] - ${$.trim(dados[1].split('-')[1])}`, $.trim(dados[1].split('-')[0]), true, true));
    $('#txtClienteConsulta').trigger('change');
    $('#txtMoedaConsulta').empty().trigger('change')
    $('#Status').val('TODOS');
    $('#txtSituacao').val('Todos');
    $('#txtDataEmiI').val(dados[2]);
    $('#txtDataEmiF').val(dados[2]);
    $('.select2-search__field').addClass('d-none');
    $('#txtVenctoI').val('1200-01-01');
    $('#txtVenctoF').val('2500-12-31');
    $('#txtClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btn-ClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btn-limpa-ClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btnConsultar').trigger('click');
    $("#txtSituacaoConsulta").empty().trigger('change')
    $("#txtHistoricoConsulta").empty().trigger('change')
    localStorage.removeItem("faturaByVenda");
  } else {
    // $('#btnConsultar').trigger('click');
  }

  $("#btn-limpa-Moeda").on("click", function () {
    $.LoadingOverlay('show');
    setTimeout(function () {
      $("#divNSU").addClass("d-none");
      $("#divCondicoesDePagamento").addClass("d-none");
      $("#txtMoeda").val("");
      $("#txtTipoMoeda").val("");
      $('#txtClasse').val('');
      $('#txtConta').val('');
      // $('#txtClasseBaixa').val('');
      $("#txtHistorico").val('');
      // $("#txtHistoricoBaixa").val('');
      $('#cbNaoLancaCc').prop('checked', false);
      $('#cbNaoLancaCc').prop('disabled', false);

      if (parametrosReceber[7].VALOR == 1) {
        $('#txtClasse').prop('disabled', true);
        $('#btn-Classe').prop('disabled', true);
        $('#btn-limpa-Classe').prop('disabled', true);
        $('#txtConta').prop('disabled', true);
        $('#btnConta').prop('disabled', true);
        $('#btn-limpa-Conta').prop('disabled', true);
        $('#txtHistorico').prop('disabled', true);
        $('#btn-Historico').prop('disabled', true);
        $('#btn-limpa-Historico').prop('disabled', true);
      }
      habilitaTroco();
      $.LoadingOverlay('hide')
    }, 2000);
  });

  $('#btnDesdobrarAgrupar').on('click', async function () {

    try {

      const data = $("#tabelaReceber").DataTable().rows(".selected").data().toArray();

      if (data.length == 0) {
        msgErro('Nenhuma duplicata selecionada. Impossível continuar.')
        return;
      }

      let valida = data.filter(e => e.SALDO == 0);

      if (valida.length > 0) {
        msgErro('Duplicata sem saldo. Impossível continuar.')
        return;
      }

      valida = data.find(e => e.STATUS === 'CHEQ')

      if (valida) {
        msgErro('Não é possível desdobrar/agrupar duplicatas do tipo cheque. Impossível continuar.')
        return
      }

      valida = undefined;

      const codCli = data[0].CODCLI;

      valida = data.find(e => codCli != e.CODCLI);

      if (valida != undefined) {
        msgErro('O cliente precisa ser o mesmo para todas as duplicatas. Impossível continuar.');
        return;
      }

      const numeroDuplicataSPC = await duplicataSPC(codCli);
      let BoaVistaSPC = {};
      bRemoverClienteSPC = null;
      if (numeroDuplicataSPC != "") {
        const duplicataSPC = data.find(item => item.NUMERO == numeroDuplicataSPC);
        if (duplicataSPC) {
          await msgAguardaConfirmacao(`Cliente ${duplicataSPC.CODCLI} - ${duplicataSPC.CLIENTE} consta no SPC/Serasa com a duplicata ${duplicataSPC.NUMERO}. Deseja remover para desdobrar/agrupar a(s) duplicata(s)?`
            , async () => {
              bRemoverClienteSPC = true;
              await rotinaGeraLog('ACESSO_RECEBER', duplicataSPC.CODCLI, `Usuário selecionou a opção de remover o cliente do SPC ao efetuar um Desdobramento/Agrupamento da duplicata ${duplicataSPC.NUMERO}`, 'Inclusão');
              BoaVistaSPC = dadosDuplicatasDesdobradasSPC(duplicataSPC);
            }
            , async () => {
              bRemoverClienteSPC = false;
              await rotinaGeraLog('ACESSO_RECEBER', duplicataSPC.CODCLI, `Usuário não removeu o cliente do SPC, não será possível desdobrar/agrupar a duplicata ${duplicataSPC.NUMERO}`, 'Inclusão');
            });
        }
      }

      msgAlerta('Deseja mesmo desdobrar/agrupar as duplicatas selecionadas?', () => { }, () => { }, () => {
        $.LoadingOverlay('show');
        $('#modal-desdobra-receber').modal('show');
        $('#modal-desdobra-receber').prop("bRemoverClienteSPC", bRemoverClienteSPC);
        $('#modal-desdobra-receber').prop("BoaVistaSPC", BoaVistaSPC);
        $.LoadingOverlay('hide');
      });

    } catch (error) {
      console.error(error);
      msgAlerta(error.message || error);
    }

  })

  async function duplicataSPC(codCli) {
    const response = await requisicao("GET", "/sisplan/cliente/v1/duplicataSPC?", `CODCLI=${codCli}`, "", 15000);

    if (!response) {
      throw new Error("Não foi possível buscar a duplicata SPC.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(`Não foi possível buscar a duplicata SPC. ${json.mensagem}`);
    }

    return json.mensagem;

  }

  $('#scrollToBottomBtn').click(function (event) {
    event.preventDefault();
    $(this).toggleClass('fa-arrow-up fa-arrow-down');
    let modalBody = $('.modal-body');
    let targetElement = $('#btn-baixar');
    let offset = targetElement.offset().top - modalBody.offset().top + modalBody.scrollTop();

    modalBody.animate({
      scrollTop: offset
    }, 'slow');
  });

  verificarNumeroRegistros()

  function verificarNumeroRegistros() {
    let numRegistros = $('#tabelaBaixarContas tbody tr').length;

    if (numRegistros < 4) {
      $('#scrollToBottomBtn').hide();
    } else {
      $('#scrollToBottomBtn').show();
    }
  }

  async function validaMoedaBaixa(Baixas) {
    try {
      const duplicatas = Baixas.map(item => `'${item.NUMERO}'`).join(',');
      const url = `/sisplan/receber/v1/validamoedabaixa?`;
      const params = `MOEDA=${pegaChave("#txtMoeda")}&DUPLICATAS=${encodeURIComponent(duplicatas)}`;
      const response = await requisicao("GET", url, params);
      const jsonStr = await response.text();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return true;
      }

      if (!!jsonStr) {
        msgAlerta(`Não será possível fazer a baixa, as duplicatas/moedas não aceitam baixa com a moeda ${pegaValor("#txtMoeda")}.\n${jsonStr.slice(0, -4)}.`)
        return false;
      }
      return true;
    } catch (error) {
      console.log(error);
      return true; //para não para o processo da baixa
    }
  }

  async function preencheContaVendaCaixa(caixa) {
    if (($('#txtConta').val() != '') || (caixa == '')) {
      return
    }
    $.LoadingOverlay('show')
    try {
      const usuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario').toUpperCase()

      const pesquisa = {
        tabela: 'VENDA_CAIXA',
        camposSelect: ['CONTA'],
        where: [`NRCAIXA = '${caixa}' AND USUARIO = '${usuario}'`]
      }

      const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      if (json.length > 0) {
        insereValor('#txtConta', json[0].CONTA, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: json[0].CONTA })
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  componenteFiltro('classe', false, false, 'ClasseGerencialAlterarReceberEmMassa')
  componenteFiltro('historico', false, false, 'HistoricoAlterarReceberEmMassa')
  componenteFiltro('banco', false, false, 'BancoAlterarReceberEmMassa')
  componenteFiltro('situacao', false, false, 'SituacaoAlterarReceberEmMassa')
  componenteFiltro('conta', false, false, 'ContaAlterarReceberEmMassa')
  componenteFiltro('moeda', false, false, 'MoedaAlterarReceberEmMassa')

  $('#btnAlterarReceberEmMassa').on('click', () => carregarModalAlterarReceberEmMassa())

  const carregarModalAlterarReceberEmMassa = () => {
    const duplicatasSelecionadas = $('#tabelaReceber').DataTable().rows('.selected').data().toArray().map((e) => `'${e.NUMERO}'`).join(',')
    if (!duplicatasSelecionadas)
      return msgErro('Nenhum registro selecionado, impossível continuar.')

    $('#modalAlterarReceberEmMassa').on('shown.bs.modal', function () {
      $('#tabelaAlterarReceberEmMassa').DataTable().columns.adjust().draw()
    })

    retornarDadosAlterarReceberEmMassa(duplicatasSelecionadas)
  }

  $('#modalAlterarReceberEmMassa').on('hide.bs.modal', () => {
    $('#modalAlterarReceberEmMassa').off('shown.bs.modal')
    if ($.fn.DataTable.isDataTable('#tabelaAlterarReceberEmMassa')) {
      $('#tabelaAlterarReceberEmMassa').DataTable().destroy()
      $('#tabelaAlterarReceberEmMassa').empty()
    }
    $('.campoAlterarReceberEmMassa').val('')
  })

  const retornarDadosAlterarReceberEmMassa = (duplicatas) => {
    $.LoadingOverlay('show')
    const filtros = {
      duplicatas,
    }
    requisicao(
      'POST',
      `/sisplan/receber/v1/retornardadosalterarreceberemmassa?`,
      '',
      JSON.stringify(filtros),
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { resultado, mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) return
        const { duplicatas } = resultado

        if (!duplicatas || !duplicatas.length) {
          msgErro('Nenhuma duplicata encontrada.')
        }

        criarTabelaAlterarReceberEmMassa(duplicatas ?? [])
      }
    }).catch((error) => {
      console.log(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => {
      $.LoadingOverlay('hide')
      $('#modalAlterarReceberEmMassa').modal('show')
    })
  }

  const criarTabelaAlterarReceberEmMassa = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaAlterarReceberEmMassa')) {
      $('#tabelaAlterarReceberEmMassa').DataTable().destroy()
      $('#tabelaAlterarReceberEmMassa').empty()
    }

    const columns = [
      {
        data: 'numero',
        title: 'Número',
      },
      {
        data: 'emissao',
        title: 'Emissão',
        type: 'date-br',
        render(data) {
          return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
        }
      },
      {
        data: 'vencimento',
        title: 'Vencimento',
        type: 'date-br',
        render(data) {
          return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
        }
      },
      {
        data: 'classeGerencial',
        title: 'Classe Gerencial',
      },
      {
        data: 'descricaoClasseGerencial',
        title: 'Descrição Classe Gerencial',
      },
      {
        data: 'historico',
        title: 'Histórico',
      },
      {
        data: 'descricaoHistorico',
        title: 'Descrição Histórico',
      },
      {
        data: 'banco',
        title: 'Banco',
      },
      {
        data: 'descricaoBanco',
        title: 'Descrição Banco',
      },
      {
        data: 'situacao',
        title: 'Situação',
      },
      {
        data: 'descricaoSituacao',
        title: 'Descrição Situação',
      },
      {
        data: 'conta',
        title: 'Conta',
      },
      {
        data: 'descricaoConta',
        title: 'Descrição Conta',
      },
      {
        data: 'moeda',
        title: 'Moeda',
      },
      {
        data: 'descricaoMoeda',
        title: 'Descrição Moeda',
      },
      {
        data: 'numeroBanco',
        title: 'Nº Banco',
      },
      {
        data: 'bordero',
        title: 'Borderô',
      },
      {
        data: 'cartaoNsu',
        title: 'Cartão NSU',
      },
      {
        data: 'observacao',
        title: 'Observação',
      },
      {
        data: 'desconto',
        title: 'Desconto',
        render: function (data) {
          if (!data) {
            return '0.00'
          }
          return parseFloat(data).toFixed(2)
        },
        className: 'text-right',
      },
      {
        data: 'juros',
        title: 'Juros',
        render: function (data) {
          if (!data) {
            return '0.00'
          }
          return parseFloat(data).toFixed(2)
        },
        className: 'text-right',
      },
      {
        data: 'possuiDescontoNaBaixa',
        title: '',
        visible: false,
      },
      {
        data: 'possuiJurosNaBaixa',
        title: '',
        visible: false,
      },
    ]

    const table = $('#tabelaAlterarReceberEmMassa').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '350px',
      select: {
        style: 'single',
        toggleable: false,
      },
    })
    table.off('select')
    table.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        const [dados] = table.rows(indexes[0]).data().toArray()
        preencherCamposAlterarReceberEmMassa(dados)
      }
    })
    table.row(':first').select()
  }

  const preencherCamposAlterarReceberEmMassa = (dados) => {

    dados.numero ? insereValor('#txtNumeroAlterarReceberEmMassa', dados.numero) : $('#txtNumeroAlterarReceberEmMassa').val('')
    dados.emissao ? insereValor('#txtEmissaoAlterarReceberEmMassa', dados.emissao?.split('T')[0]) : $('#txtEmissaoAlterarReceberEmMassa').val('')
    dados.vencimento ? insereValor('#txtVencimentoAlterarReceberEmMassa', dados.vencimento?.split('T')[0]) : $('#txtVencimentoAlterarReceberEmMassa').val('')
    dados.classeGerencial ? insereValor('#txtClasseGerencialAlterarReceberEmMassa', dados.classeGerencial, dados.descricaoClasseGerencial) : $('#txtClasseGerencialAlterarReceberEmMassa').val('')
    dados.historico ? insereValor('#txtHistoricoAlterarReceberEmMassa', dados.historico, dados.descricaoHistorico) : $('#txtHistoricoAlterarReceberEmMassa').val('')
    dados.banco ? insereValor('#txtBancoAlterarReceberEmMassa', dados.banco, dados.descricaoBanco) : $('#txtBancoAlterarReceberEmMassa').val('')
    dados.situacao ? insereValor('#txtSituacaoAlterarReceberEmMassa', dados.situacao, dados.descricaoSituacao) : $('#txtSituacaoAlterarReceberEmMassa').val('')
    dados.conta ? insereValor('#txtContaAlterarReceberEmMassa', dados.conta, dados.descricaoConta) : $('#txtContaAlterarReceberEmMassa').val('')
    dados.moeda ? insereValor('#txtMoedaAlterarReceberEmMassa', dados.moeda, dados.descricaoMoeda) : $('#txtMoedaAlterarReceberEmMassa').val('')
    dados.numeroBanco ? insereValor('#txtNumeroBancoAlterarReceberEmMassa', dados.numeroBanco) : $('#txtNumeroBancoAlterarReceberEmMassa').val('')
    dados.bordero ? insereValor('#txtBorderoAlterarReceberEmMassa', dados.bordero) : $('#txtBorderoAlterarReceberEmMassa').val('')
    dados.cartaoNsu ? insereValor('#txtCartaoNsuAlterarReceberEmMassa', dados.cartaoNsu) : $('#txtCartaoNsuAlterarReceberEmMassa').val('')
    dados.observacao ? insereValor('#txtObservacaoAlterarReceberEmMassa', dados.observacao) : $('#txtObservacaoAlterarReceberEmMassa').val('')
    dados.desconto ? insereValor('#txtDescontoAlterarReceberEmMassa', parseFloat(dados.desconto).toFixed(2)) : $('#txtDescontoAlterarReceberEmMassa').val('0.00')
    dados.juros ? insereValor('#txtJurosAlterarReceberEmMassa', parseFloat(dados.juros).toFixed(2)) : $('#txtJurosAlterarReceberEmMassa').val('0.00')
  }

  $('#btnConfirmarRegistroSelecionado').on('click', () => {
    msgAlerta(
      'Deseja alterar os dados do registro selecionado?',
      () => null,
      () => null,
      () => alterarDadosRegistroSelecionado(),
    )
  })

  $('#btnConfirmarTodosRegistros').on('click', () => {
    msgAlerta(
      'Deseja alterar os dados de todos os registros?',
      () => null,
      () => null,
      () => alterarDadosEmMassa(),
    )
  })

  const alterarDadosRegistroSelecionado = () => {
    const dadosConfirmar = retornarDadosConfirmarReceberEmMassa({ alterarSomenteSelecionado: true })
    validarDadosGravarReceberEmMassa(dadosConfirmar).then(({ dadosForamValidados, gravarInstrucaoMudanca }) => {
      if (!dadosForamValidados) return
      $.LoadingOverlay('show')
      requisicao(
        'POST',
        `/sisplan/receber/v1/gravardadosreceberemmassa?`,
        '',
        JSON.stringify({ ...dadosConfirmar, gravarInstrucaoMudanca }),
        3600000
      ).then(async (response) => {
        const dados = await response.json()
        if (dados) {
          const { mensagem } = dados
          if (mensagem?.codigo !== 200) {
            throw mensagem?.mensagem
          }

          toastr.success("Dados gravados com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 1000,
            fadeOut: 1000,
            onShown() {
              atualizarLinhaSelecionada(dadosConfirmar.dados)
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          })
        }
      }).catch((error) => {
        console.log(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      }).finally(() => $.LoadingOverlay('hide'))
    })
  }

  const alterarDadosEmMassa = () => {
    const dadosConfirmar = retornarDadosConfirmarReceberEmMassa({ alterarSomenteSelecionado: false })
    validarDadosGravarReceberEmMassa(dadosConfirmar).then(({ dadosForamValidados, gravarInstrucaoMudanca }) => {
      if (!dadosForamValidados) return
      $.LoadingOverlay('show')
      requisicao(
        'POST',
        `/sisplan/receber/v1/gravardadosreceberemmassa?`,
        '',
        JSON.stringify({ ...dadosConfirmar, gravarInstrucaoMudanca }),
        3600000
      ).then(async (response) => {
        const dados = await response.json()
        if (dados) {
          const { mensagem } = dados
          if (mensagem?.codigo !== 200) {
            throw mensagem?.mensagem
          }

          toastr.success("Dados gravados com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 1000,
            fadeOut: 1000,
            onHidden() {
              $('#modalAlterarReceberEmMassa').modal('hide')
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          })
        }
      }).catch((error) => {
        console.log(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      }).finally(() => $.LoadingOverlay('hide'))
    })
  }

  const retornarDadosConfirmarReceberEmMassa = ({ alterarSomenteSelecionado }) => {
    const emissao = $('#txtEmissaoAlterarReceberEmMassa').val() || '1200-01-01'
    const vencimento = $('#txtVencimentoAlterarReceberEmMassa').val() || '1200-01-01'
    const classeGerencial = pegaChave('#txtClasseGerencialAlterarReceberEmMassa')
    const descricaoClasseGerencial = pegaDescricao('#txtClasseGerencialAlterarReceberEmMassa')
    const historico = pegaChave('#txtHistoricoAlterarReceberEmMassa')
    const descricaoHistorico = pegaDescricao('#txtHistoricoAlterarReceberEmMassa')
    const banco = pegaChave('#txtBancoAlterarReceberEmMassa')
    const descricaoBanco = pegaDescricao('#txtBancoAlterarReceberEmMassa')
    const situacao = pegaChave('#txtSituacaoAlterarReceberEmMassa')
    const descricaoSituacao = pegaDescricao('#txtSituacaoAlterarReceberEmMassa')
    const conta = pegaChave('#txtContaAlterarReceberEmMassa')
    const descricaoConta = pegaDescricao('#txtContaAlterarReceberEmMassa')
    const moeda = pegaChave('#txtMoedaAlterarReceberEmMassa')
    const descricaoMoeda = pegaDescricao('#txtMoedaAlterarReceberEmMassa')
    const numeroBanco = $('#txtNumeroBancoAlterarReceberEmMassa').val()
    const bordero = $('#txtBorderoAlterarReceberEmMassa').val() || 0
    const cartaoNsu = $('#txtCartaoNsuAlterarReceberEmMassa').val()
    const observacao = $('#txtObservacaoAlterarReceberEmMassa').val()
    const desconto = $('#txtDescontoAlterarReceberEmMassa').val() || 0
    const juros = $('#txtJurosAlterarReceberEmMassa').val() || 0

    const dados = {
      emissao,
      vencimento,
      classeGerencial,
      descricaoClasseGerencial,
      historico,
      descricaoHistorico,
      banco,
      descricaoBanco,
      situacao,
      descricaoSituacao,
      conta,
      descricaoConta,
      moeda,
      descricaoMoeda,
      numeroBanco,
      bordero,
      cartaoNsu,
      observacao,
      desconto,
      juros,
    }

    const datatable = alterarSomenteSelecionado ? $('#tabelaAlterarReceberEmMassa').DataTable().rows({ selected: true }) : $('#tabelaAlterarReceberEmMassa').DataTable()

    const duplicatas = datatable.data().toArray().map((item) => ({
      numero: item.numero,
      possuiDescontoNaBaixa: item.possuiDescontoNaBaixa,
      possuiJurosNaBaixa: item.possuiJurosNaBaixa,
      banco: item.banco,
      bordero: item.bordero,
      vencimento: item.vencimento.split('T')[0],
    }))

    return {
      dados,
      duplicatas,
    }
  }

  const atualizarLinhaSelecionada = (dados) => {
    const datatable = $('#tabelaAlterarReceberEmMassa').DataTable()
    const [indiceLinhaSelecionada] = datatable?.rows({ selected: true }).indexes().toArray()
    const dadosAtuais = datatable.row(indiceLinhaSelecionada).data()
    const novosDados = { ...dadosAtuais, ...dados }
    datatable.row(indiceLinhaSelecionada).data(novosDados).draw(false)
  }

  $('.duasCasasDecimaisInput').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  })

  const validarDadosGravarReceberEmMassa = ({ dados, duplicatas }) => {
    return new Promise((resolve) => {
      const arrayDuplicatasJaEnviadasAoBanco = []

      const dataVencimentoAlteracao = new Date(dados.vencimento)
      const dataEmissaoAlteracao = new Date(dados.emissao)

      if (dataVencimentoAlteracao < dataEmissaoAlteracao) {
        msgErro(`Data de vencimento não pode ser menor que a data de emissão.`)
        resolve({
          dadosForamValidados: false,
          gravarInstrucaoMudanca: false,
        })
        return
      }

      const encontrouAlgumRegistroInvalido = duplicatas.some((duplicata) => {
        if (duplicata.possuiDescontoNaBaixa && parseFloat(dados.desconto) > 0) {
          msgErro(`Não é possível alterar o desconto programado quando já existem baixas com desconto.\nDuplicata: ${duplicata.numero}`)
          return true
        }

        if (duplicata.possuiJurosNaBaixa && parseFloat(dados.juros) > 0) {
          msgErro(`Não é possível alterar os juros programados quando já existem baixas com juros.\nDuplicata: ${duplicata.numero}`)
          return true
        }

        if (dados.banco !== duplicata.banco && parseInt(duplicata.bordero) > 0) {
          msgErro(`Não é possível alterar o banco se o documento já possuir número de borderô vinculado, deve-se primeiro remover a duplicata do borderô.\nDuplicata: ${duplicata.numero}`)
          return true
        }

        if (parseInt(duplicata.bordero) > 0 && dados.vencimento !== duplicata.vencimento)
          arrayDuplicatasJaEnviadasAoBanco.push(duplicata.numero)

        return false
      })

      if (encontrouAlgumRegistroInvalido) {
        resolve({
          dadosForamValidados: false,
          gravarInstrucaoMudanca: false,
        })
        return
      }

      if (arrayDuplicatasJaEnviadasAoBanco.length === 0) {
        resolve({
          dadosForamValidados: true,
          gravarInstrucaoMudanca: false,
        })
        return
      }

      msgAlerta(
        `Existem duplicatas que já foram enviadas ao banco, gravar instrução de mudança de vencimento?\nDuplicatas: ${arrayDuplicatasJaEnviadasAoBanco.join(', ')}`,
        () => null,
        () => resolve({
          dadosForamValidados: true,
          gravarInstrucaoMudanca: false,
        }),
        () => resolve({
          dadosForamValidados: true,
          gravarInstrucaoMudanca: true,
        }),
        () => resolve({
          dadosForamValidados: true,
          gravarInstrucaoMudanca: false,
        }),
      )
    })
  }

  function distribuiValor() {
    const tabela = $('#tabelaBaixarContas').DataTable().data().toArray()
    const dupBaixar = [...tabela].sort((a, b) => {
      return new Date(a.DT_VENCTO).getTime() - new Date(b.DT_VENCTO).getTime();
    });

    let valorRecebido = parseFloat($('#txtValorRecebidoDistribuir').val());

    if (!isNaN(valorRecebido) && valorRecebido > 0) {

      for (let i = 0; i < dupBaixar.length; i++) {
        const item = dupBaixar[i];
        const idxOriginal = tabela.findIndex(x => x.NUMERO === item.NUMERO);
        const desconto = parseFloat($($(".txtDesconto")[idxOriginal]).val()) || 0;
        const juros = parseFloat($($(".txtJuros")[idxOriginal]).val()) || 0;

        const saldoFinal = (parseFloat(item.SALDO) + juros - desconto);

        if (valorRecebido >= saldoFinal) {
          $($(".txtvalorPago")[idxOriginal]).val(TruncaDecimaisNova(2, saldoFinal)).trigger('blur');

          valorRecebido -= saldoFinal;
        } else if (valorRecebido > 0) {
          $($(".txtvalorPago")[idxOriginal]).val(TruncaDecimaisNova(2, valorRecebido)).trigger('blur');

          valorRecebido = 0;
        } else {
          $($(".txtvalorPago")[idxOriginal]).val(0).trigger('blur');
        }
      }

    } else {
      msgAlerta('Nenhum valor informado para distribuir!');
    }
  }


  $('#btnDistribuirValorRecebido').on('click', async () => {
    distribuiValor()
  });

  async function validarPeriodoConciliado(conta, dataLancamento, tipo) {
    const url = "/sisplan/contabil/v1/periodoconciliado?";
    const params = `CONTA=${conta}` +
      `&DATA_LANCAMENTO=${dataLancamento}` +
      `&TIPO=${tipo}`;

    const response = await requisicao("GET", url, params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível validar o período da conciliação.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }

  }

  async function validarEstornarCheques(numero, lancamento) {
    const url = "/sisplan/receber/v1/validarestornarcheques?";
    const params = `NUMERO=${numero}` +
      `&LANCAMENTO=${lancamento}`;
    let mensagem = "";

    const response = await requisicao("GET", url, params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível validar se existem cheques vínculados a duplicata.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(`Não foi possível validar se existem cheques vínculados a duplicata. ${json.mensagem}`);
    }

    if (json && JSON.parse(json.possuiCheques)) {
      const numerosChequesPendentes = await formataListas(json.chequesPendentes.toString(), true, true);
      mensagem += "Os lançamentos estornados foram baixados pelos seguintes cheques: \n";
      if (json.chequesBaixados.length > 0) {
        mensagem += `${json.chequesBaixados.toString()}. Porém estes já foram baixados e não serão excluídos.`;
      }
      if (json.chequesBaixados.length > 0 && json.chequesPendentes.length > 0) {
        mensagem += `E também pelos cheques: ${numerosChequesPendentes}. Estes serão excluídos por não estarem baixados.`;
      } else if (json.chequesPendentes.length > 0) {
        mensagem += `${numerosChequesPendentes}. Estes cheques serão excluídos por não estarem baixados.`;
      }

      await msgAguardaConfirmacao(mensagem, async () => { await deletarCheques(numerosChequesPendentes, lancamento) }, () => { }, false, true, "Confirmar");
    }

  }

  async function deletarCheques(numeros, lancamento) {
    if (numeros == "") {
      return;
    }

    const url = "/sisplan/receber/v1/deletarcheques?";
    const params = `NUMEROS=${numeros}` +
      `&LANCAMENTO=${lancamento}`;

    const response = await requisicao("DELETE", url, params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível deletar os cheques.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(`Não foi possível deletar os cheques. ${json.mensagem}`);
    }

  }

});
