$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaMoeda',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma moeda.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaMoeda',
                popover: {
                    title: 'Tabela Moedas',
                    description: 'Aqui estão os dados das moedas cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("MOEDA");

    // autocompleta 
    $('#txtClasseGerConsulta').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtHistoricoConsulta').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO chave", "descricao descricao"], "where": null}`);
    $('#txtSituacaoConsulta').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCondPagamentoConsulta').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond chave", "descricao descricao"], "where": null}`);
    // pesquisa
    $('#btn-ClasseGer').pesquisa('#txtClasseGerConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $('#btn-Historico').pesquisa('#txtHistoricoConsulta', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "descricao"]}`, 'Pesquisa Histórico', 'HISTCP');
    $('#btn-Situacao').pesquisa('#txtSituacaoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
    $('#btn-CondPagamento').pesquisa('#txtCondPagamentoConsulta', 'CODCOND', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao"]}`, 'Pesquisa Condição Pagamento', 'condicao');

    $('#btn-limpa-ClasseGer').on('click', function () {
        $('#txtClasseGerConsulta').val('');
    });

    $('#btn-limpa-Historico').on('click', function () {
        $('#txtHistoricoConsulta').val('');
    });

    $('#btn-limpa-Situacao').on('click', function () {
        $('#txtSituacaoConsulta').val('');
    });

    $('#btn-limpa-CondPagamento').on('click', function () {
        $('#txtCondPagamentoConsulta').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovaMoeda').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "moeda/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaMoeda();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaMoeda(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtClasseGerConsulta').val('');
        $('#txtHistoricoConsulta').val('');
        $('#txtSituacaoConsulta').val('');
        $('#txtCondPagamentoConsulta').val('');
    });

    async function consultaMoeda(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            let pagamento = pegaChave('#txtCondPagamentoConsulta') != '' ? ` AND CDCONDI = '${pegaChave('#txtCondPagamentoConsulta')}'` : '';
            let situacao = pegaChave('#txtSituacaoConsulta') != '' ? ` AND CODSIT = '${pegaChave('#txtSituacaoConsulta')}'` : '';
            let historico = pegaChave('#txtHistoricoConsulta') != '' ? ` AND HISTORICO = '${pegaChave('#txtHistoricoConsulta')}'` : '';
            let classeGer = pegaChave('#txtClasseGerConsulta') != '' ? ` AND CLASSE = '${pegaChave('#txtClasseGerConsulta')}'` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"moeda", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": ["1=1 ${pagamento} ${situacao} ${historico} ${classeGer}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"moeda", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null, "limit": 10000}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadMoeda == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadMoeda: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaMoeda').DataTable({
                destroy: true,
                lengthChange: true,
                paging: true,
                searching: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "CODMOE",
                    title: "Código Moeda",
                    "render": function (data, type, row) {
                        return '<span data-sort="' + parseInt(data, 10) + '">' + data + '</span>';
                    },
                    "createdCell": function (td, cellData, rowData, row, col) {
                        $(td).html(retornaBotaoOpcoes(cellData));
                    }
                },
                {
                    data: "DESCRICAO",
                    title: "Descrição"
                }],
                "order": [
                    [0, "asc"]
                ],
            });

            $('#tabelaMoeda_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaMoeda_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaMoeda").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Moeda', '', '', 999, false, false, dados);
            });

            $('#tabelaMoeda').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadMoeda).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaMoeda').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadMoeda ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODMOE"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadMoeda: novasColunas }));

            $('#tabelaMoeda').DataTable().columns().visible(true);

            $('#tabelaMoeda').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaMoeda').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMoeda').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('MOEDA', data.CODMOE);
            if (registroLiberado) {
                window.location.href = `moeda/${data.CODMOE}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaMoeda').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaMoeda').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('MOEDA', data.CODMOE);
            if (registroLiberado) {
                window.location.href = `moeda/${data.CODMOE}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaMoeda').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaMoeda").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/moeda?", `CODIGOMOEDA=${encodeURIComponent(valorLinha.CODMOE)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});