componenteFiltro("banco", false, false, "BancoMagazord");
componenteFiltro("conta", false, false, "ContaMagazord");
componenteFiltro("classe", false, false, "ClasseBaixaMagazord");
componenteFiltro("classe", false, false, "ClasseTaxaMagazord");
componenteFiltro("historico", false, false, "HistoricoMagazord");
componenteFiltro("moeda", false, false, "MoedaMagazord");

function criaDataTableMagazord() {
  $("#tabelaMagazord").DataTable({
    paging: true,
    filter: false,
    info: false,
    length: false,
    order: false,
    destroy: true,
    data: {},
    columns: dataSetColsMagazord,
    columnDefs: [
      {
        targets: [0], render: function (_data, _type, _row, meta) {
          return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S') ? 'checked' : 'disabled'} id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
        },
      },
      {
        type: 'date-br',
        targets: [10, 11, 12],
        render(data) {
          if (data) {
            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
          } else {
            return '';
          }

        },
      },
      {
        targets: [5, 6, 7, 15],
        render(data) {
          return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        },
        "className": 'pr-4 text-right'
      }
    ],
  });
};

$('#btnVerBaixasMagazord').on('click', async function () {
  await insereDadosNaTabelaMagazord();
});

$('#btnConfirmarMagazord').on('click', async function () {
  await gravaDadosNaTabelaMagazord(); 
});

$('#txtContaMagazord').on('blur', async function () {
  if ($(this).val() != '') {
    const conta = pegaChave('#txtContaMagazord'); 

    const pesquisaBanco = {
      tabela: "CADCONTA",
      camposSelect: ["CADCONTA.BANCO", "CADBAN.NOME_BANCO"],
      innerJoin: [
        { "tabela": "CADBAN", "condicao": "CADBAN.BANCO = CADCONTA.BANCO" }
      ],
      where: [`CADCONTA.CONTA = '${conta}'`]
    };

    const jsonBanco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBanco));

    if (jsonBanco.length == 0) {
        return;
    };

    $('#txtBancoMagazord').val(`[${jsonBanco[0].BANCO}] - ${jsonBanco[0].NOME_BANCO}`);
  }
});

function retornaFiltrosMagazord() {
  const banco = pegaChave('#txtBancoMagazord');
  const conta = pegaChave('#txtContaMagazord');
  const classeBaixa = pegaChave('#txtClasseBaixaMagazord');
  const classeTaxa = pegaChave('#txtClasseTaxaMagazord');
  const historico = pegaChave('#txtHistoricoMagazord');
  const moeda = pegaChave('#txtMoedaMagazord');

  return `BANCO=${banco}&CONTA=${conta}&CLASSE_BAIXA=${classeBaixa}&CLASSE_TAXA=${classeTaxa}&HISTORICO=${historico}&MOEDA=${moeda}`;
};

async function insereDadosNaTabelaMagazord() {
  $.LoadingOverlay('show');
  try {
    $('#tabelaMagazord').DataTable().clear().draw(false);
    
    const url = '/sisplan/escretorno/v1/buscabaixasmagazord?';

    const params = retornaFiltrosMagazord();

    const listaRegistrosMagazord = [];

    for (let i = 0; i < window.databody.length; i++) {
      const obj = {
        "sel": window.databody[i].sel,
        "nsu": window.databody[i].nsu,
        "parcela": window.databody[i].parcela,
        "dt_pagamento": window.databody[i].dt_pagamento,
      };
      listaRegistrosMagazord.push(obj);
    };

    let response = await requisicao('POST', url, `${params}&LISTA_REGISTROS=${JSON.stringify({ DATA: listaRegistrosMagazord })}`, ``);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (!jsonStr || jsonStr.length === 0) {
      msgAlerta('Não foi possível encontrar os dados das baixas do extrato de cartão Magazord. Por favor, tente novamente.');
      return
    };

    $('#tabelaMagazord').DataTable().rows.add(jsonStr).draw(false);
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao ver as baixas do arquivo Magazord! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide');
  }
};

criaDataTableMagazord();

async function gravaDadosNaTabelaMagazord() {
  $.LoadingOverlay('show');
  try {
    const url = '/sisplan/escretorno/v1/gravabaixasmagazord?';

    const paramsReceber = await BuscaParametrosReceber();

    if (paramsReceber[15].VALOR == '0' && isEmpty($('#txtClasseBaixaMagazord'))) {
      await msgAguardaConfirmacao('Classe/Baixa não informado, deseja utilizar a classe das Duplicatas?', () => { }, () => { throw new Error('Operação Cancelada!') })
    } else if (paramsReceber[15].VALOR == '1' && isEmpty($('#txtClasseBaixaMagazord'))) {
      return msgAlerta('Classe/Baixa não informado, verifique!')
    }

    const params = retornaFiltrosMagazord();

    const listaBaixasMagazord = [];

    const dataTableMagazord = $('#tabelaMagazord').DataTable().rows().data();

    for (let i = 0; i < dataTableMagazord.length; i++) {
      if (dataTableMagazord[i].SEL === 'S') {
        const obj = {
          "NUMERO": dataTableMagazord[i].NUMERO,
          "CODCLI": dataTableMagazord[i].COD_CLI,
          "DT_PAGAMENTO": dataTableMagazord[i].DT_PAGAMENTO,
          "VALOR_LIQUIDO": dataTableMagazord[i].VALOR_LIQUIDO,
          "VALOR_PAGO": dataTableMagazord[i].VALOR_LIQUIDO,
          "DT_EMISSAO": dataTableMagazord[i].DT_EMISSAO,
          "FATURA": dataTableMagazord[i].FATURA,
          "CLASSE_DUP": dataTableMagazord[i].CLASSE_DUP,
        };
        listaBaixasMagazord.push(obj);
      }
    };
    if (listaBaixasMagazord.length === 0) {
      msgAlerta('Nenhum registro selecionado para baixa. Por favor, selecione ao menos um registro.');
      return;
    };

    let response = await requisicao('POST', url, `${params}&LISTA_BAIXAS=${JSON.stringify({ DATA: listaBaixasMagazord })}`, ``);

    if (!response) {
      return;
    }

    if (response.status !== 200) {
      msgAlerta('Não foi possível gravar os dados das baixas do extrato de cartão Magazord. Por favor, tente novamente.');
      return
    };

    await criaMensagemSucesso('Baixas do arquivo Magazord gravadas com sucesso!', () => { window.location.reload() } );
  
  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao gravar as baixas do arquivo Magazord! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide'); 
  }
}
