$(document).ready(async function () {
    let cheqList = [];
    let recList = [];
    let recEncontroContasList = [];
    let pagarEncontroContasList = [];
    let chequePagarList = [];
    let pagtoPagarList = [];
    let tbLancarList = [];
    let tbLancarPagarList = [];
    let listaTratadaGravacao = [];
    let seq = 0;

    $(document).on('keydown', (event) => {
        const keyCode = event.code;

        if (keyCode === "F7") {
            event.preventDefault();
            const components = $('.escondeInputs');

            for (let i = 0; i < components.length; i++) {
                if ($(`#${components[i].id}`).hasClass('d-none')) {
                    $(`#${components[i].id}`).removeClass('d-none');
                } else {
                    $(`#${components[i].id}`).addClass('d-none');
                }
            };
        };
    });

    $('#btnConsultar').on('click', async function () {
        await consultaChequeComReceber();
        await consultaReceber();

        $('html, body').animate({
            scrollTop: $('#tituloTableCheque').offset().top
        }, 300);

        criaFunctionCampoSelChequeReceber();
        criaFunctionCampoSelReceber();

        $('#tabelaCheques').on('draw.dt', async function () {
            criaFunctionCampoSelChequeReceber();
        });

        $('#tabelaReceber').on('draw.dt', async function () {
            criaFunctionCampoSelReceber();
        });
    });

    $('#btnConsultarEncontroContas').on('click', async function () {
        $('#tabelaReceberEncontroContas').DataTable().clear().draw(false);
        $('#tabelaPagarEncontroContas').DataTable().clear().draw(false);

        await pesquisaReceberEncontroContas();
        await pesquisaPagarEncontroContas();

        $('html, body').animate({
            scrollTop: $('#tituloTableReceberEncontroContas').offset().top
        }, 300);

        criaFunctionCampoSelEncontroContasReceber();
        criaFunctionCampoSelEncontroContasPagar();

        $('#tabelaReceberEncontroContas').on('draw.dt', async function () {
            criaFunctionCampoSelEncontroContasReceber();
        });

        $('#tabelaPagarEncontroContas').on('draw.dt', async function () {
            criaFunctionCampoSelEncontroContasPagar();
        });
    });

    $('#btnConsultarAbaPagar').on('click', async function () {
        $('#tabelaChequesAbaPagar').DataTable().clear().draw(false);
        $('#tabelaPagarAbaPagar').DataTable().clear().draw(false);
        await pesquisaChequesAbaPagar();
        await pesquisaPagtoAbaPagar();

        $('html, body').animate({
            scrollTop: $('#tituloTableChequeAbaPagar').offset().top
        }, 300);

        criaFunctionCampoSelChequeAbaPagar();
        criaFunctionCampoSelPagtoAbaPagar();

        $('#tabelaChequesAbaPagar').on('draw.dt', async function () {
            criaFunctionCampoSelChequeAbaPagar();
        });

        $('#tabelaPagarAbaPagar').on('draw.dt', async function () {
            criaFunctionCampoSelPagtoAbaPagar();
        });
    });

    $('#btnCalcular').on('click', async function () {
        if (cheqList.length <= 0) {
            msgErro('Selecione um cheque para continuar! Tente novamente.');
            return;
        }

        if (recList.length <= 0) {
            msgErro('Selecione um receber para continuar! Tente novamente.');
            return;
        }
        try {
            await lancarBaixasReceberCheque();
            $('#modal-baixasRecCheque').modal('show');
        } catch (error) {
            console.error(error)
        }
    });

    $('#btnCalcularAbaPagar').on('click', async function () {
        if (chequePagarList.length <= 0) {
            msgErro('Selecione um cheque para continuar! Tente novamente.');
            return;
        }

        if (pagtoPagarList.length <= 0) {
            msgErro('Selecione um pagar para continuar! Tente novamente.');
            return;
        }
        try {
            await lancarBaixasPagtoCheque();
            $('#modal-baixasPagtoCheque').modal('show');
        } catch (error) {
            console.error(error)
        }
    });

    $('#btnCalcularEncontroContas').on('click', async function () {
        try {
            const classeGerBaixasRec = pegaChave('#txtClasseGerBaixaReceberEncontroContas');
            const historicoBaixasRec = pegaChave('#txtHistoricoBaixaReceberEncontroContas');
            const classeGerBaixasPag = pegaChave('#txtClasseGerBaixaPagarEncontroContas');
            const historicoBaixasPag = pegaChave('#txtHistoricoBaixaPagarEncontroContas');

            if (classeGerBaixasRec == '') {
                msgAlerta('Classe Gerencial da baixa do Receber. Não foi possível continuar. Verifique e tente novamente.');
                return
            }

            if (historicoBaixasRec == '') {
                msgAlerta('Histórico da baixa do Receber. Não foi possível continuar. Verifique e tente novamente.');
                return
            }

            if (classeGerBaixasPag == '') {
                msgAlerta('Classe Gerencial da baixa do Pagar. Não foi possível continuar. Verifique e tente novamente.');
                return
            }

            if (historicoBaixasPag == '') {
                msgAlerta('Histórico da baixa do Pagar. Não foi possível continuar. Verifique e tente novamente.');
                return
            }

            await calculaLancamentoReceberEncontroContas();
            $('#modal-baixasEncontroContas').modal('show');
        } catch (error) {
            console.error(error)
        }
    });

    $('#btnBaixaDados').on('click', async function () {
        await gravaDadosEmissao();
    });

    $('#btnBaixaDadosEncontroContas').on('click', async function () {
        await gravaDadosEmissaoEncontroContas();
    });

    $('#btnBaixaDadosPagar').on('click', async function () {
        await gravaChequexPagar();
    });

    $('#btnCarregaEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#btnCarregaEmpresasAbaPagar').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $("#divTabs").on("click", ".abaLink", function () {
        const tabClicada = $(this).attr("id");
        ativaDesativaTabs(tabClicada);
    });

    $('#modal-baixasRecCheque').on('shown.bs.modal', async function () {
        $('#txtHistoricoRBCH').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoRBCH").pesquisa_serverside(['#txtHistoricoRBCH'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoRBCH').on('click', function () { $('#txtHistoricoRBCH').val('') });

        $('#txtClasseGerRecBCH').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerRecBCH").pesquisa_serverside(['#txtClasseGerRecBCH'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerRecBCH').on('click', function () { $('#txtClasseGerRecBCH').val('') });

        $('#txtHistoricoBCHRec').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoBCHRec").pesquisa_serverside(['#txtHistoricoBCHRec'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoBCHRec').on('click', function () { $('#txtHistoricoBCHRec').val('') });

        $('#txtClasseGerBCHRec').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerBCHRec").pesquisa_serverside(['#txtClasseGerBCHRec'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerBCHRec').on('click', function () { $('#txtClasseGerBCHRec').val('') });

        setarDataAtual('txtDtPagto');
        setarDataAtual('txtDtContabilizacao');

        $('#txtContaR').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
        $('#btnContaR').pesquisa_serverside(['#txtContaR'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
        $('#btnLimpaContaR').on('click', function () { $('#txtContaR').val('') })

        $('#txtBancoR').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}`);
        $('#btnBancoR').pesquisa_serverside(['#txtBancoR'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
        $('#btnLimpaBancoR').on('click', function () { $('#txtBancoR').val('') });

        $('#txtMoedaR').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#btnMoedaR').pesquisa_serverside(['#txtMoedaR'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
        $('#btnLimpaMoedaR').on('click', function () { $('#txtMoedaR').val('') });

        $('#btnLimpaObsR').on('click', function () {
            $('#txtObsR').val('');
        });

        $('#btnLimpaDoctoR').on('click', function () {
            $('#txtDoctoR').val('');
        });

        if ((!$('#cbBuscaAntecipacao').is(':checked')) && (!$('#cbBuscaDevolucao').is(':checked'))) {
            $('#txtDoctoR').val(await RetornaProximo('DOCTO', 'CONTACOR', 'DOCTO', 6));
        };
    });

    $('#modal-baixasPagtoCheque').on('shown.bs.modal', async function () {
        $('#txtHistoricoPBCH').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoPBCH").pesquisa_serverside(['#txtHistoricoPBCH'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoPBCH').on('click', function () { $('#txtHistoricoPBCH').val('') });

        $('#txtClasseGerPagtoBCH').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerPagtoBCH").pesquisa_serverside(['#txtClasseGerPagtoBCH'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerPagtoBCH').on('click', function () { $('#txtClasseGerPagtoBCH').val('') });

        $('#txtHistoricoBCHPagto').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoBCHPagto").pesquisa_serverside(['#txtHistoricoBCHPagto'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoBCHPagto').on('click', function () { $('#txtHistoricoBCHPagto').val('') });

        $('#txtClasseGerBCHPagto').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerBCHPagto").pesquisa_serverside(['#txtClasseGerBCHPagto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerBCHPagto').on('click', function () { $('#txtClasseGerBCHPagto').val('') });

        setarDataAtual('txtDtPagtoPagar');
        setarDataAtual('txtDtContabilizacaoPagar');

        $('#txtContaP').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
        $('#btnContaP').pesquisa_serverside(['#txtContaP'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
        $('#btnLimpaContaP').on('click', function () { $('#txtContaP').val('') })

        $('#txtBancoP').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}`);
        $('#btnBancoP').pesquisa_serverside(['#txtBancoP'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
        $('#btnLimpaBancoP').on('click', function () { $('#txtBancoP').val('') });

        $('#txtMoedaP').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#btnMoedaP').pesquisa_serverside(['#txtMoedaP'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
        $('#btnLimpaMoedaP').on('click', function () { $('#txtMoedaP').val('') });

        $('#btnLimpaDoctoP').on('click', function () {
            $('#txtDoctoP').val('');
        });

        $('#btnLimpaObsP').on('click', function () {
            $('#txtObsP').val('');
        });

        $('#txtDoctoP').val(await RetornaProximo('DOCTO', 'CONTACOR', 'DOCTO', 8));
    });

    function criaFunctionCampoSelChequeReceber() {
        $('.campoSelCheque').unbind('change');
        $('.campoSelCheque').on('change', async function () {
            let qtdeCheques = parseInt($('#txtChequeSelecionadosCh').val() == '' ? '0' : $('#txtChequeSelecionadosCh').val());
            let valorSelecionadoCheques = parseFloat($('#txtValorSelecionadoCh').val() == '' ? '0' : $('#txtValorSelecionadoCh').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                const objeto = {
                    "TIPO": $(this).parent().parent().parent()[0].children[18].textContent,
                    "NUMERO": $(this).parent().parent().parent()[0].children[12].textContent,
                    "CODCLI": $(this).parent().parent().parent()[0].children[11].textContent,
                    "VALOR": parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "SALDO": parseFloat($($($(this).parent().parent().parent())[0].children)[16].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "OBS": '',
                    "VENCTO_CHEQUE": $(this).parent().parent().parent()[0].children[6].textContent,
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent
                };
                cheqList.push(objeto);
                qtdeCheques++
                valorSelecionadoCheques += parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.'));
                $('#txtChequeSelecionadosCh').val(String(qtdeCheques));
                $('#txtValorSelecionadoCh').val(valorSelecionadoCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            } else {
                qtdeCheques = qtdeCheques - 1;
                valorSelecionadoCheques -= parseFloat($($($(this).parent().parent().parent())[0].children)[7].textContent.trim().replace(/\./g, '').replace(',', '.'));
                const index = cheqList.findIndex(index => index.TIPO == $(this).parent().parent().parent()[0].children[18].textContent
                    && index.NUMERO == $(this).parent().parent().parent()[0].children[12].textContent
                    && index.CODCLI == $(this).parent().parent().parent()[0].children[11].textContent
                );
                if (index != -1) {
                    cheqList.splice(index, 1);
                };
                $('#txtChequeSelecionadosCh').val(String(qtdeCheques));
                $('#txtValorSelecionadoCh').val(valorSelecionadoCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            }
        });
    };

    function criaFunctionCampoSelReceber() {
        $('.campoSelReceber').unbind('change');
        $('.campoSelReceber').on('change', async function () {
            let qtdeDuplicatas = parseInt($('#txtDupSelecionadaRec').val() == '' ? '0' : $('#txtDupSelecionadaRec').val().replace('.', ''));
            let valorSelecionadoReceber = parseFloat($('#txtValorSelecionadoRec').val() == '' ? '0' : $('#txtValorSelecionadoRec').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                const objeto = {
                    "TIPO": $(this).parent().parent().parent()[0].children[15].textContent,
                    "NUMERO": $(this).parent().parent().parent()[0].children[1].textContent,
                    "CODCLI": $(this).parent().parent().parent()[0].children[2].textContent,
                    "VALOR": parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "SALDO": parseFloat($($($(this).parent().parent().parent())[0].children)[11].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "VALOR_UTILIZADO": 0,
                    "NR_CHEQUE_UTILIZADO": '',
                    "OBS": '',
                    "JUROS": parseFloat($($($(this).parent().parent().parent())[0].children)[9].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent,
                    "VENCTO_CHEQUE": $(this).parent().parent().parent()[0].children[5].textContent,
                    "COM2": parseFloat($(this).parent().parent().parent()[0].children[17].textContent.trim().replace(/\./g, '').replace(',', '.')),
                    "EMPRESA": $(this).parent().parent().parent()[0].children[12].textContent
                }
                recList.push(objeto);
                qtdeDuplicatas++
                valorSelecionadoReceber += parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.'));
                $('#txtDupSelecionadaRec').val(String(qtdeDuplicatas.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
                $('#txtValorSelecionadoRec').val(valorSelecionadoReceber.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }))
            } else {
                qtdeDuplicatas = qtdeDuplicatas - 1;
                valorSelecionadoReceber -= parseFloat($($($(this).parent().parent().parent())[0].children)[6].textContent.trim().replace(/\./g, '').replace(',', '.'));
                const index = recList.findIndex(index => index.TIPO == $(this).parent().parent().parent()[0].children[15].textContent
                    && index.NUMERO == $(this).parent().parent().parent()[0].children[1].textContent
                    && index.CODCLI == $(this).parent().parent().parent()[0].children[2].textContent);
                if (index != -1) {
                    recList.splice(index, 1);
                };
                $('#txtDupSelecionadaRec').val(String(qtdeDuplicatas.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
                $('#txtValorSelecionadoRec').val(valorSelecionadoReceber.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }))
            }
        });
    };

    function criaFunctionCampoSelEncontroContasReceber() {
        $('.campoSelEncontroContasReceber').unbind('change');
        $('.campoSelEncontroContasReceber').on('change', async function () {
            const data = $('#tabelaReceberEncontroContas').DataTable().row($(this).closest('tr')).data();
            let valorSelecionadoReceberEncontroContas = parseFloat($('#txtValorDuplicatasEncontroContasReceber').val() == '' ? '0' : $('#txtValorDuplicatasEncontroContasReceber').val().trim().replace(/\./g, '').replace(',', '.'));
            let saldoSelecionadoReceberEncontroContas = parseFloat($('#txtSaldoDuplicatasEncontroContasReceber').val() == '' ? '0' : $('#txtSaldoDuplicatasEncontroContasReceber').val().trim().replace(/\./g, '').replace(',', '.'))
            if ($(this).is(':checked')) {
                valorSelecionadoReceberEncontroContas += data.VALOR2;
                saldoSelecionadoReceberEncontroContas += data.SALDO;
                $('#txtValorDuplicatasEncontroContasReceber').val(valorSelecionadoReceberEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoDuplicatasEncontroContasReceber').val(saldoSelecionadoReceberEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                data.TIPO = 'REC'
                recEncontroContasList.push(data);
            } else {
                valorSelecionadoReceberEncontroContas -= data.VALOR2;
                saldoSelecionadoReceberEncontroContas -= data.SALDO;
                const index = recEncontroContasList.findIndex(item => item.NUMERO == data.NUMERO);
                if (index != -1) {
                    recEncontroContasList.splice(index, 1);
                }
                $('#txtValorDuplicatasEncontroContasReceber').val(valorSelecionadoReceberEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoDuplicatasEncontroContasReceber').val(saldoSelecionadoReceberEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            };
        });
    };

    function criaFunctionCampoSelEncontroContasPagar() {
        $('.campoSelEncontroContasPagar').unbind('change');
        $('.campoSelEncontroContasPagar').on('change', async function () {
            const data = $('#tabelaPagarEncontroContas').DataTable().row($(this).closest('tr')).data();
            let valorSelecionadoPagarEncontroContas = parseFloat($('#txtValorSelecionadoEncontroContasPagar').val() == '' ? '0' : $('#txtValorSelecionadoEncontroContasPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            let saldoSelecionadoPagarEncontroContas = parseFloat($('#txtSaldoSelecionadoEncontroContasPagar').val() == '' ? '0' : $('#txtSaldoSelecionadoEncontroContasPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                valorSelecionadoPagarEncontroContas += data.VALOR;
                saldoSelecionadoPagarEncontroContas += data.SALDO;
                $('#txtValorSelecionadoEncontroContasPagar').val(valorSelecionadoPagarEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoSelecionadoEncontroContasPagar').val(saldoSelecionadoPagarEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                data.TIPO = 'PAG';
                pagarEncontroContasList.push(data);
            } else {
                valorSelecionadoPagarEncontroContas -= data.VALOR;
                saldoSelecionadoPagarEncontroContas -= data.SALDO;
                const index = pagarEncontroContasList.findIndex(item => item.NUM_AP == data.NUM_AP);
                if (index != -1) {
                    pagarEncontroContasList.splice(index, 1);
                }
                $('#txtValorSelecionadoEncontroContasPagar').val(valorSelecionadoPagarEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoSelecionadoEncontroContasPagar').val(saldoSelecionadoPagarEncontroContas.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            }
        });
    };

    function criaFunctionCampoSelChequeAbaPagar() {
        $('.campoSelChequeAbaPagar').unbind('change');
        $('.campoSelChequeAbaPagar').on('change', async function () {
            const data = $('#tabelaChequesAbaPagar').DataTable().row($(this).closest('tr')).data();
            let valorSelecionadoChequeAbaPagar = parseFloat($('#txtValorSelecionadoChAbaPagar').val() == '' ? '0' : $('#txtValorSelecionadoChAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            let qtdeChequesSelecionados = parseInt($('#txtChequeSelecionadosChAbaPagar').val() == '' ? '0' : $('#txtChequeSelecionadosChAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                data.TIPO = 'CHEQ';
                valorSelecionadoChequeAbaPagar += data.VAL_CHEQUE;
                qtdeChequesSelecionados++;
                $('#txtValorSelecionadoChAbaPagar').val(valorSelecionadoChequeAbaPagar.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtChequeSelecionadosChAbaPagar').val(String(qtdeChequesSelecionados.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
                chequePagarList.push(data);
            } else {
                valorSelecionadoChequeAbaPagar -= data.VAL_CHEQUE;
                qtdeChequesSelecionados -= 1;
                const index = chequePagarList.findIndex(item => item.NUM_AP == data.NUM_AP);
                if (index != -1) {
                    chequePagarList.splice(index, 1);
                }
                $('#txtValorSelecionadoChAbaPagar').val(valorSelecionadoChequeAbaPagar.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtChequeSelecionadosChAbaPagar').val(String(qtdeChequesSelecionados.toLocaleString('pt-BR', { maximumFractionDigits: 2 })));
            };
        });
    };

    function criaFunctionCampoSelPagtoAbaPagar() {
        $('.campoSelPagtoAbaPagar').unbind('change');
        $('.campoSelPagtoAbaPagar').on('change', async function () {
            const data = $('#tabelaPagarAbaPagar').DataTable().row($(this).closest('tr')).data();
            let valorSelecionadoPagtoAbaPagar = parseFloat($('#txtValorSelecionadoPagtoAbaPagar').val() == '' ? '0' : $('#txtValorSelecionadoPagtoAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            let saldoPagarSelecionado = parseFloat($('#txtSaldoSelecionadoAbaPagar').val() == '' ? '0' : $('#txtSaldoSelecionadoAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            let qtdeApsSelecionadas = parseInt($('#txtQtdeApsSelecionadasAbaPagar').val() == '' ? '0' : $('#txtQtdeApsSelecionadasAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            if ($(this).is(':checked')) {
                data.TIPO = 'PAG';
                valorSelecionadoPagtoAbaPagar += data.VALOR;
                saldoPagarSelecionado += data.VALOR;
                qtdeApsSelecionadas++;
                $('#txtValorSelecionadoPagtoAbaPagar').val(valorSelecionadoPagtoAbaPagar.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoSelecionadoAbaPagar').val(saldoPagarSelecionado.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtQtdeApsSelecionadasAbaPagar').val(qtdeApsSelecionadas.toLocaleString('pt-BR', { maximumFractionDigits: 2 }));
                pagtoPagarList.push(data);
            } else {
                valorSelecionadoPagtoAbaPagar -= data.VALOR;
                saldoPagarSelecionado -= data.VALOR;
                qtdeApsSelecionadas -= 1;
                const index = pagtoPagarList.findIndex(item => item.NUM_AP == data.NUM_AP);
                if (index != -1) {
                    pagtoPagarList.splice(index, 1);
                }
                $('#txtValorSelecionadoPagtoAbaPagar').val(valorSelecionadoPagtoAbaPagar.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtSaldoSelecionadoAbaPagar').val(saldoPagarSelecionado.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $('#txtQtdeApsSelecionadasAbaPagar').val(qtdeApsSelecionadas.toLocaleString('pt-BR', { maximumFractionDigits: 2 }));
            }
        });
    }

    function criaPesquisasCheque() {
        $('#txtDtVenctoDeCh').val('1200-01-01');
        $('#txtDtVenctoAteCh').val('2500-12-31');

        $('#btnLimpaEmissorCh').on('click', function () { $('#txtEmissorCh').val('') });
        $('#btnLimpaPedidoCh').on('click', function () { $('#txtPedidoCh').val('') });
        $('#btnLimpaBuscaChequeCmc').on('click', function () { $('#txtBuscaChequeCMC').val('') });

        $('#txtClienteCh').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
        $('#btnClienteCh').pesquisa_serverside(['#txtClienteCh'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
        $('#btnLimpaClienteCh').on('click', function () { $('#txtClienteCh').val('') });

        componenteFiltro('vendedor', true, true, 'RepresentanteCh');
        componenteFiltro('situacao', true, true, 'SituacaoCh');

        $('#txtHistoricoCh').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoCh").pesquisa_serverside(['#txtHistoricoCh'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoCh').on('click', function () { $('#txtHistoricoCh').val('') });

        $('#txtClasseGerCh').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerCh").pesquisa_serverside(['#txtClasseGerCh'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerCh').on('click', function () { $('#txtClasseGerCh').val('') });

        $('#txtHistoricoBaixaCheque').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnHistoricoBaixaCheque").pesquisa_serverside(['#txtHistoricoBaixaCheque'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa Histórico');
        $('#btnLimpaHistoricoBaixaCheque').on('click', function () { $('#txtHistoricoBaixaCheque').val('') });

        $('#txtClasseGerBaixaCheque').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $("#btnClasseGerBaixaCheque").pesquisa_serverside(['#txtClasseGerBaixaCheque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Classe Gerencial');
        $('#btnLimpaClasseGerBaixaCheque').on('click', function () { $('#txtClasseGerBaixaCheque').val('') });
    };

    function criaPesquisasReceber() {
        $('#txtDtVenctoDeRec').val('1200-01-01');
        $('#txtDtVenctoAteRec').val('2500-12-31');

        $('#txtDtEmissaoDeRec').val('1200-01-01');
        $('#txtDtEmissaoAteRec').val('2500-12-31');

        $('#btnLimpaPedidoRec').on('click', function () { $('#txtPedidoRec').val('') });

        componenteFiltro('duplicata', true, true, 'NumeroRec');
        componenteFiltro('cliente', true, true, 'ClienteRec');
        componenteFiltro('situacao', true, true, 'SituacaoRec');
        componenteFiltro('fatura', true, true, 'FaturaRec');
        componenteFiltro('vendedor', true, true, 'RepresenRec');
        componenteFiltro('classe', true, true, 'ClasseGerRec');
    };

    function criaPesquisasEncontroContas() {
        componenteFiltro('cliente', true, true, 'ClienteFornecedorEncontroContas');
        componenteFiltro('empresa', true, true, 'EmpresaReceberEncontroContas');
        componenteFiltro('moeda', false, false, 'MoedaReceberEncontroContas');
        componenteFiltro('empresa', true, true, 'EmpresaPagarEncontroContas');
        componenteFiltro('classe', false, false, 'ClasseGerBaixaPagarEncontroContas');
        componenteFiltro('classe', false, false, 'ClasseGerBaixaReceberEncontroContas');
        componenteFiltro('historico', false, false, 'HistoricoBaixaPagarEncontroContas');
        componenteFiltro('historico', false, false, 'HistoricoBaixaReceberEncontroContas');
    };

    function criaPesquisasChequeAbaPagar() {
        componenteFiltro('cliente', true, true, 'ClienteChAbaPagar');
        componenteFiltro('classe', false, false, 'ClasseGerChAbaPagar');
        componenteFiltro('historico', false, false, 'HistoricoChAbaPagar');
        $('#btnLimpaEmissorChAbaPagar').on('click', function () { $('#txtEmissorChAbaPagar').val('') });
        $('#btnLimpaBuscaChequeCmcAbaPagar').on('click', function () { $('#txtBuscaChequeCMCAbaPagar').val('') });
    };

    function criaPesquisasPagtoAbaPagar() {
        componenteFiltro('pagto', true, true, 'NumeroPagtoAbaPagar');
        componenteFiltro('cliente', true, true, 'FornecedorPagtoAbaPagar');
        componenteFiltro('situacao', true, true, 'SituacaoPagtoAbaPagar');
        componenteFiltro('classe', true, true, 'ClasseGerPagtoAbaPagar');
        componenteFiltro('historico', true, true, 'HistoricoPagtoAbaPagar');
        $('#btnLimpaPedidoPagtoAbaPagar').on('click', function () { $('#txtPedidoPagtoAbaPagar').val('') });
    };

    function criaDataTables() {
        $('#tabelaCheques').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,

            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkChequeReceber${meta.row}" class="campoSelCheque" nome="checkChequeReceber${meta.row}">
                        <label for="checkChequeReceber${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [5, 6],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [7, 9, 16],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
        });

        $('#tabelaReceber').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,

            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkReceber${meta.row}" class="campoSelReceber" nome="checkReceber${meta.row}">
                        <label for="checkReceber${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [4, 5],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [6, 7, 8, 9, 10, 11],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ]
        });

        $('#tabelaBaixasRecCheque').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            order: false,
            "autoWidth": true,
            columnDefs: [
                {
                    targets: [8, 9],
                    visible: false
                }
            ]
        });

        $('#tabelaReceberEncontroContas').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [8, 9],
                    visible: false
                },
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkEncontroContasReceber${meta.row}" class="campoSelEncontroContasReceber cursor-pointer" nome="checkEncontroContasReceber${meta.row}">
                        <label for="checkEncontroContasReceber${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [4],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [5, 6],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Sel",
                    "data": "SEL"
                },
                {
                    "title": "Número",
                    "data": "NUMERO"
                },
                {
                    "title": "CodCli",
                    "data": "CODCLI"
                },
                {
                    "title": "Nome Cliente",
                    "data": "NOME"
                },
                {
                    "title": "Dt. Vencto",
                    "data": "DT_VENCTO"
                },
                {
                    "title": "Valor Dup.",
                    "data": "VALOR2"
                },
                {
                    "title": "Saldo",
                    "data": "SALDO"
                },
                // {
                //     "title": "Selecionado",
                //     "data": "SELECIONADO"
                // }, 
                {
                    "title": "Empresa",
                    "data": "EMPRESA"
                },
                {
                    "title": "Pedido",
                    "data": "PEDIDO"
                },
                {
                    "title": "Fatura",
                    "data": "FATURA"
                }
            ]
        });

        $('#tabelaPagarEncontroContas').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkPagarEncontroContas${meta.row}" class="campoSelEncontroContasPagar" nome="checkPagarEncontroContas${meta.row}">
                        <label for="checkPagarEncontroContas${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [4],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [5, 6],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Sel",
                    "data": "SEL",
                },
                {
                    "title": "Número AP.",
                    "data": "NUM_AP"
                },
                {
                    "title": "CodCre",
                    "data": "CODCRE"
                },
                {
                    "title": "Nome",
                    "data": "NOME"
                },
                {
                    "title": "Dt Vencto.",
                    "data": "DT_VENCTO"
                },
                {
                    "title": "Valor AP.",
                    "data": "VALOR"
                },
                {
                    "title": "Saldo",
                    "data": "SALDO"
                },
                {
                    "title": "Empresa",
                    "data": "EMPRESA",
                },
                {
                    "title": "Bloqueio",
                    "data": "BLOQUEIO"
                },
                {
                    "title": "Docto.",
                    "data": "DOCTO"
                }
            ]
        });

        $('#tabelaBaixasEncontroContas').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            order: false,
            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [3],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Tipo",
                    "data": "TIPO",
                },
                {
                    "title": "Número",
                    "data": "NUMERO"
                },
                {
                    "title": "CodCli",
                    "data": "CODCLI"
                },
                {
                    "title": "Valor",
                    "data": "VALOR"
                },
                {
                    "title": "Obs.:",
                    "data": "OBS"
                }
            ]
        });

        $('#tabelaChequesAbaPagar').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            "autoWidth": true,
            "columnDefs": [
                // {
                //     targets: [8, 9],
                //     visible: false
                // },
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkChequeAbaPagar${meta.row}" class="campoSelChequeAbaPagar cursor-pointer" nome="checkChequeAbaPagar${meta.row}">
                        <label for="checkChequeAbaPagar${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [5, 6],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [7, 9, 16, 17],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Sel",
                    "data": "SEL"
                },
                {
                    "title": "Número",
                    "data": "NUM_AP"
                },
                {
                    "title": "Banco",
                    "data": "BANCO"
                },
                {
                    "title": "Conta",
                    "data": "CONTA"
                },
                {
                    "title": "Agência",
                    "data": "AGENCIA"
                },
                {
                    "title": "Emissão",
                    "data": "DT_EMISSAO"
                },
                {
                    "title": "Vencimento",
                    "data": "DT_VENCTO"
                },
                {
                    "title": "Valor",
                    "data": "VAL_CHEQUE"
                },
                {
                    "title": "Emissor",
                    "data": "EMISSOR"
                },
                {
                    "title": "Val. Pago",
                    "data": "VAL_PAGO"
                },
                {
                    "title": "CodFor",
                    "data": "CODFOR"
                },
                {
                    "title": "CodCli",
                    "data": "CODCLI"
                },
                {
                    "title": "Duplicata",
                    "data": "DUPLICATA"
                },
                {
                    "title": "Empresa",
                    "data": "EMPRESA"
                },
                {
                    "title": "Obs",
                    "data": "OBS"
                },
                {
                    "title": "Barra CH.",
                    "data": "BARRA_CH"
                },
                {
                    "title": "Saldo",
                    "data": "SALDO"
                },
                {
                    "title": "Selecionado",
                    "data": "SELECIONADO"
                },
                {
                    "title": "Status",
                    "data": "STATUS"
                },
                {
                    "title": "Nome Cliente",
                    "data": "NOME_CLI"
                },
                {
                    "title": "Fantasia",
                    "data": "FANTASIA"
                },
                {
                    "title": "Classe",
                    "data": "CLASSE"
                },
                {
                    "title": "Num Processo",
                    "data": "NUM_PROCESSO"
                }
            ]
        });

        $('#tabelaPagarAbaPagar').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            "autoWidth": true,
            "columnDefs": [
                {
                    targets: [0],
                    render(data, type, row, meta) {
                        return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="checkPagtoAbaPagar${meta.row}" class="campoSelPagtoAbaPagar" nome="checkPagtoAbaPagar${meta.row}">
                        <label for="checkPagtoAbaPagar${meta.row}"></label>
                      </div>`
                    }
                },
                {
                    type: 'date-br',
                    targets: [4],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [5, 6, 8, 9],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Sel",
                    "data": "SEL",
                },
                {
                    "title": "Número AP.",
                    "data": "NUM_AP"
                },
                {
                    "title": "CodCre",
                    "data": "CODCRE"
                },
                {
                    "title": "Nome",
                    "data": "NOME"
                },
                {
                    "title": "Dt Vencto.",
                    "data": "DT_VEN"
                },
                {
                    "title": "Valor AP.",
                    "data": "VALOR"
                },
                {
                    "title": "Saldo",
                    "data": "SALDO"
                },
                {
                    "title": "Empresa",
                    "data": "EMP",
                },
                {
                    "title": "Nota",
                    "data": "NOTA_FISCAL"
                },
                {
                    "title": "Saldo Orig.",
                    "data": "SALDO"
                },
                {
                    "title": "Saldo Manip.",
                    "data": "SALDO"
                },
                {
                    "title": "Status",
                    "data": "STATUS"
                },
                {
                    "title": "Classe",
                    "data": "CLASSE"
                }
            ]
        });

        $('#tabelaBaixasPagtoCheque').DataTable({
            destroy: true,
            lengthChange: false,
            serverside: false,
            searching: false,
            pageLength: 8,
            order: false,
            "autoWidth": true,
            columnDefs: [
                // {
                //     targets: [8, 9],
                //     visible: false
                // },
                {
                    targets: [3],
                    render(data) {
                        return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    },
                    "className": 'pr-4 text-right'
                }
            ],
            columns: [
                {
                    "title": "Tipo",
                    "data": "TIPO"
                },
                {
                    "title": "Número",
                    "data": "NUMERO"
                },
                {
                    "title": "CodCli",
                    "data": "CODCLI"
                },
                {
                    "title": "Valor",
                    "data": "VALOR"
                },
                {
                    "title": "Seq",
                    "data": "SEQ"
                },
                {
                    "title": "Número Rec.",
                    "data": "NUMERO_REC"
                },
                {
                    "title": "Obs",
                    "data": "OBS"
                },
                {
                    "title": "CodCli",
                    "data": "CODCLI"
                },
                {
                    "title": "Empresa",
                    "data": "EMPRESA"
                },
            ]
        });

    };

    function ativaDesativaTabs(tabAtivada) {
        const listaTabs = $("#divTabs .abaLink").toArray();

        listaTabs.forEach(elemento => {
            const idDiv = $(elemento).attr("aria-controls");
            if (elemento.id != tabAtivada) {
                $(`#${idDiv}`).addClass("d-none");
            } else {
                $(`#${idDiv}`).removeClass("d-none");
            }
        })
    };

    criaPesquisasCheque();
    criaPesquisasReceber();
    criaPesquisasEncontroContas();
    criaPesquisasChequeAbaPagar();
    criaPesquisasPagtoAbaPagar();
    criaDataTables();

    async function consultaChequeComReceber() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/encontrocontas/v1/buscachequereceber?';
            const filtros = await retornaFiltrosCheque() + '&' + await retornaFiltrosReceber();
            const response = await requisicao('GET', url, filtros, '', 360000);
            const jsonStr = await response.json();
            let rowsTableCheque = [];
            for (row in jsonStr) {
                let r = [];
                r.push(jsonStr[row].SEL);
                r.push(jsonStr[row].NUMERO_CH);
                r.push(jsonStr[row].BANCO_CH);
                r.push(jsonStr[row].CONTA_CH);
                r.push(jsonStr[row].AGENCIA_CH);
                r.push(jsonStr[row].DT_EMISSAO);
                r.push(jsonStr[row].DT_VENCTO);
                r.push(jsonStr[row].VALOR2);
                r.push(jsonStr[row].EMISSOR_CH);
                r.push(0);
                r.push('');
                r.push(jsonStr[row].CODCLI);
                r.push(jsonStr[row].NUMERO);
                r.push(jsonStr[row].EMP);
                r.push(jsonStr[row].OBS);
                r.push(jsonStr[row].BARRA_CH);
                r.push(jsonStr[row].SALDO);
                r.push('');
                r.push(jsonStr[row].STATUS);
                r.push(jsonStr[row].NOME);
                r.push(jsonStr[row].FANTASIA);
                r.push(jsonStr[row].FATURA);
                rowsTableCheque.push(r);
            };
            $('#tabelaCheques').DataTable().rows.add(rowsTableCheque).draw(false);
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function consultaReceber() {
        $.LoadingOverlay('show');
        try {
            const url = '/sisplan/encontrocontas/v1/buscareceber?';
            const filtros = await retornaFiltrosCheque() + '&' + await retornaFiltrosReceber();
            const response = await requisicao('GET', url, filtros, '', 360000);
            const jsonStr = await response.json();
            let qtdeDupsSelecionadas = 0;
            let valorDupsSelecionadas = 0;
            let rowsTableReceber = [];
            for (row in jsonStr) {
                let r = [];
                if (jsonStr[row].SEL == 'S') {
                    qtdeDupsSelecionadas++
                    valorDupsSelecionadas = valorDupsSelecionadas + parseFloat(jsonStr[row].VALOR2);
                };
                r.push(jsonStr[row].SEL);
                r.push(jsonStr[row].NUMERO);
                r.push(jsonStr[row].CODCLI);
                r.push(jsonStr[row].NOME_CLI);
                r.push(jsonStr[row].DT_EMISSAO);
                r.push(jsonStr[row].DT_VENCTO);
                r.push(jsonStr[row].VALOR2);
                r.push(jsonStr[row].VAL_DEV);
                r.push(jsonStr[row].DESCONTO);
                r.push(jsonStr[row].JUROS);
                r.push(jsonStr[row].VALOR_PAGO);
                r.push(jsonStr[row].SALDO);
                r.push(jsonStr[row].EMP);
                r.push('');
                r.push(jsonStr[row].FATURA);
                r.push(jsonStr[row].STATUS);
                r.push(jsonStr[row].OBS);
                r.push(jsonStr[row].COM2);
                rowsTableReceber.push(r);
            };
            $('#tabelaReceber').DataTable().rows.add(rowsTableReceber).draw(false);
            // $('#txtDupSelecionadaRec').val(parseInt(qtdeDupsSelecionadas).toLocaleString('pt-BR', { maximumFractionDigits: 2 }));
            // $('#txtValorSelecionadoRec').val(parseFloat(valorDupsSelecionadas).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function lancarBaixasReceberCheque() {
        $.LoadingOverlay('show');
        try {
            $('#tabelaBaixasRecCheque').DataTable().clear().draw();
            const totValCheque = parseFloat($('#txtValorSelecionadoCh').val().trim().replace(/\./g, '').replace(',', '.'));
            const totValReceber = parseFloat($('#txtValorSelecionadoRec').val().trim().replace(/\./g, '').replace(',', '.'));
            const totQtdeCheque = $('#txtChequeSelecionadosCh').val();
            const totSaldoReceber = parseFloat((totValCheque - totValReceber) < 0 ? 0 : (totValCheque - totValReceber)).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            $('#txtValorDuplicatasRec').val(parseFloat(totValReceber).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtValorAcumuladoRec').val(parseFloat(totValCheque).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtQtdeChequesRec').val(totQtdeCheque);
            $('#txtSaldoReceberRec').val(totSaldoReceber);
            if ((totValCheque - totValReceber) > 0) {
                await msgAguardaConfirmacao(`Cheque ainda contém ${totSaldoReceber} de saldo!`, async () => { await calculaLancamentoReceber() }, () => { }, false, true, 'Ok');
            } else {
                await calculaLancamentoReceber();
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function lancarBaixasPagtoCheque() {
        $.LoadingOverlay('show');
        try {
            $('#tabelaBaixasPagtoCheque').DataTable().clear().draw();
            const totValCheques = parseFloat($('#txtValorSelecionadoChAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            const totValSel = parseFloat($('#txtValorSelecionadoPagtoAbaPagar').val().trim().replace(/\./g, '').replace(',', '.'));
            const saldoSel = totValSel - totValCheques;
            const saldoCheque = totValCheques - totValSel;
            $('#txtValorDupSelecionadasAbaPagar').val(totValCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtValorAcumuladoPagtoAbaPagar').val(totValCheques.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtSaldoSelecionadoAbaPagar').val(saldoSel.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $('#txtQtdeChequesPagtoAbaPagar').val(chequePagarList.length);
            $('#txtSaldoChequeAbaPagar').val(saldoCheque <= 0 ? 0 : saldoCheque.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            await calculaLancamentoPagar();
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function calculaLancamentoReceber() {
        $.LoadingOverlay('show');
        $('#tabelaBaixasRecCheque').DataTable().clear().draw(false);
        try {
            let listaNova = [];
            let excesso = 0;

            $.each(cheqList, function (i, cheq) {
                let somaRec = 0;
                let recIndex = 0;
                let podeContinuar = false;

                for (rec in recList) {
                    if (recList[rec].SALDO > 0) {
                        podeContinuar = true;
                        break;
                    }
                };

                if (!podeContinuar) {
                    return;
                };

                cheq.OBS = recList[recIndex].NUMERO;

                listaNova.push(cheq);

                while (somaRec < cheq.SALDO) {
                    if (!recList[recIndex]) {
                        break;
                    };

                    if (excesso > 0) {
                        let rec = {};

                        if (listaNova[listaNova.length - 1].TIPO == 'CHEQ') {
                            rec = $.extend(true, {}, listaNova[listaNova.length - 2]);
                        } else {
                            rec = $.extend(true, {}, listaNova[listaNova.length - 1]);
                        };

                        listaNova.push(rec);

                        if (listaNova[listaNova.length - 1].SALDO > 0) {
                            let recNovo = listaNova[listaNova.length - 1];
                            somaRec += recNovo.SALDO;
                            recNovo.VALOR_UTILIZADO = recNovo.SALDO;
                            recNovo.SALDO = 0;
                            recNovo.OBS = cheq.NUMERO;
                            recList[recIndex].SALDO = 0;
                            recNovo.NR_CHEQUE_UTILIZADO = cheq.NUMERO;
                        };

                        excesso = 0;
                    } else if (recList[recIndex].SALDO > 0) {
                        let rec = $.extend(true, {}, recList[recIndex]);
                        somaRec += rec.SALDO;
                        rec.VALOR_UTILIZADO = rec.SALDO;
                        rec.SALDO = 0;
                        rec.NR_CHEQUE_UTILIZADO = cheq.NUMERO;
                        rec.OBS = cheq.NUMERO;
                        recList[recIndex].SALDO = 0;
                        listaNova.push(rec);
                    };

                    if (somaRec > cheq.SALDO) {
                        excesso = somaRec - cheq.SALDO;
                        listaNova[listaNova.length - 1].SALDO = excesso;
                        recList[recIndex].SALDO = excesso;
                        listaNova[listaNova.length - 1].VALOR_UTILIZADO -= excesso;
                        somaRec -= excesso;
                    };

                    recIndex++;
                };
            });

            for (element in listaNova) {
                const tipo = listaNova[element].TIPO;
                const numero = listaNova[element].NUMERO;
                const codcli = listaNova[element].CODCLI;
                const valor = listaNova[element].TIPO == 'CHEQ' ? listaNova[element].SALDO : listaNova[element].VALOR_UTILIZADO;
                seq++;
                const numeroRec = listaNova[element].TIPO == 'CHEQ' ? listaNova[element].NUMERO : listaNova[element].NR_CHEQUE_UTILIZADO;
                const usouDev = 'N';
                const obs = listaNova[element].OBS;
                const dataVencto = listaNova[element].VENCTO_CHEQUE;
                const emp = listaNova[element].EMPRESA
                $('#tabelaBaixasRecCheque').DataTable().row.add([tipo, numero, codcli, parseFloat(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }), seq, numeroRec, obs, usouDev, dataVencto, emp]).draw(false);
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function calculaLancamentoReceberEncontroContas() {
        // $.LoadingOverlay('show');
        tbLancarList = [];
        $('#tabelaBaixasEncontroContas').DataTable().clear().draw(false);
        let iSequencia = 1;

        for (let rec of recEncontroContasList) {
            let vSaldoRec = rec.SALDO;

            for (let pag of pagarEncontroContasList) {
                if (vSaldoRec <= 0 || pag.SALDO <= 0) continue;

                const saldoRecArred = Math.round(vSaldoRec * 100);
                const saldoPagArred = Math.round(pag.SALDO * 100);

                if (saldoRecArred > saldoPagArred) {
                    tbLancarList.push({
                        TIPO: 'REC',
                        NUMERO: rec.NUMERO,
                        CODCLI: rec.CODCLI,
                        VALOR: pag.SALDO,
                        NUMREC: rec.NUMERO,
                        SEQ: iSequencia,
                        OBS: pag.NUM_AP,
                        BLOQUEIO: '',
                        DT_EMISSAO: rec.DT_EMISSAO,
                        LANCTO: '',
                        VALOR_DUP: rec.VALOR2,
                        PEDIDO: rec.PEDIDO,
                        FATURA: rec.FATURA
                    });

                    tbLancarList.push({
                        TIPO: 'PAG',
                        NUMERO: pag.NUM_AP,
                        CODCLI: pag.CODCRE,
                        VALOR: pag.SALDO,
                        NUMREC: rec.NUMERO,
                        SEQ: iSequencia,
                        OBS: rec.NUMERO,
                        BLOQUEIO: pag.BLOQUEIO,
                        DT_EMISSAO: pag.DT_EMISSAO,
                        LANCTO: '',
                        VALOR_DUP: pag.VALOR,
                        PEDIDO: '',
                        FATURA: ''
                    });

                    vSaldoRec -= pag.SALDO;
                    rec.SALDO -= pag.SALDO;
                    rec.SELECIONADO = (rec.SELECIONADO || 0) + pag.SALDO;

                    pag.SELECIONADO = (pag.SELECIONADO || 0) + pag.SALDO;
                    pag.SALDO = 0;
                } else {
                    tbLancarList.push({
                        TIPO: 'REC',
                        NUMERO: rec.NUMERO,
                        CODCLI: rec.CODCLI,
                        VALOR: vSaldoRec,
                        NUMREC: rec.NUMERO,
                        SEQ: iSequencia,
                        OBS: pag.NUM_AP,
                        BLOQUEIO: '',
                        DT_EMISSAO: rec.DT_EMISSAO,
                        LANCTO: '',
                        VALOR_DUP: rec.VALOR2,
                        PEDIDO: rec.PEDIDO,
                        FATURA: rec.FATURA
                    });

                    tbLancarList.push({
                        TIPO: 'PAG',
                        NUMERO: pag.NUM_AP,
                        CODCLI: pag.CODCRE,
                        VALOR: vSaldoRec,
                        NUMREC: rec.NUMERO,
                        SEQ: iSequencia,
                        OBS: rec.NUMERO,
                        BLOQUEIO: pag.BLOQUEIO,
                        DT_EMISSAO: pag.DT_EMISSAO,
                        LANCTO: '',
                        VALOR_DUP: pag.VALOR,
                        PEDIDO: '',
                        FATURA: ''
                    });

                    pag.SELECIONADO = (pag.SELECIONADO || 0) + vSaldoRec;
                    pag.SALDO -= vSaldoRec;

                    rec.SALDO -= vSaldoRec;
                    rec.SELECIONADO = (rec.SELECIONADO || 0) + vSaldoRec;

                    vSaldoRec = 0;
                }

                iSequencia++;
            }
        }

        $('#tabelaBaixasEncontroContas').DataTable().rows.add(tbLancarList).draw(false);
    };

    async function calculaLancamentoPagar() {
        $.LoadingOverlay('show');
        $('#baixasPagtoCheque').DataTable().clear().draw(false);
        try {
            tbLancarPagarList = [];
            let excesso = 0;

            $.each(chequePagarList, function (i, chequePagar) {
                let somaPagto = 0;
                let pagtoIndex = 0;
                let podeContinuar = false;

                for (p in pagtoPagarList) {
                    if (pagtoPagarList[p].SALDO > 0) {
                        podeContinuar = true;
                        break;
                    }
                };

                if (!podeContinuar) {
                    return;
                };

                chequePagar.OBS = pagtoPagarList[pagtoIndex].NUM_AP;

                tbLancarPagarList.push(chequePagar);

                while (somaPagto < chequePagar.SALDO) {
                    if (!pagtoPagarList[pagtoIndex]) {
                        break;
                    };

                    if (excesso > 0) {
                        let pagto = {};

                        if (tbLancarPagarList[tbLancarPagarList.length - 1].TIPO == 'CHEQ') {
                            pagto = $.extend(true, {}, tbLancarPagarList[tbLancarPagarList.length - 2]);
                        } else {
                            pagto = $.extend(true, {}, tbLancarPagarList[tbLancarPagarList.length - 1]);
                        };

                        tbLancarPagarList.push(pagto);

                        if (tbLancarPagarList[tbLancarPagarList.length - 1].SALDO > 0) {
                            let pagtoNovo = tbLancarPagarList[tbLancarPagarList.length - 1];
                            somaPagto += pagtoNovo.SALDO;
                            pagtoNovo.VALOR_UTILIZADO = pagtoNovo.SALDO;
                            pagtoNovo.SALDO = 0;
                            pagtoNovo.OBS = chequePagar.DUPLICATA;
                            pagtoPagarList[pagtoIndex].SALDO = 0;
                            pagtoNovo.NR_CHEQUE_UTILIZADO = chequePagar.DUPLICATA;
                        };

                        excesso = 0;
                    } else if (pagtoPagarList[pagtoIndex].SALDO > 0) {
                        let pagto = $.extend(true, {}, pagtoPagarList[pagtoIndex]);
                        somaPagto += pagto.SALDO;
                        pagto.VALOR_UTILIZADO = pagto.SALDO;
                        pagto.SALDO = 0;
                        pagto.NR_CHEQUE_UTILIZADO = chequePagar.DUPLICATA;
                        pagto.OBS = chequePagar.DUPLICATA;
                        pagtoPagarList[pagtoIndex].SALDO = 0;
                        tbLancarPagarList.push(pagto);
                    };

                    if (somaPagto > chequePagar.SALDO) {
                        excesso = somaPagto - chequePagar.SALDO;
                        tbLancarPagarList[tbLancarPagarList.length - 1].SALDO = excesso;
                        pagtoPagarList[pagtoIndex].SALDO = excesso;
                        tbLancarPagarList[tbLancarPagarList.length - 1].VALOR_UTILIZADO -= excesso;
                        somaPagto -= excesso;
                    };

                    pagtoIndex++;
                };
            });

            listaTratadaGravacao = [];

            for (x in tbLancarPagarList) {
                let sTipo = 'CHE';

                if ($('#cbBuscaAntecipacaoAbaPagar').is(':checked')) {
                    sTipo = 'ANT';
                }

                if ($('#cbBuscaDevAntecReceberNoGridSuperior').is(':checked')) {
                    sTipo = 'DEV';
                }

                const l = {
                    "TIPO": tbLancarPagarList[x].TIPO == 'PAG' ? 'PAG' : sTipo,
                    "NUMERO": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].NUM_AP : tbLancarPagarList[x].DUPLICATA,
                    "CODCLI": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].CODCRE : tbLancarPagarList[x].CODCLI,
                    "VALOR": tbLancarPagarList[x].TIPO == 'CHEQ' ? tbLancarPagarList[x].SALDO : tbLancarPagarList[x].VALOR_UTILIZADO,
                    "SEQ": x,
                    "NUMERO_REC": tbLancarPagarList[x].TIPO == 'CHEQ' ? tbLancarPagarList[x].NUM_AP : tbLancarPagarList[x].NR_CHEQUE_UTILIZADO,
                    "OBS": tbLancarPagarList[x].OBS,
                    "CODCLI": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].CODCRE : tbLancarPagarList[x].CODCLI,
                    "EMPRESA": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].EMP : tbLancarPagarList[x].EMPRESA,
                    "VENCTO_CHEQUE": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].DT_VEN : tbLancarPagarList[x].DT_VENCTO,
                    "DT_EMISSAO": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].DT_EMI : tbLancarPagarList[x].DT_EMISSAO,
                    "BLOQUEIO": tbLancarPagarList[x].TIPO == 'PAG' ? tbLancarPagarList[x].BLOQUEIO : "N",
                    "STATUS": tbLancarPagarList[x].STATUS
                }
                $('#tabelaBaixasPagtoCheque').DataTable()
                    .row
                    .add(l)
                    .draw(false);
                listaTratadaGravacao.push(l);
            }
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaDadosEmissao() {
        $.LoadingOverlay('show');
        try {
            const tbChequeP = [];
            let continuaGravaDados = true;

            if ((!$('#cbBuscaAntecipacao').is(':checked')) && (!$('#cbBuscaDevolucao').is(':checked')) && $('#txtDoctoR').val() == '') {
                $('#txtDoctoR').val(await RetornaProximo('DOCTO', 'CONTACOR', 'DOCTO', 6));
            };

            if (!$('#cbBaixarCheques').is(':checked')) {
                continuaGravaDados = await msgAguardaConfirmacao('Flag Baixar Cheques não está marcado. Sistema não irá fazer as baixas dos cheques selecionados. Somente as duplicatas. Continuar mesmo assim?',
                    () => { return true },
                    () => { return false }
                )
            };

            if (!continuaGravaDados) {
                return;
            }

            for (cheque in cheqList) {
                cheq = {
                    "NUMERO": cheqList[cheque].NUMERO,
                    "VALOR": cheqList[cheque].VALOR,
                };
                tbChequeP.push(cheq);
            };

            const tbRecCH = [];

            for (receber in recList) {
                rec = {
                    "NUMERO": recList[receber].NUMERO,
                    "CODCLI": recList[receber].CODCLI,
                    "EMPRESA": recList[receber].EMPRESA,
                    "COM2": recList[receber].COM2,
                    "VALOR": recList[receber].VALOR,
                    "JUROS": recList[receber].JUROS,
                };
                tbRecCH.push(rec);
            }

            const tbLancar = [];
            const tableLancar = $('#tabelaBaixasRecCheque').DataTable().data().toArray();

            for (lanc in tableLancar) {
                titulo = {
                    "TIPO": tableLancar[lanc][0],
                    "NUMERO": tableLancar[lanc][1],
                    "CODCLI": tableLancar[lanc][2],
                    "VALOR": parseFloat(tableLancar[lanc][3].trim().replace(/\./g, '').replace(',', '.')),
                    "SEQ": tableLancar[lanc][4],
                    "NUM_REC": tableLancar[lanc][5],
                    "OBS": tableLancar[lanc][6],
                    "USOU_DEV": tableLancar[lanc][7],
                    "LANCAMENTO": '',
                    "VENCTO_CHEQUE": tableLancar[lanc][8] + ' 00:00:00.000',
                    "EMPRESA": tableLancar[lanc][9],
                    "COM": 'N'
                };
                tbLancar.push(titulo);
            };

            const url = '/sisplan/encontrocontas/v1/gravadados?';
            const params = await retornaFiltrosModal();
            const response = await requisicao('POST', url, params, `JSON_TBLANCAR=${encodeURIComponent(JSON.stringify(tbLancar))}&JSON_TBRECCH=${encodeURIComponent(JSON.stringify(tbRecCH))}&JSON_TBCHEQUEP=${encodeURIComponent(JSON.stringify(tbChequeP))}`, 3200000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            };

            await criaMensagemSucesso(await response.text(), () => { window.location.reload() });
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaDadosEmissaoEncontroContas() {
        $.LoadingOverlay('show');
        try {
            const classeGerBaixasRec = pegaChave('#txtClasseGerBaixaReceberEncontroContas');
            const historicoBaixasRec = pegaChave('#txtHistoricoBaixaReceberEncontroContas');
            const classeGerBaixasPag = pegaChave('#txtClasseGerBaixaPagarEncontroContas');
            const historicoBaixasPag = pegaChave('#txtHistoricoBaixaPagarEncontroContas');
            const dtPagtoBaixas = $('#txtDtPagtoEncontroContas').val();
            const dtContBaixas = $('#txtDtContabilizacaoEncontroContas').val();

            if ((dtContBaixas == '') || (dtPagtoBaixas == '')) {
                msgAlerta('Data de pagamento ou de contabilização está vazia. Não foi possível continuar. Verifique e tente novamente.');
                return
            }

            const url = '/sisplan/encontrocontas/v1/gravadadosencontrocontas?';
            const response = await requisicao('POST', url, '', `JSON_LANCAMENTO=${encodeURIComponent(JSON.stringify(tbLancarList))}&CLASSE_GER_BAIXA_RECEBER=${classeGerBaixasRec}&HISTORICO_BAIXA_RECEBER=${historicoBaixasRec}&CLASSE_GER_BAIXA_PAGAR=${classeGerBaixasPag}&HISTORICO_BAIXA_PAGAR=${historicoBaixasPag}&DT_PAGTO_ENCONTRO_CONTAS_BAIXA=${dtPagtoBaixas}&DT_CONT_ENCONTRO_CONTAS_BAIXA=${dtContBaixas}`, 3200000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            };

            await criaMensagemSucesso('Processo concluído com sucesso!', () => { window.location.reload() });
        } catch (error) {
            console.error(error);
            msgAlerta('Ocorreu um erro ao fazer o encontro de contas. Por favor, verifique.');
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaChequexPagar() {
        $.LoadingOverlay('show');
        try {
            const dtPagtoBaixasPagar = $('#txtDtPagtoPagar').val();
            const dtContBaixasPagar = $('#txtDtContabilizacaoPagar').val();

            if ((dtContBaixasPagar == '') || (dtPagtoBaixasPagar == '')) {
                msgAlerta('Data de pagamento ou de contabilização está vazia. Não foi possível continuar. Verifique e tente novamente.');
                return
            }
            const tb = [];

            for (a in listaTratadaGravacao) {
                const b = {
                    "TIPO": listaTratadaGravacao[a].TIPO == 'PAG' ? listaTratadaGravacao[a].STATUS : listaTratadaGravacao[a].TIPO,
                    "NUMERO": listaTratadaGravacao[a].NUMERO,
                    "LANCAMENTO": "0",
                    "SEQ": listaTratadaGravacao[a].SEQ,
                    "CODCLI": listaTratadaGravacao[a].CODCLI,
                    "VALOR": listaTratadaGravacao[a].VALOR,
                    "VENCTO_CHEQUE": listaTratadaGravacao[a].VENCTO_CHEQUE,
                    "EMPRESA": listaTratadaGravacao[a].EMPRESA,
                    "DT_EMISSAO": listaTratadaGravacao[a].DT_EMISSAO,
                    "OBS": listaTratadaGravacao[a].OBS,
                    "BLOQUEIO": listaTratadaGravacao[a].BLOQUEIO,
                    "NUMERO_REC": listaTratadaGravacao[a].NUMERO_REC,
                    "CODCRE_CHEQUE": listaTratadaGravacao[a].CODCLI,
                };

                tb.push(b);
            };

            const tp = [];

            for (c in chequePagarList) {
                const d = {
                    "NUMERO": chequePagarList[c].NUM_AP,
                    "DUPLICATA": chequePagarList[c].DUPLICATA,
                    "CODCLI": chequePagarList[c].CODCLI,
                    "NUM_AP": chequePagarList[c].NUM_AP,
                    "VALOR": chequePagarList[c].VAL_CHEQUE,
                    "VALOR_DUP": chequePagarList[c].VAL_CHEQUE
                }

                tp.push(d);
            };

            const tc = [];

            for (e in pagtoPagarList) {
                const f = {
                    "NUMERO": pagtoPagarList[e].NUM_AP,
                    "NUM_AP": pagtoPagarList[e].NUM_AP,
                    "EMPRESA": pagtoPagarList[e].EMP,
                    "CODCRE": pagtoPagarList[e].CODCRE,
                    "DT_EMISSAO": pagtoPagarList[e].DT_EMI,
                }
                tc.push(f);
            };

            const url = '/sisplan/encontrocontas/v1/gravadadoschequexpagar?';
            const response = await requisicao('POST', url, '', `JSON_TBLANCAR=${encodeURIComponent(JSON.stringify(tb))}&` +
                `JSON_TBPAGTOPAGAR=${encodeURIComponent(JSON.stringify(tc))}&` +
                `JSON_TBCHEQUEPAGAR=${encodeURIComponent(JSON.stringify(tp))}&` +
                `CONTA_PAGAR_BAIXA=${pegaChave('#txtContaP')}&` +
                `CLASSE_GER_BCH_PAG=${pegaChave('#txtClasseGerBCHPagto')}&` +
                `HISTORICO_P_BCH=${pegaChave('#txtHistoricoPBCH')}&` +
                `CLASSE_GER_PAG_BCH=${pegaChave('#txtClasseGerPagtoBCH')}&` +
                `HISTORICO_BCH_PAG=${pegaChave('#txtHistoricoBCHPagto')}&` +
                `DT_PAGTO_BAIXA_PAGAR=${$('#txtDtPagtoPagar').val()}&` +
                `DT_CONT_BAIXA_PAGAR=${$('#txtDtContabilizacaoPagar').val()}&` +
                `CB_DEV_ANTEC_REC_PAGAR=${$('#cbBuscaDevAntecReceberNoGridSuperior').is(':checked')}&` +
                `ANTECIPACAO_PAGAR=${$('#cbBuscaAntecipacaoAbaPagar').is(':checked')}&` +
                `DOCTO_P=${$('#txtDoctoP').val()}&` +
                `MOEDA_P=${pegaChave('#txtMoedaP')}&` +
                `BANCO_P=${pegaChave('#txtBancoP')}&` +
                `OBS_P=${$('#txtObsP').val()}`,
                3200000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                const jsonStr = await response.json();
                msgAlerta(jsonStr.mensagem);
                return;
            };

            await criaMensagemSucesso('Processo concluído com sucesso!', () => { window.location.reload() });
        } catch (error) {
            console.error(error);
            msgAlerta('Ocorreu um erro ao fazer a baixa do cheque x pagar. Por favor, verifique.');
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    async function retornaFiltrosCheque() {
        const dtVenctoDe = $('#txtDtVenctoDeCh').val();
        const dtVenctoAte = $('#txtDtVenctoAteCh').val();
        const emissor = pegaChave('#txtEmissorCh');
        const pedido = $('#txtPedidoCh').val();
        const cliente = pegaChave('#txtClienteCh');
        const represen = await formataListas($('#txtRepresentanteCh').val().toString());
        const historico = pegaChave('#txtHistoricoCh');
        const situacao = await formataListas($('#txtSituacaoCh').val().toString());
        const classeGer = pegaChave('#txtClasseGerCh');
        const buscaCheque = $('#txtBuscaChequeCMC').val();

        return `DT_VENCTO_DE_CH=${dtVenctoDe}` +
            `&DT_VENCTO_ATE_CH=${dtVenctoAte}` +
            `&EMISSOR_CH=${emissor}` +
            `&PEDIDO_CH=${pedido}` +
            `&CLIENTE_CH=${cliente}` +
            `&REPRESEN_CH=${represen}` +
            `&HISTORICO_CH=${historico}` +
            `&SITUACAO_CH=${situacao}` +
            `&CLASSEGER_CH=${classeGer}` +
            `&BUSCACHEQUE_CH=${buscaCheque}`;
    };

    async function retornaFiltrosReceber() {
        const dtVenctoDe = $('#txtDtVenctoDeRec').val();
        const dtVenctoAte = $('#txtDtVenctoAteRec').val();
        const dtEmissaoDe = $('#txtDtEmissaoDeRec').val();
        const dtEmissaoAte = $('#txtDtEmissaoAteRec').val();
        const numero = await formataListas($('#txtNumeroRec').val().toString());
        const cliente = await formataListas($('#txtClienteRec').val().toString());
        const pedido = $('#txtPedidoRec').val();
        const fatura = await formataListas($('#txtFaturaRec').val().toString());
        const situacao = await formataListas($('#txtSituacaoRec').val().toString());
        const representante = await formataListas($('#txtRepresenRec').val().toString());
        const classeGer = await formataListas($('#txtClasseGerRec').val().toString());
        const buscaAntecipacao = $('#cbBuscaAntecipacao').is(':checked');
        const buscaDevolucao = $('#cbBuscaDevolucao').is(':checked');
        const buscaChequeDev = $('#cbBuscaChequeDev').is(':checked');
        const baixarCheques = $('#cbBaixarCheques').is(':checked');
        const naoLancaValorContaCor = $('#cbNaoLancaContaCor').is(':checked');
        const buscaAntecipacaoGridInferior = $('#cbBuscaAntecipacaoGridInferior').is(':checked');

        return `DT_VENCTO_DE_RECEBER=${dtVenctoDe}` +
            `&DT_VENCTO_ATE_RECEBER=${dtVenctoAte}` +
            `&DT_EMISSAO_DE_RECEBER=${dtEmissaoDe}` +
            `&DT_EMISSAO_ATE_RECEBER=${dtEmissaoAte}` +
            `&NUMERO_RECEBER=${numero}` +
            `&CLIENTE_RECEBER=${cliente}` +
            `&PEDIDO_RECEBER=${pedido}` +
            `&FATURA_RECEBER=${fatura}` +
            `&SITUACAO_RECEBER=${situacao}` +
            `&REPRESENTANTE_RECEBER=${representante}` +
            `&CLASSEGER_RECEBER=${classeGer}` +
            `&BUSCA_ANTECIPACAO_RECEBER=${buscaAntecipacao}` +
            `&BUSCA_DEVOLUCAO_RECEBER=${buscaDevolucao}` +
            `&BUSCA_CHEQUE_DEVOLUCAO_RECEBER=${buscaChequeDev}` +
            `&BAIXA_CHEQUES_RECEBER=${baixarCheques}` +
            `&NAO_LANCA_VALOR_CONTA_CC=${naoLancaValorContaCor}` +
            `&BUSCA_ATENCIPACAO_GRID_INFERIOR_RECEBER=${buscaAntecipacaoGridInferior}`
    };

    async function retornaFiltrosModal() {
        const dtPagto = formataDataBonita($('#txtDtPagto').val()) + ' 00:00:00.000'
        const dtCont = formataDataBonita($('#txtDtContabilizacao').val()) + ' 00:00:00.000'
        const contaR = pegaChave('#txtContaR');
        const moedaR = pegaChave('#txtMoedaR');
        const bancoR = pegaChave('#txtBancoR');
        const doctoR = $('#txtDoctoR').val();
        const obsR = $('#txtObsR').val();
        const classeGerRecBCH = pegaChave('#txtClasseGerRecBCH');
        const historicoRBCH = pegaChave('#txtHistoricoRBCH');
        const classeGerBCHRec = pegaChave('#txtClasseGerBCHRec');
        const historicoBCHRec = pegaChave('#txtHistoricoBCHRec');
        const buscaAntecipacao = $('#cbBuscaAntecipacao').is(':checked') ? 'S' : 'N';
        const buscaDev = $('#cbBuscaDevolucao').is(':checked') ? 'S' : 'N';
        const baixaChequeRec = $('#cbBaixarCheques').is(':checked') ? 'S' : 'N';
        const naoLancaCC = $('#cbNaoLancaContaCor').is(':checked') ? 'S' : 'N';

        return `CONTA=${contaR}` +
            `&DT_CONT=${dtCont}` +
            `&CLASSE_GER_BCH_REC=${classeGerBCHRec}` +
            `&CLASSE_GER_REC_BCH=${classeGerRecBCH}` +
            `&HISTORICO_R_BCH=${historicoRBCH}` +
            `&HISTORICO_BCH_REC=${historicoBCHRec}` +
            `&CB_BUSCA_ANTECIPACAO=${buscaAntecipacao}` +
            `&CB_BUSCA_DEV=${buscaDev}` +
            `&MOEDA=${moedaR}` +
            `&DOCTO_R=${doctoR}` +
            `&OBS=${obsR}` +
            `&CB_BAIXAR_CHEQUE_REC=${baixaChequeRec}` +
            `&DT_PAGTO=${dtPagto}` +
            `&BANCO=${bancoR}` +
            `&CB_NAO_LANCA_CONTA_CORRENTE=${naoLancaCC}`;
    };

    async function pesquisaReceberEncontroContas() {
        $.LoadingOverlay('show');
        try {
            const clientesFornecedorEncontroContas = await formataListas($('#txtClienteFornecedorEncontroContas').val().toString());
            const empresasReceberEncontroContas = await formataListas($('#txtEmpresaReceberEncontroContas').val().toString());
            const moedaReceberEncontroContas = $('#txtMoedaReceberEncontroContas').val();
            const empresasPagarEncontroContas = await formataListas($('#txtEmpresaPagarEncontroContas').val().toString());

            const url = '/sisplan/encontrocontas/v1/buscareceberencontrocontas?';
            const response = await requisicao('GET', url, `&CLIENTE_FORNECEDOR=${clientesFornecedorEncontroContas}&MOEDA_EC=${moedaReceberEncontroContas}&EMPRESA_RECEBER=${empresasReceberEncontroContas}&EMPRESA_PAGAR=${empresasPagarEncontroContas}`, '', 3200000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            $('#tabelaReceberEncontroContas').DataTable().rows.add(jsonStr).draw(false);

        } catch (error) {
            console.error(error);
            msgAlerta(`Ocorreu um erro ao pesquisar informações do contas a receber. Erro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function pesquisaPagarEncontroContas() {
        $.LoadingOverlay('show');
        try {
            const clientesFornecedorEncontroContas = await formataListas($('#txtClienteFornecedorEncontroContas').val().toString());
            const empresasReceberEncontroContas = await formataListas($('#txtEmpresaReceberEncontroContas').val().toString());
            const moedaReceberEncontroContas = $('#txtMoedaReceberEncontroContas').val();
            const empresasPagarEncontroContas = await formataListas($('#txtEmpresaPagarEncontroContas').val().toString());

            const url = '/sisplan/encontrocontas/v1/buscapagarencontrocontas?';
            const response = await requisicao('GET', url, `&CLIENTE_FORNECEDOR=${clientesFornecedorEncontroContas}&MOEDA_EC=${moedaReceberEncontroContas}&EMPRESA_RECEBER=${empresasReceberEncontroContas}&EMPRESA_PAGAR=${empresasPagarEncontroContas}`, '', 3200000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            $('#tabelaPagarEncontroContas').DataTable().rows.add(jsonStr).draw(false);
        } catch (error) {
            console.error(error);
            msgAlerta(`Ocorreu um erro ao pesquisar informações do contas a pagar. Erro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function pesquisaChequesAbaPagar() {
        $.LoadingOverlay('show');
        try {
            const clienteFornecedorCheque = await formataListas($('#txtClienteChAbaPagar').val().toString());
            const emissorCheque = $('#txtEmissorChAbaPagar').val();
            const classeGerCheque = pegaChave('#txtClasseGerChAbaPagar');
            const historicoCheque = pegaChave('#txtHistoricoChAbaPagar');
            const buscaChequeCmc = $('#txtBuscaChequeCMCAbaPagar').val();
            const dtVenctoDeChPagar = $('#txtDtVenctoDeChAbaPagar').val();
            const dtVenctoAteChPagar = $('#txtDtVenctoAteChAbaPagar').val();
            const buscaDevAntecRec = $('#cbBuscaDevAntecReceberNoGridSuperior').is(':checked');
            const buscaChequeDev = $('#cbBuscaChequeDevAbaPagar').is(':checked');  
            const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

            const url = '/sisplan/encontrocontas/v1/buscachequepagar?';
            const response = await requisicao('GET', url, `&CLI_FORNECEDOR_PAGAR=${clienteFornecedorCheque}` +
                `&CLASSE_GER_CH_PAGAR=${classeGerCheque}` +
                `&HISTORICO_CH_PAGAR=${historicoCheque}` +
                `&LOCALIZA_CMC_PAGAR=${buscaChequeCmc}` +
                `&DT_VENCTO_DE_CH_PAGAR=${dtVenctoDeChPagar}` +
                `&DT_VENCTO_ATE_CH_PAGAR=${dtVenctoAteChPagar}` +
                `&EMISSOR_CH_PAGAR=${emissorCheque}` +
                `&CB_CH_DEV_PAGAR=${buscaChequeDev}` +
                `&CB_DEV_ANTEC_REC_PAGAR=${buscaDevAntecRec}` +
                `&EMP_IDS=${listaEmpIds}`,
                '',
                3200000
            );

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            $('#tabelaChequesAbaPagar').DataTable().rows.add(jsonStr).draw(false);
        } catch (error) {
            console.error(error);
            msgAlerta(`Ocorreu um erro ao pesquisar informações do contas a pagar. Erro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function pesquisaPagtoAbaPagar() {
        $.LoadingOverlay('show');
        try {
            const dtVenctoDePagar = $('#txtDtVenctoDePagtoAbaPagar').val();
            const dtVenctoAtePagar = $('#txtDtVenctoAteRecAbaPagar').val();
            const dtEmissaoDePagar = $('#txtDtEmissaoDePagtoAbaPagar').val();
            const dtEmissaoAtePagar = $('#txtDtEmissaoAtePagtoAbaPagar').val();
            const numerosPagtoPagar = await formataListas($('#txtNumeroPagtoAbaPagar').val().toString());
            const fornecedoresPagtoPagar = await formataListas($('#txtFornecedorPagtoAbaPagar').val().toString());
            const pedidoPagtoPagar = $('#txtPedidoPagtoAbaPagar').val();
            const situacaoPagtoPagar = await formataListas($('#txtSituacaoPagtoAbaPagar').val().toString());
            const classeGerencialPagtoPagar = await formataListas($('#txtClasseGerPagtoAbaPagar').val().toString());
            const historicoPagtoPagar = await formataListas($('#txtHistoricoPagtoAbaPagar').val().toString());
            const cbBuscaAntecipacao = $('#cbBuscaAntecipacaoAbaPagar').is(':checked');

            const url = '/sisplan/encontrocontas/v1/buscapagtopagar?';
            const response = await requisicao('GET', url, `&PEDIDO_PAGAR=${pedidoPagtoPagar}` +
                `&CODCRE_PAGAR=${fornecedoresPagtoPagar}` +
                `&SITUACAO_PAGAR=${situacaoPagtoPagar}` +
                `&HISTORICO_PAGAR=${historicoPagtoPagar}` +
                `&ANTECIPACAO_PAGAR=${cbBuscaAntecipacao}` +
                `&NUM_AP_PAGAR=${numerosPagtoPagar}` +
                `&CLASSE_GER_PAGAR=${classeGerencialPagtoPagar}` +
                `&DT_EMISSAO_DE_PAGTO_PAGAR=${dtEmissaoDePagar}` +
                `&DT_EMISSAO_ATE_PAGTO_PAGAR=${dtEmissaoAtePagar}` +
                `&DT_VENCTO_DE_PAGTO_PAGAR=${dtVenctoDePagar}` +
                `&DT_VENCTO_ATE_PAGTO_PAGAR=${dtVenctoAtePagar}`, '', 3200000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            $('#tabelaPagarAbaPagar').DataTable().rows.add(jsonStr).draw(false);
        } catch (error) {
            console.error(error);
            msgAlerta(`Ocorreu um erro ao pesquisar informações do contas a pagar. Erro: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };
});