$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoCadastro',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaCilindro',
                popover: {
                    title: 'Tabela Subgrupo Cor',
                    description: 'Aqui estão os dados dos cilindros cadastrados.',
                    position: 'bottom'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    componenteFiltro('cilindro', true)

    const permissaoUsuarioLogado = await permissaoAcessos("CILINDRO");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    
    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + data + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu"> ' +
          '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
          '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
          '</div>';
        return retorno;
      };

    consultaCilindro();

    $('#btnConsultar').on('click', async function () {
        await consultaCilindro(true);
        $('#modal-filtros').modal('hide');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCilindro').empty().trigger('change')
    });

    async function consultaCilindro(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            const cilindro = $('#txtCilindro').val().length <= 0 ? '' : ` AND CODIGO IN (${await formataListas($('#txtCilindro').val().toString())})`;
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CILINDRO", "camposSelect":[ "CODIGO", "DESCRICAO"],"where": ["1=1 ${cilindro}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"CILINDRO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaCilindro').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                }
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                      }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#btnNovoCadastro').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cilindro/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaCilindro').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCilindro').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CILINDRO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cilindro/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCilindro').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCilindro').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CILINDRO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cilindro/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCilindro').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCilindro").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cilindro?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});