$(document).ready(async function () {

  $('#tabEstoque').on('click', () => setTimeout(
    () => $('#tabelaEstoque')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabHistoricoCompra').on('click', () => setTimeout(
    () => $('#tabelaHistoricoCompra')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#tabHistoricoCotacao').on('click', () => setTimeout(
    () => $('#tabelaHistoricoCotacao')?.DataTable()?.columns?.adjust()?.draw(false),
    500,
  ))

  $('#modalInformacoesItem').on('hide.bs.modal', () => {
    ModalInformacoesItemCentralCompras.limparModal()
    $('#tabFornecedores').removeClass('d-none')
    $('#tabEstoque').removeClass('d-none')
    $('#tabFornecedores').tab('show')
  })

  $('#modalInformacoesItem').on('shown.bs.modal', () => {
    $('#tabelaFornecedores')?.DataTable()?.columns?.adjust()?.draw(false)
    $('#tabelaHistoricoCompra')?.DataTable()?.columns?.adjust()?.draw(false)
  })
})

window.ModalInformacoesItemCentralCompras = window.ModalInformacoesItemCentralCompras || {}

ModalInformacoesItemCentralCompras.carregarModalInformacoesItem = (codigo, cor, tamanho, tipo) => {
  if (tipo === 'S') {
    $('#tabFornecedores').addClass('d-none')
    $('#tabEstoque').addClass('d-none')
    $('#tabHistoricoCompra').tab('show')
  }
  ModalInformacoesItemCentralCompras.retornarDadosItem(codigo, cor, tamanho, tipo).then(({ capa, fornecedores, estoque, historicoCompra, historicoCotacao }) => {
    ModalInformacoesItemCentralCompras.preencherCapa(capa)
    ModalInformacoesItemCentralCompras.criarTabelaFornecedores(fornecedores || [])
    ModalInformacoesItemCentralCompras.criarTabelaEstoque(estoque || [])
    ModalInformacoesItemCentralCompras.criarTabelaHistoricoCompra(historicoCompra || [])
    ModalInformacoesItemCentralCompras.criarTabelaHistoricoCotacao(historicoCotacao || [])
    $('#modalInformacoesItem').modal('show')
  }).catch((error) => {
    console.error(error)
    msgErro('Ocorreu um erro ao buscar os dados.')
  })
}

ModalInformacoesItemCentralCompras.retornarDadosItem = async (codigo, cor, tamanho, tipo) => {
  try {
    $.LoadingOverlay('show')
    const response = await requisicao(
      'GET',
      `/sisplan/centralcompras/v1/retornarinformacoesitem?`,
      `CODIGO=${codigo}&COR=${cor}&TAMANHO=${tamanho}&TIPO=${tipo}`,
      '',
      3600000,
    )

    const json = await response.json()
    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  } finally {
    $.LoadingOverlay('hide')
  }
}

ModalInformacoesItemCentralCompras.preencherCapa = (data) => {
  if (!data) return
  insereValor('#txtItemInfo', data?.codigo, data?.descricao)
  insereValor('#txtGrupoInfo', data?.codigoGrupo, data?.descricaoGrupo)
  insereValor('#txtUnidadeInfo', data?.codigoUnidade, data?.descricaoUnidade)
  insereValor('#txtClassificacaoFiscalInfo', data?.codigoClassificacaoFiscal, data?.descricaoClassificacaoFiscal)
}

ModalInformacoesItemCentralCompras.criarTabelaFornecedores = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaFornecedores')) {
    $('#tabelaFornecedores').DataTable().destroy()
    $('#tabelaFornecedores').empty()
  }

  const columns = [
    {
      data: 'id',
      title: 'Id',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'itemAtivo',
      title: 'Item Ativo',
    },
    {
      data: 'clienteAtivo',
      title: 'Cliente Ativo',
    },
    {
      data: 'codigoCliente',
      title: 'Código Cliente',
    },
    {
      data: 'nomeCliente',
      title: 'Nome Cliente',
    },
    {
      data: 'cor1',
      title: 'Cor 1',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'codigoEntrada',
      title: 'Código Entrada',
    },
    {
      data: 'ultimaAtualizacao',
      title: 'Última Atualização',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
  ]

  $('#tabelaFornecedores').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '300px',
  })
}

ModalInformacoesItemCentralCompras.criarTabelaEstoque = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaEstoque')) {
    $('#tabelaEstoque').DataTable().destroy()
    $('#tabelaEstoque').empty()
  }

  const columns = [
    {
      data: 'tipo',
      title: 'Tipo',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
    },
  ]

  $('#tabelaEstoque').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '300px',
  })
}

ModalInformacoesItemCentralCompras.criarTabelaHistoricoCompra = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaHistoricoCompra')) {
    $('#tabelaHistoricoCompra').DataTable().destroy()
    $('#tabelaHistoricoCompra').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
    },
    {
      data: 'emissao',
      title: 'Emissão',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'entrega',
      title: 'Entrega',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`))
      },
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'quantidadeOriginal',
      title: 'Quantidade Original',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidadeBaixada',
      title: 'Quantidade Baixada',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'deposito',
      title: 'Depósito',
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'solicitacao',
      title: 'Solicitação',
    },
  ]

  $('#tabelaHistoricoCompra').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '300px',
  })
}

ModalInformacoesItemCentralCompras.criarTabelaHistoricoCotacao = (data) => {
  if ($.fn.DataTable.isDataTable('#tabelaHistoricoCotacao')) {
    $('#tabelaHistoricoCotacao').DataTable().destroy()
    $('#tabelaHistoricoCotacao').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'codigoFornecedor',
      title: 'Código Fornecedor',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'corFornecedor',
      title: 'Cor Fornecedor',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'descricaoFornecedor',
      title: 'Descrição Fornecedor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'quantidadeCotada',
      title: 'Quantidade Cotada',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'fatorConversaoFornecedor',
      title: 'Fator Conversão Fornecedor',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0.00'
        }
        return parseFloat(data).toFixed(2)
      }
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'situacao',
      title: 'Situação',
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'foneFornecedor',
      title: 'Fone Fornecedor',
    },
    {
      data: 'emailFornecedor',
      title: 'E-mail Fornecedor',
    },
  ]

  $('#tabelaHistoricoCotacao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data,
    columns,
    scrollX: true,
    scrollY: '300px',
  })
}

ModalInformacoesItemCentralCompras.limparModal = () => {
  $('#txtItemInfo').val('')
  $('#txtGrupoInfo').val('')
  $('#txtUnidadeInfo').val('')
  $('#txtClassificacaoFiscalInfo').val('')
}