$(document).ready(async function () {
  $('#modalItensParcialmenteAprovados').on('hide.bs.modal', () => ModalItensParcialmenteAprovados.limparModal())
})

window.ModalItensParcialmenteAprovados = window.ModalItensParcialmenteAprovados || {}

ModalItensParcialmenteAprovados.carregarModal = ({ itens }) => {
  itens.forEach(
    (item) => {
      let htmlCardItem = `
            <div class="containerItemParcialmenteAprovado text-normal">
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Ordem de Compra:</span>
                  <span>${item.numero}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold" style="text-wrap-mode: nowrap">Aprovadores pendentes:</span>
                  <span class="destaque-em-vermelho" style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.aprovadoresPendentes.map((aprovador) => aprovador.nome).join(', ')}</span>
                </div>
              </div>
            </div>
          `
      $('#containerItensParcialmenteAprovados').append(htmlCardItem)
    }
  )

  $('#modalItensParcialmenteAprovados').modal('show')
}

ModalItensParcialmenteAprovados.limparModal = () => $('#containerItensParcialmenteAprovados').empty()