$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código',
        description: 'Esse campo é preenchido automáticamente após realizar a gravação deste registro.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Descrição',
        description: 'Adicionamos aqui uma descrição sobre este cadastro, pode ser um nome da cidade, por exemplo.',
        position: 'top'
      }
    },
    
    {
      element: '#txtCidade',
      popover: {
        title: 'Cidade',
        description: 'Aqui adicionamos a cidade para este registro.',
        position: 'top'
      }
    },
    {
      element: '#txtEstado',
      popover: {
        title: 'Estado',
        description: 'Aqui adicionamos o estado para este registro.',
        position: 'top'
      }
    },
    {
      element: '#txtPais',
      popover: {
        title: 'País',
        description: 'Aqui adicionamos o país para este registro.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o registro.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#txtCidade').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnConsultaCidade').pesquisa('#txtCidade', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":["CODIGO", "NOME"]}`, 'Consulta Cidade', 'CADDESEMBARACO');
  $('#btnLimpaColsultaCidade').on('click', function () {
    $('#txtCidade').val('');
  });

  $('#txtEstado').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnConsultaEstado').pesquisa('#txtEstado', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":["CODIGO", "DESCRICAO"]}`, 'Consulta Cidade', 'CADDESEMBARACO');
  $('#btnLimpaColsultaEstado').on('click', function () {
    $('#txtEstado').val('');
  });
  
  $('#txtPais').autocompleta(1, `JSON={ "tabela":"CADPAIS", "camposSelect":["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnConsultaPais').pesquisa('#txtPais', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADPAIS", "camposSelect":["CODIGO", "NOME"]}`, 'Consulta País', 'CADDESEMBARACO');
  $('#btnLimpaColsultaPais').on('click', function () {
    $('#txtPais').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codigostatus = parametros[parametros.length - 1];

  if (codigostatus != "" && codigostatus != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ 
            "tabela":"DESEMBARACO", "camposSelect":[ "DESEMBARACO.CODIGO", "DESEMBARACO.DESCRICAO", "DESEMBARACO.CIDADE", "CIDADE.NOME AS CIDADE_NOME", 
                                                     "DESEMBARACO.UF", "TABUF.DESCRICAO AS UF_DESCRICAO", "DESEMBARACO.PAIS", "CADPAIS.NOME AS PAIS_NOME"],
            "leftJoin": [{
              "tabela": "CIDADE", "condicao": "CIDADE.CODIGO = DESEMBARACO.CIDADE"},{
              "tabela": "CADPAIS", "condicao": "CADPAIS.CODIGO = DESEMBARACO.PAIS"},{
              "tabela": "TABUF", "condicao": "TABUF.CODIGO = DESEMBARACO.UF"}], 

            "where": ["DESEMBARACO.CODIGO =  '${codigostatus}'"]}`, null
      
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
        $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
        insereValor("#txtCidade", jsonStr.RESULT[0][0].CIDADE, jsonStr.RESULT[0][0].CIDADE_NOME);
        insereValor("#txtEstado", jsonStr.RESULT[0][0].UF, jsonStr.RESULT[0][0].UF_DESCRICAO);
        insereValor("#txtPais", jsonStr.RESULT[0][0].PAIS, jsonStr.RESULT[0][0].PAIS_NOME);

        
      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }



  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/caddesembaraco`;
  })

  async function gravaStatus() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }if($('#txtCidade').val() == '') {
        msgAlerta('Preencha o campo Cidade');
        return;
      }
      if($('#txtEstado').val() == '') {
        msgAlerta('Preencha o campo Estado');
        return;
      }
      if($('#txtPais').val() == '') {
        msgAlerta('Preencha o campo País');
        return;
      }

      let status = {}
      
      status.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo("CODIGO", "DESEMBARACO", "CODIGO", 4) : $('#txtCodigo').val();
      status.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      status.CIDADE = pegaChave('#txtCidade');
      status.UF = pegaChave('#txtEstado');
      status.PAIS = pegaChave('#txtPais');

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/caddesembaraco?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(status)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Desembaraço: ${status.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/caddesembaraco`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    await gravaStatus()
  })
});
