$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: "O campo de código é preenchido automaticamente após gravar o registro.",
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição do cadastro auxiliar.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o cadastro auxiliar.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('.campoValor').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let auxiliar = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('AUXILIAR', getCookie('usuario'), auxiliar);
        window.location.href = `${BASE_URI}/auxiliar`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (auxiliar != '' && auxiliar != 'create') {

        if (await liberarRegistro('AUXILIAR', auxiliar) == false) {
            window.location.href = '../auxiliar';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"AUXILIAR", 
                    "camposSelect":["ID", "DESCRICAO", "TIPO_IT", "OBS", "TIPO"], 
                    "where": ["ID = ${auxiliar}"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].ID);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);
                    $('.rdTipoItem').filter('[value="' + jsonStr.RESULT[0][0].TIPO_IT + '"]').prop('checked', true);
                    $('.rdTipo').filter('[value="' + jsonStr.RESULT[0][0].TIPO + '"]').prop('checked', true);
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da composição: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");
                    
                    let newCodigo = $('#txtCodigo').val()
                    if (newCodigo == ''){
                        const responseCodigo = await requisicao('GET', '/Sisplan/Funcoes/v1/proximonumeroauxiliar?', null, null);
                        const jsonStrCodigo = await responseCodigo.json()
                        newCodigo = jsonStrCodigo.json
                    }
                    
                    auxiliarClasse = {};

                    auxiliarClasse.ID = newCodigo
                    auxiliarClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    auxiliarClasse.OBS = $('#txtObs').val().toUpperCase();
                    auxiliarClasse.TIPO = $('.rdTipo').filter(':checked').val();
                    auxiliarClasse.TIPOIT = $('.rdTipoItem').filter(':checked').val();

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/auxiliar?', `JSON=${encodeURIComponent(JSON.stringify(auxiliarClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/auxiliar`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});